/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.dao.openapi;

import com.xdja.pki.ca.certmanager.dao.models.CertDO;
import com.xdja.pki.ca.certmanager.dao.models.OutdateCertDO;
import com.xdja.pki.ca.certmanager.dao.models.RevokedCertDO;
import com.xdja.pki.ca.certmanager.dao.models.TemplateDO;
import com.xdja.pki.ca.certmanager.dao.models.openapi.CertRowMapper;
import com.xdja.pki.ca.certmanager.dao.models.openapi.OutdateCertRowMapper;
import com.xdja.pki.ca.certmanager.dao.models.openapi.RARowMapper;
import com.xdja.pki.ca.certmanager.dao.models.openapi.RevokedCertRowMapper;
import com.xdja.pki.ca.certmanager.dao.models.openapi.TemplateRowMapper;
import com.xdja.pki.ca.certmanager.dao.models.ra.TRA;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.dao.BaseJdbcDao;
import java.util.List;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class RAOpenApiDao
extends BaseJdbcDao {
    public Integer getCertConfirmStatusBySN(Long raId, String sn) {
        String sql = "select cert.confirmation_status from cert inner join ra_cert on cert.id=ra_cert.cert_id and ra_cert.ra_id=:raId and cert.sn = :sn";
        MapSqlParameterSource sqlParam = new MapSqlParameterSource().addValue("sn", (Object)sn).addValue("raId", (Object)raId);
        Integer certStatus = null;
        try {
            certStatus = this.daoTemplate.queryForInt(sql, (SqlParameterSource)sqlParam);
        }
        catch (EmptyResultDataAccessException e) {
            this.logger.info("RAOpenApiDao\u67e5\u8be2\u8bc1\u4e66\u786e\u8ba4\u72b6\u6001\u72b6\u65e0\u8fd4\u56de\u503c,sn={}", (Object)sn);
            this.logger.debug(sql);
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2\u8bc1\u4e66\u786e\u8ba4\u72b6\u6001\uff0c", (Throwable)e);
        }
        return certStatus;
    }

    public CertDO getCertDetailBySn(Long raId, String sn) {
        String sql = "select cert.* from cert join ra_cert on cert.id=ra_cert.cert_id and ra_cert.ra_id=:raId and cert.sn = :sn ";
        MapSqlParameterSource sqlParam = new MapSqlParameterSource().addValue("sn", (Object)sn).addValue("raId", (Object)raId);
        CertDO cert = null;
        try {
            cert = (CertDO)this.daoTemplate.queryForObject(sql, (SqlParameterSource)sqlParam, (RowMapper)new CertRowMapper());
        }
        catch (EmptyResultDataAccessException e) {
            this.logger.info("RAOpenApiDao\u67e5\u8be2\u8bc1\u4e66sn\u4e0d\u5b58\u5728\uff0csn={}", (Object)sn);
            this.logger.debug(sql);
            throw new DAOException("\u67e5\u8be2\u8bc1\u4e66\u8be6\u60c5\uff0c", (Throwable)e);
        }
        return cert;
    }

    public CertDO checkNormalCert(Long raId, String sn) {
        String sql = "select cert.* from cert join ra_cert on cert.id=ra_cert.cert_id and ra_cert.ra_id=:raId and cert.sn = :sn  and not_after_time < now()";
        MapSqlParameterSource sqlParam = new MapSqlParameterSource().addValue("sn", (Object)sn).addValue("raId", (Object)raId);
        CertDO cert = null;
        try {
            cert = (CertDO)this.daoTemplate.queryForObject(sql, (SqlParameterSource)sqlParam, (RowMapper)new CertRowMapper());
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        return cert;
    }

    public RevokedCertDO getRevokedCertDetailBySn(Long raId, String sn) {
        String sql = "select revoked_cert.* from revoked_cert join ra_cert on revoked_cert.id=ra_cert.cert_id and ra_cert.ra_id=:raId and revoked_cert.sn = :sn ";
        MapSqlParameterSource sqlParam = new MapSqlParameterSource().addValue("sn", (Object)sn).addValue("raId", (Object)raId);
        RevokedCertDO revokCert = null;
        try {
            revokCert = (RevokedCertDO)this.daoTemplate.queryForObject(sql, (SqlParameterSource)sqlParam, (RowMapper)new RevokedCertRowMapper());
        }
        catch (EmptyResultDataAccessException e) {
            this.logger.error("RAOpenApiDao\u67e5\u8be2\u64a4\u9500\u8bc1\u4e66sn\u4e0d\u5b58\u5728\uff0csn={}", (Object)sn);
            this.logger.debug(sql);
            throw new DAOException("\u67e5\u8be2\u64a4\u9500\u8bc1\u4e66\u8be6\u60c5\uff0c", (Throwable)e);
        }
        return revokCert;
    }

    public RevokedCertDO checkRevokeCert(Long raId, String sn) {
        String sql = "select revoked_cert.* from revoked_cert join ra_cert on revoked_cert.id=ra_cert.cert_id and ra_cert.ra_id=:raId and revoked_cert.sn = :sn  and after_time < now() ";
        MapSqlParameterSource sqlParam = new MapSqlParameterSource().addValue("sn", (Object)sn).addValue("raId", (Object)raId);
        RevokedCertDO revokCert = null;
        try {
            revokCert = (RevokedCertDO)this.daoTemplate.queryForObject(sql, (SqlParameterSource)sqlParam, (RowMapper)new RevokedCertRowMapper());
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        return revokCert;
    }

    public OutdateCertDO getOutdateCertDetailBySn(Long raId, String sn) {
        String sql = "select outdate_cert.* from outdate_cert join ra_cert on outdate_cert.id=ra_cert.cert_id and ra_cert.ra_id=:raId and outdate_cert.sn = :sn ";
        MapSqlParameterSource sqlParam = new MapSqlParameterSource().addValue("sn", (Object)sn).addValue("raId", (Object)raId);
        OutdateCertDO outdateCert = null;
        try {
            outdateCert = (OutdateCertDO)this.daoTemplate.queryForObject(sql, (SqlParameterSource)sqlParam, (RowMapper)new OutdateCertRowMapper());
        }
        catch (EmptyResultDataAccessException e) {
            this.logger.error("RAOpenApiDao\u67e5\u8be2\u8fc7\u671f\u8bc1\u4e66sn\u4e0d\u5b58\u5728\uff0csn={}", (Object)sn);
            this.logger.debug(sql);
            throw new DAOException("\u67e5\u8be2\u8fc7\u671f\u8bc1\u4e66\u5f02\u5e38\uff0c", (Throwable)e);
        }
        return outdateCert;
    }

    public List<TemplateDO> getRaTemplateCodes(Long id, Integer type) {
        String sql = "select ra_template.status as bound, template.*  from ra_template join  template on template.id = ra_template.template_id and template.is_inner =:isInner and template.type=:type and ra_template.ra_id = :raId";
        MapSqlParameterSource sqlParam = new MapSqlParameterSource().addValue("raId", (Object)id).addValue("isInner", (Object)TemplateDO.InnerTypeEnum.NO.getValue()).addValue("type", (Object)type);
        return this.daoTemplate.queryForList(sql, (SqlParameterSource)sqlParam, (RowMapper)new TemplateRowMapper());
    }

    public TemplateDO getTemplateById(Long id) {
        try {
            return (TemplateDO)this.daoTemplate.fetch(TemplateDO.class, id.longValue());
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eID\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u5f02\u5e38\uff0c", (Throwable)e);
        }
    }

    public TRA getRAInfoBySN(String sn) {
        String sql = "select * from ra where id = (select ra_id from ra_server_cert where manage_cert_id = (select id from manage_cert where sn = :sn))";
        MapSqlParameterSource sqlParam = new MapSqlParameterSource().addValue("sn", (Object)sn);
        TRA ra = null;
        try {
            ra = (TRA)this.daoTemplate.queryForObject(sql, (SqlParameterSource)sqlParam, (RowMapper)new RARowMapper());
        }
        catch (EmptyResultDataAccessException e) {
            this.logger.info("\u67e5\u8be2RA\u4fe1\u606f\u4e0d\u5b58\u5728sn={},", (Object)sn);
            this.logger.debug(sql);
            throw new DAOException("\u6839\u636eSN\u67e5\u8be2\u5bf9\u5e94\u7684RA\u4fe1\u606f\u5f02\u5e38\uff0c", (Throwable)e);
        }
        return ra;
    }
}

