/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.dao.ra;

import com.xdja.pki.ca.certmanager.dao.models.TemplateDO;
import com.xdja.pki.ca.certmanager.dao.models.ra.TRA;
import com.xdja.pki.ca.certmanager.dao.models.ra.TRATemplate;
import com.xdja.pki.ca.certmanager.dao.ra.RAlistQueryResult;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.dao.BaseJdbcDao;
import java.util.Date;
import java.util.List;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.pager.Pager;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class RAmanagerDao
extends BaseJdbcDao {
    public void saveRA(TRA ra) {
        try {
            this.daoTemplate.insert((Object)ra);
        }
        catch (Exception e) {
            throw new DAOException("\u65b0\u589eRA\u5b9e\u4f53\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void updateRA(TRA ra) {
        try {
            ra.setGmt_create(null);
            this.daoTemplate.updateIgnoreNull((Object)ra);
        }
        catch (Exception e) {
            throw new DAOException("\u66f4\u65b0RA\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public TRA getRA(long id) {
        try {
            return (TRA)this.daoTemplate.fetch(TRA.class, id);
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6RA\u5b9e\u4f53\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public RAlistQueryResult getRAlistsByName(String name, Pager pager) {
        try {
            pager.setRecordCount(this.daoTemplate.count(TRA.class, (Condition)Cnd.where((String)"name", (String)"like", (Object)("%" + name + "%"))));
            List rAlists = this.daoTemplate.query(TRA.class, (Condition)Cnd.where((String)"name", (String)"like", (Object)("%" + name + "%")).orderBy("gmt_create", "desc"), pager);
            RAlistQueryResult ralistQueryResult = new RAlistQueryResult();
            ralistQueryResult.setPager(pager);
            ralistQueryResult.setRAlists(rAlists);
            return ralistQueryResult;
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2RA\u5217\u8868\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<TemplateDO> getUserTemplates(Integer type) {
        try {
            return this.daoTemplate.query(TemplateDO.class, (Condition)Cnd.where((String)"status", (String)"!=", (Object)1).and("isInner", "=", (Object)TemplateDO.InnerTypeEnum.NO.getValue()).and("type", "=", (Object)type).orderBy("gmt_create", "desc"));
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2CA\u5df2\u7ecf\u542f\u7528\u8fc7\u7684\u6a21\u677f\u4fe1\u606f\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<TRATemplate> getRATemplateById(long id) {
        try {
            return this.daoTemplate.query(TRATemplate.class, (Condition)Cnd.where((String)"raId", (String)"=", (Object)id).and("status", "=", (Object)1));
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2RA\u6388\u6743\u8bc1\u4e66\u6a21\u677f\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<Long> getRATemplateByStatus(long raId, int status) {
        try {
            MapSqlParameterSource paramSource = new MapSqlParameterSource().addValue("raId", (Object)raId).addValue("status", (Object)status);
            String sql = "SELECT template_id from ra_template where ra_id = :raId and template_id in (select id from template where `status` = :status)";
            return this.daoTemplate.queryColumnLongForList(sql, (SqlParameterSource)paramSource, "template_id");
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2RA\u5df2\u505c\u7528\u6a21\u677fID\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void saveRATemplate(TRATemplate RATemplate) {
        try {
            TRATemplate tRATemplate = this.getExsitRATemplate(RATemplate);
            if (tRATemplate != null) {
                RATemplate.setId(tRATemplate.getId());
                RATemplate.setGmt_create(null);
                RATemplate.setGmt_modified(new Date(System.currentTimeMillis()));
                this.daoTemplate.updateIgnoreNull((Object)RATemplate);
            } else {
                RATemplate.setGmt_create(new Date(System.currentTimeMillis()));
                this.daoTemplate.insert((Object)RATemplate);
            }
        }
        catch (Exception e) {
            throw new DAOException("\u4fdd\u5b58/\u66f4\u65b0RA\u6388\u6743\u6a21\u677f\u4fe1\u606f\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    private TRATemplate getExsitRATemplate(TRATemplate RATemplate) {
        try {
            return (TRATemplate)this.daoTemplate.fetch(TRATemplate.class, (Condition)Cnd.where((String)"raId", (String)"=", (Object)RATemplate.getRaId()).and("templateId", "=", (Object)RATemplate.getTemplateId()));
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u5df2\u5b58\u5728\u7684RA\u6a21\u677f\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void resetRATemplate(long id) {
        try {
            MapSqlParameterSource paramSource = new MapSqlParameterSource().addValue("status", (Object)1).addValue("raId", (Object)id);
            String sql = "DELETE FROM ra_template where ra_id = :raId AND status = :status";
            this.daoTemplate.executeSql(sql, (SqlParameterSource)paramSource);
        }
        catch (Exception e) {
            throw new DAOException("\u91cd\u7f6eRA\u6388\u6743\u6a21\u677f\u72b6\u6001\u4e3a\u5df2\u5220\u9664\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public int getRaBaseDnUnique(String baseDn, Integer id) {
        try {
            StringBuilder selectSql = new StringBuilder();
            selectSql.append("SELECT COUNT(*) FROM ra WHERE base_dn = :baseDn ");
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("baseDn", (Object)baseDn);
            if (null != id) {
                params.addValue("id", (Object)id);
                selectSql.append("AND id != :id");
            }
            return this.daoTemplate.queryForInt(selectSql.toString(), (SqlParameterSource)params);
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2RA\u7684baseDn\u662f\u5426\u91cd\u590d\u5f02\u5e38", (Throwable)e);
        }
    }

    public int getRaNameUnique(String name, Integer id) {
        try {
            StringBuilder selectSql = new StringBuilder();
            selectSql.append("SELECT COUNT(*) FROM ra WHERE name = :name ");
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("name", (Object)name);
            if (null != id) {
                params.addValue("id", (Object)id);
                selectSql.append("AND id != :id");
            }
            return this.daoTemplate.queryForInt(selectSql.toString(), (SqlParameterSource)params);
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2RA\u7684name\u662f\u5426\u91cd\u590d\u5f02\u5e38", (Throwable)e);
        }
    }

    public int getRaIpUnique(String ip, Integer id) {
        try {
            StringBuilder selectSql = new StringBuilder();
            selectSql.append("SELECT COUNT(*) FROM ra WHERE ip = :ip ");
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("ip", (Object)ip);
            if (null != id) {
                params.addValue("id", (Object)id);
                selectSql.append("AND id != :id");
            }
            return this.daoTemplate.queryForInt(selectSql.toString(), (SqlParameterSource)params);
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2RA\u7684ip\u662f\u5426\u91cd\u590d\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<String> getAllRaIp() {
        try {
            StringBuilder sqlBuffer = new StringBuilder();
            sqlBuffer.append("SELECT ip FROM ra");
            return this.daoTemplate.queryColumnForList(sqlBuffer.toString(), null, "ip");
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6RA\u7684ip\u5f02\u5e38", (Throwable)e);
        }
    }
}

