/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.securitymanager.dao;

import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.common.PageInfo;
import com.xdja.pki.ca.core.enums.KeyAlgEnum;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.ca.dao.BaseJdbcDao;
import com.xdja.pki.ca.securitymanager.dao.model.CaCertDTO;
import com.xdja.pki.ca.securitymanager.dao.model.CaCertDo;
import com.xdja.pki.ca.securitymanager.dao.model.CaDO;
import com.xdja.pki.ca.securitymanager.dao.model.CaInfoDO;
import com.xdja.pki.ca.securitymanager.dao.model.FunctionDO;
import com.xdja.pki.ca.securitymanager.dao.model.RootCertDO;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.DaoException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CaCertDao
extends BaseJdbcDao {
    public CaCertDo save(CaCertDo caCertDo) {
        try {
            return (CaCertDo)this.daoTemplate.insert((Object)caCertDo);
        }
        catch (Exception e) {
            throw new DAOException("\u4fdd\u5b58CA\u8bc1\u4e66\u4fe1\u606f\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public CaCertDo getCACertObject(Long id) {
        try {
            Cnd cnd = Cnd.where((String)"ca_id", (String)"=", (Object)id).and("status", "=", (Object)1).and("is_current", "=", (Object)CaDO.CaMasterEnum.YES.value);
            return (CaCertDo)this.daoTemplate.fetch(CaCertDo.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eCA\u7684id\u67e5\u8be2cA\u8bc1\u4e66\u4fe1\u606f\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public CaCertDo getCurrentCaCert() {
        try {
            Cnd cnd = Cnd.where((String)"is_current", (String)"=", (Object)CaDO.CaMasterEnum.YES.value);
            return (CaCertDo)this.daoTemplate.fetch(CaCertDo.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u5f53\u524dCA\u4fe1\u606f\u6570\u636e\u5e93\u5f02\u5e38");
        }
    }

    public CaCertDo getCaCert(String sn, int keyAlg) {
        try {
            Cnd cnd = Cnd.where((String)"sn", (String)"=", (Object)sn).and("publicKeyAlg", "=", (Object)keyAlg);
            return (CaCertDo)this.daoTemplate.fetch(CaCertDo.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DaoException("\u6839\u636e\u5e8f\u5217\u53f7\u3001\u5bc6\u94a5\u7b97\u6cd5\u83b7\u53d6CA\u8bc1\u4e66\u94fe\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public CaCertDo getCaCert(long id) {
        try {
            return (CaCertDo)this.daoTemplate.fetch(CaCertDo.class, id);
        }
        catch (Exception e) {
            throw new DaoException("\u6839\u636eId\u83b7\u53d6CA\u8bc1\u4e66\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public PageInfo getCaCertHistoryList(int pageNo, int pageSize) {
        try {
            StringBuilder noOutdateSql = new StringBuilder();
            StringBuilder outdateSql = new StringBuilder();
            noOutdateSql.append(" SELECT subject AS CertDn ,sn,sign_alg AS signAlg,(SELECT name FROM dic WHERE code = sign_alg AND parent_code= :signAlg ) AS signAlgStr,status,(SELECT name FROM dic WHERE code = 1 AND parent_code= 'certStatus' ) AS statusStr,DATE_FORMAT(before_time,'%Y-%m-%d %H:%i:%s') AS notBeforeTime,DATE_FORMAT(after_time,'%Y.%m.%d %H:%i:%s') AS notAfterTime FROM ca_cert WHERE is_current = 2 and after_time>NOW() ");
            outdateSql.append(" SELECT subject AS CertDn ,sn,sign_alg AS signAlg,(SELECT name FROM dic WHERE code = sign_alg AND parent_code= :signAlg ) AS signAlgStr, status,(SELECT name FROM dic WHERE code = 4 AND parent_code= 'certStatus' ) AS statusStr,DATE_FORMAT(before_time,'%Y-%m-%d %H:%i:%s') AS notBeforeTime,DATE_FORMAT(after_time,'%Y.%m.%d %H:%i:%s') AS notAfterTime FROM ca_cert WHERE is_current = 2 and after_time<NOW() ");
            StringBuilder countSql = new StringBuilder();
            StringBuilder SELECTSql = new StringBuilder();
            SELECTSql.append((CharSequence)noOutdateSql).append(" union all ").append((CharSequence)outdateSql);
            countSql.append(" SELECT count(0) FROM ( ").append((CharSequence)SELECTSql).append(" ) AS result");
            SELECTSql.append(" order by notBeforeTime desc limit :offset, :pageSize");
            MapSqlParameterSource parms = new MapSqlParameterSource();
            parms.addValue("offset", (Object)((pageNo - 1) * pageSize));
            parms.addValue("pageSize", (Object)pageSize);
            parms.addValue("signAlg", (Object)(Constants.BASE_ALG_TYPE == KeyAlgEnum.SM2.value ? "signAlg" : "signAlgRsa"));
            PageInfo pageInfo = new PageInfo(pageNo, pageSize, this.queryForInt(countSql.toString(), (SqlParameterSource)parms));
            pageInfo.setDatas((Collection)this.queryForList(SELECTSql.toString(), (SqlParameterSource)parms, (RowMapper)BeanPropertyRowMapper.newInstance(CaCertDTO.class)));
            return pageInfo;
        }
        catch (Exception e) {
            throw new DaoException("\u67e5\u8be2\u672c\u673aCA\u5386\u53f2\u8bc1\u4e66\u5217\u8868\u5931\u8d25", (Throwable)e);
        }
    }

    public Boolean currentIsRootCa() {
        try {
            String SELECTSql = " SELECT type FROM ca WHERE id=(SELECT ca_id FROM ca_cert WHERE is_current=1)";
            return this.queryForInt(SELECTSql, null) == 1;
        }
        catch (Exception e) {
            throw new DaoException("\u5224\u65ad\u672c\u673aCA\u662f\u5426\u662f\u6839CA\u5931\u8d25", (Throwable)e);
        }
    }

    public Boolean isRootCa(String signSn) {
        try {
            String SELECTSql = " SELECT type FROM ca WHERE id=(SELECT ca_id FROM ca_cert WHERE sn=:signSn)";
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("signSn", (Object)signSn);
            return this.queryForInt(SELECTSql, (SqlParameterSource)params) == 1;
        }
        catch (Exception e) {
            throw new DaoException("\u5224\u65ad\u672c\u673aCA\u662f\u5426\u662f\u6839CA\u5931\u8d25", (Throwable)e);
        }
    }

    public Boolean isCurrent(String signSn) {
        try {
            String SELECTSql = " SELECT is_current FROM ca_cert WHERE sn=:signSn ";
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("signSn", (Object)signSn);
            return this.queryForInt(SELECTSql, (SqlParameterSource)params) == 1;
        }
        catch (Exception e) {
            throw new DaoException("\u5224\u65ad\u8bc1\u4e66\u662f\u5426\u662f\u5f53\u524d\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    public RootCertDO getCurrentRootCert() {
        try {
            String SELECTSql = " SELECT subject AS certDn, sign_Alg AS signAlg, if(sign_alg='1','SM3WithSM2','SH1WithRSA') AS signAlgStr,private_key_size AS keyAlgLength,DATE_FORMAT(before_time,'%Y-%m-%d %H:%i:%s') AS notBeforeTime,DATE_FORMAT(after_time,'%Y-%m-%d %H:%i:%s') AS notAfterTime,ca_id FROM ca_cert left join ca ON ca_cert.ca_id = ca.id  WHERE ca_cert.is_current=1 and ca.type = 1  ";
            return (RootCertDO)this.queryForObject(SELECTSql, null, (RowMapper)BeanPropertyRowMapper.newInstance(RootCertDO.class));
        }
        catch (Exception e) {
            throw new DaoException("\u83b7\u53d6\u672c\u673a\u6839CA\u8be6\u60c5\u5931\u8d25", (Throwable)e);
        }
    }

    public CaCertDo getCurrentCert() {
        try {
            Cnd cnd = Cnd.where((String)"is_current", (String)"=", (Object)1);
            return (CaCertDo)this.daoTemplate.fetch(CaCertDo.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DaoException("\u83b7\u53d6\u672c\u673aCA\u8be6\u60c5\u5931\u8d25", (Throwable)e);
        }
    }

    public void setIsCurrent(String sn, int isCurrent) {
        try {
            String updateSql = "UPDATE ca_cert SET is_current=:isCurrent WHERE sn=:signSn";
            MapSqlParameterSource parms = new MapSqlParameterSource();
            parms.addValue("isCurrent", (Object)isCurrent);
            parms.addValue("signSn", (Object)sn);
            this.executeSql(updateSql, (SqlParameterSource)parms);
        }
        catch (Exception e) {
            throw new DaoException("\u8bbe\u7f6e\u5f53\u524dCA\u72b6\u6001\u5931\u8d25", (Throwable)e);
        }
    }

    public int hideCrossFunction() {
        try {
            String sql = "UPDATE function SET is_show = :isShow WHERE id =:id";
            MapSqlParameterSource mapSqlParameterSource = new MapSqlParameterSource();
            mapSqlParameterSource.addValue("isShow", (Object)FunctionDO.FunctionShowEnum.NO.value);
            mapSqlParameterSource.addValue("id", (Object)67);
            return this.update(sql, (SqlParameterSource)mapSqlParameterSource);
        }
        catch (Exception e) {
            throw new DAOException("\u9690\u85cf\u4ea4\u53c9\u8bc1\u4e66\u7cfb\u7edf\u83dc\u5355\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public CaInfoDO getCaInfo(Integer alg) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT ca.id caId, ca.is_master isCurrent, ca.base_dn baseDn, ca.type type, ca.key_alg keyAlg, caCert.id certId, caCert.cert cert, caCert.cert_chain certChain, caCert.sn sn, ").append("caCert.subject subject, caCert.issue issue, caCert.public_key_alg publicKeyAlg, caCert.private_key_size privateKeySize,caCert.sign_alg signAlg ").append("FROM ca ca LEFT JOIN ca_cert caCert ON ca.id=caCert.ca_id ").append("WHERE ca.key_alg =:alg AND caCert.is_current =:isCurrent ");
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("alg", (Object)alg);
        parameterSource.addValue("isCurrent", (Object)CaDO.CaMasterEnum.YES.value);
        List dataList = this.daoTemplate.queryForList(sqlBuffer.toString(), (SqlParameterSource)parameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(CaInfoDO.class));
        if (null == dataList || 0 == dataList.size()) {
            return null;
        }
        return (CaInfoDO)dataList.get(0);
    }

    public List<X509Certificate> getCaCertsByCaId(Long caId) {
        ArrayList<X509Certificate> caCerts = new ArrayList<X509Certificate>();
        try {
            List caCertDos = this.daoTemplate.query(CaCertDo.class, (Condition)Cnd.where((String)"ca_id", (String)"=", (Object)caId).and("status", "=", (Object)1));
            if (null != caCertDos && !caCertDos.isEmpty()) {
                for (CaCertDo caCert : caCertDos) {
                    X509Certificate certFromStr = CertUtil.getCertFromStr((String)caCert.getCert());
                    caCerts.add(certFromStr);
                }
            }
            return caCerts;
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2CA\u8bc1\u4e66\u5217\u8868\u5f02\u5e38\uff0c", (Throwable)e);
        }
    }
}

