/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.securitymanager.dao;

import com.xdja.pki.ca.core.bean.CertDTO;
import com.xdja.pki.ca.core.common.PageInfo;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.ca.dao.BaseJdbcDao;
import com.xdja.pki.ca.securitymanager.dao.model.CaServerCertDo;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.DaoException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CaServerCertDao
extends BaseJdbcDao {
    public CaServerCertDo save(CaServerCertDo caServerCertDo) {
        try {
            return (CaServerCertDo)this.daoTemplate.insert((Object)caServerCertDo);
        }
        catch (Exception e) {
            throw new DAOException("\u4fdd\u5b58CA\u670d\u52a1\u5668\u8bc1\u4e66\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public CaServerCertDo getCurrentCaServerCert() {
        try {
            Cnd cnd = Cnd.where((String)"is_current", (String)"=", (Object)CaServerCertDo.CaServerMasterEnum.YES.value);
            return (CaServerCertDo)this.daoTemplate.fetch(CaServerCertDo.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u5f53\u524dCA\u670d\u52a1\u5668\u8bc1\u4e66\u4fe1\u606f\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public Map<String, Object> getCurrentCaServerCertSn() {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("SELECT cert.sn sn, cert.public_key_alg keyAlg FROM ca_server_cert caServerCert LEFT JOIN ").append("manage_cert cert ON caServerCert.manage_cert_id = cert.id ").append("WHERE caServerCert.is_current = :isCurrent ");
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("isCurrent", (Object)CaServerCertDo.CaServerMasterEnum.YES.value);
            return this.queryForMap(sqlBuffer.toString(), (SqlParameterSource)parameterSource);
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u5f53\u524d\u670d\u52a1\u5668\u8bc1\u4e66\u8bc1\u4e66\u7684SN\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public PageInfo querySubSystemList(int pageNo, int pageSize) {
        try {
            StringBuilder selectSql = new StringBuilder();
            StringBuilder managerFreezeSql = new StringBuilder();
            StringBuilder managerOutdateSql = new StringBuilder();
            StringBuilder revokeSql = new StringBuilder();
            StringBuilder revokeOutdateSql = new StringBuilder();
            StringBuilder outdateSql = new StringBuilder();
            managerFreezeSql.append(" SELECT subject AS CertDn ,sn AS signSn,pair_cert_sn AS encSn,sign_alg AS signAlg,before_time AS notBeforeTime,after_time AS notAfterTime, 2 AS status FROM manage_cert WHERE type=1 AND after_time > NOW() AND status=2 AND id IN(SELECT manage_cert_id FROM ca_server_cert WHERE is_current = :isCurrent) ");
            managerOutdateSql.append(" SELECT subject AS CertDn ,sn AS signSn,pair_cert_sn AS encSn,sign_alg AS signAlg,before_time AS notBeforeTime,after_time AS notAfterTime,4 AS status FROM manage_cert WHERE type=1 AND after_time <NOW() AND id IN(SELECT manage_cert_id FROM ca_server_cert WHERE is_current = :isCurrent) ");
            revokeSql.append(" SELECT subject AS CertDn ,sn AS signSn,pair_cert_sn AS encSn,sign_alg AS signAlg,before_time AS notBeforeTime,after_time AS notAfterTime, 3 AS status FROM revoked_manage_cert WHERE type=1 AND after_time > NOW() AND id IN(SELECT manage_cert_id FROM ca_server_cert WHERE is_current = :isCurrent) ");
            revokeOutdateSql.append(" SELECT subject AS CertDn ,sn AS signSn,pair_cert_sn AS encSn,sign_alg AS signAlg,before_time AS notBeforeTime,after_time AS notAfterTime, 4 AS status FROM revoked_manage_cert WHERE type=1 AND after_time <NOW() AND id IN(SELECT manage_cert_id FROM ca_server_cert WHERE is_current = :isCurrent) ");
            outdateSql.append(" SELECT subject AS CertDn ,sn AS signSn,pair_cert_sn AS encSn,sign_alg AS signAlg,before_time AS notBeforeTime,after_time AS notAfterTime, 4 AS status FROM outdate_manage_cert WHERE type=1 AND id IN(SELECT manage_cert_id FROM ca_server_cert WHERE is_current = :isCurrent) ");
            selectSql.append((CharSequence)managerFreezeSql).append(" UNION ALL ").append((CharSequence)managerOutdateSql).append(" UNION ALL ").append((CharSequence)revokeSql).append(" UNION ALL ").append((CharSequence)revokeOutdateSql).append(" UNION ALL ").append((CharSequence)outdateSql);
            StringBuilder countSql = new StringBuilder();
            countSql.append("SELECT COUNT(0) FROM (").append((CharSequence)selectSql).append(") AS result");
            MapSqlParameterSource parms = new MapSqlParameterSource();
            parms.addValue("isCurrent", (Object)CaServerCertDo.CaServerMasterEnum.NO.value);
            PageInfo pageInfo = new PageInfo(pageNo, pageSize, this.daoTemplate.queryForInt(countSql.toString(), (SqlParameterSource)parms));
            selectSql.append(" ORDER BY notBeforeTime DESC LIMIT :offset, :pageSize");
            parms.addValue("offset", (Object)((pageNo - 1) * pageSize));
            parms.addValue("pageSize", (Object)pageSize);
            pageInfo.setDatas((Collection)this.daoTemplate.queryForList(selectSql.toString(), (SqlParameterSource)parms, (RowMapper)BeanPropertyRowMapper.newInstance(CertDTO.class)));
            return pageInfo;
        }
        catch (Exception e) {
            throw new DaoException("\u5206\u9875\u67e5\u8be2\u7ba1\u7406\u5458\u5386\u53f2\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    public void updateIsCurrent(Long oldSignCertId) {
        try {
            String sql = "UPDATE ca_server_cert SET is_current = :isCurrent, gmt_modified = :gmtModified WHERE manage_cert_id = :certId ";
            MapSqlParameterSource parms = new MapSqlParameterSource();
            parms.addValue("isCurrent", (Object)CaServerCertDo.CaServerMasterEnum.NO.value);
            parms.addValue("gmtModified", (Object)new Date());
            parms.addValue("certId", (Object)oldSignCertId);
            this.daoTemplate.update(sql, (SqlParameterSource)parms);
        }
        catch (Exception e) {
            throw new DaoException("\u66f4\u65b0\u5f53\u524dCA\u670d\u52a1\u5668\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    public Map<String, Object> getCurrentCaServerCertEncSn() {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("SELECT cert.pair_cert_sn sn, cert.public_key_alg keyAlg FROM ca_server_cert caServerCert LEFT JOIN ").append("manage_cert cert ON caServerCert.manage_cert_id = cert.id ").append("WHERE caServerCert.is_current = :isCurrent ");
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("isCurrent", (Object)CaServerCertDo.CaServerMasterEnum.YES.value);
            return this.queryForMap(sqlBuffer.toString(), (SqlParameterSource)parameterSource);
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u5f53\u524d\u670d\u52a1\u5668\u8bc1\u4e66\u8bc1\u4e66\u7684SN\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public Map<String, Object> getCurrentCaSignServerCert() {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("SELECT cert.data data FROM ca_server_cert caServerCert LEFT JOIN ").append("manage_cert_data cert ON caServerCert.manage_cert_id = cert.id ").append("WHERE caServerCert.is_current = :isCurrent ");
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("isCurrent", (Object)CaServerCertDo.CaServerMasterEnum.YES.value);
            return this.queryForMap(sqlBuffer.toString(), (SqlParameterSource)parameterSource);
        }
        catch (EmptyResultDataAccessException ere) {
            return null;
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u5f53\u524dCA\u7b7e\u540d\u670d\u52a1\u5668\u8bc1\u4e66\u5b9e\u4f53\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
    }

    public Map<String, Object> getCurrentCaEncServerCert() {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("SELECT data.data data FROM ca_server_cert caServerCert LEFT JOIN ").append("manage_cert cert ON caServerCert.manage_cert_id = cert.id LEFT JOIN manage_cert_data data ").append("ON cert.pair_cert_id = data.id ").append("WHERE caServerCert.is_current = :isCurrent ");
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("isCurrent", (Object)CaServerCertDo.CaServerMasterEnum.YES.value);
            return this.queryForMap(sqlBuffer.toString(), (SqlParameterSource)parameterSource);
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u5f53\u524dCA\u7b7e\u540d\u670d\u52a1\u5668\u8bc1\u4e66\u5b9e\u4f53\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
    }
}

