/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.securitymanager.dao;

import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.securitymanager.dao.model.AdminRoleDO;
import com.xdja.pki.ca.securitymanager.dao.model.RoleDO;
import com.xdja.pki.dao.BaseJdbcDao;
import java.util.List;
import java.util.Map;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class AdminRoleDao
extends BaseJdbcDao {
    public AdminRoleDO save(AdminRoleDO adminRoleDO) {
        try {
            return (AdminRoleDO)this.daoTemplate.insert((Object)adminRoleDO);
        }
        catch (Exception e) {
            throw new ServiceException("\u4fdd\u5b58\u7ba1\u7406\u5458\u8bc1\u4e66\u89d2\u8272\u5bf9\u7167\u8868\u5f02\u5e38", (Throwable)e);
        }
    }

    public int getRoleCountsByType(Integer type) {
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("SELECT count(adminRole.id) count FROM role role1 ").append("LEFT JOIN admin_role adminRole ON role1.id  =  adminRole.role_id ").append("LEFT JOIN manage_cert mc ON adminRole.manage_cert_id = mc.id ").append("WHERE role1.type =:type AND mc.confirmation_status = :conStatus ");
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("type", (Object)type);
            parameterSource.addValue("conStatus", (Object)Constants.ISSUE_CERT_OK_ACK);
            return this.daoTemplate.queryForInt(sqlBuffer.toString(), (SqlParameterSource)parameterSource);
        }
        catch (Exception e) {
            throw new ServiceException("\u67e5\u8be2\u7ba1\u7406\u5458\u8bc1\u4e66\u7b7e\u53d1\u6570\u91cf\u5f02\u5e38", (Throwable)e);
        }
    }

    public Map<String, Object> queryAdminIssueCounts() {
        return null;
    }

    public AdminRoleDO getCaAdminCertByManageId(Long managerCertId) {
        try {
            return (AdminRoleDO)this.daoTemplate.fetch(AdminRoleDO.class, (Condition)Cnd.where((String)"manageCertId", (String)"=", (Object)managerCertId));
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u7ba1\u7406\u8bc1\u4e66Id\u83b7\u53d6\u7ba1\u7406\u5458\u89d2\u8272\u4fe1\u606f\u662f\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public RoleDO getRoleByManageCertId(long manageCertId) {
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT role.id, role.name, role.type, role.note, role.gmt_create gmtCreate, role.gmt_modified gmtModified");
            sql.append(" FROM role role");
            sql.append(" JOIN admin_role adminRole ON role.id = adminRole.role_id");
            sql.append(" WHERE adminRole.manage_cert_id = :manageCertId");
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("manageCertId", (Object)manageCertId);
            List list = this.daoTemplate.queryForList(sql.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(RoleDO.class));
            if (null == list || list.isEmpty()) {
                return null;
            }
            return (RoleDO)list.get(0);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u7ba1\u7406\u5458\u8bc1\u4e66Id\u83b7\u53d6\u5bf9\u5e94\u89d2\u8272\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }
}

