/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.securitymanager.dao;

import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.ca.securitymanager.dao.model.FunctionDO;
import com.xdja.pki.dao.BaseJdbcDao;
import java.util.List;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class FunctionDao
extends BaseJdbcDao {
    public List<FunctionDO> queryAllFunctions() {
        try {
            return this.daoTemplate.query(FunctionDO.class, (Condition)Cnd.where((String)"status", (String)"=", (Object)FunctionDO.FunctionStatusEnum.NORMAL.value));
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2\u7cfb\u7edf\u6240\u6709\u6743\u9650\u83dc\u5355\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<FunctionDO> queryAdminFunctions(long manageCertId) {
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT f.id, f.name, f.obj_name objName, f.icon, f.permission_key permissionKey,");
            sql.append(" f.parent_id parentId, f.link, f.order_num orderNum, f.is_show isShow,");
            sql.append(" f.status, f.permission, f.gmt_create gmtCreate, f.gmt_modified gmtModified");
            sql.append(" FROM admin_role ar");
            sql.append(" JOIN role role ON ar.role_id = role.id");
            sql.append(" JOIN role_function rf ON role.id = rf.role_id");
            sql.append(" JOIN function f ON rf.function_id = f.id");
            sql.append(" WHERE ar.manage_cert_id = :manageCertId AND f.status = :status");
            sql.append(" ORDER BY f.parent_id, f.order_num ASC");
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("manageCertId", (Object)manageCertId);
            params.addValue("status", (Object)FunctionDO.FunctionStatusEnum.NORMAL.value);
            return this.daoTemplate.queryForList(sql.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(FunctionDO.class));
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2\u7ba1\u7406\u5458\u62e5\u6709\u7684\u6743\u9650\u83dc\u5355\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }
}

