/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.hsm.manager;

import com.xdja.pki.ca.certmanager.service.racert.bean.PwdUsedEnum;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.common.ConfigUtil;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.configBasic.bean.HsmCertNameBean;
import com.xdja.pki.ca.core.enums.DigestAlgEnum;
import com.xdja.pki.ca.core.enums.HsmInfoEnum;
import com.xdja.pki.ca.core.enums.KeyAlgEnum;
import com.xdja.pki.ca.core.enums.P10typeEnum;
import com.xdja.pki.ca.core.enums.SignAlgFormatEnum;
import com.xdja.pki.ca.core.exception.InvokeException;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.core.util.CertUtils;
import com.xdja.pki.ca.core.util.DnUtil;
import com.xdja.pki.ca.hsm.manager.HsmManager;
import com.xdja.pki.ca.securitymanager.service.vo.AlgTypeEnum;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import com.xdja.pki.ca.securitymanager.service.vo.CreateP10VO;
import com.xdja.pki.ca.securitymanager.service.vo.SignAlgTypeEnum;
import com.xdja.pki.gmssl.core.utils.GMSSLBCSignUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLECUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.sdf.SdfSHAType;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECKeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECSignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSAKeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSASignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRandomUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2SignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.gmssl.operator.utils.GMSSLContentSignerUtils;
import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLSancHsmUtils;
import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLYunHsmUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLCertUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLP10Utils;
import com.xdja.pki.gmssl.x509.utils.bean.YunHsmExceptionEnum;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import javax.naming.NamingException;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class HsmManagerImpl
implements HsmManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private Environment environment;

    public boolean testHsmConnect(String ip, Integer port, InputStream signCert, String signCertPwd, InputStream encCert, String encCertPwd, InputStream hsmCaChain) {
        if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_BC.intValue()) {
            this.logger.debug("\u7cfb\u7edf\u91c7\u7528BC\u4f5c\u4e3a\u5bc6\u7801\u8bbe\u5907\uff0c\u4e0d\u9700\u8981\u8fdb\u884c\u8fde\u901a\u6027\u6d4b\u8bd5");
            return true;
        }
        return false;
    }

    public X509Certificate genX509Certificate(String subject, BigInteger sn, Date notBefore, Date notAfter, CaInfoVO caInfoVO, PublicKey publicKey, List<Extension> extensions, String signAlg) {
        X500Name newSubject = null;
        try {
            newSubject = DnUtil.getRFC4519X500Name((String)subject);
        }
        catch (NamingException e) {
            throw new ServiceException("\u4f7f\u7528BC\u7b7e\u53d1\u8bc1\u4e66\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        subject = newSubject.toString();
        if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_BC.intValue()) {
            this.logger.debug("\u7cfb\u7edf\u91c7\u7528BC\u4f5c\u4e3a\u5bc6\u7801\u8bbe\u5907");
            try {
                this.logger.debug("\u7b7e\u540d\u7b97\u6cd5\u4e3a\uff1a" + Integer.valueOf(signAlg) + "----" + SignAlgTypeEnum.getAlgName((int)Integer.valueOf(signAlg)));
                this.logger.debug("\u516c\u94a5" + publicKey);
                this.logger.debug("\u79c1\u94a5" + caInfoVO.getRootPrivateKey());
                long begin = System.currentTimeMillis();
                X509Certificate x509Certificate = GMSSLCertUtils.generateCertByBC((X500Name)DnUtil.getRFC4519X500Name((String)caInfoVO.getSubject()), (X500Name)DnUtil.getRFC4519X500Name((String)subject), (BigInteger)sn, (Date)notBefore, (Date)notAfter, (PrivateKey)caInfoVO.getRootPrivateKey(), (PublicKey)publicKey, (String)SignAlgTypeEnum.getAlgName((int)Integer.valueOf(signAlg)), extensions, (boolean)SignAlgFormatEnum.isBlankSpaceFormat((Integer)Constants.SIGN_ALG_FORMAT_FLAG));
                this.logger.info("================generateCertByBC=========" + Thread.currentThread().getName() + " ==== " + System.currentTimeMillis() + " === " + (System.currentTimeMillis() - begin));
                return x509Certificate;
            }
            catch (Exception e) {
                throw new ServiceException("\u4f7f\u7528BC\u7b7e\u53d1\u8bc1\u4e66\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
        }
        try {
            if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_SWXA_HSM.intValue()) {
                this.logger.debug("\u7cfb\u7edf\u91c7\u7528\u4e09\u672a\u4fe1\u5b89HSM\u4f5c\u4e3a\u5bc6\u7801\u8bbe\u5907");
                GMSSLPkiCryptoInit.getSancHsmInstance();
                SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(caInfoVO.getCaPwdBean().getKeyIndex().intValue(), null);
                return GMSSLCertUtils.generateCert((X500Name)DnUtil.getRFC4519X500Name((String)caInfoVO.getSubject()), (X500Name)DnUtil.getRFC4519X500Name((String)subject), (BigInteger)sn, (Date)notBefore, (Date)notAfter, (PrivateKey)sdfPrivateKey, (PublicKey)publicKey, (String)SignAlgTypeEnum.getAlgName((int)Integer.valueOf(signAlg)), extensions, (boolean)SignAlgFormatEnum.isBlankSpaceFormat((Integer)Constants.SIGN_ALG_FORMAT_FLAG));
            }
            this.logger.debug("\u7cfb\u7edf\u91c7\u7528\u4fe1\u5927\u6377\u5b89HSM\u4f5c\u4e3a\u5bc6\u7801\u8bbe\u5907");
            SdfPrivateKey sdfPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey((int)caInfoVO.getCaPwdBean().getKeyIndex(), (String)caInfoVO.getCaPwdBean().getPrivateKeyPin());
            return GMSSLCertUtils.generateCertByYunhsm((String)DnUtil.getRFC4519X500Name((String)caInfoVO.getSubject()).toString(), (String)DnUtil.getRFC4519X500Name((String)subject).toString(), (BigInteger)sn, (Date)notBefore, (Date)notAfter, (PrivateKey)sdfPrivateKey, (PublicKey)publicKey, (String)SignAlgTypeEnum.getAlgName((int)Integer.valueOf(signAlg)), extensions, (boolean)SignAlgFormatEnum.isBlankSpaceFormat((Integer)Constants.SIGN_ALG_FORMAT_FLAG));
        }
        catch (Exception e) {
            throw new ServiceException("\u4f7f\u7528HSM\u7b7e\u53d1\u8bc1\u4e66\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    public X509Certificate genRootX509Certificate(String dn, BigInteger sn, Date notBefore, Date notAfter, PublicKey publicKey, CaInfoVO caInfoVO, List<Extension> extensions, String signAlg) {
        if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_BC.intValue()) {
            this.logger.debug("\u7cfb\u7edf\u91c7\u7528BC\u4f5c\u4e3a\u5bc6\u7801\u8bbe\u5907");
            try {
                return GMSSLCertUtils.generateCertByBC((X500Name)DnUtil.getRFC4519X500Name((String)dn), (X500Name)DnUtil.getRFC4519X500Name((String)dn), (BigInteger)sn, (Date)notBefore, (Date)notAfter, (PrivateKey)caInfoVO.getRootPrivateKey(), (PublicKey)publicKey, (String)SignAlgTypeEnum.getAlgName((int)Integer.parseInt(signAlg)), extensions, (boolean)SignAlgFormatEnum.isBlankSpaceFormat((Integer)Constants.SIGN_ALG_FORMAT_FLAG));
            }
            catch (Exception e) {
                throw new ServiceException("\u4f7f\u7528BC\u7b7e\u53d1\u8bc1\u4e66\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
        }
        try {
            if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_SWXA_HSM.intValue()) {
                this.logger.debug("\u7cfb\u7edf\u91c7\u7528\u4e09\u672a\u4fe1\u5b89HSM\u4f5c\u4e3a\u5bc6\u7801\u8bbe\u5907");
                GMSSLPkiCryptoInit.getSancHsmInstance();
                SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(caInfoVO.getCaPwdBean().getKeyIndex().intValue(), null);
                return GMSSLCertUtils.generateCert((String)dn, (String)dn, (BigInteger)sn, (Date)notBefore, (Date)notAfter, (PrivateKey)sdfPrivateKey, (PublicKey)publicKey, (String)SignAlgTypeEnum.getAlgName((int)Integer.parseInt(signAlg)), extensions, (boolean)SignAlgFormatEnum.isBlankSpaceFormat((Integer)Constants.SIGN_ALG_FORMAT_FLAG));
            }
            this.logger.debug("\u7cfb\u7edf\u91c7\u7528\u4fe1\u5927\u6377\u5b89HSM\u4f5c\u4e3a\u5bc6\u7801\u8bbe\u5907");
            return GMSSLCertUtils.generateCertByYunhsm((String)dn, (String)dn, (BigInteger)sn, (Date)notBefore, (Date)notAfter, (int)caInfoVO.getCaPwdBean().getKeyIndex(), (String)caInfoVO.getCaPwdBean().getPrivateKeyPin(), (PublicKey)publicKey, (String)SignAlgTypeEnum.getAlgName((int)Integer.parseInt(signAlg)), extensions, (boolean)SignAlgFormatEnum.isBlankSpaceFormat((Integer)Constants.SIGN_ALG_FORMAT_FLAG));
        }
        catch (Exception e) {
            throw new ServiceException("\u4f7f\u7528HSM\u7b7e\u53d1\u8bc1\u4e66\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    public PKCS10CertificationRequest genP10(CreateP10VO createP10VO, Integer type) throws NamingException, NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        this.logger.debug("\u751f\u6210p10     " + createP10VO.toString());
        String signAlgName = StringUtils.isNotBlank((CharSequence)createP10VO.getAlgName()) ? createP10VO.getAlgName() : this.getDefaultSignName(createP10VO.getAlg());
        X500Name x500Name = DnUtil.getRFC4519X500Name((String)createP10VO.getDn());
        this.logger.info("p10 4519\u683c\u5f0f\u7684dn    " + x500Name);
        if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_BC.intValue()) {
            this.logger.debug("\u7cfb\u7edf\u91c7\u7528BC\u4f5c\u4e3a\u5bc6\u7801\u8bbe\u5907");
            try {
                PrivateKey privateKey;
                PublicKey publicKey;
                if (type == P10typeEnum.CA.value) {
                    publicKey = this.getPublicKey(createP10VO.getAlg(), createP10VO.getAlgLength(), PwdUsedEnum.ROOT_CERT_TYPE.value, false);
                    privateKey = CertUtils.readPrivateKeyByPath((String)(Constants.CA_ROOT_PRIVATE_PATH + "private.key"));
                } else {
                    privateKey = createP10VO.getPrivateKey();
                    publicKey = createP10VO.getPublicKey();
                }
                return CertUtil.createP10((X500Name)x500Name, (PublicKey)publicKey, (PrivateKey)privateKey, (String)signAlgName);
            }
            catch (Exception e) {
                throw new ServiceException("\u4f7f\u7528BC\u7b7e\u53d1p10\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
        }
        try {
            this.logger.debug("\u7cfb\u7edf\u91c7\u7528HSM\u4f5c\u4e3a\u5bc6\u7801\u8bbe\u5907");
            PublicKey publicKey = this.getSignPublicKeyByHsm(createP10VO.getKeyIndex(), createP10VO.getAlg());
            if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_SWXA_HSM.intValue()) {
                this.logger.debug("\u7cfb\u7edf\u91c7\u7528\u4e09\u672a\u4fe1\u5b89HSM\u4f5c\u4e3a\u5bc6\u7801\u8bbe\u5907\u751f\u6210p10");
                SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(createP10VO.getKeyIndex().intValue(), null);
                return GMSSLP10Utils.generateP10((String)createP10VO.getDn(), (PublicKey)createP10VO.getPublicKey(), (PrivateKey)sdfPrivateKey, (String)createP10VO.getAlgName(), (boolean)SignAlgFormatEnum.isBlankSpaceFormat((Integer)Constants.SIGN_ALG_FORMAT_FLAG));
            }
            this.logger.debug("\u7cfb\u7edf\u91c7\u7528\u4fe1\u5927\u6377\u5b89HSM\u4f5c\u4e3a\u5bc6\u7801\u8bbe\u5907\u751f\u6210p10");
            SdfPrivateKey sdfPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey((int)createP10VO.getKeyIndex(), (String)createP10VO.getPrivateKeyPin());
            JcaPKCS10CertificationRequestBuilder requestBuilder = new JcaPKCS10CertificationRequestBuilder(DnUtil.getRFC4519X500Name((ASN1Encodable)x500Name), publicKey);
            ContentSigner contentSigner = GMSSLContentSignerUtils.generateContentSignerByYunhsm((String)signAlgName, (PrivateKey)sdfPrivateKey);
            return requestBuilder.build(contentSigner);
        }
        catch (Exception e) {
            throw new ServiceException("\u4f7f\u7528HSM\u7b7e\u53d1p10\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    private String getDefaultSignName(Integer alg) {
        if (AlgTypeEnum.RSA.value == alg) {
            return SignAlgTypeEnum.SHA256_WITH_RSA.algName;
        }
        if (AlgTypeEnum.SM2.value == alg) {
            return SignAlgTypeEnum.SM3_WITH_SM2.algName;
        }
        if (AlgTypeEnum.NISTP256.value == alg) {
            return SignAlgTypeEnum.SHA256_WITH_ECDSA.algName;
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b");
    }

    public void recoverHsm() {
    }

    public PublicKey getSignPublicKeyByCryptyDevice(Integer keyIndex, Integer type, Integer keyAlg, Integer keySize) {
        if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_BC.intValue()) {
            this.logger.debug("\u7cfb\u7edf\u91c7\u7528BC\u4f5c\u4e3a\u5bc6\u7801\u8bbe\u5907");
            try {
                return this.getPublicKey(keyAlg, keySize, type, true);
            }
            catch (Exception e) {
                throw new ServiceException("\u4f7f\u7528BC\u751f\u6210\u516c\u79c1\u94a5\u5f02\u5e38", (Throwable)e);
            }
        }
        try {
            this.logger.debug("\u7cfb\u7edf\u91c7\u7528HSM\u4f5c\u4e3a\u5bc6\u7801\u8bbe\u5907");
            return this.getSignPublicKeyByHsm(keyIndex, keyAlg);
        }
        catch (Exception e) {
            throw new ServiceException("\u4f7f\u7528HSM\u751f\u6210\u516c\u79c1\u94a5\u5f02\u5e38", (Throwable)e);
        }
    }

    public PublicKey getSignPublicKeyByHsm(Integer keyIndex, Integer alg) {
        try {
            if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_SWXA_HSM.intValue()) {
                this.logger.debug("\u7cfb\u7edf\u91c7\u7528\u4e09\u672a\u4fe1\u5b89HSM\u83b7\u53d6\u7b7e\u540d\u516c\u94a5\u4fe1\u606f");
                GMSSLPkiCryptoInit.getSancHsmInstance();
                if (AlgTypeEnum.RSA.value == alg) {
                    return GMSSLRSAKeyUtils.getPublicKeyFromHardware((int)keyIndex, (boolean)false);
                }
                if (AlgTypeEnum.SM2.value == alg) {
                    return GMSSLECKeyUtils.getPublicKeyFromHardware((int)keyIndex, (String)GMSSLECKeyUtils.SM2p256, (boolean)false);
                }
                this.logger.debug("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b");
                throw new Exception("\u4e09\u672a\u4fe1\u5b89HSM\u4e0d\u652f\u6301[{}]\u7b97\u6cd5 " + alg);
            }
            this.logger.debug("\u7cfb\u7edf\u91c7\u7528\u4fe1\u5927\u6377\u5b89HSM\u83b7\u53d6\u7b7e\u540d\u516c\u94a5\u4fe1\u606f");
            if (AlgTypeEnum.RSA.value == alg) {
                return GMSSLRSAKeyUtils.getSignPublicKeyByYunhsm((int)keyIndex);
            }
            if (AlgTypeEnum.SM2.value == alg) {
                return GMSSLECKeyUtils.getSignPublicKeyByYunhsm((int)keyIndex, (String)GMSSLECKeyUtils.SM2p256);
            }
            return GMSSLECKeyUtils.getSignPublicKeyByYunhsm((int)keyIndex, (String)GMSSLECKeyUtils.NISTp256);
        }
        catch (Exception e) {
            throw new ServiceException("\u4eceHSM\u83b7\u53d6\u516c\u79c1\u94a5\u5f02\u5e38", (Throwable)e);
        }
    }

    public PublicKey getEncPublicKeyByCryptyDevice(Integer keyIndex, Integer type, Integer keyAlg, Integer keySize) {
        if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_BC.intValue()) {
            this.logger.debug("\u7cfb\u7edf\u91c7\u7528BC\u4f5c\u4e3a\u5bc6\u7801\u8bbe\u5907");
            try {
                return this.getPublicKey(keyAlg, keySize, type, false);
            }
            catch (Exception e) {
                throw new ServiceException("\u4f7f\u7528BC\u751f\u6210\u516c\u79c1\u94a5\u5f02\u5e38", (Throwable)e);
            }
        }
        try {
            this.logger.debug("\u7cfb\u7edf\u91c7\u7528HSM\u4f5c\u4e3a\u5bc6\u7801\u8bbe\u5907");
            return this.getEncPublicKeyByHsm(keyIndex, keyAlg);
        }
        catch (Exception e) {
            throw new ServiceException("\u4f7f\u7528HSM\u751f\u6210\u516c\u79c1\u94a5\u5f02\u5e38", (Throwable)e);
        }
    }

    public PublicKey getPublicKey(Integer keyAlg, Integer keySize, Integer type, Boolean isSign) {
        try {
            KeyPair keyPair = keyAlg == AlgTypeEnum.SM2.value ? GMSSLSM2KeyUtils.generateSM2KeyPairByBC() : (keyAlg == AlgTypeEnum.RSA.value ? GMSSLRSAKeyUtils.generateKeyPairByBC((int)keySize) : GMSSLECUtils.generateKeyPair((String)NISTNamedCurves.getName((ASN1ObjectIdentifier)SECObjectIdentifiers.secp256r1)));
            PrivateKey privateKey = keyPair.getPrivate();
            PublicKey publicKey = keyPair.getPublic();
            if (PwdUsedEnum.ROOT_CERT_TYPE.value == type) {
                CertUtil.writeRootPri((PrivateKey)privateKey);
                CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(Constants.BASE_ALG_TYPE);
                caInfoVO.setRootPrivateKey(privateKey);
                Constants.CA_INFO.put(Constants.BASE_ALG_TYPE, caInfoVO);
            } else if (PwdUsedEnum.SERVER_CERT_TYPE.value == type) {
                if (isSign.booleanValue()) {
                    CertUtil.writeObjToFile((Object)privateKey, (String)(Constants.CA_ROOT_PRIVATE_PATH + "caServerSignCert.key"));
                } else {
                    CertUtil.writeObjToFile((Object)privateKey, (String)(Constants.CA_ROOT_PRIVATE_PATH + "caServerENCCert.key"));
                }
            }
            return publicKey;
        }
        catch (Exception e) {
            throw new ServiceException("\u4f7f\u7528BC\u751f\u6210\u516c\u79c1\u94a5\u5931\u8d25", (Throwable)e);
        }
    }

    public String signDataByHsm(Integer alg, Integer keyIndex, String privateKeyPin, String data) {
        try {
            if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_SWXA_HSM.intValue()) {
                this.logger.debug("\u4f7f\u7528\u4e09\u672a\u4fe1\u5b89HSM\u7b7e\u540d");
                SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(keyIndex.intValue(), null);
                if (AlgTypeEnum.RSA.value == alg) {
                    return GMSSLRSASignUtils.sign((PrivateKey)sdfPrivateKey, (byte[])data.getBytes(), (String)SignAlgTypeEnum.SHA256_WITH_RSA.algName).toString();
                }
                if (AlgTypeEnum.SM2.value == alg) {
                    return GMSSLECSignUtils.sign((PrivateKey)sdfPrivateKey, (byte[])data.getBytes(), null, (String)SignAlgTypeEnum.SHA256_WITH_RSA.algName).toString();
                }
                this.logger.debug("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b");
                throw new Exception("\u4e09\u672a\u4fe1\u5b89HSM\u4e0d\u652f\u6301[{}]\u7b97\u6cd5 " + alg);
            }
            this.logger.debug("\u4f7f\u7528\u4fe1\u5927\u6377\u5b89HSM\u7b7e\u540d");
            if (AlgTypeEnum.RSA.value == alg) {
                return GMSSLRSASignUtils.signByYunHsm((String)SignAlgTypeEnum.SHA256_WITH_RSA.algName, (int)keyIndex, (String)privateKeyPin, (String)data);
            }
            if (AlgTypeEnum.SM2.value == alg) {
                return GMSSLSM2SignUtils.signByYunhsm((int)keyIndex, (String)privateKeyPin, (String)Base64.toBase64String((byte[])data.getBytes()));
            }
            return Base64.toBase64String((byte[])GMSSLECSignUtils.signByYunHsm((int)keyIndex, (String)privateKeyPin, (byte[])Base64.decode((String)data), (String)SignAlgTypeEnum.SHA256_WITH_ECDSA.algName));
        }
        catch (Exception e) {
            this.logger.error("\u4f7f\u7528\u5bc6\u7801\u673a\u7b7e\u540d\u5f02\u5e38", (Throwable)e);
            throw new ServiceException("\u4f7f\u7528\u5bc6\u7801\u673a\u7b7e\u540d\u5f02\u5e38", (Throwable)e);
        }
    }

    public String signDataByDefaultHash(Integer alg, CaInfoVO caInfoVO, String data) {
        try {
            if (Constants.CRYPT_DEVICE_TYPE.equals(Constants.CRYPT_DEVICE_BC)) {
                return this.signDataByBC(alg, caInfoVO.getRootPrivateKey(), data);
            }
            return this.signDataByHsm(alg, caInfoVO.getCaPwdBean().getKeyIndex(), caInfoVO.getCaPwdBean().getPrivateKeyPin(), data);
        }
        catch (Exception e) {
            this.logger.error("\u4f7f\u7528\u5bc6\u7801\u673a\u7b7e\u540d\u5f02\u5e38", (Throwable)e);
            throw new ServiceException("\u4f7f\u7528\u5bc6\u7801\u673a\u7b7e\u540d\u5f02\u5e38", (Throwable)e);
        }
    }

    public String signDataByBC(Integer alg, PrivateKey privateKey, String data) {
        try {
            if (AlgTypeEnum.RSA.value == alg) {
                return GMSSLRSASignUtils.signByBC((String)SignAlgTypeEnum.SHA256_WITH_RSA.algName, (PrivateKey)privateKey, (String)data);
            }
            if (AlgTypeEnum.NISTP256.value == alg) {
                return Base64.toBase64String((byte[])GMSSLBCSignUtils.generateSignature((String)SignAlgTypeEnum.SHA256_WITH_ECDSA.algName, (PrivateKey)privateKey, (byte[])data.getBytes()));
            }
            if (AlgTypeEnum.SM2.value == alg) {
                return GMSSLSM2SignUtils.signByBC((PrivateKey)privateKey, (String)data);
            }
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b");
        }
        catch (Exception e) {
            this.logger.error("\u4f7f\u7528BC\u7b7e\u540d\u5f02\u5e38", (Throwable)e);
            throw new ServiceException("\u4f7f\u7528BC\u7b7e\u540d\u5f02\u5e38", (Throwable)e);
        }
    }

    public boolean verifySignByHsm(Integer alg, Integer keyIndex, String data, String sign) {
        try {
            PublicKey publicKey = this.getSignPublicKeyByHsm(keyIndex, alg);
            if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_SWXA_HSM.intValue()) {
                this.logger.debug("\u7cfb\u7edf\u91c7\u7528\u4e09\u672a\u4fe1\u5b89HSM\u8fdb\u884c\u9a8c\u7b7e");
                if (AlgTypeEnum.RSA.value == alg) {
                    return GMSSLRSASignUtils.verify((PublicKey)publicKey, (byte[])data.getBytes(), (byte[])sign.getBytes(), (String)SignAlgTypeEnum.SHA256_WITH_RSA.algName);
                }
                if (AlgTypeEnum.SM2.value == alg) {
                    return GMSSLECSignUtils.verify((PublicKey)publicKey, (byte[])data.getBytes(), (byte[])sign.getBytes(), null, (String)SignAlgTypeEnum.SM3_WITH_SM2.algName);
                }
                this.logger.debug("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b");
                throw new Exception("\u4e09\u672a\u4fe1\u5b89HSM\u4e0d\u652f\u6301[{}]\u7b97\u6cd5 " + alg);
            }
            this.logger.debug("\u7cfb\u7edf\u91c7\u7528\u4fe1\u5927\u6377\u5b89HSM\u8fdb\u884c\u9a8c\u7b7e");
            if (AlgTypeEnum.RSA.value == alg) {
                return GMSSLRSASignUtils.verifyByYunHsm((String)SignAlgTypeEnum.SHA256_WITH_RSA.algName, (PublicKey)publicKey, (String)data, (String)sign);
            }
            if (AlgTypeEnum.SM2.value == alg) {
                return GMSSLSM2SignUtils.verifyByYunhsm((PublicKey)publicKey, (String)Base64.toBase64String((byte[])data.getBytes()), (String)sign);
            }
            return GMSSLECSignUtils.verifyByYunHsm((PublicKey)publicKey, (String)data, (String)sign, (String)SignAlgTypeEnum.SHA256_WITH_ECDSA.algName);
        }
        catch (Exception e) {
            this.logger.error("\u4f7f\u7528\u5bc6\u7801\u673a\u9a8c\u8bc1\u7b7e\u540d\u5f02\u5e38", (Throwable)e);
            throw new ServiceException("\u4f7f\u7528\u5bc6\u7801\u673a\u9a8c\u8bc1\u7b7e\u540d\u5f02\u5e38", (Throwable)e);
        }
    }

    public boolean verifySignByBcDefaultAlg(Integer alg, PublicKey publicKey, String data, String sign) {
        try {
            if (AlgTypeEnum.RSA.value == alg) {
                return GMSSLRSASignUtils.verifyByBC((String)SignAlgTypeEnum.SHA256_WITH_RSA.algName, (PublicKey)publicKey, (String)data, (String)sign);
            }
            if (AlgTypeEnum.NISTP256.value == alg) {
                return GMSSLBCSignUtils.verifySignature((String)SignAlgTypeEnum.SHA256_WITH_ECDSA.algName, (PublicKey)publicKey, (byte[])data.getBytes(), (byte[])Base64.decode((String)sign));
            }
            if (AlgTypeEnum.SM2.value == alg) {
                return GMSSLSM2SignUtils.verifyByBC((PublicKey)publicKey, (String)data, (String)sign);
            }
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
        }
        catch (Exception e) {
            this.logger.error("\u4f7f\u7528\u5bc6\u7801\u673a\u9a8c\u8bc1\u7b7e\u540d\u5f02\u5e38", (Throwable)e);
            throw new ServiceException("\u4f7f\u7528\u5bc6\u7801\u673a\u9a8c\u8bc1\u7b7e\u540d\u5f02\u5e38", (Throwable)e);
        }
    }

    public boolean verifySignByDefaultHash(Integer alg, CaInfoVO caInfoVO, PublicKey publicKey, String data, String sign) {
        try {
            if (Constants.CRYPT_DEVICE_TYPE.equals(Constants.CRYPT_DEVICE_BC)) {
                return this.verifySignByBcDefaultAlg(alg, publicKey, data, sign);
            }
            return this.verifySignByHsm(alg, caInfoVO.getCaPwdBean().getKeyIndex(), data, sign);
        }
        catch (Exception e) {
            this.logger.error("\u4f7f\u7528\u5bc6\u7801\u673a\u9a8c\u8bc1\u7b7e\u540d\u5f02\u5e38", (Throwable)e);
            throw new ServiceException("\u4f7f\u7528\u5bc6\u7801\u673a\u9a8c\u8bc1\u7b7e\u540d\u5f02\u5e38", (Throwable)e);
        }
    }

    public PublicKey getEncPublicKeyByHsm(Integer keyIndex, Integer alg) {
        try {
            if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_SWXA_HSM.intValue()) {
                this.logger.debug("\u7cfb\u7edf\u91c7\u7528\u4e09\u672a\u4fe1\u5b89HSM\u83b7\u53d6\u52a0\u5bc6\u516c\u94a5\u4fe1\u606f");
                GMSSLPkiCryptoInit.getSancHsmInstance();
                if (AlgTypeEnum.RSA.value == alg) {
                    return GMSSLRSAKeyUtils.getPublicKeyFromHardware((int)keyIndex, (boolean)true);
                }
                if (AlgTypeEnum.SM2.value == alg) {
                    return GMSSLECKeyUtils.getPublicKeyFromHardware((int)keyIndex, (String)GMSSLECKeyUtils.SM2p256, (boolean)true);
                }
                this.logger.debug("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b");
                throw new Exception("\u4e09\u672a\u4fe1\u5b89HSM\u4e0d\u652f\u6301[{}]\u7b97\u6cd5 " + alg);
            }
            this.logger.debug("\u7cfb\u7edf\u91c7\u7528\u4fe1\u5927\u6377\u5b89HSM\u83b7\u53d6\u52a0\u5bc6\u516c\u94a5\u4fe1\u606f");
            if (alg == AlgTypeEnum.SM2.value) {
                return GMSSLECKeyUtils.getEncryptPublicKeyByYunhsm((int)keyIndex, (String)GMSSLECKeyUtils.SM2p256);
            }
            if (alg == AlgTypeEnum.RSA.value) {
                return GMSSLRSAKeyUtils.getEncryptPublicKeyByYunhsm((int)keyIndex);
            }
            return GMSSLECKeyUtils.getEncryptPublicKeyByYunhsm((int)keyIndex, (String)GMSSLECKeyUtils.NISTp256);
        }
        catch (Exception e) {
            throw new ServiceException("\u4f7f\u7528HSM\u751f\u6210\u516c\u79c1\u94a5\u5f02\u5e38", (Throwable)e);
        }
    }

    public String generateRandom(int length) {
        try {
            if (Constants.CRYPT_DEVICE_TYPE.equals(Constants.CRYPT_DEVICE_BC)) {
                byte[] bytes = RandomUtils.nextBytes((int)length);
                return Base64.toBase64String((byte[])bytes);
            }
            if (Constants.CRYPT_DEVICE_TYPE.equals(Constants.CRYPT_DEVICE_SWXA_HSM)) {
                GMSSLRandomUtils.generateRandom((int)length);
            }
            return GMSSLRandomUtils.generateRandomByYunhsm((int)length);
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u5bc6\u7801\u673a\u751f\u6210\u6570\u636e\u6570\u5931\u8d25", (Throwable)e);
            throw new InvokeException("\u8c03\u7528\u5bc6\u7801\u673a\u751f\u6210\u6570\u636e\u6570\u5931\u8d25", (Throwable)e);
        }
    }

    public boolean verifySign(int keyAlg, int degistAlg, PublicKey publicKey, byte[] sourceData, byte[] signData) {
        try {
            boolean flag = false;
            if (Constants.CRYPT_DEVICE_TYPE.equals(Constants.CRYPT_DEVICE_BC)) {
                this.logger.debug("\u4f7f\u7528BC\u8fdb\u884c\u9a8c\u7b7e");
                if (keyAlg == KeyAlgEnum.SM2.value && degistAlg == DigestAlgEnum.SM3.value) {
                    flag = GMSSLSM2SignUtils.verifyByBC((PublicKey)publicKey, (byte[])sourceData, (byte[])signData);
                } else if (keyAlg == KeyAlgEnum.RSA.value && degistAlg == DigestAlgEnum.SHA1.value) {
                    flag = GMSSLRSASignUtils.verifyByBC((String)SdfSHAType.SHA1_WITH_RSA.getSigAlgName(), (PublicKey)publicKey, (byte[])sourceData, (byte[])signData);
                } else if (keyAlg == KeyAlgEnum.RSA.value && degistAlg == DigestAlgEnum.SHA256.value) {
                    flag = GMSSLRSASignUtils.verifyByBC((String)SdfSHAType.SHA256_WITH_RSA.getSigAlgName(), (PublicKey)publicKey, (byte[])sourceData, (byte[])signData);
                } else if (keyAlg == KeyAlgEnum.NIST.value && degistAlg == DigestAlgEnum.SHA256.value) {
                    flag = GMSSLBCSignUtils.verifySignature((String)SignAlgTypeEnum.SHA256_WITH_ECDSA.algName, (PublicKey)publicKey, (byte[])sourceData, (byte[])signData);
                }
            } else if (Constants.CRYPT_DEVICE_TYPE.equals(Constants.CRYPT_DEVICE_XDJA_HSM)) {
                this.logger.debug("\u4f7f\u7528\u4fe1\u5927\u6377\u5b89HSM\u8fdb\u884c\u9a8c\u7b7e");
                if (keyAlg == KeyAlgEnum.SM2.value && degistAlg == DigestAlgEnum.SM3.value) {
                    flag = GMSSLSM2SignUtils.verifyBySdf((SdfCryptoType)SdfCryptoType.YUNHSM, (PublicKey)publicKey, (byte[])sourceData, (byte[])signData);
                } else if (keyAlg == KeyAlgEnum.RSA.value && degistAlg == DigestAlgEnum.SHA1.value) {
                    flag = GMSSLRSASignUtils.verifyByYunHsm((String)SdfSHAType.SHA1_WITH_RSA.getSigAlgName(), (PublicKey)publicKey, (byte[])sourceData, (byte[])signData);
                } else if (keyAlg == KeyAlgEnum.RSA.value && degistAlg == DigestAlgEnum.SHA256.value) {
                    flag = GMSSLRSASignUtils.verifyByYunHsm((String)SdfSHAType.SHA256_WITH_RSA.getSigAlgName(), (PublicKey)publicKey, (byte[])sourceData, (byte[])signData);
                } else if (keyAlg == KeyAlgEnum.NIST.value && degistAlg == DigestAlgEnum.SHA256.value) {
                    flag = GMSSLECSignUtils.verifyByBC((PublicKey)publicKey, (byte[])sourceData, (byte[])signData, (String)SignAlgTypeEnum.SHA256_WITH_ECDSA.algName);
                }
            } else {
                this.logger.debug("\u4f7f\u7528\u4e09\u672a\u4fe1\u5b89HSM\u8fdb\u884c\u9a8c\u7b7e");
                if (keyAlg == KeyAlgEnum.SM2.value && degistAlg == DigestAlgEnum.SM3.value) {
                    flag = GMSSLECSignUtils.verify((PublicKey)publicKey, (byte[])sourceData, (byte[])signData, null, (String)SignAlgTypeEnum.SM3_WITH_SM2.algName);
                } else if (keyAlg == KeyAlgEnum.RSA.value && degistAlg == DigestAlgEnum.SHA1.value) {
                    flag = GMSSLRSASignUtils.verify((PublicKey)publicKey, (byte[])sourceData, (byte[])signData, (String)SignAlgTypeEnum.SHA1_WITH_RSA.algName);
                } else if (keyAlg == KeyAlgEnum.RSA.value && degistAlg == DigestAlgEnum.SHA256.value) {
                    flag = GMSSLRSASignUtils.verify((PublicKey)publicKey, (byte[])sourceData, (byte[])signData, (String)SignAlgTypeEnum.SHA256_WITH_RSA.algName);
                } else if (keyAlg == KeyAlgEnum.NIST.value && degistAlg == DigestAlgEnum.SHA256.value) {
                    this.logger.debug("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5\u7c7b\u578b");
                    throw new Exception("\u4e09\u672a\u4fe1\u5b89HSM\u4e0d\u652f\u6301[{}]\u7b97\u6cd5 " + keyAlg);
                }
            }
            return flag;
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u5bc6\u7801\u673a\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25", (Throwable)e);
            throw new InvokeException("\u8c03\u7528\u5bc6\u7801\u673a\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25", (Throwable)e);
        }
    }

    public byte[] digest(byte[] data) {
        try {
            if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_XDJA_HSM.intValue()) {
                return GMSSLSM3DigestUtils.digestByYunhsm((byte[])data);
            }
            if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_SWXA_HSM.intValue()) {
                return GMSSLSM3DigestUtils.digest((byte[])data);
            }
            return GMSSLSM3DigestUtils.digestByBC((byte[])data);
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u5bc6\u7801\u673a\u83b7\u53d6\u6458\u8981\u5931\u8d25", (Throwable)e);
            throw new InvokeException("\u8c03\u7528\u5bc6\u7801\u673a\u83b7\u53d6\u6458\u8981\u5931\u8d25", (Throwable)e);
        }
    }

    public Result testAndSaveHsmConfig(HsmCertNameBean hsmCertNameBean, FileInputStream signCert, FileInputStream encCert, FileInputStream hsmCaChain) {
        try {
            Result result = Result.success();
            if (HsmInfoEnum.XDJA_HSM.hsmType == hsmCertNameBean.getHsmType()) {
                YunHsmExceptionEnum yunHsmExceptionEnum = GMSSLYunHsmUtils.initYunHsmConfigAndTestConnect((String)hsmCertNameBean.getIp(), (int)hsmCertNameBean.getPort(), (String)hsmCertNameBean.getSignCertPwd(), (String)hsmCertNameBean.getEncCertPwd(), (FileInputStream)signCert, (FileInputStream)encCert, (FileInputStream)hsmCaChain);
                this.logger.info("\u6d4b\u8bd5\u548c\u4fdd\u5b58\u5bc6\u7801\u4fe1\u606f\u914d\u7f6e\u4fe1\u606f\u8fd4\u56de\u503c\u4e3avalue=" + yunHsmExceptionEnum.value);
                switch (yunHsmExceptionEnum) {
                    case TELNET_PORT_FAILURE: {
                        result.setError(ErrorEnum.HSM_CONNECT_FAIL);
                        break;
                    }
                    case SIGN_PASSWORD_IS_ERROR: {
                        result.setError(ErrorEnum.SIGN_PFX_PWD_ERROR);
                        break;
                    }
                    case ENC_PASSWORD_IS_ERROR: {
                        result.setError(ErrorEnum.ENC_PFX_PWD_ERROR);
                        break;
                    }
                    case SIGN_CERT_VERIFY_IS_ERROR: {
                        result.setError(ErrorEnum.SIGN_PFX_FORMAT_ERROR);
                        break;
                    }
                    case ENC_CERT_VERIFY_IS_ERROR: {
                        result.setError(ErrorEnum.ENC_PFX_FORMAT_ERROR);
                        break;
                    }
                    case OPEN_DEVICE_IS_FAILURE: {
                        result.setError(ErrorEnum.HSM_CONNECT_FAIL);
                        break;
                    }
                    case OPEN_TRAIN_CERT_P7b_IS_ERROR: {
                        result.setError(ErrorEnum.HSM_CA_CHAIN_VERIFY_ERROR);
                        break;
                    }
                    case NORMAL: {
                        HsmCertNameBean oldHsmConfig = ConfigUtil.getHsmConfig((Environment)this.environment);
                        if (StringUtils.isBlank((CharSequence)hsmCertNameBean.getEncCert()) && null != oldHsmConfig) {
                            hsmCertNameBean.setEncCert(oldHsmConfig.getEncCert());
                        }
                        if (StringUtils.isBlank((CharSequence)hsmCertNameBean.getSignCert()) && null != oldHsmConfig) {
                            hsmCertNameBean.setSignCert(oldHsmConfig.getSignCert());
                        }
                        if (StringUtils.isBlank((CharSequence)hsmCertNameBean.getHsmCaChain()) && null != oldHsmConfig) {
                            hsmCertNameBean.setHsmCaChain(oldHsmConfig.getHsmCaChain());
                        }
                        ConfigUtil.saveHsmConfig((Environment)this.environment, (HsmCertNameBean)hsmCertNameBean);
                        break;
                    }
                    default: {
                        result.setError(ErrorEnum.HSM_CONNECT_FAIL);
                        break;
                    }
                }
            } else if (HsmInfoEnum.SWXA_HSM.hsmType == hsmCertNameBean.getHsmType()) {
                YunHsmExceptionEnum yunHsmExceptionEnum = GMSSLSancHsmUtils.initConfigAndTestConnect((String)hsmCertNameBean.getIp(), (int)hsmCertNameBean.getPort(), (String)hsmCertNameBean.getAccessPwd());
                this.logger.info("\u6d4b\u8bd5\u548c\u4fdd\u5b58\u5bc6\u7801\u4fe1\u606f\u914d\u7f6e\u4fe1\u606f\u8fd4\u56de\u503c\u4e3avalue=" + yunHsmExceptionEnum.value);
                switch (yunHsmExceptionEnum) {
                    case TELNET_PORT_FAILURE: {
                        result.setError(ErrorEnum.HSM_CONNECT_FAIL);
                        break;
                    }
                    case OPEN_DEVICE_IS_FAILURE: {
                        result.setError(ErrorEnum.HSM_CONNECT_FAIL);
                        break;
                    }
                    case NORMAL: {
                        HsmCertNameBean oldHsmConfig = ConfigUtil.getHsmConfig((Environment)this.environment);
                        if (StringUtils.isBlank((CharSequence)hsmCertNameBean.getAccessPwd()) && null != oldHsmConfig) {
                            hsmCertNameBean.setAccessPwd(oldHsmConfig.getAccessPwd());
                        }
                        ConfigUtil.saveHsmConfig((Environment)this.environment, (HsmCertNameBean)hsmCertNameBean);
                        break;
                    }
                    default: {
                        result.setError(ErrorEnum.HSM_CONNECT_FAIL);
                        break;
                    }
                }
            } else {
                throw new ServiceException("\u6d4b\u8bd5\u548c\u4fdd\u5b58\u5bc6\u7801\u673a\u914d\u7f6e\u4fe1\u606f\u65f6\u5bc6\u7801\u673a\u7c7b\u578b\u9519\u8bef");
            }
            return result;
        }
        catch (Exception e) {
            throw new ServiceException("\u6d4b\u8bd5\u548c\u4fdd\u5b58\u5bc6\u7801\u673a\u914d\u7f6e\u4fe1\u606f\u65f6\u5f02\u5e38", (Throwable)e);
        }
    }

    public String getNameByPath(String path) {
        String[] ss = path.split("\\\\");
        return ss[ss.length - 1];
    }

    public Result getHsmConfig() {
        try {
            HsmCertNameBean hsmCertNameBean = ConfigUtil.getHsmConfig((Environment)this.environment);
            if (null == hsmCertNameBean) {
                hsmCertNameBean = new HsmCertNameBean();
            }
            return Result.success((Object)hsmCertNameBean);
        }
        catch (Exception e) {
            throw new ServiceException("\u83b7\u53d6\u5bc6\u7801\u673a\u914d\u7f6e\u4fe1\u606f\u65f6\u5f02\u5e38", (Throwable)e);
        }
    }

    public Result testHsmConfig(HsmCertNameBean hsmCertNameBean, FileInputStream signCert, FileInputStream encCert, FileInputStream hsmCaCert) {
        Result result = Result.success();
        try {
            if (HsmInfoEnum.XDJA_HSM.hsmType == hsmCertNameBean.getHsmType()) {
                YunHsmExceptionEnum yunHsmExceptionEnum = GMSSLYunHsmUtils.testConnect((String)hsmCertNameBean.getIp(), (int)hsmCertNameBean.getPort(), (String)hsmCertNameBean.getSignCertPwd(), (String)hsmCertNameBean.getEncCertPwd(), (FileInputStream)signCert, (FileInputStream)encCert, (FileInputStream)hsmCaCert);
                this.logger.info(yunHsmExceptionEnum.value);
                switch (yunHsmExceptionEnum) {
                    case TELNET_PORT_FAILURE: {
                        result.setError(ErrorEnum.HSM_CONNECT_FAIL);
                        break;
                    }
                    case SIGN_PASSWORD_IS_ERROR: {
                        result.setError(ErrorEnum.SIGN_PFX_PWD_ERROR);
                        break;
                    }
                    case ENC_PASSWORD_IS_ERROR: {
                        result.setError(ErrorEnum.ENC_PFX_PWD_ERROR);
                        break;
                    }
                    case SIGN_CERT_VERIFY_IS_ERROR: {
                        result.setError(ErrorEnum.SIGN_PFX_FORMAT_ERROR);
                        break;
                    }
                    case ENC_CERT_VERIFY_IS_ERROR: {
                        result.setError(ErrorEnum.ENC_PFX_FORMAT_ERROR);
                        break;
                    }
                    case OPEN_DEVICE_IS_FAILURE: {
                        result.setError(ErrorEnum.HSM_CONNECT_FAIL);
                        break;
                    }
                    case OPEN_TRAIN_CERT_P7b_IS_ERROR: {
                        result.setError(ErrorEnum.HSM_CA_CHAIN_VERIFY_ERROR);
                        break;
                    }
                    case NORMAL: {
                        break;
                    }
                    default: {
                        result.setError(ErrorEnum.HSM_CONNECT_FAIL);
                        break;
                    }
                }
            } else if (HsmInfoEnum.SWXA_HSM.hsmType == hsmCertNameBean.getHsmType()) {
                YunHsmExceptionEnum yunHsmExceptionEnum = GMSSLSancHsmUtils.testConnect((String)hsmCertNameBean.getIp(), (int)hsmCertNameBean.getPort(), (String)hsmCertNameBean.getAccessPwd());
                this.logger.info(yunHsmExceptionEnum.value);
                switch (yunHsmExceptionEnum) {
                    case TELNET_PORT_FAILURE: {
                        result.setError(ErrorEnum.HSM_CONNECT_FAIL);
                        break;
                    }
                    case OPEN_DEVICE_IS_FAILURE: {
                        result.setError(ErrorEnum.HSM_CONNECT_FAIL);
                        break;
                    }
                    case NORMAL: {
                        break;
                    }
                    default: {
                        result.setError(ErrorEnum.HSM_CONNECT_FAIL);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u5bc6\u7801\u673a\u8fde\u63a5\u5f02\u5e38", (Throwable)e);
        }
        return result;
    }

    public void getCaServerPwd(Integer alg, Integer keySize, PublicKey signPublicKey, PublicKey encPublicKey, Integer keyIndex, String privateKeyPin) {
        try {
            if (alg == AlgTypeEnum.RSA.value || Constants.BASE_ALG_TYPE.intValue() == Constants.CRYPT_DEVICE_BC.intValue()) {
                signPublicKey = this.getPublicKey(alg, keySize, PwdUsedEnum.SERVER_CERT_TYPE.value, true);
                encPublicKey = this.getPublicKey(alg, keySize, PwdUsedEnum.SERVER_CERT_TYPE.value, false);
            } else {
                encPublicKey = this.getEncPublicKeyByCryptyDevice(keyIndex, PwdUsedEnum.SERVER_CERT_TYPE.value, alg, keySize);
                encPublicKey = this.getSignPublicKeyByCryptyDevice(keyIndex, PwdUsedEnum.SERVER_CERT_TYPE.value, alg, keySize);
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u83b7\u53d6CA\u670d\u52a1\u5668\u8bc1\u4e66\u5bc6\u94a5\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public PublicKey getCaSignServerPwd(Integer alg, Integer keySize, Integer keyIndex) {
        try {
            if (alg == AlgTypeEnum.NISTP256.value || alg == AlgTypeEnum.RSA.value || Constants.BASE_ALG_TYPE.intValue() == Constants.CRYPT_DEVICE_BC.intValue() || Constants.BASE_ALG_TYPE.intValue() == Constants.CRYPT_DEVICE_SWXA_HSM.intValue()) {
                return this.getPublicKey(alg, keySize, PwdUsedEnum.SERVER_CERT_TYPE.value, true);
            }
            return this.getSignPublicKeyByCryptyDevice(keyIndex, PwdUsedEnum.SERVER_CERT_TYPE.value, alg, keySize);
        }
        catch (Exception e) {
            throw new ServiceException("\u83b7\u53d6CA\u670d\u52a1\u5668\u8bc1\u4e66\u5bc6\u94a5\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public PublicKey getCaEncServerPwd(Integer alg, Integer keySize, Integer keyIndex) {
        try {
            if (alg == AlgTypeEnum.NISTP256.value || alg == AlgTypeEnum.RSA.value || Constants.BASE_ALG_TYPE.intValue() == Constants.CRYPT_DEVICE_BC.intValue() || Constants.BASE_ALG_TYPE.intValue() == Constants.CRYPT_DEVICE_SWXA_HSM.intValue()) {
                return this.getPublicKey(alg, keySize, PwdUsedEnum.SERVER_CERT_TYPE.value, false);
            }
            return this.getEncPublicKeyByCryptyDevice(keyIndex, PwdUsedEnum.SERVER_CERT_TYPE.value, alg, keySize);
        }
        catch (Exception e) {
            throw new ServiceException("\u83b7\u53d6CA\u670d\u52a1\u5668\u8bc1\u4e66\u5bc6\u94a5\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }
}

