/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.hsm.manager;

import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.hsm.manager.SoftAlgManager;
import com.xdja.pki.ca.securitymanager.service.vo.AlgTypeEnum;
import com.xdja.pki.gmssl.core.utils.GMSSLECUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECKeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSAKeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import java.security.KeyPair;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SoftAlgManagerImpl
implements SoftAlgManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public KeyPair generateKeyPair(Integer length) {
        try {
            KeyPair keyPair = null;
            if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_BC.intValue()) {
                if (Constants.BASE_ALG_TYPE == AlgTypeEnum.SM2.value) {
                    keyPair = GMSSLSM2KeyUtils.generateSM2KeyPairByBC();
                } else if (Constants.BASE_ALG_TYPE == AlgTypeEnum.RSA.value) {
                    Integer algLength = null == length ? 2048 : length;
                    keyPair = GMSSLRSAKeyUtils.generateKeyPairByBC((int)algLength);
                } else {
                    keyPair = GMSSLECUtils.generateKeyPair((String)NISTNamedCurves.getName((ASN1ObjectIdentifier)SECObjectIdentifiers.secp256r1));
                }
            } else if (Constants.BASE_ALG_TYPE == AlgTypeEnum.SM2.value) {
                keyPair = GMSSLECKeyUtils.generateECKeyPair((String)GMSSLECUtils.SM2p256);
            } else if (Constants.BASE_ALG_TYPE == AlgTypeEnum.RSA.value) {
                Integer algLength = null == length ? 2048 : length;
                keyPair = GMSSLRSAKeyUtils.generateRSAKeyPair((int)algLength);
            } else {
                keyPair = GMSSLECKeyUtils.generateECKeyPair((String)GMSSLECKeyUtils.NISTp256);
            }
            return keyPair;
        }
        catch (Exception e) {
            throw new ServiceException("\u751f\u6210\u516c\u79c1\u94a5\u5bf9\u5f02\u5e38", (Throwable)e);
        }
    }
}

