/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ca.bean;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;

public class SignedAndEnvelopedData
implements ASN1Encodable {
    private ASN1Integer version;
    private ASN1Set recipientInfos;
    private ASN1Set digestAlgorithms;
    private EncryptedContentInfo encryptedContentInfo;
    private ASN1Set certificates;
    private ASN1Set crls;
    private ASN1Set signerInfos;
    private boolean certsBer;
    private boolean crlsBer;

    public static SignedAndEnvelopedData getInstance(Object obj) {
        if (null == obj) {
            throw new IllegalArgumentException("unknown object in factory: ");
        }
        if (obj instanceof SignedAndEnvelopedData) {
            return (SignedAndEnvelopedData)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new SignedAndEnvelopedData((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory: " + obj.getClass().getName());
    }

    public SignedAndEnvelopedData(ASN1Integer version, ASN1Set recipientInfos, ASN1Set digestAlgorithms, EncryptedContentInfo encryptedContentInfo, ASN1Set certificates, ASN1Set crls, ASN1Set signerInfos) {
        this.version = version;
        this.recipientInfos = recipientInfos;
        this.digestAlgorithms = digestAlgorithms;
        this.encryptedContentInfo = encryptedContentInfo;
        this.certificates = certificates;
        this.crls = crls;
        this.signerInfos = signerInfos;
        this.crlsBer = crls instanceof BERSet;
        this.certsBer = certificates instanceof BERSet;
    }

    public SignedAndEnvelopedData(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.version = (ASN1Integer)e.nextElement();
        if (this.version.getValue().intValue() != 1) {
            throw new IllegalArgumentException("SignedAndEnvelopedData not version 1");
        }
        this.recipientInfos = (ASN1Set)e.nextElement();
        this.digestAlgorithms = (ASN1Set)e.nextElement();
        this.encryptedContentInfo = EncryptedContentInfo.getInstance(e.nextElement());
        while (e.hasMoreElements()) {
            ASN1Object o = (ASN1Object)e.nextElement();
            if (o instanceof DERTaggedObject) {
                DERTaggedObject tagged = (DERTaggedObject)o;
                switch (tagged.getTagNo()) {
                    case 0: {
                        this.certificates = ASN1Set.getInstance((ASN1TaggedObject)tagged, (boolean)false);
                        break;
                    }
                    case 1: {
                        this.crls = ASN1Set.getInstance((ASN1TaggedObject)tagged, (boolean)false);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown tag value " + tagged.getTagNo());
                    }
                }
                continue;
            }
            this.signerInfos = (ASN1Set)o;
        }
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public ASN1Set getRecipientInfos() {
        return this.recipientInfos;
    }

    public ASN1Set getDigestAlgorithms() {
        return this.digestAlgorithms;
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    public ASN1Set getCertificates() {
        return this.certificates;
    }

    public ASN1Set getCrls() {
        return this.crls;
    }

    public ASN1Set getSignerInfos() {
        return this.signerInfos;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.version);
        v.add((ASN1Encodable)this.recipientInfos);
        v.add((ASN1Encodable)this.digestAlgorithms);
        v.add((ASN1Encodable)this.encryptedContentInfo);
        if (this.certificates != null) {
            if (this.certsBer) {
                v.add((ASN1Encodable)new BERTaggedObject(false, 0, (ASN1Encodable)this.certificates));
            } else {
                v.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)this.certificates));
            }
        }
        if (this.crls != null) {
            if (this.crlsBer) {
                v.add((ASN1Encodable)new BERTaggedObject(false, 1, (ASN1Encodable)this.crls));
            } else {
                v.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)this.crls));
            }
        }
        v.add((ASN1Encodable)this.signerInfos);
        return new BERSequence(v);
    }

    public byte[] getDEREncoded() {
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream((OutputStream)bOut);
            dOut.writeObject((ASN1Encodable)this);
            return bOut.toByteArray();
        }
        catch (IOException var2) {
            return null;
        }
    }
}

