/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ca.cache;

import com.xdja.ca.cache.JedisAction;
import com.xdja.ca.cache.JedisActionNoResult;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.util.Pool;

public class RedisClient {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String LOCK_SUCCESS = "OK";
    private static final Long RELEASE_SUCCESS = 1L;
    private static final String SET_IF_NOT_EXIST = "NX";
    private static final String SET_IF_EXIST = "XX";
    private static final String SET_WITH_EXPIRE_TIME_IN_SECONDS = "EX";
    private static final String SET_WITH_EXPIRE_TIME_IN_MILLISECONDS = "PX";
    private Pool<Jedis> jedisPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RedisClient(Pool<Jedis> jedisPool) {
        Class<RedisClient> clazz = RedisClient.class;
        synchronized (RedisClient.class) {
            if (this.jedisPool == null) {
                this.jedisPool = jedisPool;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public <T> T execute(JedisAction<T> jedisAction) throws JedisException {
        try (Jedis jedis = null;){
            jedis = (Jedis)this.jedisPool.getResource();
            T t = jedisAction.action(jedis);
            return t;
        }
    }

    public void execute(JedisActionNoResult jedisAction) throws JedisException {
        try (Jedis jedis = null;){
            jedis = (Jedis)this.jedisPool.getResource();
            jedisAction.action(jedis);
        }
    }

    public boolean isRunning() {
        try {
            return this.execute(new JedisAction<Boolean>(){

                @Override
                public Boolean action(Jedis jedis) {
                    String result = jedis.ping();
                    return RedisClient.LOCK_SUCCESS.equals(result) || "PONG".equals(result);
                }
            });
        }
        catch (Exception e) {
            this.logger.error("\u68c0\u67e5redis\u670d\u52a1\u72b6\u6001\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public void flushDB() {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.flushDB();
            }
        });
    }

    public Long del(final String ... keys) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.del(keys);
            }
        });
    }

    public void set(final String key, final String value) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.set(key, value);
            }
        });
    }

    public String get(final String key) {
        return this.execute(new JedisAction<String>(){

            @Override
            public String action(Jedis jedis) {
                return jedis.get(key);
            }
        });
    }

    public String getSet(final String key, final String value) {
        return this.execute(new JedisAction<String>(){

            @Override
            public String action(Jedis jedis) {
                return jedis.getSet(key, value);
            }
        });
    }

    public void setex(final String key, final int seconds, final String value) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.setex(key, seconds, value);
            }
        });
    }

    public boolean setnx(final String key, final String value) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return jedis.setnx(key, value) == 1L;
            }
        });
    }

    public void mset(final String ... keysvalues) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.mset(keysvalues);
            }
        });
    }

    public List<String> mget(final String ... keys) {
        return this.execute(new JedisAction<List<String>>(){

            @Override
            public List<String> action(Jedis jedis) {
                return jedis.mget(keys);
            }
        });
    }

    public boolean exists(final String key) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return jedis.exists(key);
            }
        });
    }

    public Long lpush(final String key, final String ... values) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.lpush(key, values);
            }
        });
    }

    public Long rpush(final String key, final String ... values) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.rpush(key, values);
            }
        });
    }

    public String lpop(final String key) {
        return this.execute(new JedisAction<String>(){

            @Override
            public String action(Jedis jedis) {
                return jedis.lpop(key);
            }
        });
    }

    public String rpop(final String key) {
        return this.execute(new JedisAction<String>(){

            @Override
            public String action(Jedis jedis) {
                return jedis.rpop(key);
            }
        });
    }

    public Long llen(final String key) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.llen(key);
            }
        });
    }

    public Boolean lremOne(final String key, final String value) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return jedis.lrem(key, 1L, value) != 0L;
            }
        });
    }

    public Boolean rremOne(final String key, final String value) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return jedis.lrem(key, -1L, value) != 0L;
            }
        });
    }

    public Boolean remAll(final String key, final String value) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return jedis.lrem(key, 0L, value) != 0L;
            }
        });
    }

    public List<String> lrange(final String key, final long start, final long end) {
        return this.execute(new JedisAction<List<String>>(){

            @Override
            public List<String> action(Jedis jedis) {
                return jedis.lrange(key, start, end);
            }
        });
    }

    public String brpoplpush(final String srckey, final String dstkey) {
        return this.execute(new JedisAction<String>(){

            @Override
            public String action(Jedis jedis) {
                return jedis.brpoplpush(srckey, dstkey, 0);
            }
        });
    }

    public void hset(final String key, final String field, final String value) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.hset(key, field, value);
            }
        });
    }

    public String hget(final String key, final String field) {
        return this.execute(new JedisAction<String>(){

            @Override
            public String action(Jedis jedis) {
                return jedis.hget(key, field);
            }
        });
    }

    public boolean hexists(final String key, final String field) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return jedis.hexists(key, field);
            }
        });
    }

    public Long hlen(final String key) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.hlen(key);
            }
        });
    }

    public Long hdel(final String key, final String ... fields) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.hdel(key, fields);
            }
        });
    }

    public Set<String> hkeys(final String key) {
        return this.execute(new JedisAction<Set<String>>(){

            @Override
            public Set<String> action(Jedis jedis) {
                return jedis.hkeys(key);
            }
        });
    }

    public void hmset(final String key, final Map<String, String> hash) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.hmset(key, hash);
            }
        });
    }

    public List<String> hmget(final String key, final String ... fields) {
        return this.execute(new JedisAction<List<String>>(){

            @Override
            public List<String> action(Jedis jedis) {
                return jedis.hmget(key, fields);
            }
        });
    }

    public Map<String, String> hgetAll(final String key) {
        return this.execute(new JedisAction<Map<String, String>>(){

            @Override
            public Map<String, String> action(Jedis jedis) {
                return jedis.hgetAll(key);
            }
        });
    }

    public void zadd(final String key, final Map<String, Double> members) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.zadd(key, members);
            }
        });
    }

    public void zaddOrUpdate(final String key, final String member, final double score) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.zadd(key, score, member);
            }
        });
    }

    public Set<String> zrangeGteMinLteMax(final String key, final double min, final double max) {
        return this.execute(new JedisAction<Set<String>>(){

            @Override
            public Set<String> action(Jedis jedis) {
                return jedis.zrangeByScore(key, min, max);
            }
        });
    }

    public Set<String> zrangeGteMinLtMax(final String key, final double min, final double max) {
        return this.execute(new JedisAction<Set<String>>(){

            @Override
            public Set<String> action(Jedis jedis) {
                return jedis.zrangeByScore(key, String.valueOf(min), "(" + max);
            }
        });
    }

    public Set<String> zrangeGtMinLteMax(final String key, final double min, final double max) {
        return this.execute(new JedisAction<Set<String>>(){

            @Override
            public Set<String> action(Jedis jedis) {
                return jedis.zrangeByScore(key, "(" + min, String.valueOf(max));
            }
        });
    }

    public Set<String> zrangeGtMinLtMax(final String key, final double min, final double max) {
        return this.execute(new JedisAction<Set<String>>(){

            @Override
            public Set<String> action(Jedis jedis) {
                return jedis.zrangeByScore(key, "(" + min, "(" + max);
            }
        });
    }

    public Set<String> zrangeGtScore(final String key, final double score) {
        return this.execute(new JedisAction<Set<String>>(){

            @Override
            public Set<String> action(Jedis jedis) {
                double max = 0.0;
                Set set = jedis.zrangeWithScores(key, -1L, -1L);
                if (null != set && set.iterator().hasNext()) {
                    max = ((Tuple)set.iterator().next()).getScore();
                }
                return jedis.zrangeByScore(key, "(" + score, String.valueOf(max));
            }
        });
    }

    public Set<String> zrangeGteScore(final String key, final double score) {
        return this.execute(new JedisAction<Set<String>>(){

            @Override
            public Set<String> action(Jedis jedis) {
                double max = 0.0;
                Set set = jedis.zrangeWithScores(key, -1L, -1L);
                if (null != set && set.iterator().hasNext()) {
                    max = ((Tuple)set.iterator().next()).getScore();
                }
                return jedis.zrangeByScore(key, score, max);
            }
        });
    }

    public Set<String> zrangeLtScore(final String key, final double score) {
        return this.execute(new JedisAction<Set<String>>(){

            @Override
            public Set<String> action(Jedis jedis) {
                double min = 0.0;
                Set set = jedis.zrangeWithScores(key, 0L, 0L);
                if (null != set && set.iterator().hasNext()) {
                    min = ((Tuple)set.iterator().next()).getScore();
                }
                return jedis.zrangeByScore(key, String.valueOf(min), "(" + score);
            }
        });
    }

    public Set<String> zrangeLteScore(final String key, final double score) {
        return this.execute(new JedisAction<Set<String>>(){

            @Override
            public Set<String> action(Jedis jedis) {
                double min = 0.0;
                Set set = jedis.zrangeWithScores(key, 0L, 0L);
                if (null != set && set.iterator().hasNext()) {
                    min = ((Tuple)set.iterator().next()).getScore();
                }
                return jedis.zrangeByScore(key, min, score);
            }
        });
    }

    public void subscribe(final JedisPubSub subscriber, final String ... channel) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.subscribe(subscriber, channel);
            }
        });
    }

    public Long publish(final String channel, final String message) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.publish(channel, message);
            }
        });
    }

    public Boolean lock(final String lockKey, final String value) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                String result = jedis.set(lockKey, value, RedisClient.SET_IF_NOT_EXIST);
                return RedisClient.LOCK_SUCCESS.equals(result);
            }
        });
    }

    public Boolean lock(final String lockKey, final String value, final int expireTime) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                String result = jedis.set(lockKey, value, RedisClient.SET_IF_NOT_EXIST, RedisClient.SET_WITH_EXPIRE_TIME_IN_SECONDS, expireTime);
                return RedisClient.LOCK_SUCCESS.equals(result);
            }
        });
    }

    public Boolean releaseDistributedLock(final String lockKey, final String value) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                String script = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
                Object result = jedis.eval(script, Collections.singletonList(lockKey), Collections.singletonList(value));
                return RELEASE_SUCCESS.equals(result);
            }
        });
    }

    public Long releaseLock(final String lockKey) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.del(lockKey);
            }
        });
    }

    public Long incr(final String key) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.incr(key);
            }
        });
    }

    public Long expire(final String key, final int expireTime) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.expire(key, expireTime);
            }
        });
    }
}

