/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ca.pkcs7;

import com.xdja.ca.asn1.DigestObjectIdentifiers;
import com.xdja.ca.asn1.RsaObjectIdentifiers;
import com.xdja.ca.asn1.SM2ObjectIdentifiers;
import com.xdja.ca.constant.SdkConstants;
import com.xdja.ca.pkcs7.Sm4;
import com.xdja.ca.utils.DnUtil;
import com.xdja.ca.utils.SdkCertUtils;
import com.xdja.ca.utils.SdkHsmUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricKeyParameters;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2EncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM4ECBEncryptUtils;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pkcs7Utils {
    private static final Logger logger = LoggerFactory.getLogger(Pkcs7Utils.class);
    public static final String PKCS7_TYPE = "PKCS7";
    public static final String PKCS_BEGIN_HEADER = "-----BEGIN PKCS7-----";
    public static final String PKCS_END_HEADER = "-----END PKCS7-----";
    static final ASN1ObjectIdentifier smAlgorithm = new ASN1ObjectIdentifier("1.2.156.10197.1");
    static final ASN1ObjectIdentifier sm4 = smAlgorithm.branch("104");
    static final ASN1ObjectIdentifier sm2256 = smAlgorithm.branch("301");
    static final ASN1ObjectIdentifier sm2256_encrypt = sm2256.branch("3");
    static final ASN1ObjectIdentifier rsa = new ASN1ObjectIdentifier("1.2.840.113549.1.1.1");

    public static ASN1Set makeRecipientInfos(Integer caAlg, String protectPublicKeyCertIssuerDN, BigInteger protectPublicKeyCertSN, PublicKey protectPublicKey, byte[] sessionKey) throws Exception {
        RecipientIdentifier rid = new RecipientIdentifier(new IssuerAndSerialNumber(DnUtil.getRFC4519X500Name(protectPublicKeyCertIssuerDN), protectPublicKeyCertSN));
        AlgorithmIdentifier keyEncryptionAlgorithm = null;
        DEROctetString encryptedKey = null;
        if (SdkConstants.RSA_ALG_1.intValue() == caAlg.intValue()) {
            keyEncryptionAlgorithm = new AlgorithmIdentifier(rsa);
            RSAPublicKey publicKey = (RSAPublicKey)protectPublicKey;
            PKCS1Encoding theEngine = new PKCS1Encoding((AsymmetricBlockCipher)new RSABlindedEngine());
            RSAKeyParameters rsaKeyParameters = new RSAKeyParameters(false, publicKey.getModulus(), publicKey.getPublicExponent());
            theEngine.init(true, (CipherParameters)rsaKeyParameters);
            encryptedKey = new DEROctetString(theEngine.processBlock(sessionKey, 0, sessionKey.length));
        } else {
            keyEncryptionAlgorithm = new AlgorithmIdentifier(sm2256_encrypt);
            try {
                String encData = GMSSLSM2EncryptUtils.encryptASN1ByYunhsm((PublicKey)protectPublicKey, (String)GMSSLByteArrayUtils.base64Encode((byte[])sessionKey));
                encryptedKey = new DEROctetString(GMSSLByteArrayUtils.base64Decode((String)encData));
            }
            catch (Exception e) {
                logger.error("\u4f7f\u7528\u516c\u94a5\u52a0\u5bc6\u4f1a\u8bdd\u5bc6\u94a5\u5f02\u5e38", (Throwable)e);
                throw new Exception("\u4f7f\u7528\u516c\u94a5\u52a0\u5bc6\u4f1a\u8bdd\u5bc6\u94a5\u5f02\u5e38");
            }
        }
        KeyTransRecipientInfo keyTransRecipientInfo = new KeyTransRecipientInfo(rid, keyEncryptionAlgorithm, (ASN1OctetString)encryptedKey);
        return new DERSet((ASN1Encodable)keyTransRecipientInfo);
    }

    public static EncryptedContentInfo makeEncryptedContentInfo(Integer caAlg, byte[] encryptedContentInfo) {
        DERObjectIdentifier contentType = new DERObjectIdentifier("1.2.156.10197.6.1.4.2.104");
        AlgorithmIdentifier contentEncryptionAlgorithm = null;
        ASN1OctetString encryptedContent = null;
        return new EncryptedContentInfo((ASN1ObjectIdentifier)contentType, contentEncryptionAlgorithm, encryptedContent);
    }

    public EncryptedContentInfo makeEncryptedContentInfo(Integer caAlg, byte[] sessionKey, X509Certificate encCert) throws Exception {
        DERObjectIdentifier contentType = new DERObjectIdentifier("1.2.156.10197.6.1.4.2.104");
        AlgorithmIdentifier contentEncryptionAlgorithm = null;
        DEROctetString encryptedContent = null;
        if (SdkConstants.RSA_ALG_1.intValue() == caAlg.intValue()) {
            contentEncryptionAlgorithm = new AlgorithmIdentifier(sm4);
            try {
                encryptedContent = new DEROctetString(Sm4.sm4_encrypt_ecb(sessionKey, SdkCertUtils.writeObjectToByteArray(encCert)));
            }
            catch (Exception e) {
                logger.error("\u52a0\u5bc6\u5f02\u5e38", (Throwable)e);
                throw new Exception("\u52a0\u5bc6\u5f02\u5e38");
            }
        } else {
            contentEncryptionAlgorithm = new AlgorithmIdentifier(sm4);
            byte[] bsRequsetS = SdkCertUtils.writeObjectToByteArray(encCert);
            byte[] encData = GMSSLSM4ECBEncryptUtils.sm4SymmetricSdfWithPadding((boolean)true, (SdfCryptoType)SdfCryptoType.YUNHSM, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding, (byte[])sessionKey, (byte[])bsRequsetS);
            encryptedContent = new DEROctetString(encData);
        }
        return new EncryptedContentInfo((ASN1ObjectIdentifier)contentType, contentEncryptionAlgorithm, (ASN1OctetString)encryptedContent);
    }

    public static void printBytes(byte[] bs) {
        if (bs == null) {
            logger.info("bs is null =======================\n");
            return;
        }
        for (int i = 0; i < bs.length; ++i) {
            if (i % 20 == 0) {
                System.out.printf("%4s:  ", i);
            }
            System.out.print(Pkcs7Utils.toHex(bs[i]));
            if (i % 10 == 9) {
                System.out.print("  ");
            }
            if (i % 20 == 19) {
                System.out.print("\n");
                continue;
            }
            System.out.print(" ");
        }
        System.out.println("\n");
    }

    public static final String toHex(byte b) {
        return "" + "0123456789ABCDEF".charAt(0xF & b >> 4) + "0123456789ABCDEF".charAt(b & 0xF);
    }

    public static ASN1Set makeSignerInfos(byte[] raSignPriKey, boolean isUseHsm, String caAlg, String keyGeneraterCertIssuerDN, BigInteger keyGeneraterCertSN, int privateKeyIndex, String privateKeyPassword, byte[] structData) throws Exception {
        SignerIdentifier sid = new SignerIdentifier(new IssuerAndSerialNumber(DnUtil.getRFC4519X500Name(keyGeneraterCertIssuerDN), keyGeneraterCertSN));
        AlgorithmIdentifier digAlgorithm = null;
        AlgorithmIdentifier digEncryptionAlgorithm = null;
        String signature = null;
        if ("SHA-1WithRSA".equalsIgnoreCase(caAlg) || "SHA1WithRSA".equalsIgnoreCase(caAlg) || "SHA256WithRSA".equalsIgnoreCase(caAlg)) {
            digAlgorithm = new AlgorithmIdentifier(DigestObjectIdentifiers.sha1);
            digEncryptionAlgorithm = new AlgorithmIdentifier(RsaObjectIdentifiers.rsaEncryption);
        } else {
            digAlgorithm = new AlgorithmIdentifier(DigestObjectIdentifiers.sm3);
            digEncryptionAlgorithm = new AlgorithmIdentifier(SM2ObjectIdentifiers.sm2256_sign);
        }
        signature = isUseHsm ? SdkHsmUtils.signByYunHsm(caAlg, privateKeyIndex, privateKeyPassword, Base64.toBase64String((byte[])structData)) : SdkHsmUtils.signByBC(caAlg, raSignPriKey, Base64.toBase64String((byte[])structData));
        DEROctetString encryptedDigest = new DEROctetString(GMSSLByteArrayUtils.base64Decode((String)signature));
        ASN1OctetString encryptedDigestString = ASN1OctetString.getInstance((Object)encryptedDigest);
        ASN1Set asn1Set = null;
        SignerInfo signerInfo = new SignerInfo(sid, digAlgorithm, asn1Set, digEncryptionAlgorithm, encryptedDigestString, null);
        return new DERSet((ASN1Encodable)signerInfo);
    }

    public static String createCertChainByCerts(List<X509Certificate> certificateList) throws Exception {
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        try {
            CMSProcessableByteArray msg = new CMSProcessableByteArray("".getBytes());
            JcaCertStore jcaCertStore = new JcaCertStore(certificateList);
            gen.addCertificates((Store)jcaCertStore);
            CMSSignedData cmsSignedData = gen.generate((CMSTypedData)msg);
            return Pkcs7Utils.writeP7bPem(cmsSignedData.toASN1Structure());
        }
        catch (Exception e) {
            throw new Exception("\u521b\u5efa\u8bc1\u4e66\u94fe\u5f02\u5e38", e);
        }
    }

    public static List<X509Certificate> resolveCertChain(String certChain) throws Exception {
        String b64Cert = certChain.replace(PKCS_BEGIN_HEADER, "");
        b64Cert = b64Cert.replace(PKCS_END_HEADER, "");
        b64Cert = b64Cert.replace("\r", "");
        b64Cert = b64Cert.replace("\n", "");
        try {
            CMSSignedData cmsSignedDataResolve = new CMSSignedData(Base64.decode((String)b64Cert));
            return Pkcs7Utils.getX509CertificateListFromSignedData(cmsSignedDataResolve);
        }
        catch (Exception e) {
            throw new Exception("\u89e3\u6790\u8bc1\u4e66\u94fe\u5f02\u5e38", e);
        }
    }

    public static List<X509Certificate> getX509CertificateListFromSignedData(CMSSignedData cmsSignedData) throws Exception {
        ArrayList<X509Certificate> certificateList = new ArrayList<X509Certificate>();
        try {
            Store store = cmsSignedData.getCertificates();
            Collection collection = store.getMatches(null);
            for (X509CertificateHolder x509CertificateHolder : collection) {
                X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(x509CertificateHolder);
                certificateList.add(x509Certificate);
            }
            return certificateList;
        }
        catch (Exception e) {
            throw new Exception("\u4ececmsSignedData\u4e2d\u83b7\u53d6\u8bc1\u4e66\u94fe\u5f02\u5e38", e);
        }
    }

    public static String writeP7bPem(ContentInfo contentInfo) throws Exception {
        try {
            PemObject pemObject = new PemObject(PKCS7_TYPE, contentInfo.getEncoded("DER"));
            return Pkcs7Utils.writePemObject(pemObject);
        }
        catch (Exception e) {
            throw new Exception("\u5c06p7b\u5bf9\u8c61\u8f6c\u6362\u4e3aPem\u683c\u5f0f\u5f02\u5e38", e);
        }
    }

    public static String writeP7bPem(CMSSignedData cmsSignedData) throws Exception {
        try {
            PemObject pemObject = new PemObject(PKCS7_TYPE, cmsSignedData.toASN1Structure().getEncoded("DER"));
            return Pkcs7Utils.writePemObject(pemObject);
        }
        catch (Exception e) {
            throw new Exception("\u5c06p7b\u5bf9\u8c61\u8f6c\u6362\u4e3aPem\u683c\u5f0f\u5f02\u5e38", e);
        }
    }

    public static String writePemObject(PemObject pemObject) throws Exception {
        PemWriter pemWriter = null;
        try {
            StringWriter stringWriter = new StringWriter();
            pemWriter = new PemWriter((Writer)stringWriter);
            pemWriter.writeObject((PemObjectGenerator)pemObject);
            pemWriter.flush();
            String string = stringWriter.toString();
            return string;
        }
        catch (Exception e) {
            throw new Exception("\u6253\u5370pemObject\u5bf9\u8c61\u5f02\u5e38", e);
        }
        finally {
            if (null != pemWriter) {
                pemWriter.close();
            }
        }
    }
}

