/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ca.service.impl;

import com.xdja.ca.cache.RedisClient;
import com.xdja.ca.constant.SdkCommonVariable;
import com.xdja.ca.service.CaSdkRedisCacheManagerService;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaSdkRedisCacheManagerServiceImpl
implements CaSdkRedisCacheManagerService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private RedisClient redisClient;
    private int transIdExpireTime;
    private boolean enableRedis;

    public CaSdkRedisCacheManagerServiceImpl() {
        this.enableRedis = false;
    }

    public CaSdkRedisCacheManagerServiceImpl(RedisClient redisClient, int transIdExpireTime) {
        this.redisClient = redisClient;
        this.transIdExpireTime = transIdExpireTime;
        this.enableRedis = true;
    }

    @Override
    public Boolean cacheCaSdkCmpInfo(String transId, String baseCmpInfo) {
        if (this.enableRedis) {
            String key = MessageFormat.format("ra:cache:cmpinfo:casdk:{0}", transId);
            boolean success = this.redisClient.lock(key, baseCmpInfo, this.transIdExpireTime);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("cacheCaSdkCmpInfo key:[{}], baseCmpInfo:[{}], transIdExpireTime:[{}] success:[{}]", new Object[]{key, baseCmpInfo, this.transIdExpireTime, success});
            }
            if (success) {
                return success;
            }
            throw new RuntimeException("\u9501\u5b9a\u5931\u8d25");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("cacheCaSdkCmpInfo transId:[{}], baseCmpInfo:[{}], transIdExpireTime:[{}] ", new Object[]{transId, baseCmpInfo, this.transIdExpireTime});
        }
        SdkCommonVariable.setCmpInfo(transId, baseCmpInfo);
        return true;
    }

    @Override
    public String removeCaSdkCmpInfo(String transId) {
        if (this.enableRedis) {
            String key = MessageFormat.format("ra:cache:cmpinfo:casdk:{0}", transId);
            String value = this.redisClient.get(key);
            this.redisClient.releaseLock(key);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("removeCaSdkCmpInfo key:[{}], baseCmpInfo:[{}]", (Object)key, (Object)value);
            }
            return value;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("removeCaSdkCmpInfo transId:[{}]", (Object)transId);
        }
        return SdkCommonVariable.removeCmpInfo(transId);
    }

    @Override
    public String getCaSdkCmpInfo(String transId) {
        if (this.enableRedis) {
            String key = MessageFormat.format("ra:cache:cmpinfo:casdk:{0}", transId);
            String value = this.redisClient.get(key);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("getCaSdkCmpInfo key:[{}], baseCmpInfo:[{}]", (Object)key, (Object)value);
            }
            return value;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getCaSdkCmpInfo transId:[{}]", (Object)transId);
        }
        return SdkCommonVariable.getCmpInfo(transId);
    }

    @Override
    public Long getIncCaCmpReqId() {
        Long returnLong = this.wrapIncNumber("ra:incr:cmpinfo:casdk");
        this.logger.debug("getIncCaCmpReqId key:[{}], returnLong:[{}]", (Object)"ra:incr:cmpinfo:casdk", (Object)returnLong);
        return returnLong;
    }

    private long wrapIncNumber(String redisIncKey) {
        Long incrNumber = this.redisClient.incr(redisIncKey);
        incrNumber = incrNumber % 1000000L + 9000000L;
        return System.currentTimeMillis() * 1000000L + incrNumber;
    }
}

