/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ca.utils;

import com.xdja.ca.error.ErrorBean;
import com.xdja.ca.error.ErrorEnum;
import com.xdja.ca.sdk.SdkResult;
import com.xdja.ca.utils.OpenApiReqSignDataUtil;
import com.xdja.ca.utils.SdkHsmUtils;
import com.xdja.ca.utils.SdkJsonUtils;
import com.xdja.pki.apache.client.core.ApacheHttpException;
import com.xdja.pki.apache.client.core.ClientErrorBean;
import com.xdja.pki.apache.client.core.ClientErrorEnum;
import com.xdja.pki.apache.client.result.AdaptClientResult;
import com.xdja.pki.apache.client.result.ClientResult;
import com.xdja.pki.apache.client.utils.ApacheClientHttpUtils;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientHttpUtils {
    protected static final transient Logger logger = LoggerFactory.getLogger(ClientHttpUtils.class);

    private static ErrorEnum getErrorEnum(ErrorBean errorBean) {
        String errCode = String.valueOf(errorBean.getErrCode());
        ErrorEnum errorEnumByCode = ErrorEnum.getErrorEnumByCode(errCode);
        if (null != errorEnumByCode) {
            return errorEnumByCode;
        }
        if ("10001".equals(errCode)) {
            return ErrorEnum.CA_ILLEGAL_REQUEST_PARAMETER;
        }
        if ("10002".equals(errCode)) {
            return ErrorEnum.CA_MISSING_REQUIRED_PARAMETERS;
        }
        logger.info("=================CA\u7684open-api\u5185\u90e8\u5f02\u5e38==================");
        return ErrorEnum.CA_OPEN_API_INNER_EXCEPTION;
    }

    public static SdkResult sendApacheClientRequest(int keyIndex, String pwd, byte[] privateKey, byte[] reqBody, Map<String, String> paramsMap, String url, String contentType, String raSignSn, X509Certificate[] caCerts, String protectionAlgName, boolean isHttps, boolean isUseHsm, String requestMethod) throws ApacheHttpException {
        SdkResult sdkResult = new SdkResult();
        logger.debug("===============================\u901a\u8fc7\u5bc6\u7801\u673a\u914d\u7f6e\u548c\u7b97\u6cd5\u786e\u5b9a\u901a\u9053\u662f\u5426\u4f7f\u7528\u5bc6\u7801\u673a:{}", (Object)isUseHsm);
        if (isUseHsm) {
            if (keyIndex >= 32 || keyIndex <= 0) {
                sdkResult.setError(ErrorEnum.CMP_API_PARAMS_KEY_INDEX_IS_ERROR);
                return sdkResult;
            }
            if (StringUtils.isBlank((CharSequence)pwd)) {
                sdkResult.setError(ErrorEnum.CMP_API_PARAMS_KEY_PWD_IS_EMPTY);
                return sdkResult;
            }
        } else if (privateKey == null) {
            sdkResult.setError(ErrorEnum.CMP_API_PARAMS_RA_PRIVATE_KEY_IS_EMPTY);
            return sdkResult;
        }
        if (StringUtils.isBlank((CharSequence)raSignSn)) {
            sdkResult.setError(ErrorEnum.CMP_API_PARAMS_RA_SIGN_SN_IS_EMPTY);
            return sdkResult;
        }
        String time = String.valueOf(System.currentTimeMillis());
        String signData = null;
        String base64Data = null;
        try {
            if ("post".equalsIgnoreCase(requestMethod)) {
                base64Data = OpenApiReqSignDataUtil.buildPostReqSignData(raSignSn, time, reqBody);
            } else if ("get".equalsIgnoreCase(requestMethod)) {
                String[] split = url.split("/");
                StringBuffer sb = new StringBuffer();
                for (int i = 1; i < split.length; ++i) {
                    sb.append("/").append(split[i]);
                }
                String uri = sb.toString();
                base64Data = OpenApiReqSignDataUtil.buildGetReqSignData(raSignSn, time, uri);
            } else {
                logger.info("\u6682\u4e0d\u652f\u6301\u8be5\u8bf7\u6c42\u65b9\u5f0f ========== :{}", (Object)requestMethod);
                sdkResult.setError(ErrorEnum.REQUEST_METHOD_IS_NOT_SUPPORT);
                return sdkResult;
            }
            logger.debug(" ================ RA\u5c01\u88c5\u6d88\u606f\u4f7f\u7528\u7684\u670d\u52a1\u5668\u8bc1\u4e66\u7684\u7b7e\u540d\u7b97\u6cd5\u4e3a\uff1a{}", (Object)protectionAlgName);
            signData = isUseHsm ? SdkHsmUtils.signByYunHsm(protectionAlgName, keyIndex, pwd, base64Data) : SdkHsmUtils.signByBC(protectionAlgName, privateKey, base64Data);
            if (StringUtils.isBlank((CharSequence)signData)) {
                sdkResult.setError(ErrorEnum.SIGN_BY_HSM_IS_ERROR);
                return sdkResult;
            }
        }
        catch (Exception e) {
            logger.info("\u8bf7\u6c42 ========== \u83b7\u53d6\u7b7e\u540d\u503c\u5f02\u5e38", (Throwable)e);
            sdkResult.setError(ErrorEnum.GET_SIGN_BY_YUN_HSM_EXCEPTION);
            return sdkResult;
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("sn", raSignSn);
        headerMap.put("time", time);
        headerMap.put("sign", signData);
        CloseableHttpResponse closeableHttpResponse = ApacheClientHttpUtils.sendApacheClientRequest((byte[])reqBody, paramsMap, headerMap, (String)url, (String)contentType, (String)protectionAlgName, (boolean)isHttps, (String)requestMethod, (boolean)isUseHsm, null);
        ClientResult clientResultFromClientResponse = null;
        try {
            clientResultFromClientResponse = AdaptClientResult.getResultFromClientResponse((CloseableHttpResponse)closeableHttpResponse);
        }
        catch (IOException e) {
            logger.error("\u8bf7\u6c42\u8fd4\u56de\u6570\u636e\u89e3\u6790\u5f02\u5e38", (Throwable)e);
            sdkResult.setErrorBean(new ErrorBean(ClientErrorEnum.RESOLVE_CLIENT_RESULT_EXCEPTION.code, ClientErrorEnum.RESOLVE_CLIENT_RESULT_EXCEPTION.desc));
            return sdkResult;
        }
        if (!clientResultFromClientResponse.isSuccess().booleanValue()) {
            sdkResult.setErrorBean(new ErrorBean(clientResultFromClientResponse.getClientErrorBean().getErrCode(), clientResultFromClientResponse.getClientErrorBean().getErrMsg()));
        }
        sdkResult.setInfo(clientResultFromClientResponse.getInfo());
        return sdkResult;
    }

    public static SdkResult sendApacheClientRequestInit(byte[] reqBody, Map<String, String> paramsMap, String url, String contentType, String protectionAlgName, boolean isHttps, String requestMethod, boolean isUseHsm) throws ApacheHttpException {
        SdkResult sdkResult = new SdkResult();
        CloseableHttpResponse closeableHttpResponse = ApacheClientHttpUtils.sendApacheClientRequest((byte[])reqBody, paramsMap, null, (String)url, (String)contentType, (String)protectionAlgName, (boolean)isHttps, (String)requestMethod, (boolean)isUseHsm, null);
        ClientResult resultFromClientResponse = null;
        try {
            resultFromClientResponse = AdaptClientResult.getResultFromClientResponse((CloseableHttpResponse)closeableHttpResponse);
            if (resultFromClientResponse.isSuccess().booleanValue()) {
                sdkResult.setInfo(resultFromClientResponse.getInfo());
                return sdkResult;
            }
        }
        catch (IOException e) {
            logger.error("\u8bf7\u6c42\u8fd4\u56de\u6570\u636e\u89e3\u6790\u5f02\u5e38", (Throwable)e);
            sdkResult.setErrorBean(new ErrorBean(ClientErrorEnum.RESOLVE_CLIENT_RESULT_EXCEPTION.code, ClientErrorEnum.RESOLVE_CLIENT_RESULT_EXCEPTION.desc));
            return sdkResult;
        }
        ClientErrorBean clientErrorBean = resultFromClientResponse.getClientErrorBean();
        sdkResult.setError(ClientHttpUtils.getErrorEnum(new ErrorBean(clientErrorBean.getErrCode(), clientErrorBean.getErrMsg())));
        return sdkResult;
    }

    private static SdkResult getResultFromClientResponse(CloseableHttpResponse response) throws IOException {
        SdkResult sdkResult = new SdkResult();
        byte[] body = null;
        int statusCode = response.getStatusLine().getStatusCode();
        logger.info("========== \u6267\u884c\u8c03\u7528\u8fdc\u7a0b\u72b6\u6001\u7801\u3010" + statusCode + "\u3011");
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            body = EntityUtils.toByteArray((HttpEntity)entity);
        }
        if (statusCode != 200) {
            try {
                ErrorBean errorBean = SdkJsonUtils.json2Object(new String(body), ErrorBean.class);
                logger.info("POST\u8bf7\u6c42========= CA\u7684\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u975e200\u72b6\u6001\u4fe1\u606f:" + statusCode + " ====== errorCode:" + errorBean.getErrCode() + " ====== errorMsg:" + errorBean.getErrMsg());
                sdkResult.setError(ClientHttpUtils.getErrorEnum(errorBean));
                return sdkResult;
            }
            catch (Exception e) {
                logger.error(" ========== \u5f02\u5e38\u4fe1\u606f:{}", (Throwable)e);
                sdkResult.setError(ErrorEnum.CA_OPEN_API_RETURN_EXCEPTION);
                return sdkResult;
            }
        }
        if (null != body && body.length != 0) {
            try {
                byte[] resp = Base64.decode((byte[])body);
                sdkResult.setInfo(resp);
            }
            catch (Exception e) {
                sdkResult.setInfo(body);
            }
        } else {
            sdkResult.setInfo(null);
        }
        return sdkResult;
    }
}

