/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ca.utils;

import com.xdja.ca.error.ErrorBean;
import com.xdja.ca.error.ErrorEnum;
import com.xdja.ca.sdk.SdkResult;
import com.xdja.ca.utils.OpenApiReqSignDataUtil;
import com.xdja.ca.utils.SdkHsmUtils;
import com.xdja.ca.utils.SdkJsonUtils;
import com.xdja.pki.gmssl.http.GMSSLHttpClient;
import com.xdja.pki.gmssl.http.GMSSLHttpsClient;
import com.xdja.pki.gmssl.http.bean.GMSSLHttpRequest;
import com.xdja.pki.gmssl.http.bean.GMSSLHttpResponse;
import com.xdja.pki.gmssl.http.exception.GMSSLHttpException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLHttpReqUtils {
    protected static final transient Logger logger = LoggerFactory.getLogger(GMSSLHttpReqUtils.class);
    private static CloseableHttpClient client = null;

    public static SdkResult sendGMSSLHttpPostReturnByte(int keyIndex, String pwd, byte[] privateKey, byte[] reqBody, String url, String contentType, String raSignSn, X509Certificate[] caCerts, String protectionAlgName, boolean isHttps, boolean isUseHsm) {
        String signData;
        SdkResult sdkResult = new SdkResult();
        if (isUseHsm) {
            if (keyIndex >= 32 || keyIndex <= 0) {
                sdkResult.setError(ErrorEnum.CMP_API_PARAMS_KEY_INDEX_IS_ERROR);
                return sdkResult;
            }
            if (StringUtils.isBlank((CharSequence)pwd)) {
                sdkResult.setError(ErrorEnum.CMP_API_PARAMS_KEY_PWD_IS_EMPTY);
                return sdkResult;
            }
        } else if (privateKey == null) {
            sdkResult.setError(ErrorEnum.CMP_API_PARAMS_RA_PRIVATE_KEY_IS_EMPTY);
            return sdkResult;
        }
        if (StringUtils.isBlank((CharSequence)raSignSn)) {
            sdkResult.setError(ErrorEnum.CMP_API_PARAMS_RA_SIGN_SN_IS_EMPTY);
            return sdkResult;
        }
        GMSSLHttpClient httpClient = null;
        String time = String.valueOf(System.currentTimeMillis());
        try {
            String base64Data = OpenApiReqSignDataUtil.buildPostReqSignData(raSignSn, time, Base64.encode((byte[])reqBody));
            logger.debug("\u5f85\u7b7e\u540d\u539f\u6587 ========== " + base64Data);
            logger.debug(" ================ RA\u5c01\u88c5\u6d88\u606f\u4f7f\u7528\u7684\u670d\u52a1\u5668\u8bc1\u4e66\u7684\u7b7e\u540d\u7b97\u6cd5\u4e3a\uff1a" + protectionAlgName);
            signData = isUseHsm ? SdkHsmUtils.signByYunHsm(protectionAlgName, keyIndex, pwd, base64Data) : SdkHsmUtils.signByBC(protectionAlgName, privateKey, base64Data);
            if (StringUtils.isBlank((CharSequence)signData)) {
                sdkResult.setError(ErrorEnum.SIGN_BY_HSM_IS_ERROR);
                return sdkResult;
            }
        }
        catch (Exception e) {
            logger.info("POST\u8bf7\u6c42 ========== \u83b7\u53d6\u7b7e\u540d\u503c\u5f02\u5e38", (Throwable)e);
            sdkResult.setError(ErrorEnum.GET_SIGN_BY_YUN_HSM_EXCEPTION);
            return sdkResult;
        }
        if (isHttps) {
            if (caCerts != null && caCerts.length > 0) {
                try {
                    httpClient = new GMSSLHttpsClient(caCerts);
                }
                catch (GMSSLHttpException e) {
                    logger.error("GET\u8bf7\u6c42 ========== \u56fd\u5bc6\u5b89\u5168\u901a\u9053\u5de5\u5177\u7c7b\u5f02\u5e38{}", (Throwable)e);
                    sdkResult.setError(ErrorEnum.GMSSL_HTTP_CLIENT_INTER_EXCEPTION);
                    return sdkResult;
                }
            } else {
                httpClient = new GMSSLHttpsClient();
            }
            url = "https://" + url;
        } else {
            httpClient = new GMSSLHttpClient();
            url = "http://" + url;
        }
        GMSSLHttpRequest request = new GMSSLHttpRequest();
        request.setUrl(url);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-type", contentType);
        headerMap.put("sn", raSignSn);
        headerMap.put("time", time);
        headerMap.put("sign", signData);
        request.setHeaders(headerMap);
        request.setBody(Base64.encode((byte[])reqBody));
        GMSSLHttpResponse response = null;
        try {
            response = httpClient.post(request);
        }
        catch (Exception e) {
            logger.error("POST\u8bf7\u6c42 ========== \u56fd\u5bc6\u5b89\u5168\u901a\u9053\u5de5\u5177\u7c7b\u5f02\u5e38{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.GMSSL_HTTP_CLIENT_INTER_EXCEPTION);
            return sdkResult;
        }
        logger.debug("========== sendGMSSLHttpPost.result>>>>" + response.getStatusCode() + " " + new String(response.getBody()));
        if (response.getStatusCode() != 200) {
            try {
                ErrorBean errorBean = SdkJsonUtils.json2Object(new String(response.getBody()), ErrorBean.class);
                logger.info("POST\u8bf7\u6c42========= CA\u7684\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u975e200\u72b6\u6001\u4fe1\u606f:" + response.getStatusCode() + " ====== errorCode:" + errorBean.getErrCode() + " ====== errorMsg:" + errorBean.getErrMsg());
                sdkResult.setError(GMSSLHttpReqUtils.getErrorEnum(errorBean));
                return sdkResult;
            }
            catch (Exception e) {
                logger.info("POST\u8bf7\u6c42========= CA\u7684\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u975e200\u72b6\u6001\u7801:" + response.getStatusCode());
                logger.info(" ========== \u5f02\u5e38\u4fe1\u606f:{}", (Throwable)e);
                sdkResult.setError(ErrorEnum.CA_OPEN_API_RETURN_EXCEPTION);
                return sdkResult;
            }
        }
        byte[] resp = Base64.decode((byte[])response.getBody());
        sdkResult.setInfo(resp);
        return sdkResult;
    }

    public static SdkResult sendGMSSLHttpGetReturnByte(int keyIndex, String pwd, byte[] privateKey, Map<String, String> paramsMap, String url, String raSignSn, X509Certificate[] caCerts, String protectionAlgName, boolean isHttps, boolean isUseHsm) {
        String signData;
        SdkResult sdkResult = new SdkResult();
        if (isUseHsm) {
            if (keyIndex >= 32 || keyIndex <= 0) {
                sdkResult.setError(ErrorEnum.CMP_API_PARAMS_KEY_INDEX_IS_ERROR);
                return sdkResult;
            }
            if (StringUtils.isBlank((CharSequence)pwd)) {
                sdkResult.setError(ErrorEnum.CMP_API_PARAMS_KEY_PWD_IS_EMPTY);
                return sdkResult;
            }
        } else if (privateKey == null) {
            sdkResult.setError(ErrorEnum.CMP_API_PARAMS_RA_PRIVATE_KEY_IS_EMPTY);
            return sdkResult;
        }
        if (StringUtils.isBlank((CharSequence)raSignSn)) {
            sdkResult.setError(ErrorEnum.CMP_API_PARAMS_RA_SIGN_SN_IS_EMPTY);
            return sdkResult;
        }
        GMSSLHttpClient httpClient = null;
        String time = String.valueOf(System.currentTimeMillis());
        try {
            String[] split = url.split("/");
            StringBuffer sb = new StringBuffer();
            for (int i = 1; i < split.length; ++i) {
                sb.append("/").append(split[i]);
            }
            String uri = sb.toString();
            logger.debug("sendGMSSLHttpGetReturnByte.uri=========" + uri);
            String base64Data = OpenApiReqSignDataUtil.buildGetReqSignData(raSignSn, time, uri);
            logger.debug("\u5f85\u7b7e\u540d\u539f\u6587 ========== " + base64Data);
            logger.debug(" ================ RA\u5c01\u88c5\u6d88\u606f\u4f7f\u7528\u7684\u670d\u52a1\u5668\u8bc1\u4e66\u7684\u7b7e\u540d\u7b97\u6cd5\u4e3a\uff1a" + protectionAlgName);
            signData = isUseHsm ? SdkHsmUtils.signByYunHsm(protectionAlgName, keyIndex, pwd, base64Data) : SdkHsmUtils.signByBC(protectionAlgName, privateKey, base64Data);
            if (StringUtils.isBlank((CharSequence)signData)) {
                sdkResult.setError(ErrorEnum.SIGN_BY_HSM_IS_ERROR);
                return sdkResult;
            }
        }
        catch (Exception e) {
            logger.info("GET\u8bf7\u6c42 ========== \u83b7\u53d6\u7b7e\u540d\u503c\u5f02\u5e38", (Throwable)e);
            sdkResult.setError(ErrorEnum.GET_SIGN_BY_YUN_HSM_EXCEPTION);
            return sdkResult;
        }
        if (isHttps) {
            if (caCerts != null && caCerts.length > 0) {
                try {
                    httpClient = new GMSSLHttpsClient(caCerts);
                }
                catch (GMSSLHttpException e) {
                    logger.error("GET\u8bf7\u6c42 ========== \u56fd\u5bc6\u5b89\u5168\u901a\u9053\u5de5\u5177\u7c7b\u5f02\u5e38{}", (Throwable)e);
                    sdkResult.setError(ErrorEnum.GMSSL_HTTP_CLIENT_INTER_EXCEPTION);
                    return sdkResult;
                }
            } else {
                httpClient = new GMSSLHttpsClient();
            }
            url = "https://" + url;
        } else {
            httpClient = new GMSSLHttpClient();
            url = "http://" + url;
        }
        GMSSLHttpRequest request = new GMSSLHttpRequest();
        request.setUrl(url);
        request.setParams(paramsMap);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("sn", raSignSn);
        headerMap.put("time", time);
        headerMap.put("sign", signData);
        request.setHeaders(headerMap);
        GMSSLHttpResponse response = null;
        try {
            response = httpClient.get(request);
        }
        catch (Exception e) {
            logger.error("GET\u8bf7\u6c42 ========== \u56fd\u5bc6\u5b89\u5168\u901a\u9053\u5de5\u5177\u7c7b\u5f02\u5e38{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.GMSSL_HTTP_CLIENT_INTER_EXCEPTION);
            return sdkResult;
        }
        logger.debug("=============== sendGMSSLHttpGet.result>>>>" + response.getStatusCode() + " " + new String(response.getBody()));
        if (response.getStatusCode() != 200) {
            try {
                ErrorBean errorBean = SdkJsonUtils.json2Object(new String(response.getBody()), ErrorBean.class);
                logger.info("GET\u8bf7\u6c42=========CA\u7684\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u975e200\u72b6\u6001\u4fe1\u606f:" + response.getStatusCode() + " ====== errorCode:" + errorBean.getErrCode() + " ====== errorMsg:" + errorBean.getErrMsg());
                sdkResult.setError(GMSSLHttpReqUtils.getErrorEnum(errorBean));
                return sdkResult;
            }
            catch (Exception e) {
                logger.info("GET\u8bf7\u6c42=========CA\u7684\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u975e200\u72b6\u6001\u7801:" + response.getStatusCode());
                logger.info(" ========== \u5f02\u5e38\u4fe1\u606f:{}", (Throwable)e);
                sdkResult.setError(ErrorEnum.CA_OPEN_API_RETURN_EXCEPTION);
                return sdkResult;
            }
        }
        byte[] resp = Base64.decode((byte[])response.getBody());
        sdkResult.setInfo(resp);
        return sdkResult;
    }

    private static ErrorEnum getErrorEnum(ErrorBean errorBean) {
        String errCode = String.valueOf(errorBean.getErrCode());
        ErrorEnum errorEnumByCode = ErrorEnum.getErrorEnumByCode(errCode);
        if (null != errorEnumByCode) {
            return errorEnumByCode;
        }
        if ("10001".equals(errCode)) {
            return ErrorEnum.CA_ILLEGAL_REQUEST_PARAMETER;
        }
        if ("10002".equals(errCode)) {
            return ErrorEnum.CA_MISSING_REQUIRED_PARAMETERS;
        }
        logger.info("=================CA\u7684open-api\u5185\u90e8\u5f02\u5e38==================");
        return ErrorEnum.CA_OPEN_API_INNER_EXCEPTION;
    }

    public static SdkResult sendGMSSLHttpPostReturnString(int keyIndex, String pwd, byte[] privateKey, byte[] reqBody, String url, String contentType, String raSignSn, X509Certificate[] caCerts, String protectionAlgName, boolean isHttps, boolean isUseHsm) {
        String signData;
        SdkResult sdkResult = new SdkResult();
        if (isUseHsm) {
            if (keyIndex >= 32 || keyIndex <= 0) {
                sdkResult.setError(ErrorEnum.CMP_API_PARAMS_KEY_INDEX_IS_ERROR);
                return sdkResult;
            }
            if (StringUtils.isBlank((CharSequence)pwd)) {
                sdkResult.setError(ErrorEnum.CMP_API_PARAMS_KEY_PWD_IS_EMPTY);
                return sdkResult;
            }
        } else if (privateKey == null) {
            sdkResult.setError(ErrorEnum.CMP_API_PARAMS_RA_PRIVATE_KEY_IS_EMPTY);
            return sdkResult;
        }
        if (StringUtils.isBlank((CharSequence)raSignSn)) {
            sdkResult.setError(ErrorEnum.CMP_API_PARAMS_RA_SIGN_SN_IS_EMPTY);
            return sdkResult;
        }
        GMSSLHttpClient httpClient = null;
        String time = String.valueOf(System.currentTimeMillis());
        try {
            String base64Data = OpenApiReqSignDataUtil.buildPostReqSignData(raSignSn, time, Base64.encode((byte[])reqBody));
            logger.debug("\u5f85\u7b7e\u540d\u539f\u6587 ========== " + base64Data);
            logger.debug(" ================ RA\u5c01\u88c5\u6d88\u606f\u4f7f\u7528\u7684\u670d\u52a1\u5668\u8bc1\u4e66\u7684\u7b7e\u540d\u7b97\u6cd5\u4e3a\uff1a" + protectionAlgName);
            signData = isUseHsm ? SdkHsmUtils.signByYunHsm(protectionAlgName, keyIndex, pwd, base64Data) : SdkHsmUtils.signByBC(protectionAlgName, privateKey, base64Data);
            if (StringUtils.isBlank((CharSequence)signData)) {
                sdkResult.setError(ErrorEnum.SIGN_BY_HSM_IS_ERROR);
                return sdkResult;
            }
        }
        catch (Exception e) {
            logger.info("POST\u8bf7\u6c42 ========== \u83b7\u53d6\u7b7e\u540d\u503c\u5f02\u5e38", (Throwable)e);
            sdkResult.setError(ErrorEnum.GET_SIGN_BY_YUN_HSM_EXCEPTION);
            return sdkResult;
        }
        if (isHttps) {
            if (caCerts != null && caCerts.length > 0) {
                try {
                    httpClient = new GMSSLHttpsClient(caCerts);
                }
                catch (GMSSLHttpException e) {
                    logger.error("GET\u8bf7\u6c42 ========== \u56fd\u5bc6\u5b89\u5168\u901a\u9053\u5de5\u5177\u7c7b\u5f02\u5e38{}", (Throwable)e);
                    sdkResult.setError(ErrorEnum.GMSSL_HTTP_CLIENT_INTER_EXCEPTION);
                    return sdkResult;
                }
            } else {
                httpClient = new GMSSLHttpsClient();
            }
            url = "https://" + url;
        } else {
            httpClient = new GMSSLHttpClient();
            url = "http://" + url;
        }
        GMSSLHttpRequest request = new GMSSLHttpRequest();
        request.setUrl(url);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-type", contentType);
        headerMap.put("sn", raSignSn);
        headerMap.put("time", time);
        headerMap.put("sign", signData);
        request.setHeaders(headerMap);
        request.setBody(Base64.encode((byte[])reqBody));
        GMSSLHttpResponse response = null;
        logger.info("\u8bf7\u6c42\u5730\u5740 ========== " + url);
        try {
            response = httpClient.post(request);
        }
        catch (Exception e) {
            logger.error("POST\u8bf7\u6c42 ========== \u56fd\u5bc6\u5b89\u5168\u901a\u9053\u5de5\u5177\u7c7b\u5f02\u5e38{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.GMSSL_HTTP_CLIENT_INTER_EXCEPTION);
            return sdkResult;
        }
        logger.debug("========== sendGMSSLHttpPost.result>>>>" + response.getStatusCode() + " " + new String(response.getBody()));
        if (response.getStatusCode() != 200) {
            try {
                ErrorBean errorBean = SdkJsonUtils.json2Object(new String(response.getBody()), ErrorBean.class);
                logger.info("POST\u8bf7\u6c42========= CA\u7684\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u975e200\u72b6\u6001\u4fe1\u606f:" + response.getStatusCode() + " ====== errorCode:" + errorBean.getErrCode() + " ====== errorMsg:" + errorBean.getErrMsg());
                sdkResult.setError(GMSSLHttpReqUtils.getErrorEnum(errorBean));
                return sdkResult;
            }
            catch (Exception e) {
                logger.info("POST\u8bf7\u6c42========= CA\u7684\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u975e200\u72b6\u6001\u7801:" + response.getStatusCode());
                logger.error(" ========== \u5f02\u5e38\u4fe1\u606f:{}", (Throwable)e);
                sdkResult.setError(ErrorEnum.CA_OPEN_API_RETURN_EXCEPTION);
                return sdkResult;
            }
        }
        String resp = new String(response.getBody());
        sdkResult.setInfo(resp);
        return sdkResult;
    }

    public static SdkResult sendGMSSLHttpGetReturnString(int keyIndex, String pwd, byte[] privateKey, Map<String, String> paramsMap, String url, String raSignSn, X509Certificate[] caCerts, String protectionAlgName, boolean isHttps, boolean isUseHsm) {
        String signData;
        SdkResult sdkResult = new SdkResult();
        if (isUseHsm) {
            if (keyIndex >= 32 || keyIndex <= 0) {
                sdkResult.setError(ErrorEnum.CMP_API_PARAMS_KEY_INDEX_IS_ERROR);
                return sdkResult;
            }
            if (StringUtils.isBlank((CharSequence)pwd)) {
                sdkResult.setError(ErrorEnum.CMP_API_PARAMS_KEY_PWD_IS_EMPTY);
                return sdkResult;
            }
        } else if (privateKey == null) {
            sdkResult.setError(ErrorEnum.CMP_API_PARAMS_RA_PRIVATE_KEY_IS_EMPTY);
            return sdkResult;
        }
        if (StringUtils.isBlank((CharSequence)raSignSn)) {
            sdkResult.setError(ErrorEnum.CMP_API_PARAMS_RA_SIGN_SN_IS_EMPTY);
            return sdkResult;
        }
        GMSSLHttpClient httpClient = null;
        String time = String.valueOf(System.currentTimeMillis());
        try {
            String[] split = url.split("/");
            StringBuffer sb = new StringBuffer();
            for (int i = 1; i < split.length; ++i) {
                sb.append("/").append(split[i]);
            }
            String uri = sb.toString();
            logger.debug("sendGMSSLHttpGetReturnByte.uri=========" + uri);
            String base64Data = OpenApiReqSignDataUtil.buildGetReqSignData(raSignSn, time, uri);
            logger.debug("\u5f85\u7b7e\u540d\u539f\u6587 ========== " + base64Data);
            logger.debug(" ================ RA\u5c01\u88c5\u6d88\u606f\u4f7f\u7528\u7684\u670d\u52a1\u5668\u8bc1\u4e66\u7684\u7b7e\u540d\u7b97\u6cd5\u4e3a\uff1a" + protectionAlgName);
            signData = isUseHsm ? SdkHsmUtils.signByYunHsm(protectionAlgName, keyIndex, pwd, base64Data) : SdkHsmUtils.signByBC(protectionAlgName, privateKey, base64Data);
            if (StringUtils.isBlank((CharSequence)signData)) {
                sdkResult.setError(ErrorEnum.SIGN_BY_HSM_IS_ERROR);
                return sdkResult;
            }
        }
        catch (Exception e) {
            logger.info("GET\u8bf7\u6c42 ========== \u83b7\u53d6\u7b7e\u540d\u503c\u5f02\u5e38", (Throwable)e);
            sdkResult.setError(ErrorEnum.GET_SIGN_BY_YUN_HSM_EXCEPTION);
            return sdkResult;
        }
        if (isHttps) {
            if (caCerts != null && caCerts.length > 0) {
                try {
                    httpClient = new GMSSLHttpsClient(caCerts);
                }
                catch (GMSSLHttpException e) {
                    logger.error("GET\u8bf7\u6c42 ========== \u56fd\u5bc6\u5b89\u5168\u901a\u9053\u5de5\u5177\u7c7b\u5f02\u5e38{}", (Throwable)e);
                    sdkResult.setError(ErrorEnum.GMSSL_HTTP_CLIENT_INTER_EXCEPTION);
                    return sdkResult;
                }
            } else {
                httpClient = new GMSSLHttpsClient();
            }
            url = "https://" + url;
        } else {
            httpClient = new GMSSLHttpClient();
            url = "http://" + url;
        }
        GMSSLHttpRequest request = new GMSSLHttpRequest();
        request.setUrl(url);
        request.setParams(paramsMap);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("sn", raSignSn);
        headerMap.put("time", time);
        headerMap.put("sign", signData);
        request.setHeaders(headerMap);
        GMSSLHttpResponse response = null;
        try {
            response = httpClient.get(request);
        }
        catch (Exception e) {
            logger.error("GET\u8bf7\u6c42 ========== \u56fd\u5bc6\u5b89\u5168\u901a\u9053\u5de5\u5177\u7c7b\u5f02\u5e38{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.GMSSL_HTTP_CLIENT_INTER_EXCEPTION);
            return sdkResult;
        }
        logger.debug("=============== sendGMSSLHttpGet.result>>>>" + response.getStatusCode() + " " + new String(response.getBody()));
        if (response.getStatusCode() != 200) {
            try {
                ErrorBean errorBean = SdkJsonUtils.json2Object(new String(response.getBody()), ErrorBean.class);
                logger.info("GET\u8bf7\u6c42=========CA\u7684\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u975e200\u72b6\u6001\u4fe1\u606f:" + response.getStatusCode() + " ====== errorCode:" + errorBean.getErrCode() + " ====== errorMsg:" + errorBean.getErrMsg());
                sdkResult.setError(GMSSLHttpReqUtils.getErrorEnum(errorBean));
                return sdkResult;
            }
            catch (Exception e) {
                logger.info("GET\u8bf7\u6c42=========CA\u7684\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u975e200\u72b6\u6001\u7801:" + response.getStatusCode());
                sdkResult.setError(ErrorEnum.CA_OPEN_API_RETURN_EXCEPTION);
                return sdkResult;
            }
        }
        String resp = new String(response.getBody());
        sdkResult.setInfo(resp);
        return sdkResult;
    }

    public static SdkResult sendGMSSLHttpGetReturnByteInit(Map<String, String> paramsMap, String url, X509Certificate[] caCerts, boolean isHttps) {
        SdkResult sdkResult = new SdkResult();
        GMSSLHttpClient httpClient = null;
        String time = String.valueOf(System.currentTimeMillis());
        if (isHttps) {
            if (caCerts != null && caCerts.length > 0) {
                try {
                    httpClient = new GMSSLHttpsClient(caCerts);
                }
                catch (GMSSLHttpException e) {
                    logger.error("GET\u8bf7\u6c42 ========== \u56fd\u5bc6\u5b89\u5168\u901a\u9053\u5de5\u5177\u7c7b\u5f02\u5e38{}", (Throwable)e);
                    sdkResult.setError(ErrorEnum.GMSSL_HTTP_CLIENT_INTER_EXCEPTION);
                    return sdkResult;
                }
            } else {
                httpClient = new GMSSLHttpsClient();
            }
            url = "https://" + url;
        } else {
            httpClient = new GMSSLHttpClient();
            url = "http://" + url;
        }
        GMSSLHttpRequest request = new GMSSLHttpRequest();
        request.setUrl(url);
        request.setParams(paramsMap);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("sn", null);
        headerMap.put("time", time);
        headerMap.put("sign", null);
        request.setHeaders(headerMap);
        GMSSLHttpResponse response = null;
        try {
            response = httpClient.get(request);
        }
        catch (Exception e) {
            logger.error("GET\u8bf7\u6c42 ========== \u56fd\u5bc6\u5b89\u5168\u901a\u9053\u5de5\u5177\u7c7b\u5f02\u5e38{}", (Throwable)e);
            sdkResult.setError(ErrorEnum.GMSSL_HTTP_CLIENT_INTER_EXCEPTION);
            return sdkResult;
        }
        logger.debug("=============== sendGMSSLHttpGet.result>>>>" + response.getStatusCode() + " " + new String(response.getBody()));
        if (response.getStatusCode() != 200) {
            try {
                ErrorBean errorBean = SdkJsonUtils.json2Object(new String(response.getBody()), ErrorBean.class);
                logger.info("GET\u8bf7\u6c42=========CA\u7684\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u975e200\u72b6\u6001\u4fe1\u606f:" + response.getStatusCode() + " ====== errorCode:" + errorBean.getErrCode() + " ====== errorMsg:" + errorBean.getErrMsg());
                sdkResult.setErrorBean(errorBean);
                return sdkResult;
            }
            catch (Exception e) {
                logger.info("GET\u8bf7\u6c42=========CA\u7684\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u975e200\u72b6\u6001\u7801:" + response.getStatusCode());
                logger.info(" ========== \u5f02\u5e38\u4fe1\u606f:{}", (Throwable)e);
                sdkResult.setError(ErrorEnum.CA_OPEN_API_RETURN_EXCEPTION);
                return sdkResult;
            }
        }
        byte[] resp = Base64.decode((byte[])response.getBody());
        sdkResult.setInfo(resp);
        return sdkResult;
    }
}

