/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ca.utils;

import com.xdja.ca.asn1.RsaObjectIdentifiers;
import com.xdja.ca.asn1.SM2ObjectIdentifiers;
import com.xdja.pki.gmssl.core.utils.GMSSLBCSignUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECSignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSASignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2SignUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLCertUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import sun.security.rsa.RSAPrivateKeyImpl;
import sun.security.util.DerValue;

public class SdkHsmUtils {
    protected static final transient Logger logger = Logger.getLogger(SdkHsmUtils.class.getClass());

    public static String signByYunHsm(String signAlgName, int privateKeyIndex, String privateKeyPassword, String base64Data) throws Exception {
        String signedValue = null;
        if ("SM3withSM2".equalsIgnoreCase(signAlgName)) {
            signedValue = GMSSLSM2SignUtils.signByYunhsm((int)privateKeyIndex, (String)privateKeyPassword, (String)base64Data);
        } else if ("SHA-1WithRSA".equalsIgnoreCase(signAlgName) || "SHA1WithRSA".equalsIgnoreCase(signAlgName)) {
            signedValue = GMSSLRSASignUtils.signByYunHsm((String)GMSSLSignatureAlgorithm.SHA1_WITH_RSA.getSigAlgName(), (int)privateKeyIndex, (String)privateKeyPassword, (String)base64Data);
        } else if ("SHA256WithRSA".equalsIgnoreCase(signAlgName)) {
            signedValue = GMSSLRSASignUtils.signByYunHsm((String)GMSSLSignatureAlgorithm.SHA256_WITH_RSA.getSigAlgName(), (int)privateKeyIndex, (String)privateKeyPassword, (String)base64Data);
        } else if ("SHA256withECDSA".equalsIgnoreCase(signAlgName)) {
            signedValue = Base64.toBase64String((byte[])GMSSLECSignUtils.signByYunHsm((int)privateKeyIndex, (String)privateKeyPassword, (byte[])Base64.decode((String)base64Data), (String)GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName()));
        }
        return signedValue;
    }

    public static String signByBC(String signAlgName, byte[] privateKey, String base64Data) throws Exception {
        String signedValue = null;
        logger.info((Object)"========= SDK\u4e2d\u4f7f\u7528BC\u8fdb\u884c\u8f6f\u7b7e\u540d ============");
        if ("SM3withSM2".equalsIgnoreCase(signAlgName)) {
            PrivateKeyInfo info = PrivateKeyInfo.getInstance((Object)privateKey);
            KeyFactory keyFactory = KeyFactory.getInstance(info.getPrivateKeyAlgorithm().getAlgorithm().getId(), (Provider)new BouncyCastleProvider());
            PrivateKey priKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(info.getEncoded()));
            signedValue = GMSSLSM2SignUtils.signByBC((PrivateKey)priKey, (String)base64Data);
        } else if ("SHA-1WithRSA".equalsIgnoreCase(signAlgName) || "SHA1WithRSA".equalsIgnoreCase(signAlgName)) {
            PrivateKey priKey = RSAPrivateKeyImpl.parseKey((DerValue)new DerValue(privateKey));
            signedValue = GMSSLRSASignUtils.signByBC((String)GMSSLSignatureAlgorithm.SHA1_WITH_RSA.getSigAlgName(), (PrivateKey)priKey, (String)base64Data);
        } else if ("SHA256WithRSA".equalsIgnoreCase(signAlgName)) {
            PrivateKey priKey = RSAPrivateKeyImpl.parseKey((DerValue)new DerValue(privateKey));
            signedValue = GMSSLRSASignUtils.signByBC((String)GMSSLSignatureAlgorithm.SHA256_WITH_RSA.getSigAlgName(), (PrivateKey)priKey, (String)base64Data);
        } else if ("SHA256withECDSA".equalsIgnoreCase(signAlgName)) {
            PrivateKeyInfo info = PrivateKeyInfo.getInstance((Object)privateKey);
            KeyFactory keyFactory = KeyFactory.getInstance(info.getPrivateKeyAlgorithm().getAlgorithm().getId(), (Provider)new BouncyCastleProvider());
            PrivateKey priKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(info.getEncoded()));
            signedValue = Base64.toBase64String((byte[])GMSSLBCSignUtils.generateSignature((String)GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), (PrivateKey)priKey, (byte[])Base64.decode((String)base64Data)));
        }
        return signedValue;
    }

    public static boolean verifyCertByYunHsm(X509Certificate cert, PublicKey publicKey) throws Exception {
        String sigAlgOID = cert.getSigAlgOID();
        boolean verifyResult = false;
        verifyResult = SM2ObjectIdentifiers.sm2SignWithSm3.getId().equalsIgnoreCase(sigAlgOID) ? GMSSLCertUtils.verifyCert((PublicKey)publicKey, (X509Certificate)cert) : (RsaObjectIdentifiers.sha1WithRSA.getId().equalsIgnoreCase(sigAlgOID) ? GMSSLRSASignUtils.verifyByYunHsm((String)GMSSLSignatureAlgorithm.SHA1_WITH_RSA.getSigAlgName(), (PublicKey)publicKey, (byte[])cert.getTBSCertificate(), (byte[])cert.getSignature()) : (RsaObjectIdentifiers.sha256WithRSA.getId().equalsIgnoreCase(sigAlgOID) ? GMSSLRSASignUtils.verifyByYunHsm((String)GMSSLSignatureAlgorithm.SHA256_WITH_RSA.getSigAlgName(), (PublicKey)publicKey, (byte[])cert.getTBSCertificate(), (byte[])cert.getSignature()) : GMSSLECSignUtils.verifyByYunHsm((PublicKey)publicKey, (byte[])cert.getTBSCertificate(), (byte[])cert.getSignature(), (String)GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName())));
        return verifyResult;
    }

    public static boolean verifyCertByBC(X509Certificate cert, PublicKey publicKey) throws Exception {
        String sigAlgOID = cert.getSigAlgOID();
        boolean verifyResult = false;
        verifyResult = SM2ObjectIdentifiers.sm2SignWithSm3.getId().equalsIgnoreCase(sigAlgOID) ? GMSSLSM2SignUtils.verifyByBC((PublicKey)publicKey, (byte[])cert.getTBSCertificate(), (byte[])cert.getSignature()) : (RsaObjectIdentifiers.sha1WithRSA.getId().equalsIgnoreCase(sigAlgOID) ? GMSSLRSASignUtils.verifyByBC((String)GMSSLSignatureAlgorithm.SHA1_WITH_RSA.getSigAlgName(), (PublicKey)publicKey, (byte[])cert.getTBSCertificate(), (byte[])cert.getSignature()) : (RsaObjectIdentifiers.sha256WithRSA.getId().equalsIgnoreCase(sigAlgOID) ? GMSSLRSASignUtils.verifyByBC((String)GMSSLSignatureAlgorithm.SHA256_WITH_RSA.getSigAlgName(), (PublicKey)publicKey, (byte[])cert.getTBSCertificate(), (byte[])cert.getSignature()) : GMSSLBCSignUtils.verifySignature((String)GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), (PublicKey)publicKey, (byte[])cert.getTBSCertificate(), (byte[])cert.getSignature())));
        return verifyResult;
    }

    public static boolean verifyCertByBC(String protectionAlgId, PublicKey publicKey, byte[] sourceData, byte[] signData) throws Exception {
        boolean verifyResult = false;
        verifyResult = SM2ObjectIdentifiers.sm2SignWithSm3.getId().equalsIgnoreCase(protectionAlgId) ? GMSSLSM2SignUtils.verifyByBC((PublicKey)publicKey, (byte[])sourceData, (byte[])signData) : (RsaObjectIdentifiers.sha1WithRSA.getId().equalsIgnoreCase(protectionAlgId) ? GMSSLRSASignUtils.verifyByBC((String)GMSSLSignatureAlgorithm.SHA1_WITH_RSA.getSigAlgName(), (PublicKey)publicKey, (byte[])sourceData, (byte[])signData) : (RsaObjectIdentifiers.sha256WithRSA.getId().equalsIgnoreCase(protectionAlgId) ? GMSSLRSASignUtils.verifyByBC((String)GMSSLSignatureAlgorithm.SHA256_WITH_RSA.getSigAlgName(), (PublicKey)publicKey, (byte[])sourceData, (byte[])signData) : GMSSLBCSignUtils.verifySignature((String)GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), (PublicKey)publicKey, (byte[])sourceData, (byte[])signData)));
        return verifyResult;
    }

    public static boolean verifyCertByYunHsm(String protectionAlgName, X509Certificate cert, X509Certificate caCert) throws Exception {
        boolean verifyResult = false;
        if ("SM3withSm2".equalsIgnoreCase(protectionAlgName)) {
            verifyResult = GMSSLCertUtils.verifyCert((PublicKey)caCert.getPublicKey(), (X509Certificate)cert);
        } else if ("SHA-1WithRSA".equalsIgnoreCase(protectionAlgName) || "SHA1WithRSA".equalsIgnoreCase(protectionAlgName)) {
            verifyResult = GMSSLRSASignUtils.verifyByYunHsm((String)GMSSLSignatureAlgorithm.SHA1_WITH_RSA.getSigAlgName(), (PublicKey)caCert.getPublicKey(), (byte[])cert.getTBSCertificate(), (byte[])cert.getSignature());
        } else if ("SHA256WithRSA".equalsIgnoreCase(protectionAlgName)) {
            verifyResult = GMSSLRSASignUtils.verifyByYunHsm((String)GMSSLSignatureAlgorithm.SHA256_WITH_RSA.getSigAlgName(), (PublicKey)caCert.getPublicKey(), (byte[])cert.getTBSCertificate(), (byte[])cert.getSignature());
        } else if ("SHA256withECDSA".equalsIgnoreCase(protectionAlgName)) {
            verifyResult = GMSSLECSignUtils.verifyByYunHsm((PublicKey)caCert.getPublicKey(), (byte[])cert.getTBSCertificate(), (byte[])cert.getTBSCertificate(), (String)GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName());
        }
        return verifyResult;
    }

    public static boolean verifyCertByYunHsm(String protectionAlgId, PublicKey publicKey, byte[] sourceData, byte[] signData) throws Exception {
        boolean verifyResult = false;
        verifyResult = SM2ObjectIdentifiers.sm2SignWithSm3.getId().equalsIgnoreCase(protectionAlgId) ? GMSSLSM2SignUtils.verifyBySdf((SdfCryptoType)SdfCryptoType.YUNHSM, (PublicKey)publicKey, (byte[])sourceData, (byte[])signData) : (RsaObjectIdentifiers.sha1WithRSA.getId().equalsIgnoreCase(protectionAlgId) ? GMSSLRSASignUtils.verifyByYunHsm((String)GMSSLSignatureAlgorithm.SHA1_WITH_RSA.getSigAlgName(), (PublicKey)publicKey, (byte[])sourceData, (byte[])signData) : (RsaObjectIdentifiers.sha256WithRSA.getId().equalsIgnoreCase(protectionAlgId) ? GMSSLRSASignUtils.verifyByYunHsm((String)GMSSLSignatureAlgorithm.SHA256_WITH_RSA.getSigAlgName(), (PublicKey)publicKey, (byte[])sourceData, (byte[])signData) : GMSSLECSignUtils.verifyByYunHsm((PublicKey)publicKey, (byte[])sourceData, (byte[])signData, (String)GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName())));
        return verifyResult;
    }
}

