package com.xdja.ca.error;


import org.apache.commons.lang3.StringUtils;

/**
 * 系统共用异常枚举定义
 *
 * @author wyf
 *
 */
public enum ErrorEnum {

	/**
	 * ca-sdk  cmp异常
	 */
	MISSING_REQUIRED_PARAMETERS(400, 30000, "missing_required_parameters", "缺少必要请求参数"),
	CA_OPEN_API_RETURN_ERROR_CODE(400, 30001, "ca_open_api_return_error_code", "CA的open-api接口返回错误码"),
	REQUEST_METHOD_IS_NOT_SUPPORT(400, 30002, "request_method_is_not_support", "暂不支持该请求方式"),
	CA_OPEN_API_RETURN_INFO_IS_EMPTY(400, 30003, "ca_open_api_return_exception", "CA的open-api接口返回数据为空"),
	GMSSL_HTTP_CLIENT_INTER_EXCEPTION(400, 30004, "gmssl_http_client_inter_exception", "国密安全通道工具类异常"),
	CERT_VALIDITY_CANNOT_LESS_ZERO(400, 30005, "cert_validity_cannot_less_zero", "参数中的证书有效期不在有效期范围内"),
	GET_SIGN_BY_YUN_HSM_EXCEPTION(400,30006,"get_sign_by_yun_hsm_exception","获取签名算法值异常"),
	CA_OPEN_API_RETURN_PKI_ERROR_MSG(400, 30007, "ca_open_api_return_pki_error_msg", "CA的open-api接口返回pki错误消息"),

	GET_CMP_RANDOM_IS_EXCEPTION(400, 30008, "get_cmp_random_is_exception", "获取CMP请求随机数异常"),
	CERT_SIGN_ALG_IS_NOT_SUPPORT(400, 30009, "cert_sign_alg_is_not_support", "证书签名算法不支持"),
	MAKE_CERT_REQUEST_EXCEPTION(400, 30010, "make_cert_request_exception", "封装certRequest异常"),
	MAKE_CERT_REQUEST_MESSAGE_EXCEPTION(400, 30011, "make_cert_request_message_exception", "封装certReqMessages异常"),
	MAKE_PKI_MESSAGE_EXCEPTION(400, 30012, "make_pki_message_exception", "封装PKIMessage异常"),
	SEND_HTTP_MESSAGE_EXCEPTION(400, 30013, "send_http_message_exception", "发送Http消息异常"),
	NO_PKI_MESSAGE_RESP_MESSAGE(400, 30014, "no_pki_message_resp_message", "No pkiMessage response message"),
	NO_HEADER_IN_RESPONSE_MESSAGE(400, 30015, "no_header_in_response_message", "No header in response message"),
	RECEIVED_CA_DN_NOT_EXPECT(400, 30016, "received_ca_dn_not_exception", "received caDn not expect"),
	WRONG_LEN_OF_RECEIVED_SENDER_NONCE(400, 30017, "wrong_len_of_received_sender_nonce", "Wrong length of received sender nonce"),
	RECIPIENT_NONCE_NOT_THE_SAME_AS_WE_SENT(400, 30018, "recipient_nonce_not_the_same_as_we_sent", "recipient nonce not the same as we sent"),
	TRANS_ID_IS_NOT_THE_SAME_AS_WE_SENT(400, 30019, "trans_id_is_not_the_same_as_we_sent", "transid is not the same as the one we sent"),
	ERROR_MSG_CONTENT_EXCEPTION(400, 30020, "error_msg_content_exception", "封装ErrorMsgContent异常"),
	RESOLVE_ERROR_MSG_CONTENT_EXCEPTION(400, 30021, "resolve_error_msg_content_exception", "解析ErrorMsgContent异常"),
	RESOLVE_CERT_REP_MESSAGE_EXCEPTION(400, 30022, "resolve_cert_rep_message_exception", "解析CertRepMessage异常"),
	RESOLVE_REV_REP_CONTENT_EXCEPTION(400, 30023, "resolve_rev_rep_content_exception", "解析RevRepContent异常"),
	RA_NOT_SUPPORT_THIS_CERT_BODY_TAG(400, 30024, "ra_not_support_this_cert_body_tag", "RA 暂不支持解析当前类型的CMP请求"),
	NO_CERT_REQ_MESSAGE_RECEIVED(400, 30025, "no_cert_req_message_received", "No CertRepMessage for certificate received."),
	NO_CERT_RESPONSE_MESSAGE_RECEIVED(400, 30026, "no_cert_response_message_received", "No CertResponse for certificate received"),
	NO_RA_SEND_TRANS_ID(400, 30027, "no_ra_send_trans_id", "No ra send transId"),
	RA_RECEIVED_CERT_REQ_ID_IS_ERROR(400, 30028, "ra_received_cert_req_id_is_error", "Received CertReqId is ERROR"),
	NO_PKI_STATUS_INFO_FOR_RECEIVE(400, 30029, "no_pki_status_info_for_receive", "No PKIStatusInfo for certificate received."),
	RECEIVED_STATUS_IS_NOT_0(400, 30030, "received_status_is_not_0", "Received Status is not 0"),
	NO_CERTIFIED_KEY_PAIR_FOR_RECEIVED(400, 30031, "no_certified_key_pair_for_received", "No CertifiedKeyPair for certificate received."),
	NO_CERT_OR_ENC_CERT_FOR_RECEIVED(400, 30032, "no_cert_or_enc_cert_for_received", "No CertOrEncCert for certificate received."),
	NO_X509_CERT_FOR_RECEIVED(400, 30033, "no_x509_cert_for_receive", "No X509CertificateStructure for certificate received."),
	NO_ENCODE_CERT_FOR_RECEIVED(400, 30034, "no_encode_cert_for_received", "No encoded certificate received"),
	CMP_CERT_ENCODE_EXCEPTION(400, 30035, "cmp_cert_encode_exception", "CMPCertificate Encode Exception."),
	NOT_POSSIBLE_TO_CREATE_CERT(400, 30036, "not_possible_to_create_cert", "Not possible to create certificate."),
	RECEIVE_SUBJECT_DN_IS_NOT_SAME_APPLY(400, 30037, "receive_subject_dn_is_not_same_apply", "检测生成的证书中用户DN，是否和申请时的DN一致"),
	RECEIVE_ISSUE_DN_IS_NOT_SAME_APPLY(400, 30038, "receive_issue_dn_is_not_same_apply", "检测用户证书的颁发者DN，是否和申请时的DN一致"),
	LOCAL_CMP_CACHE_IS_EMPTY(400, 30039, "local_cmp_cache_is_empty", " 本地缓存CMP数据为空"),
	CANNOT_GET_TRANS_ID_FORM_LOCAL_CACHE(400, 30040, "cannot_get_trans_id_from_local_cache", "不能从本地缓存获取发送的transId"),
	MAKE_REV_REQ_CONTENT_EXCEPTION(400, 30041, "make_rev_req_content_exception", "封装RevReqContent异常"),
	MAKE_CERT_CONFIRM_CONTENT_EXCEPTION(400, 30042, "make_cert_confirm_content_exception", "封装CertConfirmContent异常"),
	APPLY_USER_TYPE_CANNOT_SUPPORT(400, 30043, "apply_user_type_cannot_support", "申请的用户类型不支持"),
	CONNECT_CA_OPEN_API_REFUSED(400, 30044, "connect_ca_open_api_refused", "CA的外部接口连接失败"),
	RA_VERIFY_SIGN_POP_ERROR(400, 30045, "ra_verify_sign_pop_error", "RA验证签名POP失败"),
	RA_VERIFY_SIGN_POP_EXCEPTION(400, 30046, "ra_verify_sign_pop_exception", "RA验证签名POP异常"),
	APPLY_USER_TYPE_IS_ERROR(400, 30047, "apply_user_type_is_error", "申请用户类型错误"),
	GMSSL_VERIFY_SIGN_DATA_IS_ERROR(400, 30048, "gmssl_verify_sign_data_is_error", "加密机验签失败"),
	GMSSL_VERIFY_SIGN_DATA_IS_EXCEPTION(400, 30049, "gmssl_verify_sign_data_is_exception", "加密机验签异常"),
	RA_VERIFY_CA_REP_CERT_ERROR(400, 30050, "ra_verify_ca_rep_cert_error", "RA校验CA返回的证书错误"),
	GET_RANDOM_BY_HSM_EXCEPTION(400, 30051, "get_random_by_hsm_exception", "通过密码机获取随机数异常"),
	CA_CERT_INFO_IS_ERROR(400, 30052, "ca_cert_info_is_error", "最新的CA证书信息错误"),
	SIGN_BY_HSM_IS_ERROR(400, 30053, "sign_by_hsm_is_error", "使用加密机签名失败"),
	NO_PROTECTION_ALG_IN_PKI_HEADER(400, 30054, "no_protection_alg_in_pki_header", "没有保护算法在pki消息头部"),

	NO_KEY_REC_REP_CONTENT_MESSAGE_RECEIVED(400, 30055, "no_key_rec_rep_content_message_received", "No KeyRecRepContentMessage for received."),
	BUILD_SIGNEDANDENVLOPEDDATA_FROM_ENCRYPTEDVALUE_EXCPTION(400, 30056, "build_signedAndEnvelopedData_from_encryptedvalue_exception", "构建加密私钥信封异常."),
	RESOLVE_KEY_REC_REP_CONTENT_EXCEPTION(400, 30057, "resolve_key_rec_rep_content_exception", "解析KeyRecRepContent异常"),



	// CMP构造函数参数错误
	CMP_API_PARAMS_KEY_INDEX_IS_ERROR(400, 30101, "cmp_api_params_key_index_is_error", "构造方法中秘钥索引范围错误"),
	CMP_API_PARAMS_KEY_PWD_IS_EMPTY(400, 30102, "cmp_api_params_key_pwd_is_empty", "构造方法私钥访问控制码为空"),
	CMP_API_PARAMS_RA_SIGN_SN_IS_EMPTY(400, 30103, "cmp_api_params_ra_sign_sn_is_empty", "构造方法RA的签名证书SN为空"),
	CMP_API_PARAMS_CA_CERT_LIST_IS_EMPTY(400, 30104, "cmp_api_params_ca_cert_list_is_empty", "构造方法CA证书链为空"),
	CMP_API_PARAMS_RA_PRIVATE_KEY_IS_EMPTY(400, 30105, "cmp_api_params_ra_private_key_is_empty", "构造方法RA服务器签名私钥为空"),


	/**
	 * CA的openApi内部异常
	 */
	CA_OPEN_API_INNER_EXCEPTION(400,19001,"ca_open_api_inner_exception","CA的open-api内部异常"),
	CA_OPEN_API_RETURN_EXCEPTION(400, 19002, "ca_open_api_return_exception", "CA的open-api接口返回异常")
	// CA的业务类型相关错误码  SDK做特殊处理
,	//RA_CERT_ISSUE_STATUS_REVOKED(400, 18004, "ra_cert_issue_status_revoked", "证书已被撤销"),
	CA_KM_IS_NOT_INIT(400, 19139, "ca_km_is_not_init", "CA没有进行KM服务配置"),
	RA_TEMPLATE_RELATE_DELETE(400,19136, "ra_template_relate_delte", "CA返回Ra和模板关系被删除"),
	RA_CERT_ISSUE_STATUS_REVOKED(404, 19027, "cert_has_revoked", "CA返回证书已经撤销"),
	RA_CERT_ISSUE_STATUE_NORMAL(404, 19028, "cert_is_normal", "CA返回证书状态正常"),
	RA_CERT_ISSUE_STATUS_EXPIRED(400, 19025, "cert_has_expired", "CA返回证书已经过期"),
	RA_CERT_ISSUE_STATUS_EXCEPTION(400, 19024, "cert_status_other", "CA返回证书状态异常"),
	RA_CERT_ISSUE_STATUS_FROZEND(400, 19026, "cert_has_frozend", "CA返回证书已经被冻结"),
	CA_ILLEGAL_REQUEST_PARAMETER(400, 19004, "illegal_request_parameter", "CA返回非法请求参数"),
	CA_MISSING_REQUIRED_PARAMETERS(400, 19003, "missing_required_parameters", "CA返回缺少必要请求参数"),
	USER_CERT_ACK_ERROR(400, 11449, "user_cert_write_ack_error", "CA返回证书写卡状态确认失败"),
	BASEDN_ERROR(400, 11006, "base_dn_error", "CA返回DN后缀baseDN不正确"),
	CA_ROOT_CERT_EXPIRED(400, 11034, "ca_root_cert_expired", "CA返回CA根证书已过期"),
	USER_DN_NOT_SAME_RA_BASEDN(400, 19042, "user_dn_not_same_ra_baseDn", "CA返回用户的Dn和RA的baseDn不一致"),
	TEMPLATE_NOT_EXIST(400, 11129, "template_not_exist", "CA返回模板不存在"),
	DO_NOT_GET_NOT_CONFIRMED_CERT(400,19050,"do_not_get_not_confirmed_cert","待确认证书已被撤销"),
	//CERT_STATUS_IS_CANNOT_CONFIRM(400, 19133, "cert_status_is_cannot_confirm", "证书状态已不可被确认"),
	/**
	 * 证书链验签失败
	 */
	CA_CHAIN_VERIFY_FAIL(400, 11451, "ca_chain_verify_fail", "证书链验签失败"),
	/**
	 * 证书信息不存在
	 */
	CERT_NOT_EXIST(400, 19133, "cert_not_exist", "CA返回证书信息不存在"),


	CERT_DN_IS_NOT_FORMAT(400, 20616, "cert_dn_is_not_format", "申请中DN不是标准格式"),

	TEST_CA_SERVER_CONNECT_ERROR(400,20818,"test_ca_server_connect_error","测试CA服务连接失败"),

	/**
	 * LICENSE CA返回错误码
	 */
	LICENSE_ANALYSIS_ERROR(400,11800,"license_analysis_error","CA返回解析licese文件异常无法签发"),
	LICENSE_BEFORE_EFFECTIVE_DATE(400,11804,"license_before_effective_date","CA返回license未生效无法签发"),
	LICENSE_BE_OVERDUE(400,11805,"license_be_overdue","CA返回license已过期无法签发"),
	LICENSE_MORE_THAN_PERMITTED_QUANTITY(400,11806,"license_more_than_permitted_quantity","CA返回license数量不足无法签发"),

	/**
	 * CMP协议-CA证书封装与用户证书验证错误
	 */
	CA_CERTS_NOT_EXIST(400, 11807, "ca_certs_not_exit", "缺少CA证书链."),
	BUILD_TRAIN_CERT_P7b_IS_ERROR(400,11808,"build_train_cert_p7b_is_error","封装证书链错误"),
	USER_CERT_VERIFY_FAIL(400,11809,"cmp_cert_verify_fail", "用户证书格式验证失败"),
	;
	/**
	 * HTTP状态码
	 */
	private int status;
	/**
	 * 异常信息对象
	 */
	private ErrorBean errorBean;
	/**
	 * 异常描述
	 */
	public String desc;
	/**
	 * 异常描述 英文
	 */
	public String errMsg;

	/**
	 * 错误码 syg
	 */
	public int code;

	ErrorEnum(int status, int errCode, String errMsg, String desc) {
		this.status = status;
		this.errorBean = new ErrorBean(errCode, errMsg);
		this.code = errCode;
		this.desc = desc;
		this.errMsg = errMsg;
	}

	public static ErrorEnum getErrorEnumByCode(String errCode){
		for(ErrorEnum errorEnum :values()){
			if(StringUtils.equals(String.valueOf(errorEnum.code),errCode)){
				return errorEnum;
			}
		}
		return null;
	}

	public static void main(String[] args) {
		System.out.println(getErrorEnumByCode("30105"));
	}

}
