package com.xdja.ca.pkcs7;


/**
 * SM4加解密工具类
 * 
 * @author zjx
 * @Date 2013-4-3
 * @Status Create
 */
public class Sm4 {

	/**
	 * 转4个字节转换为int
	 * @param b
	 * @param pos
	 * @return int
	 */
	private static int GET_ULONG_BE(byte[] b, int pos) {
		return    ((int) (((b)[pos]     << 24) & 0xff000000))
				| ((int) (((b)[pos + 1] << 16) & 0x00ff0000))
				| ((int) (((b)[pos + 2] << 8 ) & 0x0000ff00))
				| ((int) ((b)[pos + 3]         & 0x000000ff));
	}
	
	/**
	 * 将int转换入字节数据内
	 * @param n
	 * @param b output
	 * @param i 
	 */
	private static void PUT_ULONG_BE(int n, byte[] b, int pos) {
		(b)[pos    ] = (byte) (n >> 24);
		(b)[pos + 1] = (byte) (n >> 16);
		(b)[pos + 2] = (byte) (n >> 8);
		(b)[pos + 3] = (byte) (n);
	}

	/**
	 * 左移
	 * @param x
	 * @param n
	 * @return
	 */
	private static int SHL(int x, int n) {
		return (x & 0xFFFFFFFF) << n;
	}

	/**
	 * 循环左移
	 * 
	 * @param x
	 * @param n
	 * @return
	 */
	private static int ROTL(int x, int n) {
		return SHL(x, n) | (x >>> (32 - n));
	}
	 
	/**
	 * Expanded SM4 S-boxes
	 * Sbox table: 8bits input convert to 8 bits output
	 */
	final private static byte[][] SboxTable = new byte[][]
	{
		{(byte)0xd6,(byte)0x90,(byte)0xe9,(byte)0xfe,(byte)0xcc,(byte)0xe1,(byte)0x3d,(byte)0xb7,(byte)0x16,(byte)0xb6,(byte)0x14,(byte)0xc2,(byte)0x28,(byte)0xfb,(byte)0x2c,(byte)0x05},
		{(byte)0x2b,(byte)0x67,(byte)0x9a,(byte)0x76,(byte)0x2a,(byte)0xbe,(byte)0x04,(byte)0xc3,(byte)0xaa,(byte)0x44,(byte)0x13,(byte)0x26,(byte)0x49,(byte)0x86,(byte)0x06,(byte)0x99},
		{(byte)0x9c,(byte)0x42,(byte)0x50,(byte)0xf4,(byte)0x91,(byte)0xef,(byte)0x98,(byte)0x7a,(byte)0x33,(byte)0x54,(byte)0x0b,(byte)0x43,(byte)0xed,(byte)0xcf,(byte)0xac,(byte)0x62},
		{(byte)0xe4,(byte)0xb3,(byte)0x1c,(byte)0xa9,(byte)0xc9,(byte)0x08,(byte)0xe8,(byte)0x95,(byte)0x80,(byte)0xdf,(byte)0x94,(byte)0xfa,(byte)0x75,(byte)0x8f,(byte)0x3f,(byte)0xa6},
		{(byte)0x47,(byte)0x07,(byte)0xa7,(byte)0xfc,(byte)0xf3,(byte)0x73,(byte)0x17,(byte)0xba,(byte)0x83,(byte)0x59,(byte)0x3c,(byte)0x19,(byte)0xe6,(byte)0x85,(byte)0x4f,(byte)0xa8},
		{(byte)0x68,(byte)0x6b,(byte)0x81,(byte)0xb2,(byte)0x71,(byte)0x64,(byte)0xda,(byte)0x8b,(byte)0xf8,(byte)0xeb,(byte)0x0f,(byte)0x4b,(byte)0x70,(byte)0x56,(byte)0x9d,(byte)0x35},
		{(byte)0x1e,(byte)0x24,(byte)0x0e,(byte)0x5e,(byte)0x63,(byte)0x58,(byte)0xd1,(byte)0xa2,(byte)0x25,(byte)0x22,(byte)0x7c,(byte)0x3b,(byte)0x01,(byte)0x21,(byte)0x78,(byte)0x87},
		{(byte)0xd4,(byte)0x00,(byte)0x46,(byte)0x57,(byte)0x9f,(byte)0xd3,(byte)0x27,(byte)0x52,(byte)0x4c,(byte)0x36,(byte)0x02,(byte)0xe7,(byte)0xa0,(byte)0xc4,(byte)0xc8,(byte)0x9e},
		{(byte)0xea,(byte)0xbf,(byte)0x8a,(byte)0xd2,(byte)0x40,(byte)0xc7,(byte)0x38,(byte)0xb5,(byte)0xa3,(byte)0xf7,(byte)0xf2,(byte)0xce,(byte)0xf9,(byte)0x61,(byte)0x15,(byte)0xa1},
		{(byte)0xe0,(byte)0xae,(byte)0x5d,(byte)0xa4,(byte)0x9b,(byte)0x34,(byte)0x1a,(byte)0x55,(byte)0xad,(byte)0x93,(byte)0x32,(byte)0x30,(byte)0xf5,(byte)0x8c,(byte)0xb1,(byte)0xe3},
		{(byte)0x1d,(byte)0xf6,(byte)0xe2,(byte)0x2e,(byte)0x82,(byte)0x66,(byte)0xca,(byte)0x60,(byte)0xc0,(byte)0x29,(byte)0x23,(byte)0xab,(byte)0x0d,(byte)0x53,(byte)0x4e,(byte)0x6f},
		{(byte)0xd5,(byte)0xdb,(byte)0x37,(byte)0x45,(byte)0xde,(byte)0xfd,(byte)0x8e,(byte)0x2f,(byte)0x03,(byte)0xff,(byte)0x6a,(byte)0x72,(byte)0x6d,(byte)0x6c,(byte)0x5b,(byte)0x51},
		{(byte)0x8d,(byte)0x1b,(byte)0xaf,(byte)0x92,(byte)0xbb,(byte)0xdd,(byte)0xbc,(byte)0x7f,(byte)0x11,(byte)0xd9,(byte)0x5c,(byte)0x41,(byte)0x1f,(byte)0x10,(byte)0x5a,(byte)0xd8},
		{(byte)0x0a,(byte)0xc1,(byte)0x31,(byte)0x88,(byte)0xa5,(byte)0xcd,(byte)0x7b,(byte)0xbd,(byte)0x2d,(byte)0x74,(byte)0xd0,(byte)0x12,(byte)0xb8,(byte)0xe5,(byte)0xb4,(byte)0xb0},
		{(byte)0x89,(byte)0x69,(byte)0x97,(byte)0x4a,(byte)0x0c,(byte)0x96,(byte)0x77,(byte)0x7e,(byte)0x65,(byte)0xb9,(byte)0xf1,(byte)0x09,(byte)0xc5,(byte)0x6e,(byte)0xc6,(byte)0x84},
		{(byte)0x18,(byte)0xf0,(byte)0x7d,(byte)0xec,(byte)0x3a,(byte)0xdc,(byte)0x4d,(byte)0x20,(byte)0x79,(byte)0xee,(byte)0x5f,(byte)0x3e,(byte)0xd7,(byte)0xcb,(byte)0x39,(byte)0x48}
	};

	/**
	 * System parameter
	 */
	private static int[] FK = {0xa3b1bac6,0x56aa3350,0x677d9197,0xb27022dc};

	/**
	 * fixed parameter
	 */
	private static int[] CK =
	{
		0x00070e15,0x1c232a31,0x383f464d,0x545b6269,
		0x70777e85,0x8c939aa1,0xa8afb6bd,0xc4cbd2d9,
		0xe0e7eef5,0xfc030a11,0x181f262d,0x343b4249,
		0x50575e65,0x6c737a81,0x888f969d,0xa4abb2b9,
		0xc0c7ced5,0xdce3eaf1,0xf8ff060d,0x141b2229,
		0x30373e45,0x4c535a61,0x686f767d,0x848b9299,
		0xa0a7aeb5,0xbcc3cad1,0xd8dfe6ed,0xf4fb0209,
		0x10171e25,0x2c333a41,0x484f565d,0x646b7279
	};


	/**
	 * look up in SboxTable and get the related value.
	 * args:    [in] inch: 0x00~0xFF (8 bits unsigned value).
	 * @param inch
	 * @return
	 */
	private static byte sm4Sbox(byte inch)
	{
	    return SboxTable[(inch & 0xf0) >> 4][inch & 0x0f];
	}

	
	/**
	 * "T algorithm" == "L algorithm" + "t algorithm".
	 * args:    [in] a: a is a 32 bits unsigned value;
	 * return: c: c is calculated with line algorithm "L" and nonline algorithm "t"
	 */
	private static int T(int ka)
	{
	    int bb = 0;
	    int c = 0;
	    byte[] a = new byte[4];
	   
	    PUT_ULONG_BE(ka,a,0);
	    byte[] b=t(a);
		bb = GET_ULONG_BE(b,0);
		
		c=L(bb);
	    
	    return c;
	}
	
	/**
	 *  L函数
	 * @param bb
	 * @return
	 */
	private static int L(int bb)
	{
	    int c =bb^(ROTL(bb, 2))^(ROTL(bb, 10))^(ROTL(bb, 18))^(ROTL(bb, 24));
	    return c;
	}
	
	/**
	 *  t函数
	 * @param a
	 * @return
	 */
	private static byte[] t(byte[] a)
	{
		byte[] b = new byte[4];
	    b[0] = sm4Sbox(a[0]);
	    b[1] = sm4Sbox(a[1]);
	    b[2] = sm4Sbox(a[2]);
	    b[3] = sm4Sbox(a[3]);
	    return b;
	}

	/**
	 * private F function:
	 * Calculating and getting encryption/decryption contents.
	 * args:    [in] x0: original contents;
	 * args:    [in] x1: original contents;
	 * args:    [in] x2: original contents;
	 * args:    [in] x3: original contents;
	 * args:    [in] rk: encryption/decryption key;
	 * return the contents of encryption/decryption contents.
	 */
	private static int sm4F(int x0, int x1, int x2, int x3, int rk)
	{
	    return (x0^T(x1^x2^x3^rk));
	}

	/**
	 * T'函数
	 * @param ka
	 * @return
	 */
	private static int T2(int ka)
	{
	    int bb = 0;
	    int rk = 0;
	    
	    byte[] a = new byte[4];
		byte[] b = new byte[4];
	    PUT_ULONG_BE(ka,a,0);
	    b=t(a);
		bb = GET_ULONG_BE(b,0);
	    
	    rk = L2(bb);
	    return rk;
	}
	
	/**
	 * L'函数
	 * @param bb
	 * @return
	 */
	private static int L2(int bb)
	{
	    int rk =bb^(ROTL(bb, 13))^(ROTL(bb, 23));
	    return rk;
	}
	
	

	private static void sm4_setkey( int[] SK, byte[] key )
	{
	    int[] MK = new int[4];
	    int[] k = new int[36];
	    int i = 0;

	    MK[0] = GET_ULONG_BE( key, 0 );
	    MK[1] = GET_ULONG_BE( key, 4 );
	    MK[2] = GET_ULONG_BE( key, 8 );
	    MK[3] = GET_ULONG_BE( key, 12 );
	    k[0] = MK[0]^FK[0];
	    k[1] = MK[1]^FK[1];
	    k[2] = MK[2]^FK[2];
	    k[3] = MK[3]^FK[3];
	    for(; i<32; i++)
	    {
	        k[i+4] = k[i] ^ (T2(k[i+1]^k[i+2]^k[i+3]^CK[i]));
	        SK[i] = k[i+4];
		}

	}

	/**
	 * SM4 standard one round processing
	 *
	 */
	private static void sm4_one_round( int[] sk,
	                    byte[] input,
	                    byte[] output, int pos)
	{
	    int i = 0;
	    int[] ulbuf = new int[36];
	    
	    ulbuf[0] = GET_ULONG_BE(input, pos + 0);
	    ulbuf[1] = GET_ULONG_BE(input, pos + 4);
	    ulbuf[2] = GET_ULONG_BE(input, pos + 8);
	    ulbuf[3] = GET_ULONG_BE(input, pos + 12);
	    while(i<32)
	    {
	        ulbuf[i+4] = sm4F(ulbuf[i], ulbuf[i+1], ulbuf[i+2], ulbuf[i+3], sk[i]);
		    i++;
	    }
		PUT_ULONG_BE(ulbuf[35],output,pos + 0);
		PUT_ULONG_BE(ulbuf[34],output,pos + 4);
		PUT_ULONG_BE(ulbuf[33],output,pos + 8);
		PUT_ULONG_BE(ulbuf[32],output,pos + 12);
	}

	/**
	 * SM4 key schedule (128-bit, encryption)
	 */
	private static void sm4_setkey_enc(Sm4_context ctx, byte[] key )
	{
	    ctx.mode = Sm4_context.SM4_ENCRYPT;
		sm4_setkey( ctx.sk, key );
	}

	/**
	 * SM4 key schedule (128-bit, decryption)
	 */
	private static void sm4_setkey_dec(Sm4_context ctx, byte[] key)
	{
	    int i;
		ctx.mode = Sm4_context.SM4_ENCRYPT;
	    sm4_setkey( ctx.sk, key );
	    for( i = 0; i < ctx.sk.length/2; i ++ )
	    {
	    	int tmp = ctx.sk[ i ];
	    	ctx.sk[ i ] = ctx.sk[ 31-i ];
	    	ctx.sk[ 31-i ] = tmp;
	    }
	}


	/**
	 * SM4-ECB block encryption/decryption
	 */
	private static void sm4_crypt_ecb( Sm4_context ctx,
					   int length,
					   byte[] input,
	                   byte[] output)
	{
		for(int i=0; i<length; i+=16){
			sm4_one_round( ctx.sk, input, output, i);
		}
	}
	
	/**
	 * sm4加密
	 * @param key 密钥，16个字节
	 * @param plain 原始明文，不能为空
	 * @return 密文
	 */
	public static byte[] sm4_encrypt_ecb( byte[] key, byte[] plain)
	{
		if(key == null || key.length != 16){
			throw new IllegalArgumentException("key can't be null, and len must 16 bytes");
		}
		if(plain == null || plain.length == 0){
			throw new IllegalArgumentException("plain can't be null");
		}
		
		int padLen = 16 - plain.length % 16;
		padLen = 0 == padLen ? 16 : padLen;
		byte[] padPlain=new byte[plain.length + padLen];
		System.arraycopy(plain, 0, padPlain, 0, plain.length);
		
		for(int i=0;i<padLen;i++){
			padPlain[plain.length + i] = (byte)padLen;
		}
		
		byte[] secure = new byte[padPlain.length];
		
		Sm4_context ctx = new Sm4_context();
		sm4_setkey_enc(ctx,key);
		
		sm4_crypt_ecb(ctx,padPlain.length,padPlain,secure);
		
		return secure;
	}
	
	/**
	 * sm4加密 填充方式：在plain前边填充32个0x00，本方法内部完成
	 * @param key 密钥，16个字节
	 * @param plain 原始明文，不能为空
	 * @return 密文
	 */
	public static byte[] sm4_encrypt_ecb_padbefore32byte( byte[] key, byte[] plain)
	{
		if(key == null || key.length != 16){
			throw new IllegalArgumentException("key can't be null, and len must 16 bytes");
		}
		if(plain == null || plain.length == 0){
			throw new IllegalArgumentException("plain can't be null");
		}

		int padLen = 32;
		byte[] padPlain=new byte[plain.length + padLen];
		System.arraycopy(plain, 0, padPlain, padLen, plain.length);
		
		byte[] secure = new byte[padPlain.length];

        Sm4_context ctx = new Sm4_context();
        sm4_setkey_enc(ctx,key);

        sm4_crypt_ecb(ctx,padPlain.length,padPlain,secure);
		
		return secure;
	}
	
	/**
	 * sm4解密
	 * @param key 密钥，16个字节
	 * @param secure 密文，不能为空，且
	 * @return 成功-明文；失败-null
	 */
	public static byte[] sm4_decrypt_ecb(byte[] key, byte[] secure)
	{
		if(key == null || key.length != 16){
			throw new IllegalArgumentException("key can't be null, and len must 16 bytes");
		}
		if(secure == null || ((secure.length%16) != 0)){
			throw new IllegalArgumentException("secure can't be null, and must multiple of 16");
		}
		
		byte[] padPlain = new byte[secure.length];
		
		Sm4_context ctx = new Sm4_context();
		sm4_setkey_dec(ctx,key);
		
		sm4_crypt_ecb(ctx,secure.length,secure,padPlain);
		
		int padLen = padPlain[padPlain.length - 1] + 1;
		
		if(padLen<1 || padLen>16 || padPlain.length<padLen){
			return null;
		}
		
		byte[] plain=new byte[padPlain.length - padLen];
		
		System.arraycopy(padPlain, 0, plain, 0, plain.length);
		
		return plain;
	}

}


