/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.security.bean;

import com.xdja.pki.ca.security.bean.Function;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class Operator
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String OPERATOR = "operator";
    private String username;
    private Object currUser;
    private Set<Function> functions = new LinkedHashSet<Function>();
    private Set<String> permissions = new HashSet<String>();

    public Operator(String username, Collection<Function> functions) {
        this.username = username;
        if (null != functions && !functions.isEmpty()) {
            this.functions.addAll(functions);
            this.parserPermission(functions);
        }
    }

    public <T> Operator(String username, Collection<Function> functions, T currUser) {
        this(username, functions);
        this.setCurrUser(currUser);
    }

    private void parserPermission(Collection<Function> functions) {
        for (Function item : functions) {
            if (StringUtils.isNotBlank((CharSequence)item.getPermission())) {
                this.permissions.add(item.getPermission());
            }
            this.parserPermission(item.getChildren());
        }
    }

    public String getUsername() {
        return this.username;
    }

    public Set<String> getPermissions() {
        return Collections.unmodifiableSet(this.permissions);
    }

    public Collection<Function> getTopMenus() {
        return this.functions;
    }

    public <T> void setCurrUser(T currUser) {
        this.currUser = currUser;
    }

    public <T> T getCurrUser() {
        return (T)this.currUser;
    }
}

