/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certcrl.service.impl;

import com.xdja.pki.ca.certcrl.service.impl.CrlService;
import com.xdja.pki.ca.certcrl.service.util.ArlPublishUtil;
import com.xdja.pki.ca.certcrl.service.util.CrlPublishUtil;
import com.xdja.pki.ca.certmanager.dao.ArlDao;
import com.xdja.pki.ca.certmanager.dao.ArlDataDao;
import com.xdja.pki.ca.certmanager.dao.CrlDao;
import com.xdja.pki.ca.certmanager.dao.CrlDataDao;
import com.xdja.pki.ca.certmanager.dao.DeltaRevokeCertDao;
import com.xdja.pki.ca.certmanager.dao.RevokeCertDao;
import com.xdja.pki.ca.certmanager.dao.TemplateDao;
import com.xdja.pki.ca.certmanager.dao.TemplateUserCertDao;
import com.xdja.pki.ca.certmanager.dao.models.CrlBeanDo;
import com.xdja.pki.ca.certmanager.dao.models.DeltaRevokedCertDO;
import com.xdja.pki.ca.certmanager.dao.models.TemplateUserCertDO;
import com.xdja.pki.ca.certmanager.service.subsystem.SubSystemService;
import com.xdja.pki.ca.certmanager.service.util.ExtensionUtil;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.CrlConstants;
import com.xdja.pki.ca.core.configBasic.bean.CrlConfigBean;
import com.xdja.pki.ca.core.enums.CrlPublishEnum;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.core.util.CrlUtil;
import com.xdja.pki.ca.core.util.time.IssueTimeUtil;
import com.xdja.pki.ca.securitymanager.dao.CaCertDao;
import com.xdja.pki.ca.securitymanager.dao.CertSnDao;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import com.xdja.pki.ca.securitymanager.service.vo.SignAlgTypeEnum;
import com.xdja.pki.gmssl.x509.utils.GMSSLCRLUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLExtensionUtils;
import com.xdja.pki.gmssl.x509.utils.bean.CRLEntry;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.x509.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CRLServiceImpl
implements CrlService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private DeltaRevokeCertDao deltaRevokeCertDao;
    @Autowired
    private CertSnDao certSnDao;
    @Autowired
    private RevokeCertDao revokeCertDao;
    @Autowired
    private CrlDao crlDao;
    @Autowired
    private CrlDataDao crlDataDao;
    @Autowired
    private CaCertDao caCertDao;
    @Autowired
    private ArlDao arlDao;
    @Autowired
    private ArlDataDao arlDataDao;
    @Autowired
    private SubSystemService subSystemService;
    @Autowired
    private TemplateUserCertDao templateUserCertDao;
    @Autowired
    private TemplateDao templateDao;
    @Value(value="${ldapsdk.response.overtime}")
    public int ldapsdkOutTime;

    public void saveDeltaCrlInfo(String signSn, String encSn, Integer alg, Integer revokeReason, Date revokeDate) {
        try {
            ArrayList<DeltaRevokedCertDO> certList = new ArrayList<DeltaRevokedCertDO>();
            DeltaRevokedCertDO signSnDo = new DeltaRevokedCertDO(signSn, alg, revokeReason, revokeDate);
            certList.add(signSnDo);
            if (null != encSn) {
                DeltaRevokedCertDO encSnDo = new DeltaRevokedCertDO(encSn, alg, revokeReason, revokeDate);
                certList.add(encSnDo);
            }
            this.deltaRevokeCertDao.saveBatch(certList);
        }
        catch (Exception e) {
            throw new ServiceException("\u4fdd\u5b58\u589e\u91cfCRL\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
    }

    public void saveDeltaCrlInfo(String sn, Integer alg, Integer revokeReason, Date revokeDate) {
        try {
            DeltaRevokedCertDO signSnDo = new DeltaRevokedCertDO(sn, alg, revokeReason, revokeDate);
            this.deltaRevokeCertDao.save(signSnDo);
        }
        catch (Exception e) {
            throw new ServiceException("\u4fdd\u5b58\u589e\u91cfCRL\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
    }

    private void copyList(List<CrlBeanDo> crlList, List<CRLEntry> crlEntryList) {
        for (CrlBeanDo crlBeanDo : crlList) {
            CRLEntry crlEntry = new CRLEntry(crlBeanDo.getUserCertificateSerial(), crlBeanDo.getRevocationDate(), crlBeanDo.getReason().intValue());
            crlEntryList.add(crlEntry);
        }
    }

    private void saveCrlData(Map<Integer, X509CRL> x509CRLS, Long caCertId) {
        Map map = this.crlDao.saveCrls(caCertId, x509CRLS);
        this.crlDataDao.saveCrlDatas(x509CRLS, map);
    }

    public void doIssueCrl(Date thisUpdateDate, Integer alg, boolean isDrl) {
        String name = isDrl ? "drl" : "crl";
        this.logger.info("====================\u5f00\u59cb\u7b7e\u53d1" + name + "====================");
        CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(alg);
        List caCerts = this.caCertDao.getCaCertsByCaId(caInfoVO.getCaId());
        Long maxSn = this.certSnDao.getMaxId();
        int fragmentationSize = caInfoVO.getCrlConfig().getCertCounts();
        int deltas = CrlUtil.computeSnFragmentantation((BigInteger)BigInteger.valueOf(maxSn), (int)fragmentationSize);
        Date newUpdateDate = IssueTimeUtil.getNextUpdateDate((Date)thisUpdateDate, (Integer)(isDrl ? caInfoVO.getCrlConfig().getDeltaCrlCycle() : caInfoVO.getCrlConfig().getReleaseCycle()));
        HashMap<Integer, X509CRL> x509CrlMap = new HashMap<Integer, X509CRL>();
        HashMap crlMap = new HashMap();
        Map crlIdMap = this.crlDao.getLastCrlId();
        Integer flag = null;
        try {
            int i;
            List crlList;
            int n = 0;
            while (null != (crlList = isDrl ? this.deltaRevokeCertDao.getSnsForDrl(alg, thisUpdateDate, n, CrlConstants.DB_READ_COUNTS.intValue()) : this.revokeCertDao.getSnsForCrl(alg, thisUpdateDate, n, CrlConstants.DB_READ_COUNTS.intValue())) && 0 != crlList.size()) {
                ArrayList<CRLEntry> crlEntryList = new ArrayList<CRLEntry>();
                this.copyList(crlList, crlEntryList);
                n += CrlConstants.DB_READ_COUNTS.intValue();
                for (i = 0; i < crlEntryList.size(); ++i) {
                    CRLEntry crlEntry = (CRLEntry)crlEntryList.get(i);
                    String sn = crlEntry.getUserCertificateSerial();
                    Integer a = CrlUtil.computeSnFragmentantation((BigInteger)new BigInteger(sn, 16), (int)caInfoVO.getCrlConfig().getCertCounts());
                    TemplateUserCertDO templateUserCertDO = this.templateUserCertDao.queryBySn(sn);
                    flag = null != templateUserCertDO && templateUserCertDO.isOpenCrl() ? Integer.valueOf(templateUserCertDO.getTemplateId().intValue() * CrlConstants.TRANSLATION_17 + a) : Integer.valueOf(CrlConstants.COMMON_CRL_TEMPLATE_ID * CrlConstants.TRANSLATION_17 + a);
                    ArrayList<CRLEntry> issueCrlEntry = (ArrayList<CRLEntry>)crlMap.get(flag);
                    if (null == issueCrlEntry) {
                        issueCrlEntry = new ArrayList<CRLEntry>();
                    }
                    issueCrlEntry.add(crlEntry);
                    crlMap.put(flag, issueCrlEntry);
                }
            }
            List templateIdList = this.templateDao.getOpenCrlTemplateId();
            this.logger.debug("deltas:" + deltas);
            for (i = 0; i <= deltas; ++i) {
                int j = CrlConstants.COMMON_CRL_TEMPLATE_ID * CrlConstants.TRANSLATION_17 + i;
                List issueCrlEntry = (ArrayList)crlMap.get(j);
                if (null == issueCrlEntry) {
                    issueCrlEntry = new ArrayList();
                    crlMap.put(j, issueCrlEntry);
                }
                if (null == templateIdList) continue;
                for (Long id : templateIdList) {
                    this.logger.debug("\u5355\u72ec\u5206\u7247\u6a21\u677fid\uff1a" + id);
                    j = id.intValue() * CrlConstants.TRANSLATION_17 + i;
                    issueCrlEntry = (List)crlMap.get(j);
                    if (null != issueCrlEntry) continue;
                    issueCrlEntry = new ArrayList();
                    crlMap.put(j, issueCrlEntry);
                }
            }
            for (Integer integer : crlMap.keySet()) {
                Extension extension;
                ArrayList<Extension> extensions = new ArrayList<Extension>();
                if (isDrl) {
                    Object o = crlIdMap.get("crl" + integer + ".crl");
                    String baseCrlSn = this.crlDao.getLastCrlSnById((Long)o);
                    extension = GMSSLExtensionUtils.genDRLExtension((int)new BigInteger(baseCrlSn, 16).intValue());
                } else {
                    extension = ExtensionUtil.genAuthorityKeyIdentifier(null, (boolean)false, (X509Certificate)caInfoVO.getRootCert());
                }
                extensions.add(extension);
                BigInteger crlSn = this.certSnDao.getCrlMaxSn(new Date());
                List crlEntryList = (List)crlMap.get(integer);
                X509CRL x509CRL = Constants.CRYPT_DEVICE_TYPE.equals(Constants.CRYPT_DEVICE_BC) ? GMSSLCRLUtils.generateCRLByBC((X509Certificate)caInfoVO.getRootCert(), (PrivateKey)caInfoVO.getRootPrivateKey(), (String)SignAlgTypeEnum.getAlgName((int)Integer.parseInt(caInfoVO.getSignAlg())), (BigInteger)crlSn, (Date)thisUpdateDate, (Date)newUpdateDate, extensions, (List)crlEntryList) : GMSSLCRLUtils.generateCRLByYunhsm((X509Certificate)caInfoVO.getRootCert(), (int)caInfoVO.getCaPwdBean().getKeyIndex(), (String)caInfoVO.getCaPwdBean().getPrivateKeyPin(), (String)SignAlgTypeEnum.getAlgName((int)Integer.parseInt(caInfoVO.getSignAlg())), (BigInteger)crlSn, (Date)thisUpdateDate, (Date)newUpdateDate, extensions, (List)crlEntryList);
                x509CrlMap.put(integer, x509CRL);
            }
            if (0 != x509CrlMap.size()) {
                if (isDrl) {
                    this.saveDrlData(x509CrlMap, caInfoVO.getCertId(), crlIdMap);
                } else {
                    this.saveCrlData(x509CrlMap, caInfoVO.getCertId());
                    if (caInfoVO.getCrlConfig().isDelta()) {
                        this.deltaRevokeCertDao.deleteBatch(x509CrlMap, alg);
                    }
                }
                CrlPublishUtil crlPublishUtil = new CrlPublishUtil();
                CrlConfigBean crlConfigBean = caInfoVO.getCrlConfig();
                if (CrlPublishEnum.isHttpCRL((Integer)crlConfigBean.getCrlPublish())) {
                    crlPublishUtil.httpPublishCrl(crlConfigBean, x509CrlMap, isDrl);
                }
                if (CrlPublishEnum.isLDAPCRL((Integer)crlConfigBean.getCrlPublish())) {
                    List ldapSignCerts = this.subSystemService.getAllLdapServerCerts();
                    crlPublishUtil.ldapPublishCrl(caInfoVO, x509CrlMap, ldapSignCerts, caCerts, this.ldapsdkOutTime);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException("\u7b7e\u53d1crl\u5931\u8d25", (Throwable)e);
        }
    }

    private void saveDrlData(Map<Integer, X509CRL> x509CRLMap, Long caCertId, Map<String, Object> saveDrlData) {
        Map map = this.crlDao.saveDrls(caCertId, x509CRLMap, saveDrlData);
        this.crlDataDao.saveDrlDatas(x509CRLMap, map);
    }

    public void doIssueArl(Date thisUpdateDate, Integer alg) {
        CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(alg);
        List caCerts = this.caCertDao.getCaCertsByCaId(caInfoVO.getCaId());
        Date newUpdateDate = IssueTimeUtil.getNextUpdateDate((Date)thisUpdateDate, (Integer)caInfoVO.getCrlConfig().getReleaseCycle());
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        try {
            CrlConfigBean crlConfigBean = caInfoVO.getCrlConfig();
            if (CrlPublishEnum.isSignCRL((Integer)crlConfigBean.getCrlPublish())) {
                ArlPublishUtil arlPublishUtil = new ArlPublishUtil();
                String arlUrl = arlPublishUtil.getPublishArlUrl(caInfoVO);
                Extension extension = GMSSLExtensionUtils.genARLExtension((String)arlUrl);
                extensions.add(extension);
                List crlList = this.revokeCertDao.getSnsForArl(alg, thisUpdateDate);
                ArrayList<CRLEntry> crlEntryList = new ArrayList<CRLEntry>();
                this.copyList(crlList, crlEntryList);
                BigInteger crlSn = this.certSnDao.getCrlMaxSn(new Date());
                X509CRL x509CRL = null;
                x509CRL = Constants.CRYPT_DEVICE_TYPE.equals(Constants.CRYPT_DEVICE_BC) ? GMSSLCRLUtils.generateCRLByBC((X509Certificate)caInfoVO.getRootCert(), (PrivateKey)caInfoVO.getRootPrivateKey(), (String)SignAlgTypeEnum.getAlgName((int)Integer.parseInt(caInfoVO.getSignAlg())), (BigInteger)crlSn, (Date)thisUpdateDate, (Date)newUpdateDate, extensions, crlEntryList) : GMSSLCRLUtils.generateCRLByYunhsm((X509Certificate)caInfoVO.getRootCert(), (int)caInfoVO.getCaPwdBean().getKeyIndex(), (String)caInfoVO.getCaPwdBean().getPrivateKeyPin(), (String)SignAlgTypeEnum.getAlgName((int)Integer.parseInt(caInfoVO.getSignAlg())), (BigInteger)crlSn, (Date)thisUpdateDate, (Date)newUpdateDate, extensions, crlEntryList);
                this.saveArlData(x509CRL, caInfoVO.getCertId());
                if (CrlPublishEnum.isHttpCRL((Integer)crlConfigBean.getCrlPublish())) {
                    arlPublishUtil.httpPublishCrl(crlConfigBean, x509CRL);
                }
                if (CrlPublishEnum.isLDAPCRL((Integer)crlConfigBean.getCrlPublish())) {
                    List ldapSignCerts = this.subSystemService.getAllLdapServerCerts();
                    arlPublishUtil.ldapPublishArl(caInfoVO, x509CRL, ldapSignCerts, caCerts, this.ldapsdkOutTime);
                }
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u7b7e\u53d1ARL\u5931\u8d25", (Throwable)e);
        }
    }

    private void saveArlData(X509CRL x509CRL, Long caCertId) {
        Map map = this.arlDao.saveArls(caCertId, x509CRL);
        this.arlDataDao.saveArlDatas(x509CRL, map);
    }

    public Date getCrlLastUpdateTime() {
        try {
            return this.crlDao.getCrlLastUpdateTime();
        }
        catch (Exception e) {
            throw new ServiceException("\u83b7\u53d6\u5f53\u524d\u6700\u5927CRL\u6700\u540e\u66f4\u65b0\u65f6\u95f4\u5f02\u5e38", (Throwable)e);
        }
    }

    public Date getDrlLastUpdateTime() {
        try {
            return this.crlDao.getArlLastUpdateTime();
        }
        catch (Exception e) {
            throw new ServiceException("\u83b7\u53d6\u5f53\u524d\u6700\u5927CRL\u6700\u540e\u66f4\u65b0\u65f6\u95f4\u5f02\u5e38", (Throwable)e);
        }
    }
}

