/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certcrl.service.util;

import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.configBasic.bean.CrlConfigBean;
import com.xdja.pki.ca.core.configBasic.bean.LdapConfigBean;
import com.xdja.pki.ca.core.enums.CrlPublishEnum;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.ldap.sdk.ca.LDAPCASDK;
import com.xdja.pki.ldap.sdk.ca.LDAPResponse;
import com.xdja.pki.ldap.sdk.ca.LDAPUrlUtils;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.naming.InvalidNameException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArlPublishUtil {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public String ldapPublishArlUrl(CaInfoVO caInfoVO) throws InvalidNameException {
        LdapConfigBean ldapConfigBean = caInfoVO.getLdapConfig();
        if (null != ldapConfigBean && StringUtils.isNotBlank((CharSequence)ldapConfigBean.getMasterURL())) {
            return LDAPUrlUtils.genCertArlLdapUri((String)ldapConfigBean.getSlaveURL(), (String)caInfoVO.getSubject(), (int)0, (String)caInfoVO.getBaseDn());
        }
        return "";
    }

    public String httpPublishArlUrl(CaInfoVO caInfoVO) {
        CrlConfigBean crlConfigBean = caInfoVO.getCrlConfig();
        if (StringUtils.isNotBlank((CharSequence)crlConfigBean.getCrlRemoteURL())) {
            return crlConfigBean.getCrlRemoteURL() + "arl" + "0" + ".crl";
        }
        return "";
    }

    public String getPublishArlUrl(CaInfoVO caInfoVO) throws InvalidNameException {
        CrlConfigBean crlConfigBean = caInfoVO.getCrlConfig();
        if (CrlPublishEnum.isHttpCRL((Integer)crlConfigBean.getCrlPublish())) {
            return this.httpPublishArlUrl(caInfoVO);
        }
        if (CrlPublishEnum.isLDAPCRL((Integer)crlConfigBean.getCrlPublish())) {
            return this.ldapPublishArlUrl(caInfoVO);
        }
        return "";
    }

    public void httpPublishCrl(CrlConfigBean crlConfigBean, X509CRL x509CrlMap) {
        String crlLocalDirectory = crlConfigBean.getCrlLocalDirectory();
        this.logger.debug("\u5f00\u59cb\u8fdb\u884cARL\u6587\u4ef6\u672c\u5730\u4fdd\u5b58,\u4fdd\u5b58\u76ee\u5f55\uff1a" + crlLocalDirectory);
        if (StringUtils.isNotBlank((CharSequence)crlLocalDirectory)) {
            CertUtil.writeObjToFile((Object)x509CrlMap, (String)(crlLocalDirectory + "arl" + "0.crl"));
        }
        this.logger.debug("ARL\u6587\u4ef6\u672c\u5730\u4fdd\u5b58\u7ed3\u675f");
    }

    public void ldapPublishArl(CaInfoVO caInfoVO, X509CRL x509Crl, List<X509Certificate> ldapSignCerts, List<X509Certificate> caCerts, int ldapsdkOutTime) {
        if (null != caInfoVO.getLdapConfig() && StringUtils.isNotBlank((CharSequence)caInfoVO.getLdapConfig().getMasterURL())) {
            this.logger.info("\u5f00\u59cb\u5411LDAP\u670d\u52a1\u5668\u53d1\u5e03ARL\u5217\u8868");
            LDAPCASDK ldapServer = Constants.CRYPT_DEVICE_TYPE.equals(Constants.CRYPT_DEVICE_BC) ? new LDAPCASDK(caCerts, caInfoVO.getKeyPair(), caInfoVO.getLdapConfig().getMasterURL(), null, ldapSignCerts, null) : new LDAPCASDK(caCerts, caInfoVO.getCaPwdBean().getKeyIndex().intValue(), caInfoVO.getCaPwdBean().getPrivateKeyPin(), SdfCryptoType.YUNHSM, caInfoVO.getLdapConfig().getMasterURL(), null, ldapSignCerts, null);
            ldapServer.setTime(ldapsdkOutTime);
            LDAPResponse ldapResponse = ldapServer.sendCRL(0, x509Crl);
            this.logger.info("\u5411LDAP\u670d\u52a1\u5668\u53d1\u5e03ARL\u5217\u8868\u7ed3\u675f\uff0c\u8fd4\u56dereason\uff1a" + ldapResponse.getReason());
        }
    }
}

