/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certcrl.service.util;

import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.configBasic.bean.CrlConfigBean;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.ldap.sdk.ca.LDAPCASDK;
import com.xdja.pki.ldap.sdk.ca.LDAPResponse;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrlPublishUtil {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void httpPublishCrl(CrlConfigBean crlConfigBean, Map<Integer, X509CRL> x509CrlMap, boolean isDrl) {
        String crlLocalDirectory = crlConfigBean.getCrlLocalDirectory();
        this.logger.debug("\u5f00\u59cb\u8fdb\u884cCRL\u6587\u4ef6\u672c\u5730\u4fdd\u5b58,\u4fdd\u5b58\u76ee\u5f55\uff1a" + crlLocalDirectory);
        if (StringUtils.isNotBlank((CharSequence)crlLocalDirectory)) {
            String prifx = isDrl ? "drl" : "crl";
            for (Integer i : x509CrlMap.keySet()) {
                CertUtil.writeObjToFile((Object)x509CrlMap.get(i), (String)(crlLocalDirectory + prifx + i + ".crl"));
            }
        }
        this.logger.debug("CRL\u6587\u4ef6\u672c\u5730\u4fdd\u5b58\u7ed3\u675f");
    }

    public void ldapPublishCrl(CaInfoVO caInfoVO, Map<Integer, X509CRL> x509CrlMap, List<X509Certificate> ldapSignCerts, List<X509Certificate> caCerts, int ldapsdkOutTime) {
        if (null != caInfoVO.getLdapConfig() && StringUtils.isNotBlank((CharSequence)caInfoVO.getLdapConfig().getMasterURL())) {
            this.logger.info("\u5f00\u59cb\u5411LDAP\u670d\u52a1\u5668\u53d1\u5e03crl\u5217\u8868");
            LDAPCASDK ldapServer = Constants.CRYPT_DEVICE_TYPE.equals(Constants.CRYPT_DEVICE_BC) ? new LDAPCASDK(caCerts, caInfoVO.getKeyPair(), caInfoVO.getLdapConfig().getMasterURL(), null, ldapSignCerts, null) : new LDAPCASDK(caCerts, caInfoVO.getCaPwdBean().getKeyIndex().intValue(), caInfoVO.getCaPwdBean().getPrivateKeyPin(), SdfCryptoType.YUNHSM, caInfoVO.getLdapConfig().getMasterURL(), null, ldapSignCerts, null);
            ldapServer.setTime(ldapsdkOutTime);
            for (Integer integer : x509CrlMap.keySet()) {
                LDAPResponse ldapResponse = ldapServer.sendCRL(integer.intValue(), x509CrlMap.get(integer));
                this.logger.debug("\u5411LDAP\u670d\u52a1\u5668\u53d1\u5e03\u5206\u7247\u53f7\u4e3a" + integer + "\u7684crl\u7ed3\u675f\uff0c\u8fd4\u56dereason:" + ldapResponse.getReason());
            }
            this.logger.info("\u5411LDAP\u670d\u52a1\u5668\u53d1\u5e03DRL\u5217\u8868\u7ed3\u675f");
        }
    }
}

