/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certcrl.service.impl;

import com.xdja.pki.ca.certcrl.service.impl.CrlService;
import com.xdja.pki.ca.certcrl.service.util.ArlPublishUtil;
import com.xdja.pki.ca.certcrl.service.util.CrlPublishUtil;
import com.xdja.pki.ca.certmanager.dao.ArlDao;
import com.xdja.pki.ca.certmanager.dao.ArlDataDao;
import com.xdja.pki.ca.certmanager.dao.CertDao;
import com.xdja.pki.ca.certmanager.dao.CrlDao;
import com.xdja.pki.ca.certmanager.dao.CrlDataDao;
import com.xdja.pki.ca.certmanager.dao.DeltaRevokeCertDao;
import com.xdja.pki.ca.certmanager.dao.RevokeCertDao;
import com.xdja.pki.ca.certmanager.dao.TemplateDao;
import com.xdja.pki.ca.certmanager.dao.models.CrlBeanDo;
import com.xdja.pki.ca.certmanager.dao.models.DeltaRevokedCertDO;
import com.xdja.pki.ca.certmanager.dao.models.TemplateDO;
import com.xdja.pki.ca.certmanager.service.crltemplate.CrlTemplateService;
import com.xdja.pki.ca.certmanager.service.crltemplate.bean.CrlTemplateExtensionVO;
import com.xdja.pki.ca.certmanager.service.subsystem.SubSystemService;
import com.xdja.pki.ca.certmanager.service.util.CrlExtensionUtil;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.CrlConstants;
import com.xdja.pki.ca.core.common.PageInfo;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.enums.CrlPublishEnum;
import com.xdja.pki.ca.core.enums.SignAlgFormatEnum;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.core.util.time.IssueTimeUtil;
import com.xdja.pki.ca.securitymanager.dao.CaCertDao;
import com.xdja.pki.ca.securitymanager.dao.CertSnDao;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import com.xdja.pki.ca.securitymanager.service.vo.SignAlgTypeEnum;
import com.xdja.pki.gmssl.x509.utils.GMSSLCRLUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLExtensionUtils;
import com.xdja.pki.gmssl.x509.utils.bean.CRLEntry;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.x509.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CRLServiceImpl
implements CrlService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private DeltaRevokeCertDao deltaRevokeCertDao;
    @Autowired
    private CertSnDao certSnDao;
    @Autowired
    private RevokeCertDao revokeCertDao;
    @Autowired
    private CrlDao crlDao;
    @Autowired
    private CrlDataDao crlDataDao;
    @Autowired
    private CaCertDao caCertDao;
    @Autowired
    private ArlDao arlDao;
    @Autowired
    private ArlDataDao arlDataDao;
    @Autowired
    private SubSystemService subSystemService;
    @Autowired
    private TemplateDao templateDao;
    @Autowired
    private CertDao certDao;
    @Autowired
    CrlTemplateService crlTemplateService;
    @Value(value="${ldapsdk.response.overtime}")
    public int ldapsdkOutTime;

    public void saveDeltaCrlInfo(String signSn, String encSn, Integer alg, Integer revokeReason, Date revokeDate, long crlTempId, String segmentNo) {
        try {
            ArrayList<DeltaRevokedCertDO> certList = new ArrayList<DeltaRevokedCertDO>();
            DeltaRevokedCertDO signSnDo = new DeltaRevokedCertDO(signSn, alg, revokeReason, revokeDate, crlTempId, segmentNo);
            certList.add(signSnDo);
            if (null != encSn) {
                DeltaRevokedCertDO encSnDo = new DeltaRevokedCertDO(encSn, alg, revokeReason, revokeDate, crlTempId, segmentNo);
                certList.add(encSnDo);
            }
            this.deltaRevokeCertDao.saveBatch(certList);
        }
        catch (Exception e) {
            throw new ServiceException("\u4fdd\u5b58\u589e\u91cfCRL\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
    }

    public void saveDeltaCrlInfo(String sn, Integer alg, Integer revokeReason, Date revokeDate, long crlTempId, String segmentNo) {
        try {
            DeltaRevokedCertDO signSnDo = new DeltaRevokedCertDO(sn, alg, revokeReason, revokeDate, crlTempId, segmentNo);
            this.deltaRevokeCertDao.save(signSnDo);
        }
        catch (Exception e) {
            throw new ServiceException("\u4fdd\u5b58\u589e\u91cfCRL\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
    }

    private void copyList(List<CrlBeanDo> crlList, List<CRLEntry> crlEntryList) {
        if (!CollectionUtils.isEmpty(crlList)) {
            for (CrlBeanDo crlBeanDo : crlList) {
                CRLEntry crlEntry = new CRLEntry(crlBeanDo.getUserCertificateSerial(), crlBeanDo.getRevocationDate(), crlBeanDo.getReason().intValue());
                crlEntryList.add(crlEntry);
            }
        }
    }

    private void saveCrlData(Map<Integer, X509CRL> x509CRLS, Long caCertId, Long crlTempId) {
        Map map = this.crlDao.saveCrls(caCertId, crlTempId, x509CRLS);
        this.crlDataDao.saveCrlDatas(x509CRLS, map);
    }

    public void doIssueCrl(Date thisUpdateDate, Integer alg, boolean isDrl) {
    }

    private void saveDrlData(Map<Integer, X509CRL> x509CRLMap, Long caCertId, Map<String, Object> saveDrlData, Long crlTempId) {
        Map map = this.crlDao.saveDrls(caCertId, x509CRLMap, saveDrlData, crlTempId);
        this.crlDataDao.saveDrlDatas(x509CRLMap, map);
    }

    public void doIssueArl(Date thisUpdateDate, Integer alg) {
    }

    private void saveArlData(X509CRL x509CRL, Long caCertId) {
        Map map = this.arlDao.saveArls(caCertId, x509CRL);
        this.arlDataDao.saveArlDatas(x509CRL, map);
    }

    public Date getCrlLastUpdateTime() {
        try {
            return this.crlDao.getCrlLastUpdateTime();
        }
        catch (Exception e) {
            throw new ServiceException("\u83b7\u53d6\u5f53\u524d\u6700\u5927CRL\u6700\u540e\u66f4\u65b0\u65f6\u95f4\u5f02\u5e38", (Throwable)e);
        }
    }

    public Date getDrlLastUpdateTime() {
        try {
            return this.crlDao.getArlLastUpdateTime();
        }
        catch (Exception e) {
            throw new ServiceException("\u83b7\u53d6\u5f53\u524d\u6700\u5927CRL\u6700\u540e\u66f4\u65b0\u65f6\u95f4\u5f02\u5e38", (Throwable)e);
        }
    }

    public Date getCrlLastNextUpdatTimeByCrlTemplateId(Long tempId) {
        try {
            return this.crlDao.getCrlLastNextUpdatTimeByCrlTemplateId(tempId);
        }
        catch (Exception e) {
            throw new ServiceException("\u83b7\u53d6\u5f53\u524d\u6a21\u677f\u6700\u5927CRL\u6700\u540e\u66f4\u65b0\u65f6\u95f4\u5f02\u5e38", (Throwable)e);
        }
    }

    public Date getDrlLastNextUpdatTimeByCrlTemplateId(Long tempId) {
        try {
            return this.crlDao.getDrlLastNextUpdatTimeByCrlTemplateId(tempId);
        }
        catch (Exception e) {
            throw new ServiceException("\u83b7\u53d6\u5f53\u524d\u6a21\u677f\u6700\u5927CRL\u6700\u540e\u66f4\u65b0\u65f6\u95f4\u5f02\u5e38", (Throwable)e);
        }
    }

    public void publishCrl(Long crlTempId, Date thisUpdateTime) {
        Date nextUpdateDate = null;
        HashMap<Integer, ArrayList<CRLEntry>> crlEntryMap = new HashMap<Integer, ArrayList<CRLEntry>>();
        HashMap<Integer, X509CRL> x509CrlMap = new HashMap<Integer, X509CRL>();
        try {
            Long maxSegment;
            CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(Constants.BASE_ALG_TYPE);
            List caCerts = this.caCertDao.getCaCertsByCaId(caInfoVO.getCaId());
            Result result = this.crlTemplateService.getCrlTemplateById(crlTempId);
            if (result == null || !result.isSuccess()) {
                this.logger.error("\u83b7\u53d6crl\u6a21\u677f\u8be6\u60c5\u5931\u8d25,\u539f\u56e0\u4e3a\uff1a{}", (Object)result.getError().desc);
                throw new ServiceException("\u65e0\u6548\u7684crl\u6a21\u677fid:" + crlTempId);
            }
            CrlTemplateExtensionVO crlTemplateExtensionVO = (CrlTemplateExtensionVO)result.getInfo();
            nextUpdateDate = IssueTimeUtil.getNextUpdateDate((Date)thisUpdateTime, (Integer)crlTemplateExtensionVO.getCrlConfig().getCrlPeriod());
            Long fragmentationSize = crlTemplateExtensionVO.getCrlConfig().getCrlMaxCertNumber();
            if (0L == crlTempId) {
                Long maxSn = this.certDao.getMaxSnByTemplateId(crlTempId);
                maxSegment = (maxSn - 0x10000000L) / fragmentationSize;
            } else {
                maxSegment = (long)crlTemplateExtensionVO.getCrlConfig().getCertCount().intValue() / fragmentationSize;
            }
            int i = 0;
            while ((long)i <= maxSegment) {
                List crlList = this.revokeCertDao.queryCrlCertList(Constants.BASE_ALG_TYPE, thisUpdateTime, crlTempId, Integer.valueOf(i));
                ArrayList<CRLEntry> crlEntryList = new ArrayList<CRLEntry>();
                this.copyList(crlList, crlEntryList);
                crlEntryMap.put(i, crlEntryList);
                if (0L == crlTempId) {
                    TemplateDO query = new TemplateDO();
                    query.setCrlTempId(crlTempId);
                    query.setOpenCrl(Boolean.valueOf(true));
                    PageInfo pageInfo = this.templateDao.queryTemplates(query, 1, Integer.MAX_VALUE);
                    List templateList = (List)pageInfo.getDatas();
                    if (!CollectionUtils.isEmpty((Collection)templateList)) {
                        Integer flag = null;
                        for (TemplateDO item : templateList) {
                            flag = item.getId().intValue() * CrlConstants.TRANSLATION_17 + i;
                            List openCrlList = this.revokeCertDao.queryCrlCertList(Constants.BASE_ALG_TYPE, thisUpdateTime, crlTempId, flag);
                            ArrayList<CRLEntry> openCrlEntryList = new ArrayList<CRLEntry>();
                            this.copyList(openCrlList, openCrlEntryList);
                            crlEntryMap.put(flag, openCrlEntryList);
                        }
                    }
                }
                ++i;
            }
            if (CollectionUtils.isEmpty(crlEntryMap)) {
                return;
            }
            List crlExtensionList = crlTemplateExtensionVO.getCrlExtension();
            for (Integer segmentNo : crlEntryMap.keySet()) {
                BigInteger crlSn = this.certSnDao.getCrlMaxSn(new Date());
                String crlUrl = this.crlTemplateService.getCrl(caInfoVO, crlTempId, segmentNo.intValue(), false, crlTemplateExtensionVO.getCrlConfig().getQueryType().intValue());
                String drlUrl = this.crlTemplateService.getDrl(caInfoVO, crlTempId, segmentNo.intValue(), false, crlTemplateExtensionVO.getCrlConfig().getQueryType().intValue());
                List extensions = CrlExtensionUtil.changeExtensionFormat((List)crlExtensionList, (Integer)crlSn.intValue(), (Integer)0, (String)crlUrl, (String)drlUrl, (Boolean)false, (Boolean)false);
                List crlEntryList = (List)crlEntryMap.get(segmentNo);
                X509CRL x509CRL = Constants.CRYPT_DEVICE_TYPE.equals(Constants.CRYPT_DEVICE_BC) ? GMSSLCRLUtils.generateCRLByBC((X509Certificate)caInfoVO.getRootCert(), (PrivateKey)caInfoVO.getRootPrivateKey(), (String)SignAlgTypeEnum.getAlgName((int)Integer.parseInt(caInfoVO.getSignAlg())), null, (Date)thisUpdateTime, (Date)nextUpdateDate, (List)extensions, (List)crlEntryList, (boolean)SignAlgFormatEnum.isBlankSpaceFormat((Integer)Constants.SIGN_ALG_FORMAT_FLAG)) : GMSSLCRLUtils.generateCRLByYunhsm((X509Certificate)caInfoVO.getRootCert(), (int)caInfoVO.getCaPwdBean().getKeyIndex(), (String)caInfoVO.getCaPwdBean().getPrivateKeyPin(), (String)SignAlgTypeEnum.getAlgName((int)Integer.parseInt(caInfoVO.getSignAlg())), null, (Date)thisUpdateTime, (Date)nextUpdateDate, (List)extensions, (List)crlEntryList, (boolean)SignAlgFormatEnum.isBlankSpaceFormat((Integer)Constants.SIGN_ALG_FORMAT_FLAG));
                x509CrlMap.put(segmentNo, x509CRL);
            }
            if (!CollectionUtils.isEmpty(x509CrlMap)) {
                this.saveCrlData(x509CrlMap, caInfoVO.getCertId(), crlTempId);
                if (crlTemplateExtensionVO.getCrlConfig().getDrlPeriod() != null && crlTemplateExtensionVO.getCrlConfig().getDrlPeriod() > 0) {
                    this.deltaRevokeCertDao.deleteBatch(x509CrlMap, Constants.BASE_ALG_TYPE);
                }
                CrlPublishUtil crlPublishUtil = new CrlPublishUtil();
                if (CrlPublishEnum.isHttpCRL((Integer)crlTemplateExtensionVO.getCrlConfig().getQueryType())) {
                    crlPublishUtil.httpPublishCrl(caInfoVO, x509CrlMap, false, crlTempId);
                } else if (CrlPublishEnum.isLDAPCRL((Integer)crlTemplateExtensionVO.getCrlConfig().getQueryType())) {
                    List ldapSignCerts = this.subSystemService.getAllLdapServerCerts();
                    crlPublishUtil.ldapPublishCrl(caInfoVO, x509CrlMap, ldapSignCerts, caCerts, this.ldapsdkOutTime, crlTempId);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException("\u7b7e\u53d1crl\u5931\u8d25", (Throwable)e);
        }
        finally {
            CrlConstants.CRL_THREAD_NEXT_UPDATE_TIME.put("crl" + crlTempId, nextUpdateDate);
        }
    }

    public void publishDrl(Long crlTempId, Date thisUpdateTime) {
        Date nextUpdateDate = null;
        HashMap<Integer, ArrayList<CRLEntry>> crlEntryMap = new HashMap<Integer, ArrayList<CRLEntry>>();
        HashMap<Integer, X509CRL> x509CrlMap = new HashMap<Integer, X509CRL>();
        try {
            Long maxSegment;
            Map crlIdMap = this.crlDao.getLastCrlId(crlTempId);
            CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(Constants.BASE_ALG_TYPE);
            List caCerts = this.caCertDao.getCaCertsByCaId(caInfoVO.getCaId());
            Result result = this.crlTemplateService.getCrlTemplateById(crlTempId);
            if (result == null || !result.isSuccess()) {
                this.logger.error("\u83b7\u53d6crl\u6a21\u677f\u8be6\u60c5\u5931\u8d25,\u539f\u56e0\u4e3a\uff1a{}", (Object)result.getError().desc);
                throw new ServiceException("\u65e0\u6548\u7684crl\u6a21\u677fid:" + crlTempId);
            }
            CrlTemplateExtensionVO crlTemplateExtensionVO = (CrlTemplateExtensionVO)result.getInfo();
            nextUpdateDate = IssueTimeUtil.getNextUpdateDate((Date)thisUpdateTime, (Integer)crlTemplateExtensionVO.getCrlConfig().getDrlPeriod());
            Long fragmentationSize = crlTemplateExtensionVO.getCrlConfig().getCrlMaxCertNumber();
            if (0L == crlTempId) {
                Long maxSn = this.certDao.getMaxSnByTemplateId(crlTempId);
                maxSegment = (maxSn - 0x10000000L) / fragmentationSize;
            } else {
                maxSegment = (long)crlTemplateExtensionVO.getCrlConfig().getCertCount().intValue() / fragmentationSize;
            }
            int i = 0;
            while ((long)i <= maxSegment) {
                List crlList = this.deltaRevokeCertDao.queryDrlCertList(Constants.BASE_ALG_TYPE, thisUpdateTime, crlTempId, i);
                ArrayList<CRLEntry> crlEntryList = new ArrayList<CRLEntry>();
                this.copyList(crlList, crlEntryList);
                crlEntryMap.put(i, crlEntryList);
                if (0L == crlTempId) {
                    TemplateDO query = new TemplateDO();
                    query.setCrlTempId(crlTempId);
                    query.setOpenCrl(Boolean.valueOf(true));
                    PageInfo pageInfo = this.templateDao.queryTemplates(query, 1, Integer.MAX_VALUE);
                    List templateList = (List)pageInfo.getDatas();
                    if (!CollectionUtils.isEmpty((Collection)templateList)) {
                        for (TemplateDO item : templateList) {
                            Integer flag = item.getId().intValue() * CrlConstants.TRANSLATION_17 + i;
                            List openCrlList = this.deltaRevokeCertDao.queryDrlCertList(Constants.BASE_ALG_TYPE, thisUpdateTime, crlTempId, flag.intValue());
                            ArrayList<CRLEntry> openCrlEntryList = new ArrayList<CRLEntry>();
                            this.copyList(openCrlList, openCrlEntryList);
                            crlEntryMap.put(flag, openCrlEntryList);
                        }
                    }
                }
                ++i;
            }
            if (CollectionUtils.isEmpty(crlEntryMap)) {
                this.logger.debug("\u6a21\u677f[{}]\u6ca1\u6709\u9700\u751f\u6210drl\u7684\u4fe1\u606f", (Object)crlTempId);
                return;
            }
            List crlExtensionList = crlTemplateExtensionVO.getCrlExtension();
            for (Integer segmentNo : crlEntryMap.keySet()) {
                BigInteger crlSn = this.certSnDao.getCrlMaxSn(new Date());
                String crlUrl = this.crlTemplateService.getCrl(caInfoVO, crlTempId, segmentNo.intValue(), false, crlTemplateExtensionVO.getCrlConfig().getQueryType().intValue());
                String drlUrl = this.crlTemplateService.getDrl(caInfoVO, crlTempId, segmentNo.intValue(), false, crlTemplateExtensionVO.getCrlConfig().getQueryType().intValue());
                String baseSn = this.crlDao.getLastCrlSn(crlTempId == 0L ? "" : crlTempId + "crl" + segmentNo + ".crl");
                this.logger.debug("\u83b7\u53d6\u5230\u6700\u65b0baseSn\uff1a{}" + baseSn);
                Integer baseSnInt = 0;
                if (!StringUtils.isBlank((CharSequence)baseSn)) {
                    baseSnInt = Integer.parseInt(baseSn, 16);
                }
                List extensions = CrlExtensionUtil.changeExtensionFormat((List)crlExtensionList, (Integer)crlSn.intValue(), (Integer)baseSnInt, (String)crlUrl, (String)drlUrl, (Boolean)false, (Boolean)true);
                List crlEntryList = (List)crlEntryMap.get(segmentNo);
                X509CRL x509CRL = Constants.CRYPT_DEVICE_TYPE.equals(Constants.CRYPT_DEVICE_BC) ? GMSSLCRLUtils.generateCRLByBC((X509Certificate)caInfoVO.getRootCert(), (PrivateKey)caInfoVO.getRootPrivateKey(), (String)SignAlgTypeEnum.getAlgName((int)Integer.parseInt(caInfoVO.getSignAlg())), null, (Date)thisUpdateTime, (Date)nextUpdateDate, (List)extensions, (List)crlEntryList, (boolean)SignAlgFormatEnum.isBlankSpaceFormat((Integer)Constants.SIGN_ALG_FORMAT_FLAG)) : GMSSLCRLUtils.generateCRLByYunhsm((X509Certificate)caInfoVO.getRootCert(), (int)caInfoVO.getCaPwdBean().getKeyIndex(), (String)caInfoVO.getCaPwdBean().getPrivateKeyPin(), (String)SignAlgTypeEnum.getAlgName((int)Integer.parseInt(caInfoVO.getSignAlg())), null, (Date)thisUpdateTime, (Date)nextUpdateDate, (List)extensions, (List)crlEntryList, (boolean)SignAlgFormatEnum.isBlankSpaceFormat((Integer)Constants.SIGN_ALG_FORMAT_FLAG));
                x509CrlMap.put(segmentNo, x509CRL);
            }
            if (!CollectionUtils.isEmpty(x509CrlMap)) {
                this.saveDrlData(x509CrlMap, caInfoVO.getCertId(), crlIdMap, crlTempId);
                CrlPublishUtil crlPublishUtil = new CrlPublishUtil();
                if (CrlPublishEnum.isHttpCRL((Integer)crlTemplateExtensionVO.getCrlConfig().getQueryType())) {
                    crlPublishUtil.httpPublishCrl(caInfoVO, x509CrlMap, true, crlTempId);
                } else if (CrlPublishEnum.isLDAPCRL((Integer)crlTemplateExtensionVO.getCrlConfig().getQueryType())) {
                    List ldapSignCerts = this.subSystemService.getAllLdapServerCerts();
                    crlPublishUtil.ldapPublishCrl(caInfoVO, x509CrlMap, ldapSignCerts, caCerts, this.ldapsdkOutTime, crlTempId);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException("\u7b7e\u53d1drl\u5931\u8d25", (Throwable)e);
        }
        finally {
            CrlConstants.CRL_THREAD_NEXT_UPDATE_TIME.put("drl" + crlTempId, nextUpdateDate);
        }
    }

    public void publishArl(Long crlTempId, Date thisUpdateTime) {
        CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(Constants.BASE_ALG_TYPE);
        List caCerts = this.caCertDao.getCaCertsByCaId(caInfoVO.getCaId());
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        try {
            Result result = this.crlTemplateService.getCrlTemplateById(crlTempId);
            if (result == null || !result.isSuccess()) {
                this.logger.error("\u83b7\u53d6crl\u6a21\u677f\u8be6\u60c5\u5931\u8d25,\u539f\u56e0\u4e3a\uff1a{}", (Object)result.getError().desc);
                throw new ServiceException("\u65e0\u6548\u7684crl\u6a21\u677fid:" + crlTempId);
            }
            CrlTemplateExtensionVO crlTemplateExtensionVO = (CrlTemplateExtensionVO)result.getInfo();
            Date nextUpdateDate = IssueTimeUtil.getNextUpdateDate((Date)thisUpdateTime, (Integer)crlTemplateExtensionVO.getCrlConfig().getCrlPeriod());
            String arlUrl = this.crlTemplateService.getCrl(caInfoVO, crlTempId, 0, true, crlTemplateExtensionVO.getCrlConfig().getQueryType().intValue());
            Extension extension = GMSSLExtensionUtils.genARLExtension((String)arlUrl);
            extensions.add(extension);
            List crlList = this.revokeCertDao.getSnsForArl(Constants.BASE_ALG_TYPE, thisUpdateTime);
            ArrayList<CRLEntry> crlEntryList = new ArrayList<CRLEntry>();
            this.copyList(crlList, crlEntryList);
            BigInteger crlSn = this.certSnDao.getCrlMaxSn(new Date());
            X509CRL x509CRL = Constants.CRYPT_DEVICE_TYPE.equals(Constants.CRYPT_DEVICE_BC) ? GMSSLCRLUtils.generateCRLByBC((X509Certificate)caInfoVO.getRootCert(), (PrivateKey)caInfoVO.getRootPrivateKey(), (String)SignAlgTypeEnum.getAlgName((int)Integer.parseInt(caInfoVO.getSignAlg())), (BigInteger)crlSn, (Date)thisUpdateTime, (Date)nextUpdateDate, extensions, crlEntryList, (boolean)SignAlgFormatEnum.isBlankSpaceFormat((Integer)Constants.SIGN_ALG_FORMAT_FLAG)) : GMSSLCRLUtils.generateCRLByYunhsm((X509Certificate)caInfoVO.getRootCert(), (int)caInfoVO.getCaPwdBean().getKeyIndex(), (String)caInfoVO.getCaPwdBean().getPrivateKeyPin(), (String)SignAlgTypeEnum.getAlgName((int)Integer.parseInt(caInfoVO.getSignAlg())), (BigInteger)crlSn, (Date)thisUpdateTime, (Date)nextUpdateDate, extensions, crlEntryList, (boolean)SignAlgFormatEnum.isBlankSpaceFormat((Integer)Constants.SIGN_ALG_FORMAT_FLAG));
            this.saveArlData(x509CRL, caInfoVO.getCertId());
            ArlPublishUtil arlPublishUtil = new ArlPublishUtil();
            if (CrlPublishEnum.isHttpCRL((Integer)crlTemplateExtensionVO.getCrlConfig().getQueryType())) {
                arlPublishUtil.httpPublishCrl(caInfoVO.getDirServerConfigBean().getLocalURL(), x509CRL);
            }
            if (CrlPublishEnum.isLDAPCRL((Integer)crlTemplateExtensionVO.getCrlConfig().getQueryType())) {
                List ldapSignCerts = this.subSystemService.getAllLdapServerCerts();
                arlPublishUtil.ldapPublishArl(caInfoVO, x509CRL, ldapSignCerts, caCerts, this.ldapsdkOutTime);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException("\u7b7e\u53d1arl\u5931\u8d25", (Throwable)e);
        }
    }
}

