/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certcrl.service.util;

import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.configBasic.bean.DirServerConfigBean;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.ldap.sdk.ca.LDAPCASDK;
import com.xdja.pki.ldap.sdk.ca.LDAPResponse;
import com.xdja.pki.ldap.sdk.ca.LDAPUrlUtils;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.naming.InvalidNameException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArlPublishUtil {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public String ldapPublishArlUrl(CaInfoVO caInfoVO) throws InvalidNameException {
        DirServerConfigBean dirServerConfigBean = caInfoVO.getDirServerConfigBean();
        if (null != dirServerConfigBean && StringUtils.isNotBlank((CharSequence)dirServerConfigBean.getMasterURL())) {
            return LDAPUrlUtils.genCertArlLdapUri((String)dirServerConfigBean.getSlaveURL(), (String)caInfoVO.getSubject(), (int)0, (String)caInfoVO.getBaseDn());
        }
        return "";
    }

    public void httpPublishCrl(String localURL, X509CRL x509CrlMap) {
        this.logger.debug("\u5f00\u59cb\u8fdb\u884cARL\u6587\u4ef6\u672c\u5730\u4fdd\u5b58,\u4fdd\u5b58\u76ee\u5f55\uff1a" + localURL);
        if (StringUtils.isNotBlank((CharSequence)localURL)) {
            CertUtil.writeObjToFile((Object)x509CrlMap, (String)(localURL + "/" + "arl" + "0.crl"));
        }
        this.logger.debug("ARL\u6587\u4ef6\u672c\u5730\u4fdd\u5b58\u7ed3\u675f");
    }

    public void ldapPublishArl(CaInfoVO caInfoVO, X509CRL x509Crl, List<X509Certificate> ldapSignCerts, List<X509Certificate> caCerts, int ldapsdkOutTime) {
        if (null != caInfoVO.getDirServerConfigBean() && StringUtils.isNotBlank((CharSequence)caInfoVO.getDirServerConfigBean().getMasterURL())) {
            this.logger.info("\u5f00\u59cb\u5411LDAP\u670d\u52a1\u5668\u53d1\u5e03ARL\u5217\u8868");
            LDAPCASDK ldapServer = Constants.CRYPT_DEVICE_TYPE.equals(Constants.CRYPT_DEVICE_BC) ? new LDAPCASDK(caCerts, caInfoVO.getKeyPair(), caInfoVO.getDirServerConfigBean().getMasterURL(), null, ldapSignCerts, null) : new LDAPCASDK(caCerts, caInfoVO.getCaPwdBean().getKeyIndex().intValue(), caInfoVO.getCaPwdBean().getPrivateKeyPin(), SdfCryptoType.YUNHSM, caInfoVO.getDirServerConfigBean().getMasterURL(), null, ldapSignCerts, null);
            ldapServer.setTime(ldapsdkOutTime);
            LDAPResponse ldapResponse = ldapServer.sendCRL(0, x509Crl);
            this.logger.info("\u5411LDAP\u670d\u52a1\u5668\u53d1\u5e03ARL\u5217\u8868\u7ed3\u675f\uff0c\u8fd4\u56dereason\uff1a" + ldapResponse.getReason());
        }
    }
}

