/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certcrl.service.util;

import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.configBasic.bean.DirServerConfigBean;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.ldap.sdk.ca.LDAPCASDK;
import com.xdja.pki.ldap.sdk.ca.LDAPResponse;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrlPublishUtil {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Deprecated
    public void httpPublishCrl(DirServerConfigBean dirServerConfigBean, Map<Integer, X509CRL> x509CrlMap, boolean isDrl) {
        String crlLocalDirectory = dirServerConfigBean.getExtranetHttpURL();
        this.logger.debug("\u5f00\u59cb\u8fdb\u884cCRL\u6587\u4ef6\u672c\u5730\u4fdd\u5b58,\u4fdd\u5b58\u76ee\u5f55\uff1a" + crlLocalDirectory);
        if (StringUtils.isNotBlank((CharSequence)crlLocalDirectory)) {
            String prifx = isDrl ? "drl" : "crl";
            for (Integer i : x509CrlMap.keySet()) {
                CertUtil.writeObjToFile((Object)x509CrlMap.get(i), (String)(crlLocalDirectory + "/" + prifx + i + ".crl"));
            }
        }
        this.logger.debug("CRL\u6587\u4ef6\u672c\u5730\u4fdd\u5b58\u7ed3\u675f");
    }

    public void httpPublishCrl(CaInfoVO caInfoVO, Map<Integer, X509CRL> x509CrlMap, boolean isDrl, Long crlTempId) {
        if (caInfoVO.getDirServerConfigBean() == null || StringUtils.isBlank((CharSequence)caInfoVO.getDirServerConfigBean().getLocalURL())) {
            this.logger.error("local url \u914d\u7f6e\u4e3a\u7a7a\uff0c\u4e0d\u53d1\u5e03httpCrl");
            return;
        }
        String crlLocalDirectory = caInfoVO.getDirServerConfigBean().getLocalURL();
        this.logger.debug("\u5f00\u59cb\u8fdb\u884cCRL\u6587\u4ef6\u672c\u5730\u4fdd\u5b58,\u4fdd\u5b58\u76ee\u5f55\uff1a" + crlLocalDirectory);
        if (StringUtils.isNotBlank((CharSequence)crlLocalDirectory)) {
            String prifx = isDrl ? "drl" : "crl";
            for (Integer i : x509CrlMap.keySet()) {
                CertUtil.writeObjToFile((Object)x509CrlMap.get(i), (String)(crlLocalDirectory + "/" + (crlTempId == 0L ? "" : crlTempId) + prifx + i + ".crl"));
            }
        }
        this.logger.debug("CRL\u6587\u4ef6\u672c\u5730\u4fdd\u5b58\u7ed3\u675f");
    }

    public void ldapPublishCrl(CaInfoVO caInfoVO, Map<Integer, X509CRL> x509CrlMap, List<X509Certificate> ldapSignCerts, List<X509Certificate> caCerts, int ldapsdkOutTime, Long crlTempId) {
        if (null != caInfoVO.getDirServerConfigBean() && StringUtils.isNotBlank((CharSequence)caInfoVO.getDirServerConfigBean().getMasterURL())) {
            this.logger.info("\u5f00\u59cb\u5411LDAP\u670d\u52a1\u5668\u53d1\u5e03crl\u5217\u8868");
            LDAPCASDK ldapServer = Constants.CRYPT_DEVICE_TYPE.equals(Constants.CRYPT_DEVICE_BC) ? new LDAPCASDK(caCerts, caInfoVO.getKeyPair(), caInfoVO.getDirServerConfigBean().getMasterURL(), null, ldapSignCerts, null) : new LDAPCASDK(caCerts, caInfoVO.getCaPwdBean().getKeyIndex().intValue(), caInfoVO.getCaPwdBean().getPrivateKeyPin(), SdfCryptoType.YUNHSM, caInfoVO.getDirServerConfigBean().getMasterURL(), null, ldapSignCerts, null);
            ldapServer.setTime(ldapsdkOutTime);
            for (Integer integer : x509CrlMap.keySet()) {
                LDAPResponse ldapResponse = ldapServer.sendCRL(crlTempId.intValue(), integer.intValue(), x509CrlMap.get(integer));
                this.logger.debug("\u5411LDAP\u670d\u52a1\u5668\u53d1\u5e03\u5206\u7247\u53f7\u4e3a" + integer + "\u7684crl\u7ed3\u675f\uff0c\u8fd4\u56dereason:" + ldapResponse.getReason());
            }
            this.logger.info("\u5411LDAP\u670d\u52a1\u5668\u53d1\u5e03DRL\u5217\u8868\u7ed3\u675f");
        }
    }
}

