/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.crl.util;

import com.xdja.pki.ca.certcrl.service.impl.CrlService;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.common.ConfigUtil;
import com.xdja.pki.ca.core.configBasic.bean.CrlConfigBean;
import com.xdja.pki.ca.core.configBasic.bean.LdapConfigBean;
import com.xdja.pki.ca.core.enums.CrlPublishEnum;
import com.xdja.pki.ca.core.util.SpringBeanUtil;
import com.xdja.pki.ca.core.util.time.DateTimeUtil;
import com.xdja.pki.ca.core.util.time.IssueTimeUtil;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import com.xdja.pki.ca.task.CrlPublish;
import com.xdja.pki.ca.task.DrlPublish;
import java.security.Provider;
import java.security.Security;
import java.util.Date;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

@Configuration
@Order(value=2)
public class CrlThreadUtil
implements CommandLineRunner {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static boolean flag = true;
    @Autowired
    private Environment environment;

    public void run(String ... args) throws Exception {
        try {
            CaInfoVO caInfoVO = null;
            if (ConfigUtil.verifySystemInitIsOK((Environment)this.environment) && flag || Constants.IS_CRL_AGAIN_FIRST) {
                while (true) {
                    Object obj;
                    if (null != (obj = Constants.CA_INFO.get(Constants.BASE_ALG_TYPE))) {
                        caInfoVO = (CaInfoVO)obj;
                        flag = false;
                        break;
                    }
                    Thread.sleep(30000L);
                }
            }
            this.logger.debug("CRL\u7ebf\u7a0b\u6c60\u4e2d\u7684\u7ebf\u7a0b\u6570\u91cf;" + Constants.CRL_THREAD_POOL_EXECUTOR.getPoolSize());
            Constants.CRL_THREAD_POOL_EXECUTOR.shutdownNow();
            boolean isDone = false;
            do {
                isDone = Constants.CRL_THREAD_POOL_EXECUTOR.awaitTermination(1L, TimeUnit.SECONDS);
                this.logger.debug("CRL\u7ebf\u7a0b\u6c60\u5173\u95ed\u7ed3\u679c\uff1a" + isDone);
            } while (!isDone);
            this.logger.debug("CRL\u7ebf\u7a0b\u6c60\u4e2d\u7684\u7ebf\u7a0b\u6570\u91cf;" + Constants.CRL_THREAD_POOL_EXECUTOR.getPoolSize());
            Constants.CRL_THREAD_POOL_EXECUTOR = new ScheduledThreadPoolExecutor(2);
            Long nowTime = System.currentTimeMillis();
            CrlService crlService = (CrlService)SpringBeanUtil.getBean(CrlService.class);
            if (this.checkIsSignCrl(caInfoVO)) {
                Date updateTime;
                if (null != caInfoVO.getCrlConfig()) {
                    updateTime = crlService.getCrlLastUpdateTime();
                    if (null == updateTime || Constants.IS_CRL_AGAIN_FIRST) {
                        updateTime = DateTimeUtil.longToDate((long)nowTime);
                    } else {
                        Integer releaseCycle = caInfoVO.getCrlConfig().getReleaseCycle();
                        updateTime = IssueTimeUtil.computeCrlPublishTime((Date)updateTime, (Long)nowTime, (Integer)releaseCycle);
                    }
                    try {
                        long sleepTime = updateTime.getTime() - System.currentTimeMillis();
                        sleepTime = sleepTime > 0L ? sleepTime : 0L;
                        Constants.NEXT_CRL_UPDATE_TIME = updateTime;
                        CrlPublish crlPublish = new CrlPublish();
                        Constants.CRL_THREAD_POOL_EXECUTOR.scheduleAtFixedRate(crlPublish, sleepTime / 1000L, caInfoVO.getCrlConfig().getReleaseCycle() * 60, TimeUnit.SECONDS);
                        this.logger.info("\u542f\u52a8\u53d1\u5e03CRL\u53d1\u5e03\u7ebf\u7a0b\u6210\u529f");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    this.logger.debug("\u7cfb\u7edf\u6ca1\u6709\u5b8c\u6210\u521d\u59cb\u5316\u6216\u672a\u914d\u7f6eCRL\uff0c\u4e0d\u8fdb\u884cCRL\u53d1\u5e03");
                }
                if (this.checkIsSignDrl(caInfoVO)) {
                    if (null != caInfoVO.getCrlConfig() && caInfoVO.getCrlConfig().isDelta()) {
                        updateTime = crlService.getDrlLastUpdateTime();
                        Integer releaseCycle = caInfoVO.getCrlConfig().getDeltaCrlCycle();
                        updateTime = null == updateTime || Constants.IS_DRL_AGAIN_FIRST ? DateTimeUtil.longToDate((long)(nowTime + (long)(releaseCycle * 60 * 1000))) : IssueTimeUtil.computeCrlPublishTime((Date)updateTime, (Long)nowTime, (Integer)releaseCycle);
                        try {
                            long sleepTime = updateTime.getTime() - System.currentTimeMillis();
                            sleepTime = sleepTime > 0L ? sleepTime : 0L;
                            Constants.NEXT_DRL_UPDATE_TIME = updateTime;
                            DrlPublish drlPublish = new DrlPublish();
                            Constants.CRL_THREAD_POOL_EXECUTOR.scheduleAtFixedRate(drlPublish, sleepTime / 1000L, caInfoVO.getCrlConfig().getDeltaCrlCycle() * 60, TimeUnit.SECONDS);
                            this.logger.info("\u542f\u52a8\u53d1\u5e03DRL\u53d1\u5e03\u7ebf\u7a0b\u6210\u529f");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        this.logger.debug("\u7cfb\u7edf\u6ca1\u6709\u5b8c\u6210\u521d\u59cb\u5316\u6216\u672a\u914d\u7f6eDRL\uff0c\u4e0d\u8fdb\u884cDRL\u53d1\u5e03");
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("CRL\u7ebf\u7a0b\u6c60\u6ca1\u6709\u542f\u52a8\u6210\u529f");
            Thread.sleep(30000L);
            this.logger.info("CRL\u7ebf\u7a0b\u6c6030s\u540e\u91cd\u65b0\u542f\u52a8");
            this.run(new String[0]);
        }
    }

    public boolean checkIsSignCrl(CaInfoVO caInfoVO) throws Exception {
        boolean crlFlag;
        boolean bl = crlFlag = ConfigUtil.verifySystemInitIsOK((Environment)this.environment) && null != caInfoVO && null != caInfoVO.getCrlConfig() && null != caInfoVO.getCrlConfig().getReleaseCycle() && null != caInfoVO.getCrlConfig().getCertCounts();
        if (crlFlag) {
            return this.checkCrlPublish(caInfoVO);
        }
        return false;
    }

    public boolean checkCrlPublish(CaInfoVO caInfoVO) throws Exception {
        boolean crlFlag = CrlPublishEnum.isSignCRL((Integer)caInfoVO.getCrlConfig().getCrlPublish());
        if (!crlFlag) {
            return this.compatibleOldVerison(caInfoVO);
        }
        return true;
    }

    public boolean compatibleOldVerison(CaInfoVO caInfoVO) throws Exception {
        LdapConfigBean ldapConfigBean = caInfoVO.getLdapConfig();
        if (null != ldapConfigBean && StringUtils.isNotBlank((CharSequence)ldapConfigBean.getSlaveURL()) && StringUtils.isNotBlank((CharSequence)ldapConfigBean.getMasterURL())) {
            CrlConfigBean crlConfigBean = caInfoVO.getCrlConfig();
            crlConfigBean.setCrlPublish(CrlConfigBean.LDAP_PUBLISH);
            ConfigUtil.saveCrlConfig((Environment)this.environment, (CrlConfigBean)crlConfigBean);
            return true;
        }
        return false;
    }

    public boolean checkIsSignDrl(CaInfoVO caInfoVO) throws Exception {
        boolean crlFlag;
        boolean bl = crlFlag = ConfigUtil.verifySystemInitIsOK((Environment)this.environment) && null != caInfoVO && null != caInfoVO.getCrlConfig() && caInfoVO.getCrlConfig().isDelta() && null != caInfoVO.getCrlConfig().getDeltaCrlCycle();
        if (crlFlag) {
            return this.checkCrlPublish(caInfoVO);
        }
        this.logger.debug("\u68c0\u6d4b\u5230\u9700\u8981\u53d1\u5e03drl");
        return false;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

