/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.task;

import com.xdja.pki.ca.certmanager.service.task.CertConfirmService;
import com.xdja.pki.ca.certmanager.service.task.ICertArchiveService;
import com.xdja.pki.ca.certmanager.service.task.ICertPublishService;
import com.xdja.pki.ca.certmanager.service.task.ICertStatusSyncService;
import com.xdja.pki.ca.certmanager.service.task.IPubKeyRevokedNotifyService;
import com.xdja.pki.ca.core.exception.ServiceException;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class Task {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private CertConfirmService certConfirmService;
    @Autowired
    private ICertArchiveService certArchiveService;
    @Autowired
    private ICertStatusSyncService certStatusSyncService;
    @Autowired
    private ICertPublishService certPublishService;
    @Autowired
    private IPubKeyRevokedNotifyService pubKeyRevokedNotifyService;

    @Scheduled(cron="${task.cert.confirm.cron}")
    public void certStatusConfirm() {
        try {
            this.certConfirmService.doExecute();
        }
        catch (ServiceException e) {
            this.logger.error("\u8bc1\u4e66\u786e\u8ba4\u8c03\u5ea6\u4e1a\u52a1\u6267\u884c\u5931\u8d25", (Throwable)e);
        }
    }

    @Scheduled(cron="${task.cert.publish.cron}")
    public void certPublish() {
        this.logger.debug("\u8bc1\u4e66\u53d1\u5e03==========");
        System.out.println("\u8bc1\u4e66\u53d1\u5e03\u7ebf\u7a0b\u540d\u79f0\uff1a" + Thread.currentThread().getName());
        try {
            this.certPublishService.pushCertPublishSync();
        }
        catch (ServiceException e) {
            this.logger.error("Task\u8bc1\u4e66\u53d1\u5e03\u8c03\u5ea6\u4e1a\u52a1\u6267\u884c\u5931\u8d25", (Throwable)e);
        }
    }

    @Scheduled(cron="${task.cert.status.update.cron}")
    public void certStatusUpdate() {
        this.logger.debug("\u8bc1\u4e66\u72b6\u6001\u66f4\u65b0==========");
        try {
            this.certStatusSyncService.execCertStatSync();
        }
        catch (ServiceException e) {
            this.logger.error("Task\u8bc1\u4e66\u72b6\u6001\u66f4\u65b0\u8c03\u5ea6\u4efb\u52a1\u5931\u8d25\uff0c", (Throwable)e);
        }
    }

    @Scheduled(cron="${task.key.revoke.notify.cron}")
    public void keyRevokeNotify() {
        this.logger.debug("\u5bc6\u94a5\u64a4\u9500\u901a\u77e5==========");
        this.pubKeyRevokedNotifyService.execPubKeyRevokeNotify();
    }

    @Scheduled(cron="${task.expired.cert.archive.cron}")
    public void expiredCertArchive() {
        this.logger.debug("\u8fc7\u671f\u8bc1\u4e66\u5f52\u6863==========");
        try {
            this.certArchiveService.saveExpireCertArchive();
            this.certArchiveService.saveExpireManageCertArchive();
        }
        catch (ServiceException e) {
            this.logger.error("Task\u8fc7\u671f\u8bc1\u4e66\u5f52\u6863\u5931\u8d25\uff0c", (Throwable)e);
        }
    }
}

