/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.cams;

import com.xdja.pki.cams.core.ConfigureBean;
import com.xdja.pki.cams.core.Result;
import com.xdja.pki.cams.httpClient.ApacheClientHttpUtils;
import com.xdja.pki.cams.httpClient.params.BaseDnParams;
import com.xdja.pki.cams.httpClient.params.IssueCertHttpParams;
import com.xdja.pki.cams.httpClient.params.QueryCertHttpParams;
import com.xdja.pki.cams.httpClient.params.RegisterUserHttpParams;
import com.xdja.pki.cams.httpClient.params.RevokeCertHttpParams;
import com.xdja.pki.cams.request.IssueCertReq;
import com.xdja.pki.cams.request.QueryCertReq;
import com.xdja.pki.cams.request.RegisterUserReq;
import com.xdja.pki.cams.request.RevokeCertReq;
import com.xdja.pki.cams.response.IssueCertResp;
import com.xdja.pki.cams.response.QueryCertResp;
import com.xdja.pki.cams.response.RegisterUserResp;
import com.xdja.pki.cams.util.CertUtils;
import com.xdja.pki.cams.util.SdkJsonUtils;
import java.io.File;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkService {
    private static final Logger logger = LoggerFactory.getLogger(SdkService.class);
    private ConfigureBean sdkConfigBean;

    public SdkService(String ip, String port, String deviceCertPath, String deviceCertPwd) {
        File file = new File(deviceCertPath);
        if (!file.exists()) {
            throw new RuntimeException("\u8bc1\u4e66\u94fe\u4e0d\u5b58\u5728");
        }
        this.sdkConfigBean = new ConfigureBean(ip, port, deviceCertPath, deviceCertPwd);
        this.initPkcs12(this.sdkConfigBean);
    }

    public SdkService(String ip, String port, String deviceCertPath, String deviceCertPwd, boolean isHttps, boolean isGmssl) {
        File file = new File(deviceCertPath);
        if (!file.exists()) {
            throw new RuntimeException("\u8bc1\u4e66\u94fe\u4e0d\u5b58\u5728");
        }
        this.sdkConfigBean = new ConfigureBean(ip, port, deviceCertPath, deviceCertPwd, isHttps, isGmssl);
        this.initPkcs12(this.sdkConfigBean);
    }

    private void initPkcs12(ConfigureBean sdkConfigBean) {
        X509Certificate signCert = CertUtils.getCertFromP12File(sdkConfigBean.getSignCertFilePath(), sdkConfigBean.getSignCertFilePwd());
        sdkConfigBean.setSignCert(signCert);
        PrivateKey privateKey = CertUtils.getPrivateKeyByP12File(sdkConfigBean.getSignCertFilePath(), sdkConfigBean.getSignCertFilePwd());
        sdkConfigBean.setPrivateKey(privateKey);
        int algType = CertUtils.getCertKeyAlg(CertUtils.getPublicKeyByX509Cert(signCert));
        sdkConfigBean.setAlgType(algType);
        sdkConfigBean.setSignCertSn(signCert.getSerialNumber().toString(16));
    }

    public Result getCaBaseDn() {
        return ApacheClientHttpUtils.exeHttpsRequest(new BaseDnParams(this.sdkConfigBean));
    }

    public Result registerUser(RegisterUserReq registerUserReq) {
        logger.debug("registerUser---------:{}", (Object)registerUserReq);
        Result result = ApacheClientHttpUtils.exeHttpsRequest(new RegisterUserHttpParams(this.sdkConfigBean, registerUserReq));
        if (result.isSuccess()) {
            RegisterUserResp resp = SdkJsonUtils.json2Object(result.getInfo().toString(), RegisterUserResp.class);
            result.setInfo(resp);
        }
        return result;
    }

    public Result issueCert(IssueCertReq issueCertReq) {
        logger.debug("issueCert---------:{}", (Object)issueCertReq);
        Result result = ApacheClientHttpUtils.exeHttpsRequest(new IssueCertHttpParams(this.sdkConfigBean, issueCertReq));
        if (result.isSuccess()) {
            IssueCertResp resp = SdkJsonUtils.json2Object(result.getInfo().toString(), IssueCertResp.class);
            result.setInfo(resp);
        }
        return result;
    }

    public Result queryCert(QueryCertReq queryCertReq) {
        logger.debug("queryCert---------:{}", (Object)queryCertReq);
        Result result = ApacheClientHttpUtils.exeHttpsRequest(new QueryCertHttpParams(this.sdkConfigBean, queryCertReq));
        if (result.isSuccess()) {
            QueryCertResp resp = SdkJsonUtils.json2Object(result.getInfo().toString(), QueryCertResp.class);
            result.setInfo(resp);
        }
        return result;
    }

    public Result revokeCert(RevokeCertReq revokeCertReq) {
        logger.debug("revokeCert---------:{}", (Object)revokeCertReq);
        Result result = ApacheClientHttpUtils.exeHttpsRequest(new RevokeCertHttpParams(this.sdkConfigBean, revokeCertReq));
        return result;
    }
}

