/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.cams.httpClient;

import com.xdja.pki.cams.core.ErrorBean;
import com.xdja.pki.cams.core.ErrorEnum;
import com.xdja.pki.cams.core.Result;
import com.xdja.pki.cams.exception.SdkException;
import com.xdja.pki.cams.httpClient.HttpParams;
import com.xdja.pki.cams.util.SdkJsonUtils;
import com.xdja.pki.gmssl.GMSSLContext;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheClientHttpUtils {
    private static final int HTTP_OK = 200;
    private static final String HTTP_POST = "post";
    private static final String HTTP_GET = "get";
    private static final Logger logger = LoggerFactory.getLogger(ApacheClientHttpUtils.class);
    private static CloseableHttpClient client = null;
    private static HttpClientContext context = HttpClientContext.adapt((HttpContext)new BasicHttpContext());

    private static HttpUriRequest createHttpUriRequest(HttpParams httpParams) throws URISyntaxException {
        URIBuilder uri;
        HttpPost httpUriRequest = null;
        try {
            uri = httpParams.enableHttps() ? new URIBuilder("https://" + httpParams.getUrl()) : new URIBuilder("http://" + httpParams.getUrl());
        }
        catch (URISyntaxException e) {
            logger.error("createHttpUriRequest------\u5f02\u5e38", (Throwable)e);
            throw new SdkException("createHttpUriRequest------\u5f02\u5e38:" + e.getMessage());
        }
        if (HTTP_POST.equalsIgnoreCase(httpParams.httpMethod())) {
            httpUriRequest = new HttpPost(uri.build());
            ByteArrayEntity bodyEntity = new ByteArrayEntity(httpParams.body().getBytes());
            httpUriRequest.setEntity((HttpEntity)bodyEntity);
        } else if (HTTP_GET.equalsIgnoreCase(httpParams.httpMethod())) {
            if (null != httpParams.pathVariables() && httpParams.pathVariables().size() != 0) {
                LinkedList<BasicNameValuePair> list = new LinkedList<BasicNameValuePair>();
                for (Map.Entry<String, String> entry : httpParams.pathVariables().entrySet()) {
                    BasicNameValuePair param = new BasicNameValuePair(entry.getKey(), entry.getValue());
                    list.add(param);
                }
                uri.setParameters(list);
            }
            httpUriRequest = new HttpGet(uri.build());
            RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(6000).setSocketTimeout(20000).setConnectTimeout(6000).build();
            ((HttpGet)httpUriRequest).setConfig(config);
        } else {
            throw new SdkException("\u4e0d\u652f\u6301\u7684\u53c2\u6570\u7c7b\u578b----httpParams.httpMethod():" + httpParams.httpMethod());
        }
        return httpUriRequest;
    }

    private static void putHttpHeader(HttpUriRequest httpUriRequest, HttpParams httpParams) {
        Map<String, Object> header = httpParams.headers();
        for (Map.Entry<String, Object> entry : header.entrySet()) {
            httpUriRequest.addHeader(entry.getKey(), entry.getValue().toString());
        }
    }

    private static Result parseSuccessBean(byte[] responseBody) {
        Result sdkResult = new Result();
        if (null != responseBody && responseBody.length != 0) {
            try {
                byte[] resp = Base64.decode((byte[])responseBody);
                sdkResult.setInfo(resp);
            }
            catch (Exception e) {
                sdkResult.setInfo(new String(responseBody));
            }
        } else {
            sdkResult.setInfo(null);
        }
        return sdkResult;
    }

    private static Result parseErrorBean(byte[] responseBody) {
        try {
            Result sdkResult = new Result();
            ErrorBean errorBean = SdkJsonUtils.json2Object(new String(responseBody), ErrorBean.class);
            logger.debug("POST\u8bf7\u6c42====== errorCode:" + errorBean.getErrorCode() + " ====== errorMsg:" + errorBean.getErrorMsg());
            sdkResult.setErrorBean(errorBean);
            return sdkResult;
        }
        catch (Exception e) {
            Result sdkResult = new Result();
            logger.error("\u89e3\u6790\u54cd\u5e94\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            sdkResult.setErrorBean(new ErrorBean(ErrorEnum.SERVER_INNER_EXCEPTION.code, ErrorEnum.SERVER_INNER_EXCEPTION.errMsg));
            return sdkResult;
        }
    }

    public static Result exeHttpsRequest(HttpParams httpParams) {
        Result sdkResult = new Result();
        try {
            ApacheClientHttpUtils.initHttpClient(httpParams.enableHttps(), httpParams.enableGMSSL());
            HttpUriRequest httpUriRequest = ApacheClientHttpUtils.createHttpUriRequest(httpParams);
            ApacheClientHttpUtils.putHttpHeader(httpUriRequest, httpParams);
            CloseableHttpResponse response = client.execute(httpUriRequest, (HttpContext)context);
            int statusCode = response.getStatusLine().getStatusCode();
            logger.debug("========== \u6267\u884c\u8c03\u7528\u8fdc\u7a0b\u72b6\u6001\u7801\u3010" + statusCode + "\u3011");
            HttpEntity entity = response.getEntity();
            byte[] responseBody = null;
            if (entity != null) {
                responseBody = EntityUtils.toByteArray((HttpEntity)entity);
            }
            sdkResult = statusCode != 200 ? ApacheClientHttpUtils.parseErrorBean(responseBody) : ApacheClientHttpUtils.parseSuccessBean(responseBody);
            EntityUtils.consume((HttpEntity)entity);
            response.close();
        }
        catch (Exception e) {
            logger.error("exeHttpsRequest ----- \u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
        return sdkResult;
    }

    private static void initHttpClient(boolean isHttps, boolean enableGMSSL) {
        if (client == null) {
            Registry socketFactoryRegistry;
            if (isHttps) {
                SSLContext sslcontext = ApacheClientHttpUtils.createSSLContext(enableGMSSL);
                socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)new SSLConnectionSocketFactory(sslcontext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER)).build();
            } else {
                socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
            }
            PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            connManager.setMaxTotal(500);
            connManager.setDefaultMaxPerRoute(500);
            DefaultConnectionKeepAliveStrategy myStrategy = new DefaultConnectionKeepAliveStrategy(){

                public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                    long keepAlive = super.getKeepAliveDuration(response, context);
                    if (keepAlive == -1L) {
                        keepAlive = 60000L;
                    }
                    return keepAlive;
                }
            };
            client = HttpClients.custom().setKeepAliveStrategy((ConnectionKeepAliveStrategy)myStrategy).setConnectionManager((HttpClientConnectionManager)connManager).build();
            context = HttpClientContext.create();
        }
    }

    private static SSLContext createSSLContext(boolean enableGMSSL) {
        SSLContext sslContext;
        logger.debug("createSSLContext--------enableGMSSL:" + enableGMSSL);
        if (enableGMSSL) {
            try {
                sslContext = GMSSLContext.getClientInstance((String)"GMSSLv1.1").getSslContext();
            }
            catch (GMSSLContext.GMSSLException e) {
                logger.error("createSSLContext--------getClientInstance(GMSSLv1.1)", (Throwable)e);
                throw new SdkException(e.toString());
            }
        }
        try {
            sslContext = GMSSLContext.getClientInstance((String)"TLSv1.2").getSslContext();
        }
        catch (GMSSLContext.GMSSLException e) {
            logger.error("createSSLContext--------getClientInstance(TLSv1.2)", (Throwable)e);
            throw new SdkException(e.toString());
        }
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        try {
            sslContext.init(null, new TrustManager[]{trustManager}, null);
        }
        catch (KeyManagementException e) {
            logger.error("createSSLContext--------sslContext.init", (Throwable)e);
            throw new SdkException(e.toString());
        }
        return sslContext;
    }
}

