/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.cams.httpClient;

import com.xdja.pki.cams.core.ConfigureBean;
import com.xdja.pki.cams.httpClient.HttpParams;
import com.xdja.pki.cams.util.CertUtils;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.util.encoders.Base64;

public abstract class DefaultHttpParams
implements HttpParams {
    private final Map<String, Object> header = new HashMap<String, Object>();
    protected ConfigureBean configureBean;

    public DefaultHttpParams(ConfigureBean configureBean) {
        this.configureBean = configureBean;
        Long timestamp = System.currentTimeMillis();
        this.header.put("Content-Type", "application/json");
        this.header.put("sn", configureBean.getSignCertSn());
        this.header.put("timestamp", timestamp);
        String signData = Base64.toBase64String((byte[])(configureBean.getSignCertSn() + ":" + timestamp).getBytes());
        this.header.put("signData", signData);
        this.header.put("sign", CertUtils.signByBc(configureBean.getPrivateKey(), signData, configureBean.getAlgType()));
    }

    @Override
    public boolean enableHttps() {
        return this.configureBean.isHttps();
    }

    @Override
    public boolean enableGMSSL() {
        return this.configureBean.isGmssl();
    }

    @Override
    public Map<String, Object> headers() {
        return this.header;
    }
}

