/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.cams.util;

import com.xdja.pki.cams.core.KeyAlgEnum;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSASignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2SignUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Base64;

public class CertUtils {
    private static final String CERT_HEAD = "-----BEGIN CERTIFICATE-----";
    private static final String CERT_TAIL = "-----END CERTIFICATE-----";

    public static X509Certificate getCertFromBase64Str(String base64Str) throws Exception {
        base64Str = base64Str.replace(CERT_HEAD, "");
        base64Str = base64Str.replace(CERT_TAIL, "");
        CertificateFactory factory = CertificateFactory.getInstance("X509", "BC");
        return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(Base64.decode((String)base64Str)));
    }

    public static X509Certificate getCertFromP12File(String deviceCertPath, String pwd) {
        Certificate[] certCHain = null;
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12", "BC");
            FileInputStream is = new FileInputStream(deviceCertPath);
            keyStore.load(is, pwd.toCharArray());
            Enumeration<String> enums = keyStore.aliases();
            while (enums.hasMoreElements()) {
                String keyAlias = enums.nextElement();
                if (!keyStore.isKeyEntry(keyAlias)) continue;
                certCHain = keyStore.getCertificateChain(keyAlias);
            }
            List list = CertUtils.sortCerts(Arrays.asList(certCHain));
            return (X509Certificate)list.get(0);
        }
        catch (Exception e) {
            throw new RuntimeException("\u672a\u627e\u5230\u8bbe\u5907\u8bc1\u4e66\u4e2d\u7684\u7528\u6237\u8bc1\u4e66", e);
        }
    }

    public static List sortCerts(List<Certificate> certs) {
        int j;
        if (certs.size() < 2) {
            return certs;
        }
        X500Principal issuer = ((X509Certificate)certs.get(0)).getIssuerX500Principal();
        boolean okay = true;
        for (int i = 1; i != certs.size(); ++i) {
            X509Certificate cert = (X509Certificate)certs.get(i);
            if (!issuer.equals(cert.getSubjectX500Principal())) {
                okay = false;
                break;
            }
            issuer = ((X509Certificate)certs.get(i)).getIssuerX500Principal();
        }
        if (okay) {
            return certs;
        }
        ArrayList<X509Certificate> retList = new ArrayList<X509Certificate>(certs.size());
        ArrayList orig = new ArrayList();
        for (j = 0; j < certs.size(); ++j) {
            X509Certificate cert = (X509Certificate)certs.get(j);
            boolean found = false;
            X500Principal subject = cert.getSubjectX500Principal();
            for (int k = 0; k != certs.size(); ++k) {
                X509Certificate c = (X509Certificate)certs.get(k);
                if (!c.getIssuerX500Principal().equals(subject)) continue;
                found = true;
                break;
            }
            if (found) continue;
            retList.add(cert);
            certs.remove(j);
        }
        block3: for (j = 0; j != retList.size(); ++j) {
            issuer = ((X509Certificate)retList.get(j)).getIssuerX500Principal();
            for (int k = 0; k < certs.size(); ++k) {
                X509Certificate c = (X509Certificate)certs.get(k);
                if (!issuer.equals(c.getSubjectX500Principal())) continue;
                retList.add(c);
                certs.remove(k);
                continue block3;
            }
        }
        if (certs.size() > 0) {
            return orig;
        }
        return retList;
    }

    public static PrivateKey getPrivateKeyByP12File(String deviceCertPath, String pwd) {
        Key key = null;
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12", "BC");
            FileInputStream is = new FileInputStream(deviceCertPath);
            keyStore.load(is, pwd.toCharArray());
            Enumeration<String> enums = keyStore.aliases();
            while (enums.hasMoreElements()) {
                String keyAlias = enums.nextElement();
                if (!keyStore.isKeyEntry(keyAlias)) continue;
                key = keyStore.getKey(keyAlias, pwd.toCharArray());
            }
            return (PrivateKey)key;
        }
        catch (Exception e) {
            throw new RuntimeException("\u672a\u627e\u5230\u8bbe\u5907\u8bc1\u4e66\u7684\u79c1\u94a5", e);
        }
    }

    public static Integer getCertKeyAlg(PublicKey publicKey) {
        String algorithm = publicKey.getAlgorithm().toLowerCase();
        KeyAlgEnum keyAlgEnum = KeyAlgEnum.RSA.name.equals(algorithm) ? KeyAlgEnum.RSA : KeyAlgEnum.SM2;
        return keyAlgEnum.type;
    }

    public static PublicKey getPublicKeyByX509Cert(X509Certificate cert) {
        return cert.getPublicKey();
    }

    public static String signByBc(PrivateKey privateKey, String data, Integer alg) {
        return CertUtils.signByBc(privateKey, data, KeyAlgEnum.getSignAlgNameByAlgType(alg));
    }

    public static String signByBc(PrivateKey privateKey, String data, String signAlgName) {
        try {
            if (signAlgName.equalsIgnoreCase(KeyAlgEnum.RSA.signAlgName)) {
                return GMSSLRSASignUtils.signByBC((String)signAlgName, (PrivateKey)privateKey, (String)data);
            }
            return GMSSLSM2SignUtils.signByBC((PrivateKey)privateKey, (String)data);
        }
        catch (Exception e) {
            throw new RuntimeException("\u7b7e\u540d\u5931\u8d25", e);
        }
    }

    public static String toPem(Object object) {
        try {
            StringWriter stringWriter = new StringWriter();
            JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)stringWriter);
            pemWriter.writeObject(object);
            pemWriter.flush();
            pemWriter.close();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static byte[] getSm2PrivateKey(PrivateKey privateKey) {
        ECPrivateKey ecPrivateKey = (ECPrivateKey)privateKey;
        return BigIntegers.asUnsignedByteArray((int)32, (BigInteger)ecPrivateKey.getS());
    }

    public static void writeBytesToFile(String path, byte[] bytes) {
        File file = new File(path);
        FilterOutputStream bos = null;
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists() && !file.createNewFile()) {
                throw new IOException();
            }
            bos = new BufferedOutputStream(new FileOutputStream(file));
            bos.write(bytes);
            ((BufferedOutputStream)bos).flush();
        }
        catch (Exception e) {
            throw new RuntimeException("\u4fdd\u5b58\u6587\u4ef6\u5f02\u5e38");
        }
        finally {
            if (null != bos) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    throw new RuntimeException();
                }
            }
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

