/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.example.https.server;

import com.xdja.pki.gmssl.example.https.HttpsUtil;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.XDJAJsseProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMHttpsServerXDJACACert {
    private static Logger logger = LoggerFactory.getLogger((String)GMHttpsServerXDJACACert.class.getName());

    public static void main(String[] args) throws Exception {
        Certificate[] certificates;
        char[] password = "e2c1b5c1".toCharArray();
        KeyStore ks = KeyStore.getInstance("pkcs12", "BC");
        ks.load(ClassLoader.getSystemResourceAsStream("e2c1b5c1_sm2.p12"), password);
        String alias = ks.aliases().nextElement();
        PrivateKey privateKey = (PrivateKey)ks.getKey(alias, password);
        for (Certificate certificate : certificates = ks.getCertificateChain(alias)) {
            logger.info(certificate.toString());
        }
        Certificate caCert = CertificateFactory.getInstance("X.509", "BC").generateCertificate(ClassLoader.getSystemResourceAsStream("root_sm2.cer"));
        KeyStore serverStore = KeyStore.getInstance("BKS", "BC");
        serverStore.load(null, null);
        serverStore.setKeyEntry("server", privateKey, password, certificates);
        KeyStore trustStore = KeyStore.getInstance("BKS", "BC");
        trustStore.load(null, null);
        trustStore.setCertificateEntry("ca", caCert);
        HttpsUtil.startGMHttpsServer((KeyStore)serverStore, (char[])password, (KeyStore)trustStore, (boolean)false);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        if (Security.getProvider("XDJAJSSE") == null) {
            Security.addProvider((Provider)new XDJAJsseProvider());
        }
    }
}

