package com.xdja.pki.gmssl.example.https.client;

import com.squareup.okhttp.*;
import com.xdja.pki.gmssl.GMSSLContext;
import com.xdja.pki.gmssl.example.Constants;
import org.bouncycastle.jsse.provider.XDJAJsseProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.net.ssl.*;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;

public class GMOKHttpsClientExample {

    private static Logger logger = LoggerFactory.getLogger(GMOKHttpsClientExample.class.getName());

    public static void main(String[] args) throws Exception {
        // 获取 国密SSL socket factory
        SSLSocketFactory socketFactory = GMSSLContext.getClientInstance(Constants.GMSSLv11).getSocketFactory();

        OkHttpClient client = new OkHttpClient();
        client.setSocketFactory(socketFactory);
        client.setHostnameVerifier(new HostnameVerifier() {
            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
        //配置国密SSL的tlv版本以及加密套件
        ConnectionSpec gmsslConnection = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS)
                .tlsVersions("GMSSLv1.1")
                .cipherSuites("GMSSL_ECC_SM4_SM3")
                .build();
        client.setConnectionSpecs(Collections.singletonList(gmsslConnection));

        Request request = new Request.Builder()
                .url("https://11.12.108.160:8443")
                .build();
        Call call = client.newCall(request);
        Response response = call.execute();
        if (response.isSuccessful()) {
            ResponseBody body = response.body();
            if (body != null) {
                logger.info(body.string());
            }
        }
    }
}
