package com.xdja.pki.gmssl.http.bean;

import java.security.KeyStore;

public class GMSSLHttpsClientConfig extends GMSSLHttpClientConfig {

    /**
     * 是否开启 SSL 即 使用 https
     */
    private boolean sslEnabled;

    /**
     * SSL 协议
     */
    private String sslProtocol;

    /**
     * 是否开启 客户端验证
     */
    private boolean clientAuth;

    /**
     * 客户端 keystore 私钥、证书
     */
    private KeyStore clientKeyStore;

    /**
     * 客户端 keystore 密码
     */
    private String clientKeyStorePassword;

    /**
     * 客户端 keystore provider
     */
    private String clientKeyStoreProvider;

    /**
     * 客户端 keystore type
     */
    private String clientKeyStoreType;

    /**
     * 客户端 trust store 信任锚点
     */
    private KeyStore trustStore;

    /**
     * 客户端 trust store 密码
     */
    private String trustStorePassword;

    /**
     * 客户端 trust store provider
     */
    private String trustStoreProvider;

    /**
     * 客户端 trust store type
     */
    private String trustStoreType;

    public boolean isSslEnabled() {
        return sslEnabled;
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public String getSslProtocol() {
        return sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public boolean isClientAuth() {
        return clientAuth;
    }

    public void setClientAuth(boolean clientAuth) {
        this.clientAuth = clientAuth;
    }

    public KeyStore getClientKeyStore() {
        return clientKeyStore;
    }

    public void setClientKeyStore(KeyStore clientKeyStore) {
        this.clientKeyStore = clientKeyStore;
    }

    public String getClientKeyStorePassword() {
        return clientKeyStorePassword;
    }

    public void setClientKeyStorePassword(String clientKeyStorePassword) {
        this.clientKeyStorePassword = clientKeyStorePassword;
    }

    public String getClientKeyStoreProvider() {
        return clientKeyStoreProvider;
    }

    public void setClientKeyStoreProvider(String clientKeyStoreProvider) {
        this.clientKeyStoreProvider = clientKeyStoreProvider;
    }

    public String getClientKeyStoreType() {
        return clientKeyStoreType;
    }

    public void setClientKeyStoreType(String clientKeyStoreType) {
        this.clientKeyStoreType = clientKeyStoreType;
    }

    public KeyStore getTrustStore() {
        return trustStore;
    }

    public void setTrustStore(KeyStore trustStore) {
        this.trustStore = trustStore;
    }

    public String getTrustStorePassword() {
        return trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String getTrustStoreProvider() {
        return trustStoreProvider;
    }

    public void setTrustStoreProvider(String trustStoreProvider) {
        this.trustStoreProvider = trustStoreProvider;
    }

    public String getTrustStoreType() {
        return trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    @Override
    public String toString() {
        return "GMSSLHttpsClientConfig{" +
                "sslEnabled=" + sslEnabled +
                ", sslProtocol='" + sslProtocol + '\'' +
                ", clientAuth=" + clientAuth +
                ", clientKeyStore=" + clientKeyStore +
                ", clientKeyStorePassword='" + clientKeyStorePassword + '\'' +
                ", clientKeyStoreProvider='" + clientKeyStoreProvider + '\'' +
                ", clientKeyStoreType='" + clientKeyStoreType + '\'' +
                ", trustStore=" + trustStore +
                ", trustStorePassword='" + trustStorePassword + '\'' +
                ", trustStoreProvider='" + trustStoreProvider + '\'' +
                ", trustStoreType='" + trustStoreType + '\'' +
                ", connectTimeout=" + connectTimeout +
                ", readTimeout=" + readTimeout +
                '}';
    }
}
