package com.xdja.pki.gmssl.https;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import org.bouncycastle.tls.GMSSLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.nio.charset.StandardCharsets;

class GMHttpsUtils {

    private static Logger logger = LoggerFactory.getLogger(GMHttpsUtils.class.getName());

    static void write(OutputStream outputStream, String body) throws IOException {
        if (body != null) {
            outputStream.write(body.getBytes(StandardCharsets.UTF_8));
            outputStream.close();
        }
    }

    static String read(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);

        StringBuilder response = new StringBuilder();
        String str = null;
        while ((str = bufferedReader.readLine()) != null) {
            response.append(str);
        }
        bufferedReader.close();
        inputStreamReader.close();
        inputStream.close();
        return response.toString();
    }
}
