/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.https;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsExchange;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import com.xdja.pki.gmssl.GMSSLContext;
import com.xdja.pki.gmssl.https.GMHttpsException;
import com.xdja.pki.gmssl.https.GMHttpsMethod;
import com.xdja.pki.gmssl.https.GMHttpsRequest;
import com.xdja.pki.gmssl.https.GMHttpsResponse;
import com.xdja.pki.gmssl.https.GMHttpsUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMHttpsServer {
    private static Logger logger = LoggerFactory.getLogger((String)GMHttpsServer.class.getName());

    public static void startHttpsServer(KeyStore serverStore, char[] password, KeyStore trustStore, final boolean needClientAuth, Context[] contexts, String host, int port, String protocol) throws GMHttpsException {
        GMSSLContext gmsslContext = null;
        try {
            gmsslContext = GMSSLContext.getServerInstance(serverStore, password, trustStore, protocol);
        }
        catch (GMSSLContext.GMSSLException e) {
            throw new GMHttpsException("get server instance exception", e);
        }
        HttpsServer httpsServer = null;
        try {
            httpsServer = HttpsServer.create(new InetSocketAddress(host, port), 0);
        }
        catch (IOException e) {
            throw new GMHttpsException("create https server exception", e);
        }
        httpsServer.setHttpsConfigurator(new HttpsConfigurator(gmsslContext.getSslContext()){

            @Override
            public void configure(HttpsParameters httpsParameters) {
                SSLContext sslContext = this.getSSLContext();
                SSLParameters sslParameters = sslContext.getDefaultSSLParameters();
                sslParameters.setNeedClientAuth(needClientAuth);
                httpsParameters.setSSLParameters(sslParameters);
            }
        });
        for (final Context context : contexts) {
            httpsServer.createContext(context.path, new HttpHandler(){

                @Override
                public void handle(HttpExchange httpExchange) throws IOException {
                    HttpsExchange httpsExchange = (HttpsExchange)httpExchange;
                    httpsExchange.getSSLSession();
                    if (!httpsExchange.getRequestMethod().equals(context.method.toString())) {
                        context.handler.onRequestError(httpsExchange.getRequestURI() + " method want: " + (Object)((Object)context.method) + ", but request is: " + httpsExchange.getRequestMethod());
                        httpsExchange.sendResponseHeaders(405, 0L);
                        return;
                    }
                    byte[] requestBody = GMHttpsUtils.readBytes(httpsExchange.getRequestBody());
                    GMHttpsRequest request = new GMHttpsRequest(null, httpsExchange.getRequestURI().toString(), httpsExchange.getRequestMethod(), requestBody);
                    GMHttpsResponse response = context.handler.onRequest(request);
                    httpExchange.getResponseHeaders().set("Content-Type", "text/html");
                    httpExchange.sendResponseHeaders(response.getCode(), response.getBody().length);
                    GMHttpsUtils.writeBytes(httpsExchange.getResponseBody(), response.getBody());
                }
            });
        }
        httpsServer.setExecutor(Executors.newCachedThreadPool());
        logger.info("Starting server on port " + port + "...");
        httpsServer.start();
        logger.info("Server started successfully!");
    }

    public static interface Handler {
        public GMHttpsResponse onRequest(GMHttpsRequest var1);

        public void onRequestError(String var1);
    }

    public static class Context {
        private String path;
        private GMHttpsMethod method;
        private Handler handler;

        public Context(String path, GMHttpsMethod method, Handler handler) {
            this.path = path;
            this.method = method;
            this.handler = handler;
        }
    }
}

