/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.http.api;

import com.xdja.pki.gmssl.GMSSLContext;
import com.xdja.pki.gmssl.http.bean.GMSSLHttpClientConfig;
import com.xdja.pki.gmssl.http.bean.GMSSLHttpMethod;
import com.xdja.pki.gmssl.http.bean.GMSSLHttpRequest;
import com.xdja.pki.gmssl.http.bean.GMSSLHttpResponse;
import com.xdja.pki.gmssl.http.bean.GMSSLHttpsClientConfig;
import com.xdja.pki.gmssl.http.exception.GMSSLHttpErrorCode;
import com.xdja.pki.gmssl.http.exception.GMSSLHttpException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.XDJAJsseProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHttpClient {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected GMSSLHttpClientConfig httpClientConfig;

    public BaseHttpClient() {
    }

    public BaseHttpClient(GMSSLHttpClientConfig httpClientConfig) {
        this.httpClientConfig = httpClientConfig;
    }

    public GMSSLHttpResponse connect(GMSSLHttpMethod httpMethod, GMSSLHttpRequest request) throws GMSSLHttpException {
        int statusCode;
        String uri = this.generateURL(request);
        HttpURLConnection connection = null;
        URL conUrl = null;
        try {
            conUrl = new URL(uri);
        }
        catch (MalformedURLException e) {
            throw new GMSSLHttpException(e, GMSSLHttpErrorCode.GENERATE_URL_ERROR);
        }
        try {
            connection = (HttpURLConnection)conUrl.openConnection();
        }
        catch (IOException e) {
            throw new GMSSLHttpException(e, GMSSLHttpErrorCode.OPENCONNECTION_ERROR);
        }
        Map<String, String> headers = request.getHeaders();
        if (headers != null && headers.size() != 0) {
            for (String key : headers.keySet()) {
                connection.setRequestProperty(key, headers.get(key));
                this.logger.info("http request set header {}={}", (Object)key, (Object)headers.get(key));
            }
        }
        if (this.httpClientConfig != null) {
            int readTimeout;
            int connectTimeout = this.httpClientConfig.getConnectTimeout();
            if (connectTimeout != 0) {
                connection.setConnectTimeout(connectTimeout);
                this.logger.info("http request set connect timeout {}", (Object)connectTimeout);
            }
            if ((readTimeout = this.httpClientConfig.getReadTimeout()) != 0) {
                connection.setReadTimeout(readTimeout);
                this.logger.info("http request set read timeout {}", (Object)readTimeout);
            }
            this.setSSLSocketFactory(connection);
        }
        connection.setDoInput(true);
        try {
            String method = httpMethod.getValue();
            this.logger.info("http request method is {}", (Object)method);
            connection.setRequestMethod(method);
        }
        catch (ProtocolException e) {
            throw new GMSSLHttpException(e, GMSSLHttpErrorCode.SET_REQUEST_METHOD_ERROR);
        }
        connection.setDoOutput(true);
        try {
            connection.connect();
        }
        catch (IOException e) {
            throw new GMSSLHttpException(e, GMSSLHttpErrorCode.CONNECTION_ERROR);
        }
        this.writeRequestBody(connection, request);
        GMSSLHttpResponse response = new GMSSLHttpResponse();
        response.setHeaders(connection.getHeaderFields());
        try {
            statusCode = connection.getResponseCode();
            response.setStatusCode(statusCode);
        }
        catch (IOException e) {
            throw new GMSSLHttpException(e, GMSSLHttpErrorCode.CONNECTION_GET_RESPONSE_STATUS_CODE_ERROR);
        }
        try {
            String responseMessage = connection.getResponseMessage();
            response.setStatusMessage(responseMessage);
        }
        catch (IOException e) {
            throw new GMSSLHttpException(e, GMSSLHttpErrorCode.CONNECTION_GET_RESPONSE_STATUS_CODE_ERROR);
        }
        this.readResponseBody(connection, statusCode, response);
        return response;
    }

    private String generateURL(GMSSLHttpRequest request) throws GMSSLHttpException {
        StringBuilder sb = new StringBuilder(request.getUrl());
        URL url = null;
        try {
            url = new URL(sb.toString());
        }
        catch (MalformedURLException e) {
            throw new GMSSLHttpException(e, GMSSLHttpErrorCode.URL_ERROR);
        }
        Map<String, String> params = request.getParams();
        if (params != null && params.size() != 0) {
            if (url.getQuery() == null) {
                sb.append("?");
            }
            for (String key : params.keySet()) {
                sb.append(key).append("=").append(params.get(key)).append("&");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        String uri = sb.toString();
        this.logger.info("http request url is {}", (Object)uri);
        return uri;
    }

    private void setSSLSocketFactory(HttpURLConnection connection) throws GMSSLHttpException {
        if (this.httpClientConfig instanceof GMSSLHttpsClientConfig) {
            GMSSLHttpsClientConfig httpsClientConfig = (GMSSLHttpsClientConfig)this.httpClientConfig;
            String sslProtocol = httpsClientConfig.getSslProtocol();
            if (httpsClientConfig.isSslEnabled() && sslProtocol != null) {
                this.logger.info("http request set ssl protocol {}", (Object)sslProtocol);
                try {
                    SSLSocketFactory socketFactory = null;
                    socketFactory = httpsClientConfig.getClientKeyStore() != null && httpsClientConfig.getTrustStore() != null ? GMSSLContext.getClientInstance(httpsClientConfig.getClientKeyStore(), httpsClientConfig.getClientKeyStorePassword().toCharArray(), httpsClientConfig.getTrustStore(), sslProtocol).getSocketFactory() : (httpsClientConfig.getTrustStore() != null ? GMSSLContext.getClientInstance(httpsClientConfig.getTrustStorePassword().toCharArray(), httpsClientConfig.getTrustStore(), sslProtocol).getSocketFactory() : GMSSLContext.getClientInstance(sslProtocol).getSocketFactory());
                    ((HttpsURLConnection)connection).setSSLSocketFactory(socketFactory);
                }
                catch (GMSSLContext.GMSSLException | IOException e) {
                    throw new GMSSLHttpException(e, GMSSLHttpErrorCode.GENERATE_SSL_SOCKET_FACTORY_ERROR);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeRequestBody(HttpURLConnection connection, GMSSLHttpRequest request) throws GMSSLHttpException {
        OutputStream outputStream;
        byte[] body = request.getBody();
        if (body == null) return;
        if (body.length <= 0) return;
        try {
            outputStream = connection.getOutputStream();
        }
        catch (IOException e) {
            throw new GMSSLHttpException(e, GMSSLHttpErrorCode.CONNECTION_GET_OUTPUT_STREAM_ERROR);
        }
        DataOutputStream dos = new DataOutputStream(outputStream);
        try {
            dos.write(body);
            return;
        }
        catch (IOException e) {
            throw new GMSSLHttpException("write error", e, GMSSLHttpErrorCode.CONNECTION_WRITE_BODY_ERROR);
        }
        finally {
            try {
                dos.flush();
            }
            catch (IOException e) {
                throw new GMSSLHttpException("flush error", e, GMSSLHttpErrorCode.CONNECTION_WRITE_BODY_ERROR);
            }
            finally {
                try {
                    dos.close();
                    outputStream.close();
                }
                catch (IOException e) {
                    throw new GMSSLHttpException("close error", e, GMSSLHttpErrorCode.CONNECTION_WRITE_BODY_ERROR);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readResponseBody(HttpURLConnection connection, int statusCode, GMSSLHttpResponse response) throws GMSSLHttpException {
        InputStream inputStream;
        int contentLength = connection.getContentLength();
        try {
            inputStream = 200 <= statusCode && statusCode <= 299 ? connection.getInputStream() : connection.getErrorStream();
        }
        catch (IOException e) {
            throw new GMSSLHttpException(e, GMSSLHttpErrorCode.CONNECTION_GET_INPUT_STREAM_ERROR);
        }
        if (inputStream == null) {
            this.logger.error("connection content length is {}, but input stream is null", (Object)contentLength);
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int length = 0;
        try {
            while ((length = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            throw new GMSSLHttpException(e, GMSSLHttpErrorCode.CONNECTION_GET_RESPONSE_BODY_ERROR);
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException e) {
                throw new GMSSLHttpException("close bos error", e, GMSSLHttpErrorCode.CONNECTION_GET_RESPONSE_BODY_ERROR);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    throw new GMSSLHttpException("close input stream error", e, GMSSLHttpErrorCode.CONNECTION_GET_RESPONSE_BODY_ERROR);
                }
            }
        }
        byte[] body = bos.toByteArray();
        response.setBody(body);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        if (Security.getProvider("XDJAJSSE") == null) {
            Security.addProvider((Provider)new XDJAJsseProvider());
        }
    }
}

