package com.xdja.pki.gmssl.http.bean;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;

import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GMSSLHttpResponse {
    /**
     * 响应状态码
     */
    private int statusCode;

    /**
     * 响应消息
     */
    private String statusMessage;

    /**
     * 响应头部
     */
    private Map<String, List<String>> headers = new HashMap<>();

    /**
     * 响应消息体
     */
    private byte[] body;

    private InputStream inputStream;

    public int getStatusCode() {
        return statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getStatusMessage() {
        return statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public Map<String, List<String>> getHeaders() {
        return headers;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public byte[] getBody() {
        return body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public InputStream getInputStream() {
        return inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public String toString() {
        if (body != null) {
            return "GMSSLHttpResponse{" +
                    "statusCode=" + statusCode +
                    ", statusMessage='" + statusMessage + '\'' +
                    ", headers=" + headers +
                    ", body=" + new String(body) +
                    ", bodyBase64=" + GMSSLByteArrayUtils.base64Encode(body) +
                    ", bodyHex=" + GMSSLByteArrayUtils.hexEncode(body) +
                    '}';
        }
        return "GMSSLHttpResponse{" +
                "statusCode=" + statusCode +
                ", statusMessage='" + statusMessage + '\'' +
                ", headers=" + headers +
                '}';
    }
}
