/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.http;

import com.xdja.pki.gmssl.http.GMSSLHttpClient;
import com.xdja.pki.gmssl.http.bean.GMSSLHttpClientConfig;
import com.xdja.pki.gmssl.http.bean.GMSSLHttpRequest;
import com.xdja.pki.gmssl.http.bean.GMSSLHttpResponse;
import com.xdja.pki.gmssl.http.bean.GMSSLHttpsClientConfig;
import com.xdja.pki.gmssl.http.bean.GMSSLProtocol;
import com.xdja.pki.gmssl.http.exception.GMSSLHttpErrorCode;
import com.xdja.pki.gmssl.http.exception.GMSSLHttpException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLHttpsClient
extends GMSSLHttpClient {
    private Logger logger = LoggerFactory.getLogger(GMSSLHttpsClient.class);

    public GMSSLHttpsClient() {
        GMSSLHttpsClientConfig httpsClientConfig = new GMSSLHttpsClientConfig();
        httpsClientConfig.setSslEnabled(true);
        httpsClientConfig.setSslProtocol(GMSSLProtocol.GMSSLv11.getValue());
        this.httpClientConfig = httpsClientConfig;
    }

    public GMSSLHttpsClient(GMSSLHttpClientConfig httpClientConfig) {
        super(httpClientConfig);
    }

    public GMSSLHttpsClient(X509Certificate caCert) throws GMSSLHttpException {
        this(new X509Certificate[]{caCert});
    }

    public GMSSLHttpsClient(X509Certificate[] caCerts) throws GMSSLHttpException {
        GMSSLHttpsClientConfig httpsClientConfig = new GMSSLHttpsClientConfig();
        httpsClientConfig.setSslEnabled(true);
        this.logger.info("get caCerts signAlg is " + caCerts[0].getSigAlgName());
        try {
            KeyStore keyStore;
            if (caCerts[0].getSigAlgName().contains("RSA") || caCerts[0].getSigAlgName().contains("ECDSA")) {
                keyStore = KeyStore.getInstance("JKS");
                httpsClientConfig.setSslProtocol(GMSSLProtocol.TLSV12.getValue());
            } else {
                keyStore = KeyStore.getInstance("BKS", "BC");
                httpsClientConfig.setSslProtocol(GMSSLProtocol.GMSSLv11.getValue());
            }
            keyStore.load(null, "password".toCharArray());
            for (int i = 0; i < caCerts.length; ++i) {
                keyStore.setCertificateEntry("trust-" + i, caCerts[i]);
            }
            httpsClientConfig.setTrustStore(keyStore);
            httpsClientConfig.setTrustStorePassword("password");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GMSSLHttpException("client keystore", GMSSLHttpErrorCode.GENERATE_TRUST_KEYSTORE__ERROR);
        }
        this.httpClientConfig = httpsClientConfig;
    }

    public GMSSLHttpsClient(X509Certificate[] caCerts, boolean isByYunHsm) throws GMSSLHttpException {
        GMSSLHttpsClientConfig httpsClientConfig = new GMSSLHttpsClientConfig();
        httpsClientConfig.setSslEnabled(true);
        this.logger.info("get caCerts signAlg is " + caCerts[0].getSigAlgName());
        try {
            KeyStore keyStore;
            if (caCerts[0].getSigAlgName().contains("RSA")) {
                keyStore = KeyStore.getInstance("JKS");
                httpsClientConfig.setSslProtocol(GMSSLProtocol.TLSV12.getValue());
            } else if (isByYunHsm) {
                keyStore = KeyStore.getInstance("BKS", "BC");
                httpsClientConfig.setSslProtocol(GMSSLProtocol.GMSSLSDFYUNHSMv11.getValue());
            } else {
                keyStore = KeyStore.getInstance("BKS", "BC");
                httpsClientConfig.setSslProtocol(GMSSLProtocol.GMSSLv11.getValue());
            }
            keyStore.load(null, "password".toCharArray());
            for (int i = 0; i < caCerts.length; ++i) {
                keyStore.setCertificateEntry("trust-" + i, caCerts[i]);
            }
            httpsClientConfig.setTrustStore(keyStore);
            httpsClientConfig.setTrustStorePassword("password");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GMSSLHttpException("client keystore", GMSSLHttpErrorCode.GENERATE_TRUST_KEYSTORE__ERROR);
        }
        this.httpClientConfig = httpsClientConfig;
    }

    private void checkConfig() throws GMSSLHttpException {
        if (!(this.httpClientConfig instanceof GMSSLHttpsClientConfig)) {
            throw new GMSSLHttpException("config", GMSSLHttpErrorCode.HTTPS_CONFIG_ERROR);
        }
        GMSSLHttpsClientConfig httpsClientConfig = (GMSSLHttpsClientConfig)this.httpClientConfig;
        if (!httpsClientConfig.isSslEnabled() || httpsClientConfig.getSslProtocol() == null) {
            throw new GMSSLHttpException("ssl protocol", GMSSLHttpErrorCode.HTTPS_CONFIG_ERROR);
        }
    }

    @Override
    public GMSSLHttpResponse get(GMSSLHttpRequest request) throws GMSSLHttpException {
        this.checkConfig();
        return super.get(request);
    }

    @Override
    public GMSSLHttpResponse post(GMSSLHttpRequest request) throws GMSSLHttpException {
        this.checkConfig();
        return super.post(request);
    }

    @Override
    public GMSSLHttpResponse put(GMSSLHttpRequest request) throws GMSSLHttpException {
        this.checkConfig();
        return super.put(request);
    }

    @Override
    public GMSSLHttpResponse delete(GMSSLHttpRequest request) throws GMSSLHttpException {
        this.checkConfig();
        return super.delete(request);
    }
}

