package org.bouncycastle.jsse.provider;

import java.security.Principal;
import java.security.cert.Certificate;

import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSessionContext;

// TODO[jsse] Serializable ?
class ProvExtendedSSLSession_7
    extends ExtendedSSLSession
{
    final ProvSSLSession sslSession;

    ProvExtendedSSLSession_7(ProvSSLSession sslSession)
    {
        this.sslSession = sslSession;
    }

    @Override
    public int getApplicationBufferSize()
    {
        return sslSession.getApplicationBufferSize();
    }

    @Override
    public String getCipherSuite()
    {
        return sslSession.getCipherSuite();
    }

    @Override
    public long getCreationTime()
    {
        return sslSession.getCreationTime();
    }

    @Override
    public byte[] getId()
    {
        return sslSession.getId();
    }

    @Override
    public long getLastAccessedTime()
    {
        return sslSession.getLastAccessedTime();
    }

    @Override
    public Certificate[] getLocalCertificates()
    {
        return sslSession.getLocalCertificates();
    }

    @Override
    public Principal getLocalPrincipal()
    {
        return sslSession.getLocalPrincipal();
    }

    @Override
    public String[] getLocalSupportedSignatureAlgorithms()
    {
        return sslSession.getLocalSupportedSignatureAlgorithms();
    }

    @Override
    public int getPacketBufferSize()
    {
        return sslSession.getPacketBufferSize();
    }

    @Override
    public javax.security.cert.X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException
    {
        return sslSession.getPeerCertificateChain();
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException
    {
        return sslSession.getPeerCertificates();
    }

    @Override
    public String getPeerHost()
    {
        return sslSession.getPeerHost();
    }

    @Override
    public int getPeerPort()
    {
        return sslSession.getPeerPort();
    }

    @Override
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException
    {
        return sslSession.getPeerPrincipal();
    }

    @Override
    public String[] getPeerSupportedSignatureAlgorithms()
    {
        return sslSession.getPeerSupportedSignatureAlgorithms();
    }

    @Override
    public String getProtocol()
    {
        return sslSession.getProtocol();
    }

    @Override
    public SSLSessionContext getSessionContext()
    {
        return sslSession.getSessionContext();
    }

    @Override
    public Object getValue(String name)
    {
        return sslSession.getValue(name);
    }

    @Override
    public String[] getValueNames()
    {
        return sslSession.getValueNames();
    }

    @Override
    public void invalidate()
    {
        sslSession.invalidate();
    }

    @Override
    public boolean isValid()
    {
        return sslSession.isValid();
    }

    @Override
    public void putValue(String name, Object value)
    {
        sslSession.putValue(name, value);
    }

    @Override
    public void removeValue(String name)
    {
        sslSession.removeValue(name);
    }
}
