/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvDHConfigVerifier;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.ProvSSLSessionImpl;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.SupportedGroups;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatusRequest;
import org.bouncycastle.tls.DefaultTlsClient;
import org.bouncycastle.tls.DefaultTlsKeyExchangeFactory;
import org.bouncycastle.tls.GMSSLUtils;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.ServerName;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsServerCertificate;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedAgreement;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCryptoSdf;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaDefaultTlsCredentialedSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JceDefaultTlsCredentialedAgreement;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.IPAddress;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvTlsClient
extends DefaultTlsClient
implements ProvTlsPeer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final boolean provEnableSNIExtension = PropertyUtils.getBooleanSystemProperty("jsse.enableSNIExtension", true);
    protected final ProvTlsManager manager;
    protected final ProvSSLParameters sslParameters;
    protected ProvSSLSessionImpl sslSession = null;
    protected boolean handshakeComplete = false;

    ProvTlsClient(ProvTlsManager manager, ProvSSLParameters sslParameters) {
        super(manager.getContextData().getCrypto(), new DefaultTlsKeyExchangeFactory(), new ProvDHConfigVerifier());
        this.manager = manager;
        this.sslParameters = sslParameters;
    }

    @Override
    protected CertificateStatusRequest getCertificateStatusRequest() {
        return null;
    }

    @Override
    protected Vector getSupportedGroups(boolean offeringDH, boolean offeringEC) {
        return SupportedGroups.getClientSupportedGroups(this.manager.getContext().isFips(), offeringDH, offeringEC);
    }

    @Override
    protected Vector getSNIServerNames() {
        if (provEnableSNIExtension) {
            List<BCSNIServerName> sniServerNames = this.sslParameters.getServerNames();
            if (sniServerNames == null) {
                String peerHost = this.manager.getPeerHost();
                if (peerHost != null && peerHost.indexOf(46) > 0 && !IPAddress.isValid((String)peerHost)) {
                    Vector<ServerName> serverNames = new Vector<ServerName>(1);
                    serverNames.addElement(new ServerName(0, peerHost));
                    return serverNames;
                }
            } else {
                Vector<ServerName> serverNames = new Vector<ServerName>(sniServerNames.size());
                for (BCSNIServerName sniServerName : sniServerNames) {
                    if (sniServerName.getType() != 0) continue;
                    try {
                        serverNames.addElement(new ServerName((short)sniServerName.getType(), new String(sniServerName.getEncoded(), "ASCII")));
                    }
                    catch (UnsupportedEncodingException e) {
                        this.logger.warn("Unable to include SNI server name", (Throwable)e);
                    }
                }
                if (!serverNames.isEmpty()) {
                    return serverNames;
                }
            }
        }
        return null;
    }

    @Override
    protected Vector getSupportedSignatureAlgorithms() {
        return JsseUtils.getSupportedSignatureAlgorithms(this.getCrypto());
    }

    @Override
    public synchronized boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        return new TlsAuthentication(){

            @Override
            public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
                int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(ProvTlsClient.this.selectedCipherSuite);
                switch (keyExchangeAlgorithm) {
                    case 7: 
                    case 9: 
                    case 16: 
                    case 18: {
                        return null;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 17: 
                    case 19: {
                        return ProvTlsClient.this.generateCredentials(keyExchangeAlgorithm, certificateRequest);
                    }
                    case 101: {
                        return ProvTlsClient.this.generateCredentialsECCSM2(keyExchangeAlgorithm, certificateRequest);
                    }
                }
                throw new TlsFatalAlert(80);
            }

            @Override
            public void notifyServerCertificate(TlsServerCertificate serverCertificate) throws IOException {
                String authType;
                boolean noServerCert;
                boolean bl = noServerCert = serverCertificate == null || serverCertificate.getCertificate() == null || serverCertificate.getCertificate().isEmpty();
                if (noServerCert) {
                    throw new TlsFatalAlert(40);
                }
                X509Certificate[] chain = JsseUtils.getX509CertificateChain(ProvTlsClient.this.manager.getContextData().getCrypto(), serverCertificate.getCertificate());
                if (!ProvTlsClient.this.manager.isServerTrusted(chain, authType = JsseUtils.getAuthTypeServer(TlsUtils.getKeyExchangeAlgorithm(ProvTlsClient.this.selectedCipherSuite)))) {
                    ProvTlsClient.this.logger.error("server cert is not trust, alert bad_certificate");
                    throw new TlsFatalAlert(42);
                }
            }
        };
    }

    @Override
    public int[] getCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.manager.getContextData().getCrypto(), this.manager.getContext().convertCipherSuites(this.sslParameters.getCipherSuites()));
    }

    @Override
    public short[] getCompressionMethods() {
        short[] sArray;
        if (this.manager.getContext().isFips()) {
            short[] sArray2 = new short[1];
            sArray = sArray2;
            sArray2[0] = 0;
        } else {
            sArray = super.getCompressionMethods();
        }
        return sArray;
    }

    @Override
    public ProtocolVersion getMinimumVersion() {
        return this.manager.getContext().getMinimumVersion(this.sslParameters.getProtocols());
    }

    @Override
    public ProtocolVersion getClientVersion() {
        return this.manager.getContext().getMaximumVersion(this.sslParameters.getProtocols());
    }

    @Override
    public TlsSession getSessionToResume() {
        TlsSession sessionToResume;
        ProvSSLSessionContext sessionContext = this.manager.getContextData().getClientSessionContext();
        this.sslSession = sessionContext.getSessionImpl(this.manager.getPeerHost(), this.manager.getPeerPort());
        if (this.sslSession != null && (sessionToResume = this.sslSession.getTlsSession()) != null) {
            return sessionToResume;
        }
        if (!this.manager.getEnableSessionCreation()) {
            throw new IllegalStateException("No resumable sessions and session creation is disabled");
        }
        return null;
    }

    @Override
    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        super.notifyAlertRaised(alertLevel, alertDescription, message, cause);
        String msg = JsseUtils.getAlertLogMessage("Client raised", alertLevel, alertDescription);
        if (message != null) {
            msg = msg + ": " + message;
        }
        if (alertLevel == 1 || alertDescription == 80) {
            this.logger.warn(msg, cause);
        } else if (alertLevel == 2) {
            this.logger.error(msg, cause);
        } else {
            this.logger.info(msg, cause);
        }
    }

    @Override
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        super.notifyAlertReceived(alertLevel, alertDescription);
        String msg = JsseUtils.getAlertLogMessage("Client received", alertLevel, alertDescription);
        if (alertLevel == 1) {
            this.logger.warn(msg);
        } else {
            this.logger.info(msg);
        }
    }

    @Override
    public synchronized void notifyHandshakeComplete() throws IOException {
        this.handshakeComplete = true;
        TlsSession handshakeSession = this.context.getSession();
        if (this.sslSession == null || this.sslSession.getTlsSession() != handshakeSession) {
            this.sslSession = this.manager.getContextData().getClientSessionContext().reportSession(handshakeSession, this.manager.getPeerHost(), this.manager.getPeerPort());
        }
        this.manager.notifyHandshakeComplete(new ProvSSLConnection(this.context, this.sslSession));
    }

    @Override
    public void notifySecureRenegotiation(boolean secureRenegotiation) throws IOException {
        boolean allowLegacyHelloMessages;
        if (!secureRenegotiation && !(allowLegacyHelloMessages = PropertyUtils.getBooleanSystemProperty("sun.security.ssl.allowLegacyHelloMessages", true))) {
            throw new TlsFatalAlert(40);
        }
    }

    @Override
    public void notifySelectedCipherSuite(int selectedCipherSuite) {
        this.manager.getContext().validateNegotiatedCipherSuite(selectedCipherSuite);
        super.notifySelectedCipherSuite(selectedCipherSuite);
        this.logger.debug("Client notified of selected CipherSuite: " + this.manager.getContext().getCipherSuiteString(selectedCipherSuite));
    }

    @Override
    public void notifyServerVersion(ProtocolVersion serverVersion) throws IOException {
        String selected = this.manager.getContext().getProtocolString(serverVersion);
        if (selected != null) {
            for (String protocol : this.sslParameters.getProtocols()) {
                if (!selected.equals(protocol)) continue;
                return;
            }
        }
        throw new TlsFatalAlert(70);
    }

    @Override
    public void notifySessionID(byte[] sessionID) {
        super.notifySessionID(sessionID);
        if (sessionID == null || sessionID.length == 0) {
            this.logger.info("Server did not specify a session ID");
        } else if (this.sslSession != null && Arrays.areEqual((byte[])sessionID, (byte[])this.sslSession.getId())) {
            this.logger.debug("Server resumed session: " + Hex.toHexString((byte[])sessionID));
        } else {
            if (!this.manager.getEnableSessionCreation()) {
                throw new IllegalStateException("Server did not resume session and session creation is disabled");
            }
            this.logger.debug("Server specified new Session: " + Hex.toHexString((byte[])sessionID));
        }
    }

    private TlsCredentials generateCredentialsECCSM2(int keyExchangeAlgorithm, CertificateRequest certificateRequest) throws IOException {
        if (!(this.getCrypto() instanceof BcTlsCrypto) && !(this.getCrypto() instanceof BcTlsCryptoSdf)) {
            throw new TlsFatalAlert(80);
        }
        short signatureAlgorithm = TlsUtils.getSignatureAlgorithm(keyExchangeAlgorithm);
        SignatureAndHashAlgorithm sigAlg = TlsUtils.chooseSignatureAndHashAlgorithm(this.context, this.supportedSignatureAlgorithms, signatureAlgorithm);
        X509KeyManager keyManager = this.manager.getContextData().getKeyManager();
        if (keyManager == null) {
            this.logger.info("generate credentials gmssl x509 keyManager is null!");
            return null;
        }
        X509TrustManager trustManager = this.manager.getContextData().getTrustManager();
        if (trustManager == null) {
            this.logger.info("generate credentials gmssl x509 trustManager is null!");
            return null;
        }
        String keyType = JsseUtils.getAuthTypeServer(keyExchangeAlgorithm);
        return GMSSLUtils.generateCredentials(keyType, (AbstractTlsCrypto)this.getCrypto(), keyManager, sigAlg, this.context);
    }

    private TlsCredentials generateCredentials(int keyExchangeAlgorithm, CertificateRequest certificateRequest) throws IOException {
        Socket socket;
        String alias;
        X509KeyManager km = this.manager.getContextData().getKeyManager();
        if (km == null) {
            return null;
        }
        short[] certTypes = certificateRequest.getCertificateTypes();
        if (certTypes == null || certTypes.length == 0) {
            return null;
        }
        String[] keyTypes = new String[certTypes.length];
        for (int i = 0; i < certTypes.length; ++i) {
            keyTypes[i] = JsseUtils.getAuthTypeClient(certTypes[i]);
        }
        Principal[] issuers = null;
        Vector cas = certificateRequest.getCertificateAuthorities();
        if (cas != null && cas.size() > 0) {
            X500Name[] names = cas.toArray(new X500Name[cas.size()]);
            Set<X500Principal> principals = JsseUtils.toX500Principals(names);
            issuers = principals.toArray(new Principal[principals.size()]);
        }
        if ((alias = km.chooseClientAlias(keyTypes, issuers, socket = null)) == null) {
            return null;
        }
        TlsCrypto crypto = this.getCrypto();
        if (!(crypto instanceof JcaTlsCrypto) && !(crypto instanceof BcTlsCrypto)) {
            throw new UnsupportedOperationException();
        }
        PrivateKey privateKey = km.getPrivateKey(alias);
        Certificate certificate = JsseUtils.getCertificateMessage(crypto, km.getCertificateChain(alias));
        if (privateKey == null || certificate.isEmpty()) {
            return null;
        }
        switch (keyExchangeAlgorithm) {
            case 7: 
            case 9: 
            case 16: 
            case 18: {
                if (crypto instanceof JcaTlsCrypto) {
                    return new JceDefaultTlsCredentialedAgreement((JcaTlsCrypto)crypto, certificate, privateKey);
                }
                AsymmetricKeyParameter parameter = PrivateKeyFactory.createKey((PrivateKeyInfo)PrivateKeyInfo.getInstance((Object)privateKey.getEncoded()));
                return new BcDefaultTlsCredentialedAgreement((BcTlsCrypto)crypto, certificate, parameter);
            }
            case 1: 
            case 3: 
            case 5: 
            case 17: 
            case 19: {
                short certificateType = certificate.getCertificateAt(0).getClientCertificateType();
                short signatureAlgorithm = TlsUtils.getSignatureAlgorithmClient(certificateType);
                SignatureAndHashAlgorithm sigAlg = TlsUtils.chooseSignatureAndHashAlgorithm(this.context, this.supportedSignatureAlgorithms, signatureAlgorithm);
                if (crypto instanceof JcaTlsCrypto) {
                    return new JcaDefaultTlsCredentialedSigner(new TlsCryptoParameters(this.context), (JcaTlsCrypto)crypto, privateKey, certificate, sigAlg);
                }
                AsymmetricKeyParameter parameter = PrivateKeyFactory.createKey((PrivateKeyInfo)PrivateKeyInfo.getInstance((Object)privateKey.getEncoded()));
                return new BcDefaultTlsCredentialedSigner(new TlsCryptoParameters(this.context), (BcTlsCrypto)crypto, parameter, certificate, sigAlg);
            }
        }
        throw new TlsFatalAlert(80);
    }
}

