/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.X509KeyManager;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.DefaultTlsCredentialedSigner;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsHandshakeHash;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.tls.crypto.TlsVerifier;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedECCSM2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLUtils {
    private static Logger logger = LoggerFactory.getLogger((String)GMSSLUtils.class.getName());

    public static DefaultTlsCredentialedSigner generateCredentials(String keyType, AbstractTlsCrypto crypto, X509KeyManager keyManager, SignatureAndHashAlgorithm sigAlg, TlsContext context) throws IOException {
        String signatureAlias = GMSSLUtils.getSignatureAlias(keyType, keyManager, crypto, context);
        String encryptionAlias = GMSSLUtils.getEncryptioneAlias(keyType, keyManager, crypto, context);
        List<String> aliases = context.isServer() ? Arrays.asList(keyManager.getServerAliases(keyType, null)) : Arrays.asList(keyManager.getClientAliases(keyType, null));
        if (signatureAlias == null && !aliases.contains(signatureAlias = "sign")) {
            signatureAlias = aliases.get(0);
        }
        if (encryptionAlias == null && !aliases.contains(encryptionAlias = "enc")) {
            encryptionAlias = aliases.get(1);
        }
        if (signatureAlias != null && encryptionAlias != null) {
            PrivateKey signaturePrivateKey = keyManager.getPrivateKey(signatureAlias);
            PrivateKey encryptionPrivateKey = keyManager.getPrivateKey(encryptionAlias);
            Certificate signatureCertificate = GMSSLUtils.getCertificateMessage(crypto, keyManager.getCertificateChain(signatureAlias));
            Certificate encryptionCertificate = GMSSLUtils.getCertificateMessage(crypto, keyManager.getCertificateChain(encryptionAlias));
            Certificate gmsslCertificate = GMSSLUtils.makeGMSSLCertificate(signatureCertificate, encryptionCertificate);
            return new BcDefaultTlsCredentialedECCSM2(new TlsCryptoParameters(context), crypto, gmsslCertificate, signaturePrivateKey, encryptionPrivateKey, sigAlg);
        }
        return null;
    }

    public static Certificate makeGMSSLCertificate(Certificate signatureCertificate, Certificate encryptionCertificate) {
        TlsCertificate certificateAt;
        int i;
        ArrayList<TlsCertificate> list = new ArrayList<TlsCertificate>();
        list.add(signatureCertificate.getCertificateAt(0));
        list.add(encryptionCertificate.getCertificateAt(0));
        ArrayList<BigInteger> sns = new ArrayList<BigInteger>();
        for (i = 1; i < signatureCertificate.getLength(); ++i) {
            certificateAt = signatureCertificate.getCertificateAt(i);
            list.add(certificateAt);
            sns.add(certificateAt.getSerialNumber());
        }
        for (i = 1; i < encryptionCertificate.getLength(); ++i) {
            certificateAt = encryptionCertificate.getCertificateAt(i);
            if (sns.contains(certificateAt.getSerialNumber())) continue;
            list.add(certificateAt);
        }
        TlsCertificate[] tlsCertificates = list.toArray(new TlsCertificate[list.size()]);
        return new Certificate(tlsCertificates);
    }

    public static TlsCertificate getSignatureCertificate(Certificate gmsslCertificate) {
        return gmsslCertificate.getCertificateAt(0);
    }

    public static TlsCertificate getEncryptionCertificate(Certificate gmsslCertificate) {
        return gmsslCertificate.getCertificateAt(1);
    }

    public static String getSignatureAlias(String keyType, X509KeyManager keyManager, TlsCrypto crypto, TlsContext context) throws IOException {
        return GMSSLUtils.getAliasWithKeyUsage(keyType, 192, keyManager, crypto, context);
    }

    public static String getEncryptioneAlias(String keyType, X509KeyManager keyManager, TlsCrypto crypto, TlsContext context) throws IOException {
        return GMSSLUtils.getAliasWithKeyUsage(keyType, 56, keyManager, crypto, context);
    }

    public static String getAliasWithKeyUsage(String keyType, int keyUsage, X509KeyManager keyManager, TlsCrypto crypto, TlsContext context) throws IOException {
        String[] aliases = context.isServer() ? keyManager.getServerAliases(keyType, null) : keyManager.getClientAliases(keyType, null);
        if (aliases == null) {
            throw new IOException("key manager get aliases is null, check your key manager set!");
        }
        if (aliases.length == 1) {
            return aliases[0];
        }
        if (aliases.length != 2) {
            return null;
        }
        for (String alias : aliases) {
            int bits;
            KeyUsage ku;
            Certificate certificate = GMSSLUtils.getCertificateMessage(crypto, keyManager.getCertificateChain(alias));
            TlsCertificate tlsCertificate = certificate.getCertificateAt(0);
            byte[] encoding = tlsCertificate.getEncoded();
            Extensions exts = org.bouncycastle.asn1.x509.Certificate.getInstance((Object)encoding).getTBSCertificate().getExtensions();
            if (exts == null || (ku = KeyUsage.fromExtensions((Extensions)exts)) == null || ((bits = ku.getBytes()[0] & 0xFF) & keyUsage) != keyUsage) continue;
            return alias;
        }
        return null;
    }

    public static Certificate getCertificateMessage(TlsCrypto crypto, X509Certificate[] chain) throws IOException {
        if (chain == null || chain.length < 1) {
            return Certificate.EMPTY_CHAIN;
        }
        TlsCertificate[] certificateList = new TlsCertificate[chain.length];
        try {
            for (int i = 0; i < chain.length; ++i) {
                certificateList[i] = crypto.createCertificate(chain[i].getEncoded());
            }
        }
        catch (CertificateEncodingException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
        return new Certificate(certificateList);
    }

    static byte[] generateECCSM2ServerKeyExchangeSignature(TlsContext context, TlsCredentialedSigner credentials, TlsCertificate encryptionCertificate) throws IOException {
        byte[] m = GMSSLUtils.calculateSignatureECCSM2(context, encryptionCertificate);
        byte[] signature = credentials.generateRawSignature(m);
        return signature;
    }

    static void verifyECCSM2ServerKeyExchangeSignature(TlsContext context, TlsVerifier verifier, DigitallySigned signedParams, TlsCertificate encryptionCertificate) throws IOException {
        byte[] m = GMSSLUtils.calculateSignatureECCSM2(context, encryptionCertificate);
        boolean verified = verifier.verifyRawSignature(signedParams, m);
        if (!verified) {
            logger.error("verifyServerKeyExchangeSignature: verified {}", (Object)verified);
            throw new TlsFatalAlert(51);
        }
    }

    static byte[] calculateSignatureECCSM2(TlsContext context, TlsCertificate encryptionCertificate) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        SecurityParameters securityParameters = context.getSecurityParameters();
        output.write(securityParameters.clientRandom);
        output.write(securityParameters.serverRandom);
        byte[] cb = encryptionCertificate.getEncoded();
        TlsUtils.writeOpaque24(cb, output);
        return output.toByteArray();
    }

    static byte[] generateCertificateVerify(TlsContext context, TlsCredentialedSigner credentialedSigner, TlsStreamSigner streamSigner, TlsHandshakeHash handshakeHash) throws IOException {
        byte[] hash = handshakeHash.getFinalHash((short)7);
        byte[] signature = credentialedSigner.generateRawSignature(hash);
        return signature;
    }

    static void verifyCertificateVerify(TlsContext context, CertificateRequest certificateRequest, Certificate certificate, ByteArrayInputStream buf, TlsHandshakeHash handshakeHash) throws IOException {
        DigitallySigned signedParams;
        byte[] certificateVerify = TlsUtils.readOpaque16(buf);
        byte[] hash = handshakeHash.getFinalHash((short)7);
        TlsVerifier verifier = certificate.getCertificateAt(0).createVerifier((short)4);
        boolean verified = verifier.verifyRawSignature(signedParams = new DigitallySigned(new SignatureAndHashAlgorithm(7, 4), certificateVerify), hash);
        if (!verified) {
            logger.error("verifyCertificateVerify verified: {}" + verified);
            throw new TlsFatalAlert(51);
        }
    }
}

