/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.tls.AbstractTlsKeyExchange;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.DigestInputBuffer;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.ServerSRPParams;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsSRPConfigVerifier;
import org.bouncycastle.tls.TlsSRPLoginParameters;
import org.bouncycastle.tls.TlsSRPUtils;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsSRP6Client;
import org.bouncycastle.tls.crypto.TlsSRP6Server;
import org.bouncycastle.tls.crypto.TlsSRPConfig;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.TlsVerifier;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.io.TeeInputStream;

public class TlsSRPKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsSRPConfigVerifier srpConfigVerifier;
    protected byte[] identity;
    protected byte[] password;
    protected TlsSRPConfig srpConfig = null;
    protected TlsSRP6Client srpClient = null;
    protected TlsSRP6Server srpServer = null;
    protected BigInteger srpPeerCredentials = null;
    protected BigInteger srpVerifier = null;
    protected byte[] srpSalt = null;
    protected TlsCredentialedSigner serverCredentials = null;
    protected TlsVerifier verifier = null;

    private static int checkKeyExchange(int keyExchange) {
        switch (keyExchange) {
            case 21: 
            case 22: 
            case 23: {
                return keyExchange;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsSRPKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsSRPConfigVerifier srpConfigVerifier, byte[] identity, byte[] password) {
        super(TlsSRPKeyExchange.checkKeyExchange(keyExchange), supportedSignatureAlgorithms);
        this.srpConfigVerifier = srpConfigVerifier;
        this.identity = identity;
        this.password = password;
    }

    public TlsSRPKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, byte[] identity, TlsSRPLoginParameters loginParameters) {
        super(TlsSRPKeyExchange.checkKeyExchange(keyExchange), supportedSignatureAlgorithms);
        this.identity = identity;
        this.srpConfig = loginParameters.getConfig();
        this.srpVerifier = loginParameters.getVerifier();
        this.srpSalt = loginParameters.getSalt();
    }

    @Override
    public void skipServerCredentials() throws IOException {
        if (this.keyExchange != 21) {
            throw new TlsFatalAlert(80);
        }
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        if (this.keyExchange == 21) {
            throw new TlsFatalAlert(80);
        }
        if (!(serverCredentials instanceof TlsCredentialedSigner)) {
            throw new TlsFatalAlert(80);
        }
        this.serverCredentials = (TlsCredentialedSigner)serverCredentials;
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (this.keyExchange == 21) {
            throw new TlsFatalAlert(80);
        }
        if (serverCertificate.isEmpty()) {
            throw new TlsFatalAlert(42);
        }
        this.checkServerCertSigAlg(serverCertificate);
        this.verifier = serverCertificate.getCertificateAt(0).createVerifier(TlsUtils.getSignatureAlgorithm(this.keyExchange));
    }

    @Override
    public boolean requiresServerKeyExchange() {
        return true;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        this.srpServer = this.context.getCrypto().createSRP6Server(this.srpConfig, this.srpVerifier);
        BigInteger B = this.srpServer.generateServerCredentials();
        BigInteger[] ng = this.srpConfig.getExplicitNG();
        ServerSRPParams srpParams = new ServerSRPParams(ng[0], ng[1], this.srpSalt, B);
        DigestInputBuffer buf = new DigestInputBuffer();
        srpParams.encode(buf);
        if (this.serverCredentials != null) {
            DigitallySigned signedParams = TlsUtils.generateServerKeyExchangeSignature(this.context, this.serverCredentials, buf);
            signedParams.encode(buf);
        }
        return buf.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        DigestInputBuffer buf = null;
        InputStream teeIn = input;
        if (this.keyExchange != 21) {
            buf = new DigestInputBuffer();
            teeIn = new TeeInputStream(input, (OutputStream)buf);
        }
        ServerSRPParams srpParams = ServerSRPParams.parse(teeIn);
        if (buf != null) {
            DigitallySigned signedParams = this.parseSignature(input);
            TlsUtils.verifyServerKeyExchangeSignature(this.context, this.verifier, buf, signedParams);
        }
        this.srpConfig = new TlsSRPConfig();
        this.srpConfig.setExplicitNG(new BigInteger[]{srpParams.getN(), srpParams.getG()});
        if (!this.srpConfigVerifier.accept(this.srpConfig)) {
            throw new TlsFatalAlert(71);
        }
        this.srpSalt = srpParams.getS();
        this.srpPeerCredentials = TlsSRPKeyExchange.validatePublicValue(srpParams.getN(), srpParams.getB());
        this.srpClient = this.context.getCrypto().createSRP6Client(this.srpConfig);
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void generateClientKeyExchange(OutputStream output) throws IOException {
        BigInteger A = this.srpClient.generateClientCredentials(this.srpSalt, this.identity, this.password);
        TlsSRPUtils.writeSRPParameter(A, output);
        this.context.getSecurityParameters().srpIdentity = Arrays.clone((byte[])this.identity);
    }

    @Override
    public void processClientKeyExchange(InputStream input) throws IOException {
        this.srpPeerCredentials = TlsSRPKeyExchange.validatePublicValue(this.srpConfig.getExplicitNG()[0], TlsSRPUtils.readSRPParameter(input));
        this.context.getSecurityParameters().srpIdentity = Arrays.clone((byte[])this.identity);
    }

    @Override
    public TlsSecret generatePreMasterSecret() throws IOException {
        BigInteger S = this.srpServer != null ? this.srpServer.calculateSecret(this.srpPeerCredentials) : this.srpClient.calculateSecret(this.srpPeerCredentials);
        return this.context.getCrypto().createSecret(BigIntegers.asUnsignedByteArray((BigInteger)S));
    }

    public static BigInteger validatePublicValue(BigInteger N, BigInteger val) throws IOException {
        if ((val = val.mod(N)).equals(BigInteger.ZERO)) {
            throw new TlsFatalAlert(47);
        }
        return val;
    }
}

