/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;

class ProvSSLParameters {
    private final ProvSSLContextSpi context;
    private String[] cipherSuites;
    private String[] protocols;
    private boolean needClientAuth = false;
    private boolean wantClientAuth = false;
    private Object algorithmConstraints;
    private String endpointIdentificationAlgorithm;
    private boolean useCipherSuitesOrder;
    private List<BCSNIMatcher> sniMatchers;
    private List<BCSNIServerName> sniServerNames;

    private static <T> List<T> copyList(Collection<T> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    ProvSSLParameters(ProvSSLContextSpi context, String[] cipherSuites, String[] protocols) {
        this.context = context;
        this.cipherSuites = cipherSuites;
        this.protocols = protocols;
    }

    ProvSSLParameters copy() {
        ProvSSLParameters p = new ProvSSLParameters(this.context, this.cipherSuites, this.protocols);
        p.needClientAuth = this.needClientAuth;
        p.wantClientAuth = this.wantClientAuth;
        p.algorithmConstraints = this.algorithmConstraints;
        p.endpointIdentificationAlgorithm = this.endpointIdentificationAlgorithm;
        p.useCipherSuitesOrder = this.useCipherSuitesOrder;
        p.sniMatchers = this.sniMatchers;
        p.sniServerNames = this.sniServerNames;
        return p;
    }

    public void setCipherSuites(String[] cipherSuites) {
        if (!this.context.isSupportedCipherSuites(cipherSuites)) {
            throw new IllegalArgumentException("'cipherSuites' cannot be null, or contain unsupported cipher suites");
        }
        this.cipherSuites = (String[])cipherSuites.clone();
    }

    public void setProtocols(String[] protocols) {
        if (!this.context.isSupportedProtocols(protocols)) {
            throw new IllegalArgumentException("'protocols' cannot be null, or contain unsupported protocols");
        }
        this.protocols = (String[])protocols.clone();
    }

    void setProtocolsArray(String[] protocols) {
        this.protocols = protocols;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
        this.wantClientAuth = false;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.needClientAuth = false;
        this.wantClientAuth = wantClientAuth;
    }

    public String[] getCipherSuites() {
        return (String[])this.cipherSuites.clone();
    }

    public String[] getProtocols() {
        return (String[])this.protocols.clone();
    }

    String[] getProtocolsArray() {
        return this.protocols;
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public Object getAlgorithmConstraints() {
        return this.algorithmConstraints;
    }

    public void setAlgorithmConstraints(Object algorithmConstraints) {
        this.algorithmConstraints = algorithmConstraints;
    }

    public String getEndpointIdentificationAlgorithm() {
        return this.endpointIdentificationAlgorithm;
    }

    public void setEndpointIdentificationAlgorithm(String endpointIdentificationAlgorithm) {
        this.endpointIdentificationAlgorithm = endpointIdentificationAlgorithm;
    }

    public boolean getUseCipherSuitesOrder() {
        return this.useCipherSuitesOrder;
    }

    public void setUseCipherSuitesOrder(boolean honorOrder) {
        this.useCipherSuitesOrder = honorOrder;
    }

    public List<BCSNIServerName> getServerNames() {
        return ProvSSLParameters.copyList(this.sniServerNames);
    }

    public void setServerNames(List<BCSNIServerName> serverNames) {
        this.sniServerNames = ProvSSLParameters.copyList(serverNames);
    }

    public Collection<BCSNIMatcher> getSNIMatchers() {
        return ProvSSLParameters.copyList(this.sniMatchers);
    }

    public void setSNIMatchers(Collection<BCSNIMatcher> matchers) {
        this.sniMatchers = ProvSSLParameters.copyList(matchers);
    }
}

