/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.ProvSSLSessionImpl;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.SupportedGroups;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.DefaultTlsServer;
import org.bouncycastle.tls.GMSSLUtils;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.ServerNameList;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsDHUtils;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedAgreement;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedDecryptor;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCryptoSdf;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaDefaultTlsCredentialedSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JceDefaultTlsCredentialedAgreement;
import org.bouncycastle.tls.crypto.impl.jcajce.JceDefaultTlsCredentialedDecryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvTlsServer
extends DefaultTlsServer
implements ProvTlsPeer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int provEphemeralDHKeySize = PropertyUtils.getIntegerSystemProperty("jdk.tls.ephemeralDHKeySize", 2048, 1024, 8192);
    protected final ProvTlsManager manager;
    protected final ProvSSLParameters sslParameters;
    protected ProvSSLSessionImpl sslSession = null;
    protected BCSNIServerName matchedSNIServerName = null;
    protected Set<String> keyManagerMissCache = null;
    protected TlsCredentials credentials = null;
    protected boolean handshakeComplete = false;

    ProvTlsServer(ProvTlsManager manager, ProvSSLParameters sslParameters) throws SSLException {
        super(manager.getContextData().getCrypto());
        this.manager = manager;
        this.sslParameters = sslParameters;
        if (!manager.getEnableSessionCreation()) {
            throw new SSLException("Session resumption not implemented yet and session creation is disabled");
        }
    }

    @Override
    protected int getMaximumNegotiableCurveBits() {
        return SupportedGroups.getServerMaximumNegotiableCurveBits(this.manager.getContext().isFips(), this.clientSupportedGroups);
    }

    @Override
    protected int getMaximumNegotiableFiniteFieldBits() {
        int maxBits = SupportedGroups.getServerMaximumNegotiableFiniteFieldBits(this.manager.getContext().isFips(), this.clientSupportedGroups);
        return maxBits >= provEphemeralDHKeySize ? maxBits : 0;
    }

    @Override
    protected ProtocolVersion getMaximumVersion() {
        return this.manager.getContext().getMaximumVersion(this.sslParameters.getProtocols());
    }

    @Override
    protected boolean selectCipherSuite(int cipherSuite) throws IOException {
        if (!this.selectCredentials(cipherSuite)) {
            return false;
        }
        this.manager.getContext().validateNegotiatedCipherSuite(cipherSuite);
        return super.selectCipherSuite(cipherSuite);
    }

    @Override
    protected int selectCurve(int minimumCurveBits) {
        if (this.clientSupportedGroups == null) {
            return this.selectDefaultCurve(minimumCurveBits);
        }
        boolean isFips = this.manager.getContext().isFips();
        return SupportedGroups.getServerSelectedCurve(isFips, minimumCurveBits, this.clientSupportedGroups);
    }

    @Override
    protected int selectDefaultCurve(int minimumCurveBits) {
        return SupportedGroups.getServerDefaultCurve(this.manager.getContext().isFips(), minimumCurveBits);
    }

    @Override
    protected TlsDHConfig selectDefaultDHConfig(int minimumFiniteFieldBits) {
        return SupportedGroups.getServerDefaultDHConfig(this.manager.getContext().isFips(), minimumFiniteFieldBits);
    }

    @Override
    protected TlsDHConfig selectDHConfig(int minimumFiniteFieldBits) {
        minimumFiniteFieldBits = Math.max(minimumFiniteFieldBits, provEphemeralDHKeySize);
        if (this.clientSupportedGroups == null) {
            return this.selectDefaultDHConfig(minimumFiniteFieldBits);
        }
        boolean isFips = this.manager.getContext().isFips();
        int namedGroup = SupportedGroups.getServerSelectedFiniteField(isFips, minimumFiniteFieldBits, this.clientSupportedGroups);
        return TlsDHUtils.createNamedDHConfig(namedGroup);
    }

    @Override
    public synchronized boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    @Override
    public TlsCredentials getCredentials() throws IOException {
        return this.credentials;
    }

    @Override
    public int[] getCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.manager.getContextData().getCrypto(), this.manager.getContext().convertCipherSuites(this.sslParameters.getCipherSuites()));
    }

    @Override
    protected short[] getCompressionMethods() {
        short[] sArray;
        if (this.manager.getContext().isFips()) {
            short[] sArray2 = new short[1];
            sArray = sArray2;
            sArray2[0] = 0;
        } else {
            sArray = super.getCompressionMethods();
        }
        return sArray;
    }

    @Override
    public CertificateRequest getCertificateRequest() throws IOException {
        boolean shouldRequest;
        boolean bl = shouldRequest = this.sslParameters.getNeedClientAuth() || this.sslParameters.getWantClientAuth();
        if (!shouldRequest) {
            return null;
        }
        short[] certificateTypes = new short[]{1, 2, 64, 80};
        Vector serverSigAlgs = null;
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(this.serverVersion)) {
            serverSigAlgs = JsseUtils.getSupportedSignatureAlgorithms(this.getCrypto());
        }
        Vector<X500Name> certificateAuthorities = new Vector<X500Name>();
        X509TrustManager tm = this.manager.getContextData().getTrustManager();
        if (tm != null) {
            for (X509Certificate caCert : tm.getAcceptedIssuers()) {
                certificateAuthorities.addElement(X500Name.getInstance((Object)caCert.getSubjectX500Principal().getEncoded()));
            }
        }
        return new CertificateRequest(certificateTypes, serverSigAlgs, certificateAuthorities);
    }

    @Override
    public int getSelectedCipherSuite() throws IOException {
        this.keyManagerMissCache = new HashSet<String>();
        int selectedCipherSuite = super.getSelectedCipherSuite();
        this.keyManagerMissCache = null;
        return selectedCipherSuite;
    }

    @Override
    public Hashtable getServerExtensions() throws IOException {
        super.getServerExtensions();
        if (this.matchedSNIServerName != null) {
            this.checkServerExtensions().put(TlsExtensionsUtils.EXT_server_name, TlsExtensionsUtils.createEmptyExtensionData());
        }
        return this.serverExtensions;
    }

    @Override
    public TlsSession getSessionToResume(byte[] sessionID) {
        TlsSession sessionToResume;
        ProvSSLSessionContext sessionContext = this.manager.getContextData().getServerSessionContext();
        this.sslSession = sessionContext.getSessionImpl(sessionID);
        if (this.sslSession != null && (sessionToResume = this.sslSession.getTlsSession()) != null) {
            return sessionToResume;
        }
        if (!this.manager.getEnableSessionCreation()) {
            throw new IllegalStateException("No resumable sessions and session creation is disabled");
        }
        return null;
    }

    @Override
    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        String msg = JsseUtils.getAlertLogMessage("Server raised", alertLevel, alertDescription);
        if (message != null) {
            msg = msg + ": " + message;
        }
        if (alertLevel == 1 || alertDescription == 80) {
            this.logger.warn(msg, cause);
        } else if (alertLevel == 2) {
            this.logger.error(msg, cause);
        } else {
            this.logger.info(msg, cause);
        }
    }

    @Override
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        super.notifyAlertReceived(alertLevel, alertDescription);
        String msg = JsseUtils.getAlertLogMessage("Server received", alertLevel, alertDescription);
        if (alertLevel == 1) {
            this.logger.warn(msg);
        } else {
            this.logger.info(msg);
        }
    }

    @Override
    public ProtocolVersion getServerVersion() throws IOException {
        ProtocolVersion version;
        String[] protocols = this.sslParameters.getProtocols();
        if (protocols != null && protocols.length > 0 && (version = this.clientVersion) != null) {
            version = version.getPreviousVersion();
            String versionString = this.manager.getContext().getProtocolString(version);
            if (versionString != null && JsseUtils.contains(protocols, versionString)) {
                this.serverVersion = version;
                return this.serverVersion;
            }
        }
        throw new TlsFatalAlert(70);
    }

    @Override
    public void notifyClientCertificate(Certificate clientCertificate) throws IOException {
        boolean noClientCert;
        assert (this.sslParameters.getNeedClientAuth() || this.sslParameters.getWantClientAuth());
        boolean bl = noClientCert = clientCertificate == null || clientCertificate.isEmpty();
        if (noClientCert) {
            if (this.sslParameters.getNeedClientAuth()) {
                this.logger.info("client cert is null!");
                throw new TlsFatalAlert(40);
            }
        } else {
            short clientCertificateType;
            String authType;
            X509Certificate[] chain = JsseUtils.getX509CertificateChain(this.manager.getContextData().getCrypto(), clientCertificate);
            if (!this.manager.isClientTrusted(chain, authType = JsseUtils.getAuthTypeClient(clientCertificateType = clientCertificate.getCertificateAt(0).getClientCertificateType()))) {
                this.logger.info("client cert not trust! subjectDN={} sn={} issueDN={} alert bad_certificate", new Object[]{chain[0].getSubjectDN().toString(), chain[0].getSerialNumber(), chain[0].getIssuerDN().toString()});
                throw new TlsFatalAlert(42);
            }
        }
    }

    @Override
    public synchronized void notifyHandshakeComplete() throws IOException {
        this.handshakeComplete = true;
        TlsSession handshakeSession = this.context.getSession();
        if (this.sslSession == null || this.sslSession.getTlsSession() != handshakeSession) {
            this.sslSession = this.manager.getContextData().getServerSessionContext().reportSession(handshakeSession, null, -1);
        }
        this.manager.notifyHandshakeComplete(new ProvSSLConnection(this.context, this.sslSession));
    }

    @Override
    public void notifySecureRenegotiation(boolean secureRenegotiation) throws IOException {
        boolean allowLegacyHelloMessages;
        if (!secureRenegotiation && !(allowLegacyHelloMessages = PropertyUtils.getBooleanSystemProperty("sun.security.ssl.allowLegacyHelloMessages", true))) {
            throw new TlsFatalAlert(40);
        }
    }

    @Override
    public void processClientExtensions(Hashtable clientExtensions) throws IOException {
        ServerNameList serverNameList;
        Collection<BCSNIMatcher> sniMatchers;
        super.processClientExtensions(clientExtensions);
        if (clientExtensions != null && (sniMatchers = this.sslParameters.getSNIMatchers()) != null && !sniMatchers.isEmpty() && (serverNameList = TlsExtensionsUtils.getServerNameExtension(clientExtensions)) != null) {
            this.matchedSNIServerName = JsseUtils.findMatchingSNIServerName(serverNameList, sniMatchers);
            if (this.matchedSNIServerName == null) {
                throw new TlsFatalAlert(112);
            }
        }
    }

    protected boolean selectCredentials(int cipherSuite) throws IOException {
        this.credentials = null;
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(cipherSuite);
        switch (keyExchangeAlgorithm) {
            case 11: 
            case 20: {
                return true;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return this.generateCredentials(keyExchangeAlgorithm);
            }
            case 101: {
                return this.generateCredentialsGMSSL(keyExchangeAlgorithm);
            }
        }
        return false;
    }

    private boolean generateCredentialsGMSSL(int keyExchangeAlgorithm) throws IOException {
        if (!(this.getCrypto() instanceof BcTlsCrypto) && !(this.getCrypto() instanceof BcTlsCryptoSdf)) {
            throw new TlsFatalAlert(80);
        }
        short signatureAlgorithm = TlsUtils.getSignatureAlgorithm(keyExchangeAlgorithm);
        SignatureAndHashAlgorithm sigAlg = TlsUtils.chooseSignatureAndHashAlgorithm(this.context, this.supportedSignatureAlgorithms, signatureAlgorithm);
        X509KeyManager keyManager = this.manager.getContextData().getKeyManager();
        if (keyManager == null) {
            this.logger.info("generate credentials gmssl x509 keyManager is null!");
            return false;
        }
        X509TrustManager trustManager = this.manager.getContextData().getTrustManager();
        if (trustManager == null) {
            this.logger.info("generate credentials gmssl x509 trustManager is null!");
            return false;
        }
        String keyType = JsseUtils.getAuthTypeServer(keyExchangeAlgorithm);
        if (this.keyManagerMissCache.contains(keyType)) {
            this.logger.info("generate credentials keyType: " + keyType + " keyManagerMissCache: " + this.keyManagerMissCache);
            return false;
        }
        this.credentials = GMSSLUtils.generateCredentials(keyType, (AbstractTlsCrypto)this.getCrypto(), keyManager, sigAlg, this.context);
        return this.credentials != null;
    }

    private boolean generateCredentials(int keyExchangeAlgorithm) throws IOException {
        X509KeyManager km = this.manager.getContextData().getKeyManager();
        if (km == null) {
            return false;
        }
        String keyType = JsseUtils.getAuthTypeServer(keyExchangeAlgorithm);
        if (this.keyManagerMissCache.contains(keyType)) {
            return false;
        }
        Principal[] issuers = null;
        Socket socket = null;
        String alias = km.chooseServerAlias(keyType, issuers, socket);
        if (alias == null) {
            this.keyManagerMissCache.add(keyType);
            return false;
        }
        TlsCrypto crypto = this.getCrypto();
        if (!(crypto instanceof JcaTlsCrypto) && !(crypto instanceof BcTlsCrypto)) {
            throw new UnsupportedOperationException();
        }
        PrivateKey privateKey = km.getPrivateKey(alias);
        Certificate certificate = JsseUtils.getCertificateMessage(crypto, km.getCertificateChain(alias));
        if (privateKey == null || !JsseUtils.isUsableKeyForServer(keyExchangeAlgorithm, privateKey) || certificate.isEmpty()) {
            this.keyManagerMissCache.add(keyType);
            return false;
        }
        switch (keyExchangeAlgorithm) {
            case 7: 
            case 9: 
            case 16: 
            case 18: {
                if (crypto instanceof JcaTlsCrypto) {
                    this.credentials = new JceDefaultTlsCredentialedAgreement((JcaTlsCrypto)crypto, certificate, privateKey);
                } else {
                    AsymmetricKeyParameter parameter = PrivateKeyFactory.createKey((PrivateKeyInfo)PrivateKeyInfo.getInstance((Object)privateKey.getEncoded()));
                    this.credentials = new BcDefaultTlsCredentialedAgreement((BcTlsCrypto)crypto, certificate, parameter);
                }
                return true;
            }
            case 3: 
            case 5: 
            case 17: 
            case 19: {
                short signatureAlgorithm = TlsUtils.getSignatureAlgorithm(keyExchangeAlgorithm);
                SignatureAndHashAlgorithm sigAlg = TlsUtils.chooseSignatureAndHashAlgorithm(this.context, this.supportedSignatureAlgorithms, signatureAlgorithm);
                if (crypto instanceof JcaTlsCrypto) {
                    this.credentials = new JcaDefaultTlsCredentialedSigner(new TlsCryptoParameters(this.context), (JcaTlsCrypto)crypto, privateKey, certificate, sigAlg);
                } else {
                    AsymmetricKeyParameter parameter = PrivateKeyFactory.createKey((PrivateKeyInfo)PrivateKeyInfo.getInstance((Object)privateKey.getEncoded()));
                    this.credentials = new BcDefaultTlsCredentialedSigner(new TlsCryptoParameters(this.context), (BcTlsCrypto)crypto, parameter, certificate, sigAlg);
                }
                return true;
            }
            case 1: {
                if (crypto instanceof JcaTlsCrypto) {
                    this.credentials = new JceDefaultTlsCredentialedDecryptor((JcaTlsCrypto)crypto, certificate, privateKey);
                } else {
                    AsymmetricKeyParameter parameter = PrivateKeyFactory.createKey((PrivateKeyInfo)PrivateKeyInfo.getInstance((Object)privateKey.getEncoded()));
                    this.credentials = new BcDefaultTlsCredentialedDecryptor((BcTlsCrypto)crypto, certificate, parameter);
                }
                return true;
            }
        }
        return false;
    }
}

