/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfECEngine;
import com.xdja.pki.gmssl.crypto.sdf.SdfECKeyParameters;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2EncryptUtils;
import java.io.IOException;
import java.security.PrivateKey;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.DefaultTlsCredentialedSigner;
import org.bouncycastle.tls.GMSSLUtils;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.TlsSigner;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCryptoSdf;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSM2Signer;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSM2SignerSdf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BcDefaultTlsCredentialedECCSM2
extends DefaultTlsCredentialedSigner
implements TlsCredentialedDecryptor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected AbstractTlsCrypto crypto;
    protected PrivateKey signaturePrivateKey;
    protected PrivateKey encryptionPrivateKey;
    protected Certificate gmsslCertificate;

    private static TlsSigner makeSigner(AbstractTlsCrypto crypto, PrivateKey privateKey) {
        if (crypto instanceof BcTlsCrypto) {
            AsymmetricKeyParameter parameter;
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)privateKey.getEncoded());
            if (privateKeyInfo == null) {
                throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
            }
            try {
                parameter = PrivateKeyFactory.createKey((PrivateKeyInfo)privateKeyInfo);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
            }
            if (!(parameter instanceof ECPrivateKeyParameters)) {
                throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
            }
            BcTlsSM2Signer signer = new BcTlsSM2Signer((BcTlsCrypto)crypto, parameter);
            return signer;
        }
        if (crypto instanceof BcTlsCryptoSdf) {
            if (!(privateKey instanceof SdfPrivateKey)) {
                throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
            }
            return new BcTlsSM2SignerSdf((BcTlsCryptoSdf)crypto, (AsymmetricKeyParameter)new SdfECKeyParameters((SdfPrivateKey)privateKey));
        }
        throw new IllegalArgumentException("un supported: " + crypto.getClass().getName());
    }

    private static Certificate makeSignerCertificate(Certificate gmsslCertificate) {
        return new Certificate(new TlsCertificate[]{GMSSLUtils.getSignatureCertificate(gmsslCertificate)});
    }

    public BcDefaultTlsCredentialedECCSM2(TlsCryptoParameters cryptoParams, AbstractTlsCrypto crypto, Certificate gmsslCertificate, PrivateKey signaturePrivateKey, PrivateKey encryptionPrivateKey, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        super(cryptoParams, BcDefaultTlsCredentialedECCSM2.makeSigner(crypto, signaturePrivateKey), BcDefaultTlsCredentialedECCSM2.makeSignerCertificate(gmsslCertificate), signatureAndHashAlgorithm);
        this.gmsslCertificate = gmsslCertificate;
        this.signaturePrivateKey = signaturePrivateKey;
        this.encryptionPrivateKey = encryptionPrivateKey;
        this.crypto = crypto;
    }

    @Override
    public Certificate getCertificate() {
        return this.gmsslCertificate;
    }

    @Override
    public TlsSecret decrypt(TlsCryptoParameters cryptoParams, byte[] ciphertext) throws IOException {
        if (this.crypto instanceof BcTlsCrypto) {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)this.encryptionPrivateKey.getEncoded());
            if (privateKeyInfo == null) {
                throw new IllegalArgumentException("'privateKey' type not supported: " + this.encryptionPrivateKey.getClass().getName());
            }
            AsymmetricKeyParameter parameter = PrivateKeyFactory.createKey((PrivateKeyInfo)privateKeyInfo);
            return this.safeDecryptPreMasterSecret((ECKeyParameters)parameter, ciphertext);
        }
        if (this.crypto instanceof BcTlsCryptoSdf) {
            return this.safeDecryptPreMasterSecretSdf((BcTlsCryptoSdf)this.crypto, ciphertext);
        }
        throw new IllegalArgumentException("'crypto' type not supported: " + this.crypto.getClass().getName());
    }

    protected TlsSecret safeDecryptPreMasterSecret(ECKeyParameters ecServerPrivateKey, byte[] encryptedPreMasterSecret) throws TlsFatalAlert {
        try {
            byte[] M = GMSSLSM2EncryptUtils.decryptASN1ByBC((ECKeyParameters)ecServerPrivateKey, (byte[])encryptedPreMasterSecret);
            return this.crypto.createSecret(M);
        }
        catch (Exception e) {
            GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"ecServerPrivateKey s: ", (byte[])ecServerPrivateKey.getParameters().getH().toByteArray());
            GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"encryptedPreMasterSecret", (byte[])encryptedPreMasterSecret);
            throw new TlsFatalAlert(51, (Throwable)e);
        }
    }

    protected TlsSecret safeDecryptPreMasterSecretSdf(BcTlsCryptoSdf crypto, byte[] encryptedPreMasterSecret) throws TlsFatalAlert {
        SdfPrivateKey pPrivateKey = (SdfPrivateKey)this.signaturePrivateKey;
        try {
            SdfECKeyParameters parameters = new SdfECKeyParameters(pPrivateKey);
            SdfECEngine sdfECEngine = new SdfECEngine(crypto.getSdfCryptoType());
            sdfECEngine.init(false, (CipherParameters)parameters);
            byte[] M = sdfECEngine.decryptASN1(encryptedPreMasterSecret);
            sdfECEngine.release();
            return crypto.createSecret(M);
        }
        catch (Exception e) {
            this.logger.debug("private key index: {}", (Object)pPrivateKey.getIndex());
            this.logger.debug("private key password: {}", (Object)pPrivateKey.getPassword());
            GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"encryptedPreMasterSecret", (byte[])encryptedPreMasterSecret);
            throw new TlsFatalAlert(51, (Throwable)e);
        }
    }

    public TlsCertificate getSignatureCertificate() {
        return GMSSLUtils.getSignatureCertificate(this.gmsslCertificate);
    }

    public TlsCertificate getEncryptionCertificate() {
        return GMSSLUtils.getEncryptionCertificate(this.gmsslCertificate);
    }
}

