/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.minipcie.demo;

import com.xdja.SafeKey.JNIAPI;
import com.xdja.SafeKey.MiniPcieFile;
import com.xdja.SafeKey.Sm2PrivateKey;
import com.xdja.SafeKey.Sm2PublicKey;
import com.xdja.SafeKey.bean.MiniPcieIndexEnum;
import com.xdja.SafeKey.utils.MiniPcieXKFUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLECUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLFileUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.minipcie.demo.MiniPcieCreateFile;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.util.encoders.Hex;

public class MiniPcieDemo {
    private static byte[] pubkeyId = Hex.decode((String)"002a");
    private static byte[] prikeyId = Hex.decode((String)"002b");
    private static String password = "111111";
    public static final String CREATE_FILE = "createFile";
    public static final String GENERATE_KEYPAIR = "generateKeyPair";
    public static final String ALL = "all";

    public static void main(String[] args) throws Exception {
        if (CREATE_FILE.equalsIgnoreCase(args[0])) {
            MiniPcieCreateFile.createFile(Integer.valueOf(args[1]));
        }
        if (GENERATE_KEYPAIR.equalsIgnoreCase(args[0])) {
            MiniPcieDemo.generateKey(Integer.valueOf(args[1]));
        }
        if (ALL.equalsIgnoreCase(args[0])) {
            MiniPcieDemo.generateRandom();
            MiniPcieDemo.sm1();
            MiniPcieDemo.sm4();
            MiniPcieDemo.sm2Decrypt();
            MiniPcieDemo.sm2Verify();
            MiniPcieDemo.writeCert();
            MiniPcieDemo.writeKeyPair();
            MiniPcieDemo.testGenerateKeyPair();
            MiniPcieDemo.getFileInfo();
        }
    }

    public static void generateKey(int fileId) throws Exception {
        MiniPcieXKFUtils.generateSm2KeyPairInContent((byte[])MiniPcieIndexEnum.getInfoFromIndex((int)fileId).getSignPublicKeyIndex(), (byte[])MiniPcieIndexEnum.getInfoFromIndex((int)fileId).getSignPrivateIndex());
        MiniPcieXKFUtils.generateSm2KeyPairInContent((byte[])MiniPcieIndexEnum.getInfoFromIndex((int)fileId).getEncPublicKeyIndex(), (byte[])MiniPcieIndexEnum.getInfoFromIndex((int)fileId).getEncPrivateIndex());
    }

    public static void generateRandom() throws Exception {
        System.out.println("\u5f00\u59cb\u901a\u8fc7\u8fde\u63a5\u6c60\u751f\u6210\u968f\u673a\u6570");
        long Time1 = System.nanoTime();
        byte[] bytes = MiniPcieXKFUtils.generateRandom((int)1211);
        long Time2 = System.nanoTime();
        System.out.println("Time2 - Time1 =" + (Time2 - Time1));
        System.out.println(Hex.toHexString((byte[])bytes));
        System.out.println("#################################");
        System.out.println("##########\u751f\u6210\u968f\u673a\u6570\u9700\u6c42\u5b8c\u6210#######");
        System.out.println("#################################");
    }

    public static void generateRandomWithoutPool() throws Exception {
        JNIAPI jniapi = new JNIAPI();
        int[] dev = new int[1];
        long[] handle = new long[1];
        long enumTime1 = System.nanoTime();
        jniapi.EnumDev(0, dev);
        long enumTime2 = System.nanoTime();
        jniapi.OpenDev(0, handle);
        byte[] data = new byte[1211];
        jniapi.GenRandom(handle[0], 1211, data);
        System.out.println(Hex.toHexString((byte[])data));
    }

    public static void sm1() throws Exception {
        byte[] key = MiniPcieXKFUtils.generateRandom((int)16);
        byte[] data = MiniPcieXKFUtils.generateRandom((int)32);
        byte[] out = MiniPcieXKFUtils.sm1((byte[])key, (byte[])data, (int)1, null);
        System.out.println(Hex.toHexString((byte[])out));
        System.out.println(out.length);
        System.out.println("#################################");
        System.out.println("##########sm1\u9700\u6c42\u5b8c\u6210#######");
        System.out.println("#################################");
    }

    public static void sm4() throws Exception {
        byte[] key = MiniPcieXKFUtils.generateRandom((int)16);
        byte[] data = MiniPcieXKFUtils.generateRandom((int)32);
        byte[] out = MiniPcieXKFUtils.sm4((byte[])key, (byte[])data, (int)1, null);
        System.out.println(Hex.toHexString((byte[])out));
        System.out.println(out.length);
        System.out.println("#################################");
        System.out.println("##########sm4\u9700\u6c42\u5b8c\u6210#######");
        System.out.println("#################################");
    }

    public static void writeCert() throws Exception {
        X509Certificate certificate = GMSSLX509Utils.readCertificateFromCer((String)GMSSLFileUtils.getResourceAsPath((String)"ca.cer"));
        byte[] certIndex = MiniPcieIndexEnum.getInfoFromIndex((int)1).getEncCertIndex();
        System.out.println(MiniPcieIndexEnum.getInfoFromIndex((int)1).encCertIndex);
        System.out.println(Hex.toHexString((byte[])certIndex));
        MiniPcieXKFUtils.writeCert((byte[])certificate.getEncoded(), (byte[])certIndex, (String)password);
        System.out.println("#################################");
        System.out.println("##########\u5199\u8bc1\u4e66\u9700\u6c42\u5b8c\u6210#######");
        System.out.println("#################################");
    }

    public static void readCert() throws Exception {
        X509Certificate certificate = GMSSLX509Utils.readCertificateFromCer((String)GMSSLFileUtils.getResourceAsPath((String)"ca.cer"));
        byte[] certIndex = MiniPcieIndexEnum.getInfoFromIndex((int)1).getEncCertIndex();
        System.out.println(MiniPcieIndexEnum.getInfoFromIndex((int)1).encCertIndex);
        System.out.println(Hex.toHexString((byte[])certIndex));
        byte[] bytes = MiniPcieXKFUtils.readCert((byte[])MiniPcieIndexEnum.getInfoFromIndex((int)1).getEncCertIndex());
        X509Certificate x509Certificate = GMSSLX509Utils.readCertificateFromCerByte((byte[])bytes);
        System.out.println(x509Certificate);
        System.out.println("#################################");
        System.out.println("##########\u8bfb\u8bc1\u4e66\u9700\u6c42\u5b8c\u6210#######");
        System.out.println("#################################");
    }

    public static void writeKeyPair() throws Exception {
        KeyPair keyPair = GMSSLX509Utils.generateSM2KeyPair();
        MiniPcieXKFUtils.verifyPin((byte[])"111111".getBytes());
        Sm2PublicKey sm2PublicKey = new Sm2PublicKey(keyPair.getPublic());
        MiniPcieXKFUtils.writeSm2PublicKey((byte[])pubkeyId, (String)"111111", (Sm2PublicKey)sm2PublicKey);
        Sm2PrivateKey sm2PrivateKey = new Sm2PrivateKey(keyPair.getPrivate());
        MiniPcieXKFUtils.writeSm2PrivateKey((byte[])prikeyId, (String)"111111", (Sm2PrivateKey)sm2PrivateKey);
        System.out.println(keyPair.getPublic());
        Sm2PublicKey export = MiniPcieXKFUtils.readSm2PublicKey((byte[])pubkeyId);
        System.out.println(export.getPublicKey(GMSSLECUtils.SM2p256));
        System.out.println(sm2PrivateKey.toString());
        System.out.println("#################################");
        System.out.println("##########\u5199\u5165\u5bc6\u94a5\u5bf9\u9700\u6c42\u5b8c\u6210#######");
        System.out.println("#################################");
    }

    public static void sm2Verify() throws Exception {
        byte[] data = "test".getBytes();
        byte[] hash = MiniPcieXKFUtils.sm3((byte[])data);
        byte[] sign = MiniPcieXKFUtils.sm2SignWithInternalHash((byte[])data, (byte[])pubkeyId, (byte[])prikeyId, (String)"111111");
        System.out.println(Hex.toHexString((byte[])sign));
        Sm2PublicKey sm2PublicKey = MiniPcieXKFUtils.readSm2PublicKey((byte[])pubkeyId);
        System.out.println(Hex.toHexString((byte[])sm2PublicKey.x));
        System.out.println(Hex.toHexString((byte[])sm2PublicKey.y));
        boolean b = MiniPcieXKFUtils.sm2VerifyWithInternalHash((byte[])data, (byte[])sign, (Sm2PublicKey)sm2PublicKey);
        if (b) {
            System.out.println("#################################");
            System.out.println("##########SM2\u9a8c\u7b7e\u9700\u6c42\u5b8c\u6210#######");
            System.out.println("#################################");
        } else {
            System.out.println("\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01");
            System.out.println("\uff01\uff01\uff01\uff01\uff01\uff01\uff01SM2\u9a8c\u7b7e\u9700\u6c42\u5931\u8d25\uff01\uff01\uff01\uff01\uff01");
            System.out.println("\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01");
        }
    }

    public static void testGenerateKeyPair() throws Exception {
        KeyPair keyPair = MiniPcieXKFUtils.generateSm2KeyPair();
        System.out.println(keyPair.getPublic());
        System.out.println(keyPair.getPrivate());
        System.out.println("#################################");
        System.out.println("##########\u751f\u6210\u5bc6\u94a5\u5bf9\u9700\u6c42\u5b8c\u6210#######");
        System.out.println("#################################");
    }

    public static void testGenerateKeyPairInContent() throws Exception {
        boolean t = MiniPcieXKFUtils.generateSm2KeyPairInContent((byte[])MiniPcieIndexEnum.getInfoFromIndex((int)1).getEncPublicKeyIndex(), (byte[])MiniPcieIndexEnum.getInfoFromIndex((int)1).getEncPrivateIndex());
    }

    public static void sm2Decrypt() throws Exception {
        Sm2PublicKey sm2PublicKey = MiniPcieXKFUtils.readSm2PublicKey((byte[])pubkeyId);
        byte[] data = "test".getBytes();
        byte[] out = MiniPcieXKFUtils.sm2Encrypt((byte[])data, (Sm2PublicKey)sm2PublicKey);
        System.out.println(Hex.toHexString((byte[])out));
        byte[] decrypt = MiniPcieXKFUtils.sm2Decrypt((byte[])out, (byte[])prikeyId, (String)password);
        System.out.println(new String(decrypt));
        System.out.println("#################################");
        System.out.println("##########SM2\u89e3\u5bc6\u9700\u6c42\u5b8c\u6210#######");
        System.out.println("#################################");
    }

    public static void writeSm2PrivateKey() throws Exception {
        KeyPair keyPair = GMSSLX509Utils.generateSM2KeyPair();
        byte[] keyId = Hex.decode((String)"0076");
        BCECPrivateKey privateKey = (BCECPrivateKey)keyPair.getPrivate();
        Sm2PrivateKey sm2PrivateKey = new Sm2PrivateKey(privateKey.getD().toByteArray());
        boolean b = MiniPcieXKFUtils.writeSm2PrivateKey((byte[])keyId, (String)"111111", (Sm2PrivateKey)sm2PrivateKey);
        System.out.println(keyPair.getPublic());
        System.out.println(b);
    }

    public static void readSm2PublicKey() throws Exception {
        KeyPair keyPair = GMSSLX509Utils.generateSM2KeyPair();
        BCECPublicKey publicKey = (BCECPublicKey)keyPair.getPublic();
        MiniPcieXKFUtils.verifyPin((byte[])"111111".getBytes());
        Sm2PublicKey sm2PublicKey = new Sm2PublicKey(publicKey.getW().getAffineY().toByteArray(), publicKey.getW().getAffineY().toByteArray());
        boolean b = MiniPcieXKFUtils.writeSm2PublicKey((byte[])pubkeyId, (String)"111111", (Sm2PublicKey)sm2PublicKey);
        System.out.println(keyPair.getPublic());
        System.out.println(b);
        Sm2PublicKey export = MiniPcieXKFUtils.readSm2PublicKey((byte[])pubkeyId);
        System.out.println(export);
    }

    public static void getFileInfo() throws Exception {
        MiniPcieFile fileInfo = MiniPcieXKFUtils.getFileInfo((byte[])MiniPcieIndexEnum.getInfoFromIndex((int)1).getSignPublicKeyIndex());
        System.out.println(fileInfo.toString());
        MiniPcieFile fileInfoA = MiniPcieXKFUtils.getFileInfo((byte[])MiniPcieIndexEnum.getInfoFromIndex((int)1).getSignPrivateIndex());
        System.out.println(fileInfoA);
        System.out.println("#################################");
        System.out.println("##########\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f\u9700\u6c42\u5b8c\u6210#######");
        System.out.println("#################################");
    }
}

