/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.minipcie.demo.utils;

import com.xdja.SafeKey.bean.MiniPcieIndexEnum;
import com.xdja.SafeKey.utils.MiniPcieXKFUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricKeyParameters;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECKeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECSignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRandomUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM1ECBEncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2EncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM4ECBEncryptUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLCertUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLExtensionUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.util.encoders.Hex;
import org.junit.Assert;

public class MiniPcieUtilsMain {
    public static final String SM1_TEST = "sm1";
    public static final String SM2_ENCRYPT = "sm2Encrypt";
    public static final String SM2_SIGN = "sm2Sign";
    public static final String SM3_TEST = "sm3";
    public static final String SM4_TEST = "sm4";
    public static final String GEN_KEY_PAIR = "genKeyPair";
    public static final String READ_PUBLIC_KEY = "readPublickey";
    public static final String GEN_KEY_IN_CONTAINER = "genKeyInContainer";
    public static final String IMPORT_KEY = "importKey";
    public static final String IMPORT_CERT = "importCert";
    public static final String GENERATE_RANDOM = "random";

    public static void main(String[] args) throws Exception {
        switch (args[0]) {
            case "sm1": {
                MiniPcieUtilsMain.testSM1();
                break;
            }
            case "sm2Encrypt": {
                MiniPcieUtilsMain.testSm2Encrypt();
                MiniPcieUtilsMain.testSm2ASN1Encrypt();
                break;
            }
            case "sm2Sign": {
                MiniPcieUtilsMain.testSM2Sign();
                break;
            }
            case "sm3": {
                MiniPcieUtilsMain.testSM3Digest();
                break;
            }
            case "sm4": {
                MiniPcieUtilsMain.testSM4NoPadding();
                MiniPcieUtilsMain.testSM4PKCS7();
                break;
            }
            case "genKeyPair": {
                MiniPcieUtilsMain.testGenerateKeyPair();
                break;
            }
            case "readPublickey": {
                MiniPcieUtilsMain.getPublicKeyFromHardware();
                break;
            }
            case "genKeyInContainer": {
                MiniPcieUtilsMain.genKeyPair();
                break;
            }
            case "importKey": {
                MiniPcieUtilsMain.importKey();
            }
            case "importCert": {
                MiniPcieUtilsMain.testGenerateCertByMiniPcie();
                break;
            }
            case "random": {
                GMSSLPkiCryptoInit.getMiniPcieInstance();
                byte[] bytes = GMSSLRandomUtils.generateRandom((int)32);
                System.out.println(Hex.toHexString((byte[])bytes));
                break;
            }
            case "all": {
                MiniPcieUtilsMain.testSM1();
                MiniPcieUtilsMain.testSM2Sign();
                MiniPcieUtilsMain.testSM3Digest();
                MiniPcieUtilsMain.testSM4NoPadding();
                MiniPcieUtilsMain.testSM4PKCS7();
                MiniPcieUtilsMain.testGenerateKeyPair();
                MiniPcieUtilsMain.importKey();
                MiniPcieUtilsMain.testGenerateCertByMiniPcie();
                GMSSLPkiCryptoInit.getMiniPcieInstance();
                byte[] byteA = GMSSLRandomUtils.generateRandom((int)32);
                System.out.println(Hex.toHexString((byte[])byteA));
                MiniPcieUtilsMain.genKeyPair();
                MiniPcieUtilsMain.testSm2Encrypt();
                MiniPcieUtilsMain.testSm2ASN1Encrypt();
                MiniPcieUtilsMain.testGenerateCertByMiniPcieSign();
                MiniPcieUtilsMain.testGenerateCertByMiniPcieEnc();
                break;
            }
            default: {
                System.out.println("un support the method " + args[0]);
            }
        }
    }

    private static void genKeyPair() throws Exception {
        int fileId = 1;
        MiniPcieXKFUtils.generateSm2KeyPairInContent((byte[])MiniPcieIndexEnum.getInfoFromIndex((int)fileId).getSignPublicKeyIndex(), (byte[])MiniPcieIndexEnum.getInfoFromIndex((int)fileId).getSignPrivateIndex());
        MiniPcieXKFUtils.generateSm2KeyPairInContent((byte[])MiniPcieIndexEnum.getInfoFromIndex((int)fileId).getEncPublicKeyIndex(), (byte[])MiniPcieIndexEnum.getInfoFromIndex((int)fileId).getEncPrivateIndex());
        fileId = 2;
        MiniPcieXKFUtils.generateSm2KeyPairInContent((byte[])MiniPcieIndexEnum.getInfoFromIndex((int)fileId).getSignPublicKeyIndex(), (byte[])MiniPcieIndexEnum.getInfoFromIndex((int)fileId).getSignPrivateIndex());
        MiniPcieXKFUtils.generateSm2KeyPairInContent((byte[])MiniPcieIndexEnum.getInfoFromIndex((int)fileId).getEncPublicKeyIndex(), (byte[])MiniPcieIndexEnum.getInfoFromIndex((int)fileId).getEncPrivateIndex());
    }

    public static void importKey() throws Exception {
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        KeyPair keyPair = GMSSLECKeyUtils.generateECKeyPair((String)GMSSLECKeyUtils.SM2p256);
        GMSSLECKeyUtils.writeKeyPairToHardWare((int)1, (String)"111111", (KeyPair)keyPair, (boolean)true);
        keyPair = GMSSLECKeyUtils.generateECKeyPair((String)GMSSLECKeyUtils.SM2p256);
        GMSSLECKeyUtils.writeKeyPairToHardWare((int)1, (String)"111111", (KeyPair)keyPair, (boolean)false);
        keyPair = GMSSLECKeyUtils.generateECKeyPair((String)GMSSLECKeyUtils.SM2p256);
        GMSSLECKeyUtils.writeKeyPairToHardWare((int)2, (String)"111111", (KeyPair)keyPair, (boolean)true);
        keyPair = GMSSLECKeyUtils.generateECKeyPair((String)GMSSLECKeyUtils.SM2p256);
        GMSSLECKeyUtils.writeKeyPairToHardWare((int)2, (String)"111111", (KeyPair)keyPair, (boolean)false);
        System.out.println("##########Import KeyPair Success ###########");
    }

    public static void getPublicKeyFromHardware() throws Exception {
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        PublicKey publicKey1 = GMSSLECKeyUtils.getPublicKeyFromHardware((int)1, (String)GMSSLECKeyUtils.SM2p256, (boolean)true);
        PublicKey publicKey2 = GMSSLECKeyUtils.getPublicKeyFromHardware((int)1, (String)GMSSLECKeyUtils.SM2p256, (boolean)false);
        PublicKey publicKey3 = GMSSLECKeyUtils.getPublicKeyFromHardware((int)2, (String)GMSSLECKeyUtils.SM2p256, (boolean)true);
        PublicKey publicKey4 = GMSSLECKeyUtils.getPublicKeyFromHardware((int)2, (String)GMSSLECKeyUtils.SM2p256, (boolean)false);
        System.out.println(publicKey1);
        System.out.println(publicKey2);
        System.out.println(publicKey3);
        System.out.println(publicKey4);
        System.out.println("##########Read Public Key Success ###########");
    }

    public static void testGenerateKeyPair() throws Exception {
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        KeyPair keyPair = GMSSLECKeyUtils.generateECKeyPair((String)GMSSLECKeyUtils.SM2p256);
        System.out.println(keyPair.getPublic());
        System.out.println(keyPair.getPrivate());
        System.out.println("##########testGenerateKeyPair Success ###########");
    }

    public static void testSM4SSLV3() throws Exception {
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        byte[] data = "test sm2 sign ".getBytes();
        byte[] key = Hex.decode((String)"11aa1234567abcdef123456789abcdef");
        byte[] encrypt = GMSSLSM4ECBEncryptUtils.encrypt((byte[])key, (byte[])data, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.SSL3Padding);
        byte[] decrypt1 = GMSSLSM4ECBEncryptUtils.decrypt((byte[])key, (byte[])encrypt, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.SSL3Padding);
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] decrypt3 = GMSSLSM4ECBEncryptUtils.decrypt((byte[])key, (byte[])encrypt, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.SSL3Padding);
        Assert.assertArrayEquals((byte[])decrypt1, (byte[])data);
        Assert.assertArrayEquals((byte[])decrypt3, (byte[])data);
        System.out.println(new String(decrypt1));
        System.out.println(new String(decrypt3));
        System.out.println("##########SM4 SSL3Padding ENCRYPT Success ###########");
    }

    public static void testSM4PKCS7() throws Exception {
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        byte[] data = "test sm2 sign ".getBytes();
        byte[] key = Hex.decode((String)"11123456789abcdef123456789abcdef");
        byte[] encrypt = GMSSLSM4ECBEncryptUtils.encrypt((byte[])key, (byte[])data, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        byte[] decrypt1 = GMSSLSM4ECBEncryptUtils.decrypt((byte[])key, (byte[])encrypt, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] decrypt3 = GMSSLSM4ECBEncryptUtils.decrypt((byte[])key, (byte[])encrypt, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        Assert.assertArrayEquals((byte[])decrypt1, (byte[])data);
        Assert.assertArrayEquals((byte[])decrypt3, (byte[])data);
        System.out.println(new String(decrypt1));
        System.out.println(new String(decrypt3));
        System.out.println("##########SM4 PKCS7Padding ENCRYPT Success ###########");
    }

    public static void testSM4NoPadding() throws Exception {
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        byte[] key = Hex.decode((String)"11123456789abcdef123456789abcdef");
        byte[] encrypt = GMSSLSM4ECBEncryptUtils.encrypt((byte[])key, (byte[])key, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.NoPadding);
        byte[] decrypt1 = GMSSLSM4ECBEncryptUtils.decrypt((byte[])key, (byte[])encrypt, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.NoPadding);
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] decrypt2 = GMSSLSM4ECBEncryptUtils.decrypt((byte[])key, (byte[])encrypt, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.NoPadding);
        Assert.assertArrayEquals((byte[])decrypt1, (byte[])key);
        Assert.assertArrayEquals((byte[])decrypt2, (byte[])key);
        System.out.println(Hex.toHexString((byte[])decrypt1));
        System.out.println(Hex.toHexString((byte[])decrypt2));
        System.out.println("##########SM4 NoPadding ENCRYPT Success ###########");
    }

    public static void testSm2ASN1Encrypt() throws Exception {
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        byte[] data = "test sm2 sign ".getBytes();
        SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(1, "111111");
        PublicKey publicKey = GMSSLECKeyUtils.getPublicKeyFromHardware((int)1, (String)GMSSLECKeyUtils.SM2p256, (boolean)true);
        byte[] encrypt = GMSSLSM2EncryptUtils.encryptAsn1Data((PublicKey)publicKey, (byte[])data);
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] encrypt1 = GMSSLSM2EncryptUtils.encryptAsn1Data((PublicKey)publicKey, (byte[])data);
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        byte[] decrypt = GMSSLSM2EncryptUtils.decryptAsn1Cipher((PrivateKey)sdfPrivateKey, (byte[])encrypt);
        byte[] decrypt1 = GMSSLSM2EncryptUtils.decryptAsn1Cipher((PrivateKey)sdfPrivateKey, (byte[])encrypt1);
        System.out.println(Hex.toHexString((byte[])encrypt));
        System.out.println(Hex.toHexString((byte[])encrypt1));
        System.out.println(Hex.toHexString((byte[])decrypt));
        System.out.println(new String(decrypt));
        System.out.println(Hex.toHexString((byte[])decrypt1));
        Assert.assertArrayEquals((byte[])decrypt, (byte[])data);
        Assert.assertArrayEquals((byte[])decrypt1, (byte[])data);
        System.out.println("##########SM2 ASN1 ENCRYPT Success ###########");
    }

    private static void testSM3Digest() throws Exception {
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        byte[] data = "12352355345345334534534535236746545635345354345354".getBytes();
        byte[] digest = GMSSLSM3DigestUtils.digest((byte[])data);
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] digest1 = GMSSLSM3DigestUtils.digest((byte[])data);
        Assert.assertArrayEquals((byte[])digest, (byte[])digest1);
        System.out.println("##########SM3 Digest Success ###########");
    }

    private static void testSm2Encrypt() throws Exception {
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        byte[] data = "test sm2 sign ".getBytes();
        SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(1, "111111");
        PublicKey publicKey = GMSSLECKeyUtils.getPublicKeyFromHardware((int)1, (String)GMSSLECKeyUtils.SM2p256, (boolean)true);
        byte[] encrypt = GMSSLSM2EncryptUtils.encrypt((PublicKey)publicKey, (byte[])data);
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] encrypt1 = GMSSLSM2EncryptUtils.encrypt((PublicKey)publicKey, (byte[])data);
        GMSSLByteArrayUtils.printHexBinary(null, (String)"encrypt by mini pcie", (byte[])encrypt);
        GMSSLByteArrayUtils.printHexBinary(null, (String)"encrypt by bc", (byte[])encrypt1);
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        byte[] decrypt = GMSSLSM2EncryptUtils.decrypt((PrivateKey)sdfPrivateKey, (byte[])encrypt);
        byte[] decrypt1 = GMSSLSM2EncryptUtils.decrypt((PrivateKey)sdfPrivateKey, (byte[])encrypt1);
        Assert.assertArrayEquals((byte[])decrypt, (byte[])data);
        Assert.assertArrayEquals((byte[])decrypt1, (byte[])data);
        System.out.println("##########SM2 Encrypt Success ###########");
    }

    private static void testSM2Sign() throws Exception {
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        byte[] data = "test sm2 sign ".getBytes();
        SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(1, "111111");
        PublicKey publicKey = GMSSLECKeyUtils.getPublicKeyFromHardware((int)1, (String)GMSSLECKeyUtils.SM2p256, (boolean)false);
        byte[] sign = GMSSLECSignUtils.sign((PrivateKey)sdfPrivateKey, (byte[])data, null, (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName());
        boolean verify = GMSSLECSignUtils.verify((PublicKey)publicKey, (byte[])data, (byte[])sign, null, (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName());
        GMSSLPkiCryptoInit.getBCInstance();
        boolean verify1 = GMSSLECSignUtils.verify((PublicKey)publicKey, (byte[])data, (byte[])sign, null, (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName());
        Assert.assertTrue((boolean)verify);
        Assert.assertTrue((boolean)verify1);
        System.out.println("##########SM2 Sign Success ###########");
    }

    private static void testSM1() throws Exception {
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        byte[] data = "test sm2 sign ".getBytes();
        byte[] key = Hex.decode((String)"11aa1234567abcdef123456789abcdef");
        byte[] encrypt = GMSSLSM1ECBEncryptUtils.encrypt((byte[])key, (byte[])data, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.SSL3Padding);
        byte[] decrypt1 = GMSSLSM1ECBEncryptUtils.decrypt((byte[])key, (byte[])encrypt, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.SSL3Padding);
        Assert.assertArrayEquals((byte[])decrypt1, (byte[])data);
        System.out.println("##########SM1 SSL3Padding Success ###########");
        encrypt = GMSSLSM1ECBEncryptUtils.encrypt((byte[])key, (byte[])data, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        decrypt1 = GMSSLSM1ECBEncryptUtils.decrypt((byte[])key, (byte[])encrypt, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        Assert.assertArrayEquals((byte[])decrypt1, (byte[])data);
        System.out.println("##########SM1 PKCS7Padding Success ###########");
        encrypt = GMSSLSM1ECBEncryptUtils.encrypt((byte[])key, (byte[])key, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.NoPadding);
        decrypt1 = GMSSLSM1ECBEncryptUtils.decrypt((byte[])key, (byte[])encrypt, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.NoPadding);
        Assert.assertArrayEquals((byte[])decrypt1, (byte[])key);
        System.out.println("##########SM1 NoPadding Success ###########");
    }

    public static void testGenerateCertByMiniPcie() throws Exception {
        KeyPair keyPair = GMSSLX509Utils.generateSM2KeyPair();
        PublicKey subjectKey = keyPair.getPublic();
        SdfPrivateKey issuerKey = GMSSLECKeyUtils.genSdfPrivateKey((int)1, (String)"111111");
        String issuer = "CN=ca, O=xdja, C=cn";
        String subject = "CN=user0, O=xdja, C=cn";
        BigInteger serial = BigInteger.valueOf(1L);
        Date notBefore = new Date();
        Date notAfter = new Date();
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        extensions.add(GMSSLExtensionUtils.genBasicConstraintsExtension((Integer)1));
        extensions.add(GMSSLExtensionUtils.genAuthorityInfoAccessExtension((String)"ldap://11.12.11.111:389?cACertificate;binary,crossCertificatePair;binary"));
        extensions.add(GMSSLExtensionUtils.genSignatureCertKeyUsageExtension());
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        X509Certificate certificate = GMSSLCertUtils.generateCert((String)issuer, (String)subject, (BigInteger)serial, (Date)notBefore, (Date)notAfter, (PrivateKey)issuerKey, (PublicKey)subjectKey, (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(), extensions, (boolean)true);
        PublicKey publicKeyFromHardware = GMSSLECKeyUtils.getPublicKeyFromHardware((int)1, (String)GMSSLECKeyUtils.SM2p256, (boolean)false);
        boolean b = GMSSLCertUtils.verifyCert((PublicKey)publicKeyFromHardware, (X509Certificate)certificate);
        System.out.println(b);
        GMSSLPkiCryptoInit.getBCInstance();
        b = GMSSLCertUtils.verifyCert((PublicKey)publicKeyFromHardware, (X509Certificate)certificate);
        System.out.println(b);
        Assert.assertTrue((boolean)b);
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        b = GMSSLCertUtils.verifyCert((PublicKey)publicKeyFromHardware, (X509Certificate)certificate);
        System.out.println(b);
        Assert.assertTrue((boolean)b);
        GMSSLCertUtils.writeCertToHardWare((int)1, (String)"111111", (X509Certificate)certificate, (boolean)false);
        X509Certificate x509Certificate = GMSSLCertUtils.readCertFromHardWare((int)1, (boolean)false);
        System.out.println(x509Certificate);
    }

    public static void testGenerateCertByMiniPcieSign() throws Exception {
        KeyPair keyPair = GMSSLX509Utils.generateSM2KeyPair();
        PublicKey subjectKey = keyPair.getPublic();
        SdfPrivateKey issuerKey = GMSSLECKeyUtils.genSdfPrivateKey((int)2, (String)"111111");
        String issuer = "CN=ca, O=xdja, C=cn";
        String subject = "CN=user0, O=xdja, C=cn";
        BigInteger serial = BigInteger.valueOf(1L);
        Date notBefore = new Date();
        Date notAfter = new Date();
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        extensions.add(GMSSLExtensionUtils.genBasicConstraintsExtension((Integer)2));
        extensions.add(GMSSLExtensionUtils.genAuthorityInfoAccessExtension((String)"ldap://11.12.11.111:389?cACertificate;binary,crossCertificatePair;binary"));
        extensions.add(GMSSLExtensionUtils.genSignatureCertKeyUsageExtension());
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        X509Certificate certificate = GMSSLCertUtils.generateCert((String)issuer, (String)subject, (BigInteger)serial, (Date)notBefore, (Date)notAfter, (PrivateKey)issuerKey, (PublicKey)subjectKey, (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(), extensions, (boolean)true);
        PublicKey publicKeyFromHardware = GMSSLECKeyUtils.getPublicKeyFromHardware((int)2, (String)GMSSLECKeyUtils.SM2p256, (boolean)false);
        boolean b = GMSSLCertUtils.verifyCert((PublicKey)publicKeyFromHardware, (X509Certificate)certificate);
        System.out.println(b);
        GMSSLPkiCryptoInit.getBCInstance();
        b = GMSSLCertUtils.verifyCert((PublicKey)publicKeyFromHardware, (X509Certificate)certificate);
        System.out.println(b);
        Assert.assertTrue((boolean)b);
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        b = GMSSLCertUtils.verifyCert((PublicKey)publicKeyFromHardware, (X509Certificate)certificate);
        System.out.println(b);
        Assert.assertTrue((boolean)b);
        GMSSLCertUtils.writeCertToHardWare((int)2, (String)"111111", (X509Certificate)certificate, (boolean)false);
        X509Certificate x509Certificate = GMSSLCertUtils.readCertFromHardWare((int)2, (boolean)false);
        System.out.println(x509Certificate);
    }

    public static void testGenerateCertByMiniPcieEnc() throws Exception {
        KeyPair keyPair = GMSSLX509Utils.generateSM2KeyPair();
        PublicKey subjectKey = keyPair.getPublic();
        SdfPrivateKey issuerKey = GMSSLECKeyUtils.genSdfPrivateKey((int)2, (String)"111111");
        String issuer = "CN=ca, O=xdja, C=cn";
        String subject = "CN=user0, O=xdja, C=cn";
        BigInteger serial = BigInteger.valueOf(1L);
        Date notBefore = new Date();
        Date notAfter = new Date();
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        extensions.add(GMSSLExtensionUtils.genBasicConstraintsExtension((Integer)2));
        extensions.add(GMSSLExtensionUtils.genAuthorityInfoAccessExtension((String)"ldap://11.12.11.111:389?cACertificate;binary,crossCertificatePair;binary"));
        extensions.add(GMSSLExtensionUtils.genSignatureCertKeyUsageExtension());
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        X509Certificate certificate = GMSSLCertUtils.generateCert((String)issuer, (String)subject, (BigInteger)serial, (Date)notBefore, (Date)notAfter, (PrivateKey)issuerKey, (PublicKey)subjectKey, (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(), extensions, (boolean)true);
        PublicKey publicKeyFromHardware = GMSSLECKeyUtils.getPublicKeyFromHardware((int)2, (String)GMSSLECKeyUtils.SM2p256, (boolean)true);
        boolean b = GMSSLCertUtils.verifyCert((PublicKey)publicKeyFromHardware, (X509Certificate)certificate);
        System.out.println(b);
        GMSSLPkiCryptoInit.getBCInstance();
        b = GMSSLCertUtils.verifyCert((PublicKey)publicKeyFromHardware, (X509Certificate)certificate);
        System.out.println(b);
        Assert.assertTrue((boolean)b);
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        b = GMSSLCertUtils.verifyCert((PublicKey)publicKeyFromHardware, (X509Certificate)certificate);
        System.out.println(b);
        Assert.assertTrue((boolean)b);
        GMSSLCertUtils.writeCertToHardWare((int)2, (String)"111111", (X509Certificate)certificate, (boolean)true);
        X509Certificate x509Certificate = GMSSLCertUtils.readCertFromHardWare((int)2, (boolean)true);
        System.out.println(x509Certificate);
    }
}

