package com.xdja.pki.gmssl.minipcie.demo;

import com.xdja.SafeKey.JNIAPI;
import com.xdja.SafeKey.MiniPcieFile;
import com.xdja.SafeKey.Sm2PrivateKey;
import com.xdja.SafeKey.Sm2PublicKey;
import com.xdja.SafeKey.bean.MiniPcieIndexEnum;
import com.xdja.SafeKey.utils.MiniPcieXKFUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLECUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLFileUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.util.encoders.Hex;

import java.security.KeyPair;
import java.security.cert.X509Certificate;

/**
 * @description: TODO
 * @author: feng zhen
 * @date: 2020/5/28 14:24
 **/
public class MiniPcieDemo {

    private static byte[] pubkeyId = Hex.decode("002a");
    private static byte[] prikeyId = Hex.decode("002b");
    private static String password = "111111";

    public static final String CREATE_FILE = "createFile";
    public static final String GENERATE_KEYPAIR = "generateKeyPair";
    public static final String ALL = "all";

    public static void main(String[] args) throws Exception {
        //  generateRandomWithoutPool();
        if (CREATE_FILE.equalsIgnoreCase(args[0])) {
            MiniPcieCreateFile.createFile(Integer.valueOf(args[1]));
        }
        if (GENERATE_KEYPAIR.equalsIgnoreCase(args[0])) {
            generateKey(Integer.valueOf(args[1]));
        }
        if (ALL.equalsIgnoreCase(args[0])) {
            generateRandom();
            sm1();
            sm4();
            sm2Decrypt();
            sm2Verify();
            writeCert();
            writeKeyPair();
            testGenerateKeyPair();
            getFileInfo();
        }
    }

    public static void generateKey(int fileId) throws Exception {
        MiniPcieXKFUtils.generateSm2KeyPairInContent(
                MiniPcieIndexEnum.getInfoFromIndex(fileId).getSignPublicKeyIndex(),
                MiniPcieIndexEnum.getInfoFromIndex(fileId).getSignPrivateIndex()
        );
        MiniPcieXKFUtils.generateSm2KeyPairInContent(
                MiniPcieIndexEnum.getInfoFromIndex(fileId).getEncPublicKeyIndex(),
                MiniPcieIndexEnum.getInfoFromIndex(fileId).getEncPrivateIndex()
        );
    }

    public static void generateRandom() throws Exception {
        System.out.println("开始通过连接池生成随机数");
        long Time1 = System.nanoTime();
        byte[] bytes = MiniPcieXKFUtils.generateRandom(1211);
        long Time2 = System.nanoTime();
        System.out.println("Time2 - Time1 =" + (Time2 - Time1));
        System.out.println(Hex.toHexString(bytes));
        System.out.println("#################################");
        System.out.println("##########生成随机数需求完成#######");
        System.out.println("#################################");
    }

    public static void generateRandomWithoutPool() throws Exception {
        JNIAPI jniapi = new JNIAPI();
        int[] dev = new int[1];
        long[] handle = new long[1];
        long enumTime1 = System.nanoTime();
        jniapi.EnumDev(JNIAPI.CT_ALL, dev);
        long enumTime2 = System.nanoTime();
        jniapi.OpenDev(0, handle);
        byte[] data = new byte[1211];
        jniapi.GenRandom(handle[0], 1211, data);
        System.out.println(Hex.toHexString(data));
    }

    public static void sm1() throws Exception {
        byte[] key = MiniPcieXKFUtils.generateRandom(16);
        byte[] data = MiniPcieXKFUtils.generateRandom(32);
        byte[] out = MiniPcieXKFUtils.sm1(key, data, JNIAPI.ECB_ENCRYPT, null);
        System.out.println(Hex.toHexString(out));
        System.out.println(out.length);
        System.out.println("#################################");
        System.out.println("##########sm1需求完成#######");
        System.out.println("#################################");
    }

    public static void sm4() throws Exception {
        byte[] key = MiniPcieXKFUtils.generateRandom(16);
        byte[] data = MiniPcieXKFUtils.generateRandom(32);
        byte[] out = MiniPcieXKFUtils.sm4(key, data, JNIAPI.ECB_ENCRYPT, null);
        System.out.println(Hex.toHexString(out));
        System.out.println(out.length);
        System.out.println("#################################");
        System.out.println("##########sm4需求完成#######");
        System.out.println("#################################");
    }

    public static void writeCert() throws Exception {
        X509Certificate certificate = GMSSLX509Utils.readCertificateFromCer(GMSSLFileUtils.getResourceAsPath("ca.cer"));
        byte[] certIndex = MiniPcieIndexEnum.getInfoFromIndex(1).getEncCertIndex();
        //System.out.println(certificate);
        System.out.println(MiniPcieIndexEnum.getInfoFromIndex(1).encCertIndex);
        System.out.println(Hex.toHexString(certIndex));
        MiniPcieXKFUtils.writeCert(certificate.getEncoded(), certIndex, password);
        System.out.println("#################################");
        System.out.println("##########写证书需求完成#######");
        System.out.println("#################################");
    }

    public static void readCert() throws Exception {
        X509Certificate certificate = GMSSLX509Utils.readCertificateFromCer(GMSSLFileUtils.getResourceAsPath("ca.cer"));
        byte[] certIndex = MiniPcieIndexEnum.getInfoFromIndex(1).getEncCertIndex();
        //System.out.println(certificate);
        System.out.println(MiniPcieIndexEnum.getInfoFromIndex(1).encCertIndex);
        System.out.println(Hex.toHexString(certIndex));
        byte[] bytes = MiniPcieXKFUtils.readCert(MiniPcieIndexEnum.getInfoFromIndex(1).getEncCertIndex());
        X509Certificate x509Certificate = GMSSLX509Utils.readCertificateFromCerByte(bytes);
        System.out.println(x509Certificate);
        System.out.println("#################################");
        System.out.println("##########读证书需求完成#######");
        System.out.println("#################################");
    }

    public static void writeKeyPair() throws Exception {
        KeyPair keyPair = GMSSLX509Utils.generateSM2KeyPair();
        MiniPcieXKFUtils.verifyPin("111111".getBytes());
        Sm2PublicKey sm2PublicKey = new Sm2PublicKey(keyPair.getPublic());
        MiniPcieXKFUtils.writeSm2PublicKey(pubkeyId, "111111", sm2PublicKey);
        Sm2PrivateKey sm2PrivateKey = new Sm2PrivateKey(keyPair.getPrivate());
        MiniPcieXKFUtils.writeSm2PrivateKey(prikeyId, "111111", sm2PrivateKey);
        System.out.println(keyPair.getPublic());
        Sm2PublicKey export = MiniPcieXKFUtils.readSm2PublicKey(pubkeyId);
        System.out.println(export.getPublicKey(GMSSLECUtils.SM2p256));
        System.out.println(sm2PrivateKey.toString());
        System.out.println("#################################");
        System.out.println("##########写入密钥对需求完成#######");
        System.out.println("#################################");
    }

    // TODO: 2020/5/18 -10 -24
    public static void sm2Verify() throws Exception {
        //560903472   0
        byte[] data = "test".getBytes();
        byte[] hash = MiniPcieXKFUtils.sm3(data);
        byte[] sign = MiniPcieXKFUtils.sm2SignWithInternalHash(data, pubkeyId, prikeyId, "111111");
        System.out.println(Hex.toHexString(sign));
        Sm2PublicKey sm2PublicKey = MiniPcieXKFUtils.readSm2PublicKey(pubkeyId);
        System.out.println(Hex.toHexString(sm2PublicKey.x));
        System.out.println(Hex.toHexString(sm2PublicKey.y));
        boolean b = MiniPcieXKFUtils.sm2VerifyWithInternalHash(data, sign, sm2PublicKey);
        if (b) {
            System.out.println("#################################");
            System.out.println("##########SM2验签需求完成#######");
            System.out.println("#################################");
        } else {
            System.out.println("！！！！！！！！！！！！！！！！！！！！");
            System.out.println("！！！！！！！SM2验签需求失败！！！！！");
            System.out.println("！！！！！！！！！！！！！！！！！！！！");
        }
    }

    public static void testGenerateKeyPair() throws Exception {
        KeyPair keyPair = MiniPcieXKFUtils.generateSm2KeyPair();
        System.out.println(keyPair.getPublic());
        System.out.println(keyPair.getPrivate());
        System.out.println("#################################");
        System.out.println("##########生成密钥对需求完成#######");
        System.out.println("#################################");
    }

    public static void testGenerateKeyPairInContent() throws Exception {
        boolean t = MiniPcieXKFUtils.generateSm2KeyPairInContent(MiniPcieIndexEnum.getInfoFromIndex(1).getEncPublicKeyIndex(),
                MiniPcieIndexEnum.getInfoFromIndex(1).getEncPrivateIndex());
    }


    public static void sm2Decrypt() throws Exception {
        Sm2PublicKey sm2PublicKey = MiniPcieXKFUtils.readSm2PublicKey(pubkeyId);
        byte[] data = "test".getBytes();
        byte[] out = MiniPcieXKFUtils.sm2Encrypt(data, sm2PublicKey);
        System.out.println(Hex.toHexString(out));
        byte[] decrypt = MiniPcieXKFUtils.sm2Decrypt(out, prikeyId, password);
        System.out.println(new String(decrypt));
        System.out.println("#################################");
        System.out.println("##########SM2解密需求完成#######");
        System.out.println("#################################");
    }


    //@Test
    public static void writeSm2PrivateKey() throws Exception {
        KeyPair keyPair = GMSSLX509Utils.generateSM2KeyPair();
        // TODO: 2020/5/16 密钥转换
        byte[] keyId = Hex.decode("0076");
        BCECPrivateKey privateKey = (BCECPrivateKey) keyPair.getPrivate();
        //  MiniPcieXKFUtils.verifyPin("111111".getBytes());
        Sm2PrivateKey sm2PrivateKey = new Sm2PrivateKey(privateKey.getD().toByteArray());
        boolean b = MiniPcieXKFUtils.writeSm2PrivateKey(keyId, "111111", sm2PrivateKey);
        System.out.println(keyPair.getPublic());
        System.out.println(b);
    }

    public static void readSm2PublicKey() throws Exception {
        KeyPair keyPair = GMSSLX509Utils.generateSM2KeyPair();
        BCECPublicKey publicKey = (BCECPublicKey) keyPair.getPublic();
        MiniPcieXKFUtils.verifyPin("111111".getBytes());
        Sm2PublicKey sm2PublicKey = new Sm2PublicKey(publicKey.getW().getAffineY().toByteArray(), publicKey.getW().getAffineY().toByteArray());
        boolean b = MiniPcieXKFUtils.writeSm2PublicKey(pubkeyId, "111111", sm2PublicKey);
        System.out.println(keyPair.getPublic());
        System.out.println(b);
        Sm2PublicKey export = MiniPcieXKFUtils.readSm2PublicKey(pubkeyId);
        System.out.println(export);
    }

    public static void getFileInfo() throws Exception {
        MiniPcieFile fileInfo = MiniPcieXKFUtils.getFileInfo(MiniPcieIndexEnum.getInfoFromIndex(1).getSignPublicKeyIndex());
        System.out.println(fileInfo.toString());
        MiniPcieFile fileInfoA = MiniPcieXKFUtils.getFileInfo(MiniPcieIndexEnum.getInfoFromIndex(1).getSignPrivateIndex());
        System.out.println(fileInfoA);
        System.out.println("#################################");
        System.out.println("##########获取设备信息需求完成#######");
        System.out.println("#################################");
    }

}
