package com.xdja.pki.gmssl.sanc;

import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECKeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSAKeyUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLP10Utils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

import java.security.PublicKey;
import java.util.Scanner;

/**
 * @description: TODO
 * @author: feng zhen
 * @date: 2020/6/4 10:33
 **/
public class Main {
    public static void main(String[] args) throws Exception {
        Scanner in = new Scanner(System.in);
        System.out.println("------------------------------------------------------------");
        System.out.println("Please enter the key index to which you want to generate P10");
        System.out.println("------------------------------------------------------------");
        int keyIndex = in.nextInt();
        System.out.println();
        System.out.println("you enter the key index is " + keyIndex);
        System.out.println();
        System.out.println("-----------------------------");
        System.out.println("Please choice the signAlgName");
        System.out.println("|choice|        value        |");
        System.out.println("|   1  |    SM3_WITH_SM2     |");
        System.out.println("|   2  |   SHA1_WITH_RSA     |");
        System.out.println("|   3  |   SHA256_WITH_RSA   |");
        System.out.println("-----------------------------");
        int choice = in.nextInt();
        String algorithm;
        // 1 sm2  2 rsa
        int keyType;
        if (choice == 1) {
            System.out.println();
            algorithm = GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName();
            System.out.println("you choice SM3_WITH_SM2");
            keyType  = 1;
        } else if (choice == 2) {
            algorithm = GMSSLSignatureAlgorithm.SHA1_WITH_RSA.getSigAlgName();
            System.out.println("you choice SHA1_WITH_RSA");
            keyType  = 2;
        } else if (choice == 3) {
            algorithm = GMSSLSignatureAlgorithm.SHA256_WITH_RSA.getSigAlgName();
            System.out.println("you choice SHA256_WITH_RSA");
            keyType  = 2;
        } else {
            throw new Exception("un know the choice " + choice);
        }
        System.out.println("------------------------------------------------------------");
        System.out.println("Please enter the subject dn to which you want to generate P10");
        System.out.println("------------------------------------------------------------");
        in = new Scanner(System.in);
        String subject = in.nextLine();
        System.out.println();
        System.out.println("you enter the subject dn is " + subject);
        System.out.println();
        System.out.println("------------------------------------");
        System.out.println("  Please enter the hsm config path    ");
        System.out.println("------------------------------------");
        String configPath = in.nextLine();
        System.out.println();
        System.out.println("you enter the config path is " + configPath);
        System.out.println();
        System.out.println("------------------------------------------------------------");
        System.out.println("  Please enter the path to the file you want to generate   ");
        System.out.println("------------------------------------------------------------");
        String writePath = in.nextLine();
        System.out.println();
        System.out.println("you enter the write path is " + writePath);
        System.out.println();
        PublicKey encPublicKey;
        PublicKey signPublicKey;
        GMSSLPkiCryptoInit.getSancHsmInstance(configPath);
        if (keyType == 1){
             encPublicKey = GMSSLECKeyUtils.getPublicKeyFromHardware(keyIndex, GMSSLECKeyUtils.SM2p256, true);
             signPublicKey = GMSSLECKeyUtils.getPublicKeyFromHardware(keyIndex, GMSSLECKeyUtils.SM2p256, false);
        }else {
            encPublicKey = GMSSLRSAKeyUtils.getPublicKeyFromHardware(keyIndex,  true);
            signPublicKey = GMSSLRSAKeyUtils.getPublicKeyFromHardware(keyIndex, false);
        }
        PKCS10CertificationRequest pkcs10CertificationRequest = GMSSLP10Utils.generateP10(subject, signPublicKey, new SdfPrivateKey(keyIndex), algorithm, false);
        long currentTimeMillis = System.currentTimeMillis();
        GMSSLP10Utils.writeP10ToFile(writePath,"certreq_" + keyIndex + "_" + currentTimeMillis,pkcs10CertificationRequest);
        GMSSLX509Utils.writePublicKeyToPem(writePath,"encpubwithoid_" + keyIndex + "_" + currentTimeMillis,encPublicKey);
    }
}
