/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.tomcat.tools.main;

import com.alibaba.fastjson.JSONObject;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2EncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM4ECBEncryptUtils;
import com.xdja.pki.gmssl.tomcat.tools.main.SM2EnvelopedData;
import com.xdja.pki.gmssl.tomcat.tools.main.TomcatPropertiesEntry;
import com.xdja.pki.gmssl.tomcat.utils.GMSSLTomcatUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolveCertUtils {
    private static Logger logger = LoggerFactory.getLogger(ResolveCertUtils.class);
    public static final String CERT_HEAD = "-----BEGIN CERTIFICATE-----";
    public static final String CERT_TAIL = "-----END CERTIFICATE-----";
    public static final String PUBLIC_KEY_HEAD = "-----BEGIN PUBLIC KEY-----";
    public static final String PUBLIC_KEY_TAIL = "-----END PUBLIC KEY-----";

    public static void addHttpsPort(String confPath) throws Exception {
        X509Certificate encCert;
        TomcatPropertiesEntry tomcatProperties = null;
        try {
            tomcatProperties = ResolveCertUtils.getTomcatProperties(confPath);
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            return;
        }
        System.out.println(tomcatProperties.toString());
        try {
            byte[] encData = GMSSLX509Utils.readFileToByte((String)tomcatProperties.getEncCertPath());
            String cert = ResolveCertUtils.getEncCertByEnvelopData(tomcatProperties.getEncKeyIndex(), tomcatProperties.getEncPriKey(), encData);
            encCert = ResolveCertUtils.getCertFromB64(cert);
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u52a0\u5bc6\u8bc1\u4e66\u94fe\u5931\u8d25", (Throwable)e);
            return;
        }
        X509Certificate sign = null;
        ArrayList<X509Certificate> rootCerts = new ArrayList<X509Certificate>();
        try {
            String signCert = ResolveCertUtils.file2String(new File(tomcatProperties.getSignCertPath()), "utf-8");
            List<X509Certificate> certs = ResolveCertUtils.getCertsByCertChain(signCert);
            for (X509Certificate cert : certs) {
                if (cert.getSubjectX500Principal().equals(encCert.getSubjectX500Principal())) {
                    sign = cert;
                    continue;
                }
                rootCerts.add(cert);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u7b7e\u540d\u8bc1\u4e66\u94fe\u5931\u8d25", (Throwable)e);
            return;
        }
        GMSSLTomcatUtils.openHttpsPortByYunHsm(rootCerts, (X509Certificate)sign, (X509Certificate)encCert, (int)tomcatProperties.getEncKeyIndex(), (String)tomcatProperties.getEncPriKey(), (String)tomcatProperties.getTomcatPath(), (int)tomcatProperties.getHttpsPort());
    }

    public X509Certificate getEncCert(int keyIndex, String priKeyPwd, String path) throws Exception {
        byte[] data = GMSSLX509Utils.readFileToByte((String)path);
        String cert = ResolveCertUtils.getEncCertByEnvelopData(keyIndex, priKeyPwd, data);
        return ResolveCertUtils.getCertFromStr(cert);
    }

    public static List<X509Certificate> getCertsByCertChain(String p7b) throws CMSException, CertificateException {
        ArrayList<X509Certificate> certificateList = new ArrayList<X509Certificate>();
        CMSSignedData cmsSignedData = new CMSSignedData(Base64.decode((String)p7b));
        Store store = cmsSignedData.getCertificates();
        Collection collection = store.getMatches(null);
        for (X509CertificateHolder x509CertificateHolder : collection) {
            X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(x509CertificateHolder);
            certificateList.add(x509Certificate);
        }
        return certificateList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String file2String(File file, String encoding) {
        InputStreamReader reader = null;
        StringWriter writer = new StringWriter();
        try {
            reader = encoding == null || "".equals(encoding.trim()) ? new InputStreamReader(new FileInputStream(file)) : new InputStreamReader((InputStream)new FileInputStream(file), encoding);
            char[] buffer = new char[2048];
            int n = 0;
            while (-1 != (n = reader.read(buffer))) {
                writer.write(buffer, 0, n);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (writer != null) {
            return writer.toString();
        }
        return null;
    }

    public static TomcatPropertiesEntry getTomcatProperties(String confPath) throws IOException {
        TomcatPropertiesEntry propertiesEntry = new TomcatPropertiesEntry();
        File file = new File(confPath);
        String jsonString = FileUtils.readFileToString((File)file, (String)"UTF-8");
        JSONObject dataJson = JSONObject.parseObject((String)jsonString);
        JSONObject tomcatProperties = dataJson.getJSONObject("Tomcat");
        propertiesEntry.setTomcatPath(tomcatProperties.getString("tomcatPath"));
        propertiesEntry.setRootCertPath(tomcatProperties.getString("rootCertPath"));
        propertiesEntry.setSignCertPath(tomcatProperties.getString("signCertPath"));
        propertiesEntry.setEncCertPath(tomcatProperties.getString("encCertPath"));
        propertiesEntry.setEncKeyIndex(tomcatProperties.getInteger("encKeyIndex"));
        propertiesEntry.setEncPriKey(tomcatProperties.getString("encPriKey"));
        propertiesEntry.setHttpsPort(tomcatProperties.getInteger("httpsPort"));
        propertiesEntry.setCryptoType(tomcatProperties.getString("cryptoType"));
        return propertiesEntry;
    }

    public static String getEncCertByEnvelopData(int keyIndex, String priKeyPwd, byte[] data) throws Exception {
        SM2EnvelopedData envelopedData = SM2EnvelopedData.getInstance(Base64.decode((byte[])data));
        ASN1Set recipientInfos = envelopedData.getRecipientInfos();
        DERSequence derSequence = (DERSequence)recipientInfos.getObjectAt(0);
        DEROctetString pwdSymmetricKey = null;
        for (int i = 0; i < derSequence.size(); ++i) {
            ASN1Encodable object = null;
            object = derSequence.getObjectAt(i);
            if (!(object instanceof DEROctetString)) continue;
            pwdSymmetricKey = (DEROctetString)object;
        }
        EncryptedContentInfo encryptedContentInfo = envelopedData.getEncryptedContentInfo();
        ASN1OctetString encryptedContent = encryptedContentInfo.getEncryptedContent();
        String base64Enc = Base64.toBase64String((byte[])pwdSymmetricKey.getOctets());
        String symmetricKey = GMSSLSM2EncryptUtils.decryptASN1ByYunhsm((int)keyIndex, (String)priKeyPwd, (String)base64Enc);
        String encCert = GMSSLSM4ECBEncryptUtils.decryptByBCWithPKCS7Padding((String)symmetricKey, (String)Base64.toBase64String((byte[])encryptedContent.getOctets()));
        return encCert;
    }

    public static X509Certificate getCertFromStr(String str) {
        str = str.replace(CERT_HEAD, "").replace(CERT_TAIL, "");
        str = str.replace("\r", "").replace("\n", "");
        X509Certificate x509Cert = ResolveCertUtils.getCertFromB64(str = str.replace("\\r", "").replace("\\n", ""));
        if (x509Cert == null) {
            x509Cert = ResolveCertUtils.getCertFromNormalStr(str);
        }
        if (x509Cert == null) {
            x509Cert = ResolveCertUtils.getCertFromStr16(str);
        }
        return x509Cert;
    }

    private static synchronized X509Certificate getCertFromB64(String b64) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", (Provider)new BouncyCastleProvider());
            byte[] bsCert = Base64.decode((String)b64);
            ByteArrayInputStream inStream = new ByteArrayInputStream(bsCert);
            X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception e) {
            System.err.println("getCertFromB64 error: " + e.toString());
            return null;
        }
    }

    private static synchronized X509Certificate getCertFromStr16(String str) {
        byte[] bs = ResolveCertUtils.hex2byte(str);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", (Provider)new BouncyCastleProvider());
            ByteArrayInputStream inStream = new ByteArrayInputStream(bs);
            X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception e) {
            System.err.println("getCertFromFullStr error: " + e.toString());
            return null;
        }
    }

    public static byte[] hex2byte(String str) {
        if (null == str || str.equals("")) {
            return null;
        }
        StringBuffer sb = new StringBuffer(str = str.trim());
        int len = sb.length();
        if (len == 0 || len % 2 == 1) {
            return null;
        }
        byte[] b = new byte[len / 2];
        try {
            for (int i = 0; i < len; i += 2) {
                b[i / 2] = (byte)Integer.decode("0x" + sb.substring(i, i + 2)).intValue();
            }
            return b;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static synchronized X509Certificate getCertFromNormalStr(String str) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", (Provider)new BouncyCastleProvider());
            ByteArrayInputStream inStream = new ByteArrayInputStream(str.getBytes());
            X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception e) {
            System.err.println("getCertFromFullStr error: " + e.toString());
            return null;
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

